/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.service.MilestoneScheduleMaintenanceService;
import org.kuali.kfs.module.ar.document.validation.impl.MilestoneScheduleRuleUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;

public class MilestoneScheduleMaintainableImpl
extends FinancialSystemMaintainable {
    private static volatile MilestoneScheduleMaintenanceService milestoneScheduleMaintenanceService;

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        if (StringUtils.equals((String)"awardLookupable", (String)((String)fieldValues.get("refreshCaller")))) {
            if (MilestoneScheduleRuleUtil.checkIfMilestonesExists(this.getMilestoneSchedule())) {
                String pathToMaintainable = "document.newMaintainableObject";
                GlobalVariables.getMessageMap().addToErrorPath(pathToMaintainable);
                GlobalVariables.getMessageMap().putError("proposalNumber", "error.cg.award.milestone.schedule.exists", new String[]{this.getMilestoneSchedule().getProposalNumber().toString()});
                GlobalVariables.getMessageMap().removeFromErrorPath(pathToMaintainable);
            }
        } else {
            super.refresh(refreshCaller, fieldValues, document);
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        List<Milestone> milestones = this.getMilestoneSchedule().getMilestones();
        if (ObjectUtils.isNotNull(milestones)) {
            for (Milestone milestone : milestones) {
                milestone.setBilled(false);
                milestone.setMilestoneIdentifier(null);
            }
        }
    }

    public void processAfterRetrieve() {
        MilestoneSchedule milestoneSchedule = this.getMilestoneSchedule();
        milestoneSchedule.refreshNonUpdateableReferences();
        super.processAfterRetrieve();
    }

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)document.getNewMaintainableObject().getBusinessObject();
        String proposalNumber = milestoneSchedule.getProposalNumber();
        for (Section section : sections) {
            String sectionId = section.getSectionId();
            if (!sectionId.equalsIgnoreCase("Milestones")) continue;
            this.prepareMilestonesTab(section, proposalNumber);
        }
        return sections;
    }

    protected void prepareMilestonesTab(Section section, String proposalNumber) {
        for (Row row : section.getRows()) {
            for (Field field : row.getFields()) {
                if (!field.getCONTAINER().equalsIgnoreCase(field.getFieldType())) continue;
                for (Row containerRow : field.getContainerRows()) {
                    for (Field containerRowfield : containerRow.getFields()) {
                        String milestoneId;
                        if (!ObjectUtils.getNestedAttributePrimitive((String)containerRowfield.getPropertyName()).matches("milestoneIdentifier") || !StringUtils.isNotEmpty((String)(milestoneId = containerRowfield.getPropertyValue())) || !this.getMilestoneScheduleMaintenanceService().hasMilestoneBeenCopiedToInvoice(proposalNumber, milestoneId)) continue;
                        for (Field rowfield : row.getFields()) {
                            if (!rowfield.getCONTAINER().equalsIgnoreCase(rowfield.getFieldType())) continue;
                            for (Row fieldContainerRow : rowfield.getContainerRows()) {
                                for (Field fieldContainerRowField : fieldContainerRow.getFields()) {
                                    fieldContainerRowField.setReadOnly(true);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public MilestoneSchedule getMilestoneSchedule() {
        return (MilestoneSchedule)this.getBusinessObject();
    }

    public MilestoneScheduleMaintenanceService getMilestoneScheduleMaintenanceService() {
        if (milestoneScheduleMaintenanceService == null) {
            milestoneScheduleMaintenanceService = (MilestoneScheduleMaintenanceService)SpringContext.getBean(MilestoneScheduleMaintenanceService.class);
        }
        return milestoneScheduleMaintenanceService;
    }
}

