/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.dataaccess.AccountsReceivableDocumentHeaderDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class AccountsReceivableDocumentHeaderDaoOjb
extends PlatformAwareDaoBaseOjb
implements AccountsReceivableDocumentHeaderDao {
    @Override
    public Collection getARDocumentHeadersByCustomerNumber(String customerNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("customerNumber", (Object)customerNumber);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(AccountsReceivableDocumentHeader.class, (Criteria)criteria));
    }

    @Override
    public Collection getARDocumentHeadersByCustomerNumberByProcessingOrgCodeAndChartCode(String customerNumber, String processingChartOfAccountCode, String processingOrganizationCode) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("customerNumber", (Object)customerNumber);
        criteria.addEqualTo("processingChartOfAccountCode", (Object)processingChartOfAccountCode);
        criteria.addEqualTo("processingOrganizationCode", (Object)processingOrganizationCode);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(AccountsReceivableDocumentHeader.class, (Criteria)criteria));
    }

    @Override
    public Collection<String> getARDocumentNumbersIncludingHiddenApplicationByCustomerNumber(String customerNumber) {
        ArrayList<String> documentNumbers = new ArrayList<String>();
        Criteria criteria1 = new Criteria();
        criteria1.addEqualTo("customerNumber", (Object)customerNumber);
        ReportQueryByCriteria query = new ReportQueryByCriteria(AccountsReceivableDocumentHeader.class, new String[]{"documentNumber"}, criteria1, true);
        Iterator results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (results.hasNext()) {
            Object[] res = (Object[])results.next();
            documentNumbers.add((String)res[0]);
        }
        if (!documentNumbers.isEmpty()) {
            HashSet appDocumentNumbers = new HashSet();
            Criteria criteria2 = new Criteria();
            criteria2.addIn("financialDocumentReferenceInvoiceNumber", documentNumbers);
            query = new ReportQueryByCriteria(InvoicePaidApplied.class, new String[]{"documentNumber"}, criteria2, true);
            results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
            while (results.hasNext()) {
                Object[] res = (Object[])results.next();
                String documentNumber = (String)res[0];
                if (documentNumbers.contains(documentNumber)) continue;
                documentNumbers.add(documentNumber);
            }
        }
        return documentNumbers;
    }

    @Override
    public Collection<AccountsReceivableDocumentHeader> getARDocumentHeadersIncludingHiddenApplicationByCustomerNumber(String customerNumber) {
        Collection<String> documentNumbers = this.getARDocumentNumbersIncludingHiddenApplicationByCustomerNumber(customerNumber);
        if (!documentNumbers.isEmpty()) {
            Criteria criteria3 = new Criteria();
            criteria3.addIn("documentNumber", documentNumbers);
            return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(AccountsReceivableDocumentHeader.class, (Criteria)criteria3));
        }
        return new ArrayList<AccountsReceivableDocumentHeader>();
    }
}

