/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.event;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEventBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.validation.event.CashControlDetailEvent;

public abstract class CashControlDetailEventBase
extends KualiDocumentEventBase
implements CashControlDetailEvent {
    private static final Logger LOG = Logger.getLogger(CashControlDetailEventBase.class);
    private final CashControlDetail cashControlDetail;

    public CashControlDetailEventBase(String description, String errorPathPrefix, Document document, CashControlDetail cashControlDetail) {
        super(description, errorPathPrefix, document);
        this.cashControlDetail = (CashControlDetail)((Object)ObjectUtils.deepCopy((Serializable)((Object)cashControlDetail)));
        this.logEvent();
    }

    @Override
    public CashControlDetail getCashControlDetail() {
        return this.cashControlDetail;
    }

    public void validate() {
        super.validate();
        if (this.getCashControlDetail() == null) {
            throw new IllegalArgumentException("invalid (null) cash control detail");
        }
    }

    private void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.cashControlDetail == null) {
            logMessage.append("null cashControlDetail");
        } else {
            logMessage.append(" cashControlDetail# ");
            logMessage.append(this.cashControlDetail.getDocumentNumber());
        }
        LOG.debug((Object)logMessage);
    }
}

