/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.module.ar.document.validation.ContinueCustomerInvoiceWriteoffDocumentRule;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerInvoiceWriteoffDocumentRule
extends TransactionalDocumentRuleBase
implements ContinueCustomerInvoiceWriteoffDocumentRule<TransactionalDocument> {
    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean success = super.processCustomSaveDocumentBusinessRules(document);
        GlobalVariables.getMessageMap().addToErrorPath("document");
        CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument = (CustomerInvoiceWriteoffDocument)document;
        success &= this.validateCustomerNote(customerInvoiceWriteoffDocument.getCustomerNote());
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return success &= this.validateWriteoffGLPEGenerationInformation(customerInvoiceWriteoffDocument);
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean success = super.processCustomSaveDocumentBusinessRules(document);
        GlobalVariables.getMessageMap().addToErrorPath("document");
        CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument = (CustomerInvoiceWriteoffDocument)document;
        success &= this.validateCustomerNote(customerInvoiceWriteoffDocument.getCustomerNote());
        success &= this.validateWriteoffGLPEGenerationInformation(customerInvoiceWriteoffDocument);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return success &= this.doesCustomerInvoiceDocumentHaveValidBalance(customerInvoiceWriteoffDocument);
    }

    protected boolean validateCustomerNote(String customerNote) {
        boolean success = true;
        if (StringUtils.isNotEmpty((String)customerNote) && customerNote.trim().length() < 5) {
            GlobalVariables.getMessageMap().putError("customerNote", "error.document.customerInvoiceWriteoff.invalidCustomerNote", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean validateWriteoffGLPEGenerationInformation(CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument) {
        String writeoffTaxGenerationOption;
        boolean success = true;
        String writeoffGenerationOption = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "GLPE_WRITEOFF_GENERATION_METHOD");
        if ("1".equals(writeoffGenerationOption)) {
            for (CustomerInvoiceDetail customerInvoiceDetail : customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getCustomerInvoiceDetailsWithoutDiscounts()) {
                success &= this.doesChartCodeHaveCorrespondingWriteoffObjectCode(customerInvoiceDetail);
            }
        } else if ("2".equals(writeoffGenerationOption)) {
            success &= this.doesOrganizationAccountingDefaultHaveWriteoffInformation(customerInvoiceWriteoffDocument);
        }
        if ("N".equals(writeoffTaxGenerationOption = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "ALLOW_SALES_TAX_LIABILITY_ADJUSTMENT_IND"))) {
            success &= this.doesOrganizationAccountingDefaultHaveWriteoffInformation(customerInvoiceWriteoffDocument);
        }
        return success;
    }

    protected boolean doesChartCodeHaveCorrespondingWriteoffObjectCode(CustomerInvoiceDetail customerInvoiceDetail) {
        boolean success = true;
        String writeoffObjectCode = ((ParameterService)SpringContext.getBean(ParameterService.class)).getSubParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "GLPE_WRITEOFF_OBJECT_CODE_BY_CHART", customerInvoiceDetail.getChartOfAccountsCode());
        if (StringUtils.isBlank((String)writeoffObjectCode)) {
            GlobalVariables.getMessageMap().putError("customerInvoiceDetailsForWriteoff", "error.document.customerInvoiceWriteoff.chartWriteoffObjectDoesntExist", new String[]{customerInvoiceDetail.getChartOfAccountsCode()});
            success = false;
        }
        return success;
    }

    protected boolean doesOrganizationAccountingDefaultHaveWriteoffInformation(CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument) {
        boolean success = true;
        Integer currentFiscalYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        String billByChartOfAccountCode = customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getBillByChartOfAccountCode();
        String billedByOrganizationCode = customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getBilledByOrganizationCode();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", currentFiscalYear);
        criteria.put("chartOfAccountsCode", billByChartOfAccountCode);
        criteria.put("organizationCode", billedByOrganizationCode);
        OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
        if (ObjectUtils.isNotNull((Object)((Object)organizationAccountingDefault))) {
            success &= this.doesWriteoffAccountNumberExist(organizationAccountingDefault);
            success &= this.doesWriteoffChartOfAccountsCodeExist(organizationAccountingDefault);
            success &= this.doesWriteoffFinancialObjectCodeExist(organizationAccountingDefault);
        } else {
            GlobalVariables.getMessageMap().putError("customerInvoiceDetailsForWriteoff", "error.document.customerInvoiceWriteoff.writeoffFAUMustExist", new String[]{currentFiscalYear.toString(), billByChartOfAccountCode, billedByOrganizationCode});
            success = false;
        }
        return success;
    }

    protected boolean doesWriteoffAccountNumberExist(OrganizationAccountingDefault organizationAccountingDefault) {
        if (StringUtils.isBlank((String)organizationAccountingDefault.getWriteoffAccountNumber())) {
            GlobalVariables.getMessageMap().putError("customerInvoiceDetailsForWriteoff", "error.document.customerInvoiceWriteoff.chartWriteoffFAUAccountMustExist", new String[]{organizationAccountingDefault.getUniversityFiscalYear().toString(), organizationAccountingDefault.getChartOfAccountsCode(), organizationAccountingDefault.getOrganizationCode()});
            return false;
        }
        return true;
    }

    protected boolean doesWriteoffChartOfAccountsCodeExist(OrganizationAccountingDefault organizationAccountingDefault) {
        if (StringUtils.isBlank((String)organizationAccountingDefault.getWriteoffChartOfAccountsCode())) {
            GlobalVariables.getMessageMap().putError("customerInvoiceDetailsForWriteoff", "error.document.customerInvoiceWriteoff.chartWriteoffFAUChartMustExist", new String[]{organizationAccountingDefault.getUniversityFiscalYear().toString(), organizationAccountingDefault.getChartOfAccountsCode(), organizationAccountingDefault.getOrganizationCode()});
            return false;
        }
        return true;
    }

    protected boolean doesWriteoffFinancialObjectCodeExist(OrganizationAccountingDefault organizationAccountingDefault) {
        if (StringUtils.isBlank((String)organizationAccountingDefault.getWriteoffFinancialObjectCode())) {
            GlobalVariables.getMessageMap().putError("customerInvoiceDetailsForWriteoff", "error.document.customerInvoiceWriteoff.chartWriteoffFAUObjectMustExist", new String[]{organizationAccountingDefault.getUniversityFiscalYear().toString(), organizationAccountingDefault.getChartOfAccountsCode(), organizationAccountingDefault.getOrganizationCode()});
            return false;
        }
        return true;
    }

    protected boolean doesCustomerInvoiceDocumentHaveValidBalance(CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument) {
        if (KualiDecimal.ZERO.isGreaterEqual((AbstractKualiDecimal)customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getOpenAmount())) {
            GlobalVariables.getMessageMap().putError("customerInvoiceDetailsForWriteoff", "error.document.customerInvoiceWriteoff.invoiceHasCreditBalance", new String[0]);
            return false;
        }
        return true;
    }

    public boolean checkIfThereIsNoAnotherCRMInRouteForTheInvoice(String invoiceDocumentNumber) {
        CustomerInvoiceWriteoffDocumentService service = (CustomerInvoiceWriteoffDocumentService)SpringContext.getBean(CustomerInvoiceWriteoffDocumentService.class);
        boolean success = service.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(invoiceDocumentNumber);
        if (!success) {
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.onlyOneCRMInRoutePerInvoice", new String[0]);
        }
        return success;
    }

    public boolean checkIfThereIsNoAnotherWriteoffInRouteForTheInvoice(String invoiceDocumentNumber) {
        CustomerInvoiceWriteoffDocumentService service = (CustomerInvoiceWriteoffDocumentService)SpringContext.getBean(CustomerInvoiceWriteoffDocumentService.class);
        boolean success = service.checkIfThereIsNoAnotherWriteoffInRouteForTheInvoice(invoiceDocumentNumber);
        if (!success) {
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerInvoiceWriteoff.onlyOneWriteoffInRoutePerInvoice", new String[0]);
        }
        return success;
    }

    @Override
    public boolean processContinueCustomerInvoiceWriteoffDocumentRules(TransactionalDocument document) {
        CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument = (CustomerInvoiceWriteoffDocument)document;
        boolean success = this.checkIfInvoiceNumberIsValid(customerInvoiceWriteoffDocument.getFinancialDocumentReferenceInvoiceNumber());
        if (success) {
            success = this.doesCustomerInvoiceDocumentHaveValidBalance(customerInvoiceWriteoffDocument);
        }
        if (success) {
            success = this.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(customerInvoiceWriteoffDocument.getFinancialDocumentReferenceInvoiceNumber());
        }
        if (success) {
            success = this.checkIfThereIsNoAnotherWriteoffInRouteForTheInvoice(customerInvoiceWriteoffDocument.getFinancialDocumentReferenceInvoiceNumber());
        }
        return success;
    }

    public boolean checkIfInvoiceNumberIsValid(String invDocumentNumber) {
        boolean success = true;
        if (ObjectUtils.isNull((Object)invDocumentNumber) || StringUtils.isBlank((String)invDocumentNumber)) {
            success = false;
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.invRefNumberIsRequired", new String[0]);
        } else {
            CustomerInvoiceDocumentService service = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
            CustomerInvoiceDocument customerInvoiceDocument = service.getInvoiceByInvoiceDocumentNumber(invDocumentNumber);
            if (ObjectUtils.isNull((Object)customerInvoiceDocument)) {
                success = false;
                GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.invalidInvoiceDocumentNumber", new String[0]);
            } else if (!((CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class)).checkIfInvoiceNumberIsFinal(invDocumentNumber)) {
                success = false;
                GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerInvoiceDocument.notFinal", new String[0]);
            }
        }
        return success;
    }
}

