/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationInvoiceDetailApply;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentApplicationInvoiceApply
implements Serializable {
    private CustomerInvoiceDocument invoice;
    private List<PaymentApplicationInvoiceDetailApply> detailApplications;
    private String payAppDocNumber;
    private boolean quickApply;
    private boolean quickApplyOldValue;

    public PaymentApplicationInvoiceApply(String payAppDocNumber, CustomerInvoiceDocument invoice) {
        this.invoice = invoice;
        this.detailApplications = new ArrayList<PaymentApplicationInvoiceDetailApply>();
        for (CustomerInvoiceDetail invoiceDetail : invoice.getCustomerInvoiceDetailsWithoutDiscounts()) {
            this.detailApplications.add(new PaymentApplicationInvoiceDetailApply(payAppDocNumber, invoiceDetail));
        }
        this.quickApply = false;
        this.quickApplyOldValue = false;
        this.payAppDocNumber = payAppDocNumber;
    }

    public KualiDecimal getAmountToApply() {
        KualiDecimal applyAmount = KualiDecimal.ZERO;
        for (PaymentApplicationInvoiceDetailApply detailApplication : this.detailApplications) {
            applyAmount = (KualiDecimal)applyAmount.add((AbstractKualiDecimal)detailApplication.getAmountApplied());
        }
        return applyAmount;
    }

    public boolean isAnyAppliedAmounts() {
        for (PaymentApplicationInvoiceDetailApply detailApplication : this.detailApplications) {
            if (!detailApplication.getAmountApplied().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    public List<PaymentApplicationInvoiceDetailApply> getDetailApplications() {
        return this.detailApplications;
    }

    public String getDocumentNumber() {
        return this.invoice.getDocumentNumber();
    }

    public KualiDecimal getOpenAmount() {
        return this.invoice.getOpenAmount();
    }

    public boolean isQuickApply() {
        return this.quickApply;
    }

    public void setQuickApply(boolean quickApply) {
        this.quickApplyOldValue = this.quickApply;
        this.quickApply = quickApply;
        for (PaymentApplicationInvoiceDetailApply detailApplication : this.detailApplications) {
            detailApplication.setInvoiceQuickApplied(quickApply);
        }
    }

    public boolean isQuickApplyChanged() {
        return this.quickApply != this.quickApplyOldValue;
    }

    public CustomerInvoiceDocument getInvoice() {
        return this.invoice;
    }
}

