/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.identity.OrganizationHierarchyAwareRoleTypeServiceBase;
import org.kuali.rice.core.api.uif.RemotableAttributeError;

public class CollectorRoleTypeServiceImpl
extends OrganizationHierarchyAwareRoleTypeServiceBase {
    public boolean performMatch(Map<String, String> qualification, Map<String, String> roleQualifier) {
        boolean matches = false;
        matches = this.doesCustomerMatch(qualification, roleQualifier);
        String billingChartOfAccountsCode = qualification.get("billingChartOfAccountsCode");
        String billingOrganizationCode = qualification.get("billingOrganizationCode");
        String processingChartOfAccountsCode = qualification.get("processingChartOfAccountsCode");
        String processingOrganizationCode = qualification.get("processingOrganizationCode");
        if (StringUtils.isNotBlank((String)billingChartOfAccountsCode) && StringUtils.isNotBlank((String)billingOrganizationCode) || StringUtils.isNotBlank((String)processingChartOfAccountsCode) && StringUtils.isNotBlank((String)processingOrganizationCode)) {
            matches &= this.doesOrgMatch(billingChartOfAccountsCode, billingOrganizationCode, "billingChartOfAccountsCode", "billingOrganizationCode", roleQualifier) || this.doesOrgMatch(processingChartOfAccountsCode, processingOrganizationCode, "processingChartOfAccountsCode", "processingOrganizationCode", roleQualifier);
        }
        return matches;
    }

    protected boolean doesOrgMatch(String chartOfAccountsCode, String organizationCode, String chartOfAccountsCodeKey, String organizationCodeKey, Map<String, String> roleQualifier) {
        boolean orgMatches = false;
        String chart = roleQualifier.get(chartOfAccountsCodeKey);
        String org = roleQualifier.get(organizationCodeKey);
        if (StringUtils.isNotEmpty((String)chart) && StringUtils.isNotEmpty((String)org) && StringUtils.isNotEmpty((String)chartOfAccountsCode) && StringUtils.isNotEmpty((String)organizationCode) && this.isParentOrg(chartOfAccountsCode, organizationCode, chart, org, true)) {
            orgMatches = true;
        }
        return orgMatches;
    }

    protected boolean doesCustomerMatch(Map<String, String> qualification, Map<String, String> roleQualifier) {
        String customerName;
        boolean customerMatches = true;
        if (qualification != null && !qualification.isEmpty() && roleQualifier != null && !roleQualifier.isEmpty() && StringUtils.isNotEmpty((String)(customerName = qualification.get("customerName")))) {
            char startingQualificationLetter = customerName.charAt(0);
            char endingQualificationLetter = customerName.charAt(0);
            String startingQualifierLetter = roleQualifier.get("customerNameStartingLetter");
            String endingQualifierLetter = roleQualifier.get("customerNameEndingLetter");
            if (StringUtils.isNotEmpty((String)startingQualifierLetter) && StringUtils.isNotEmpty((String)endingQualifierLetter) && (startingQualificationLetter < startingQualifierLetter.charAt(0) || endingQualificationLetter > endingQualifierLetter.charAt(0))) {
                customerMatches = false;
            }
        }
        return customerMatches;
    }

    public List<RemotableAttributeError> validateAttributes(String kimTypeId, Map<String, String> attributes) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        errors.addAll(super.validateAttributes(kimTypeId, attributes));
        RemotableAttributeError.Builder errorBuilder = null;
        String billingChartCode = attributes.get("billingChartOfAccountsCode");
        String billingOrganizationCode = attributes.get("billingOrganizationCode");
        String processingChartCode = attributes.get("processingChartOfAccountsCode");
        String processingOrganizationCode = attributes.get("processingOrganizationCode");
        if (StringUtils.isNotEmpty((String)billingChartCode)) {
            if (StringUtils.isEmpty((String)billingOrganizationCode)) {
                errorBuilder = RemotableAttributeError.Builder.create((String)"billingOrganizationCode", (String[])new String[]{"error.billingchart.or.billingorg.notempty.all.required"});
                errors.add(errorBuilder.build());
            }
            if (StringUtils.isNotEmpty((String)processingChartCode)) {
                errorBuilder = RemotableAttributeError.Builder.create((String)"processingChartOfAccountsCode", (String[])new String[]{"error.either.billingchart.or.processchart.required.not.both"});
                errors.add(errorBuilder.build());
            }
            if (StringUtils.isNotEmpty((String)processingOrganizationCode)) {
                errorBuilder = RemotableAttributeError.Builder.create((String)"processingOrganizationCode", (String[])new String[]{"error.either.billingchart.or.processchart.required.not.both"});
                errors.add(errorBuilder.build());
            }
        } else if (StringUtils.isNotEmpty((String)billingOrganizationCode)) {
            errorBuilder = RemotableAttributeError.Builder.create((String)"billingChartOfAccountsCode", (String[])new String[]{"error.billingchart.or.billingorg.notempty.all.required"});
            errors.add(errorBuilder.build());
            if (StringUtils.isNotEmpty((String)processingChartCode)) {
                errorBuilder = RemotableAttributeError.Builder.create((String)"processingChartOfAccountsCode", (String[])new String[]{"error.either.billingchart.or.processchart.required.not.both"});
                errors.add(errorBuilder.build());
            }
            if (StringUtils.isNotEmpty((String)processingOrganizationCode)) {
                errorBuilder = RemotableAttributeError.Builder.create((String)"processingOrganizationCode", (String[])new String[]{"error.either.billingchart.or.processchart.required.not.both"});
                errors.add(errorBuilder.build());
            }
        } else if (StringUtils.isEmpty((String)processingChartCode)) {
            if (StringUtils.isNotEmpty((String)processingOrganizationCode)) {
                errorBuilder = RemotableAttributeError.Builder.create((String)"processingOrganizationCode", (String[])new String[]{"error.processchart.or.processorg.notempty.all.required"});
                errors.add(errorBuilder.build());
            } else {
                errorBuilder = RemotableAttributeError.Builder.create((String)"billingChartOfAccountsCode", (String[])new String[]{"error.either.billingchart.or.processchart.required.not.both"});
                errors.add(errorBuilder.build());
            }
        } else if (StringUtils.isEmpty((String)processingOrganizationCode)) {
            errorBuilder = RemotableAttributeError.Builder.create((String)"billingChartOfAccountsCode", (String[])new String[]{"error.either.billingchart.or.processchart.required.not.both"});
            errors.add(errorBuilder.build());
        }
        String startingLetter = attributes.get("customerNameStartingLetter");
        String endingLetter = attributes.get("customerNameEndingLetter");
        if (StringUtils.isNotEmpty((String)startingLetter)) {
            if (StringUtils.isNotEmpty((String)endingLetter)) {
                char customerNameEndingLetter;
                char customerNameStartingLetter = attributes.get("customerNameStartingLetter").charAt(0);
                if (customerNameStartingLetter > (customerNameEndingLetter = attributes.get("customerNameEndingLetter").charAt(0))) {
                    errorBuilder = RemotableAttributeError.Builder.create((String)"customerNameStartingLetter", (String[])new String[]{"error.startletter.after.endletter"});
                    errors.add(errorBuilder.build());
                }
            } else {
                errorBuilder = RemotableAttributeError.Builder.create((String)"customerNameStartingLetter", (String[])new String[]{"error.startletter.or.endletter.notempty.all.required"});
                errors.add(errorBuilder.build());
            }
        } else if (StringUtils.isNotEmpty((String)endingLetter)) {
            errorBuilder = RemotableAttributeError.Builder.create((String)"customerNameStartingLetter", (String[])new String[]{"error.startletter.or.endletter.notempty.all.required"});
            errors.add(errorBuilder.build());
        }
        return errors;
    }
}

