/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.time.DateUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAgingReportDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.dataaccess.CustomerAgingReportDao;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.CustomerAgingReportService;
import org.kuali.kfs.module.ar.report.util.CustomerAgingReportDataHolder;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerAgingReportServiceImpl
implements CustomerAgingReportService {
    protected ParameterService parameterService;
    protected DateTimeService dateTimeService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected CustomerAgingReportDao customerAgingReportDao;

    @Override
    public CustomerAgingReportDataHolder calculateAgingReportAmounts(Collection<CustomerInvoiceDetail> details, Date reportRunDate) {
        CustomerAgingReportDataHolder agingData = new CustomerAgingReportDataHolder();
        KualiDecimal total0to30 = KualiDecimal.ZERO;
        KualiDecimal total31to60 = KualiDecimal.ZERO;
        KualiDecimal total61to90 = KualiDecimal.ZERO;
        KualiDecimal total91toSYSPR = KualiDecimal.ZERO;
        KualiDecimal totalSYSPRplus1orMore = KualiDecimal.ZERO;
        String nbrDaysForLastBucket = this.parameterService.getParameterValueAsString(CustomerAgingReportDetail.class, "CUSTOMER_INVOICE_AGE");
        Date cutoffdate30 = DateUtils.addDays((Date)reportRunDate, (int)-30);
        Date cutoffdate60 = DateUtils.addDays((Date)reportRunDate, (int)-60);
        Date cutoffdate90 = DateUtils.addDays((Date)reportRunDate, (int)-90);
        Date cutoffdate120 = DateUtils.addDays((Date)reportRunDate, (int)(-1 * Integer.parseInt(nbrDaysForLastBucket)));
        HashMap<String, Object> knownCustomers = new HashMap<String, Object>(details.size());
        HashMap<String, CustomerInvoiceDocument> retrievedInvoices = new HashMap<String, CustomerInvoiceDocument>();
        KualiDecimal totalBalance = new KualiDecimal(0.0);
        CustomerAgingReportDetail custDetail = null;
        for (CustomerInvoiceDetail cid : details) {
            java.sql.Date approvalDate;
            CustomerInvoiceDocument custInvoice;
            String invoiceDocumentNumber = cid.getDocumentNumber();
            if (retrievedInvoices.containsKey(invoiceDocumentNumber)) {
                custInvoice = (CustomerInvoiceDocument)retrievedInvoices.get(invoiceDocumentNumber);
            } else {
                custInvoice = this.customerInvoiceDocumentService.getInvoiceByInvoiceDocumentNumber(invoiceDocumentNumber);
                retrievedInvoices.put(invoiceDocumentNumber, custInvoice);
            }
            if (ObjectUtils.isNull((Object)(approvalDate = custInvoice.getBillingDate())) || !ObjectUtils.isNotNull((Object)custInvoice) || !cid.getAmountOpen().isNonZero() || !cid.getAmount().isPositive()) continue;
            Customer customerobj = custInvoice.getCustomer();
            String customerNumber = customerobj.getCustomerNumber();
            String customerName = customerobj.getCustomerName();
            if (knownCustomers.containsKey(customerNumber)) {
                custDetail = (CustomerAgingReportDetail)((Object)knownCustomers.get(customerNumber));
            } else {
                custDetail = new CustomerAgingReportDetail();
                custDetail.setCustomerName(customerName);
                custDetail.setCustomerNumber(customerNumber);
                knownCustomers.put(customerNumber, (Object)custDetail);
            }
            KualiDecimal amountOpenOnReportRunDate = cid.getAmountOpenByDateFromDatabase(reportRunDate);
            if (!approvalDate.after(reportRunDate) && !approvalDate.before(cutoffdate30)) {
                custDetail.setUnpaidBalance0to30((KualiDecimal)amountOpenOnReportRunDate.add((AbstractKualiDecimal)custDetail.getUnpaidBalance0to30()));
                total0to30 = (KualiDecimal)total0to30.add((AbstractKualiDecimal)amountOpenOnReportRunDate);
            } else if (approvalDate.before(cutoffdate30) && !approvalDate.before(cutoffdate60)) {
                custDetail.setUnpaidBalance31to60((KualiDecimal)amountOpenOnReportRunDate.add((AbstractKualiDecimal)custDetail.getUnpaidBalance31to60()));
                total31to60 = (KualiDecimal)total31to60.add((AbstractKualiDecimal)amountOpenOnReportRunDate);
            } else if (approvalDate.before(cutoffdate60) && !approvalDate.before(cutoffdate90)) {
                custDetail.setUnpaidBalance61to90((KualiDecimal)amountOpenOnReportRunDate.add((AbstractKualiDecimal)custDetail.getUnpaidBalance61to90()));
                total61to90 = (KualiDecimal)total61to90.add((AbstractKualiDecimal)amountOpenOnReportRunDate);
            } else if (approvalDate.before(cutoffdate90) && !approvalDate.before(cutoffdate120)) {
                custDetail.setUnpaidBalance91toSYSPR((KualiDecimal)amountOpenOnReportRunDate.add((AbstractKualiDecimal)custDetail.getUnpaidBalance91toSYSPR()));
                total91toSYSPR = (KualiDecimal)total91toSYSPR.add((AbstractKualiDecimal)amountOpenOnReportRunDate);
            } else if (approvalDate.before(cutoffdate120)) {
                custDetail.setUnpaidBalanceSYSPRplus1orMore((KualiDecimal)amountOpenOnReportRunDate.add((AbstractKualiDecimal)custDetail.getUnpaidBalanceSYSPRplus1orMore()));
                totalSYSPRplus1orMore = (KualiDecimal)totalSYSPRplus1orMore.add((AbstractKualiDecimal)amountOpenOnReportRunDate);
            }
            totalBalance = (KualiDecimal)totalBalance.add((AbstractKualiDecimal)amountOpenOnReportRunDate);
        }
        agingData.setTotal0to30(total0to30);
        agingData.setTotal31to60(total31to60);
        agingData.setTotal61to90(total61to90);
        agingData.setTotal91toSYSPR(total91toSYSPR);
        agingData.setTotalSYSPRplus1orMore(totalSYSPRplus1orMore);
        agingData.setTotalAmountDue(totalBalance);
        agingData.setKnownCustomers(knownCustomers);
        return agingData;
    }

    @Override
    public HashMap<String, KualiDecimal> findInvoiceAmountByProcessingChartAndOrg(String chart, String org, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findInvoiceAmountByProcessingChartAndOrg(chart, org, begin, end);
    }

    @Override
    public HashMap<String, KualiDecimal> findAppliedAmountByProcessingChartAndOrg(String chart, String org, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findAppliedAmountByProcessingChartAndOrg(chart, org, begin, end);
    }

    @Override
    public HashMap<String, KualiDecimal> findDiscountAmountByProcessingChartAndOrg(String chart, String org, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findDiscountAmountByProcessingChartAndOrg(chart, org, begin, end);
    }

    @Override
    public HashMap<String, KualiDecimal> findInvoiceAmountByBillingChartAndOrg(String chart, String org, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findInvoiceAmountByBillingChartAndOrg(chart, org, begin, end);
    }

    @Override
    public HashMap<String, KualiDecimal> findAppliedAmountByBillingChartAndOrg(String chart, String org, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findAppliedAmountByBillingChartAndOrg(chart, org, begin, end);
    }

    @Override
    public HashMap<String, KualiDecimal> findDiscountAmountByBillingChartAndOrg(String chart, String org, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findDiscountAmountByBillingChartAndOrg(chart, org, begin, end);
    }

    @Override
    public HashMap<String, KualiDecimal> findInvoiceAmountByAccount(String chart, String account, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findInvoiceAmountByAccount(chart, account, begin, end);
    }

    @Override
    public HashMap<String, KualiDecimal> findAppliedAmountByAccount(String chart, String account, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findAppliedAmountByAccount(chart, account, begin, end);
    }

    @Override
    public HashMap<String, KualiDecimal> findDiscountAmountByAccount(String chart, String account, java.sql.Date begin, java.sql.Date end) {
        return this.getCustomerAgingReportDao().findDiscountAmountByAccount(chart, account, begin, end);
    }

    @Override
    public KualiDecimal findWriteOffAmountByCustomerNumber(String customerNumber) {
        return this.getCustomerAgingReportDao().findWriteOffAmountByCustomerNumber(customerNumber);
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public CustomerAgingReportDao getCustomerAgingReportDao() {
        return this.customerAgingReportDao;
    }

    public void setCustomerAgingReportDao(CustomerAgingReportDao customerAgingReportDao) {
        this.customerAgingReportDao = customerAgingReportDao;
    }
}

