/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAgencyAddress;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.service.CustomerDocumentService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerDocumentServiceImpl
implements CustomerDocumentService {
    protected CustomerService customerService;
    protected DocumentService documentService;
    protected DataDictionaryService dataDictionaryService;
    protected KualiModuleService kualiModuleService;
    protected MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    protected WorkflowDocumentService workflowDocumentService;

    @Override
    public String createAndSaveCustomer(String description, ContractsAndGrantsBillingAgency agency) throws WorkflowException {
        MaintenanceDocument doc = null;
        doc = (MaintenanceDocument)this.documentService.getNewDocument(this.maintenanceDocumentDictionaryService.getDocumentTypeName(Customer.class));
        doc.getDocumentHeader().setDocumentDescription(this.truncateField(DocumentHeader.class, "documentDescription", description));
        doc.getDocumentHeader().setExplanation(description + "(Agency Number - " + agency.getAgencyNumber() + " )");
        doc.refreshNonUpdateableReferences();
        Customer customer = (Customer)doc.getNewMaintainableObject().getBusinessObject();
        customer.setCustomerName(this.truncateField(agency.getClass(), "customerName", agency.getReportingName().toUpperCase()));
        customer.setCustomerTypeCode(this.truncateField(agency.getClass(), "customerTypeCode", agency.getCustomerTypeCode()));
        if (agency.isActive()) {
            customer.setActive(true);
        }
        String customerNumber = this.customerService.getNextCustomerNumber(customer);
        customer.setCustomerNumber(customerNumber);
        List agencyAddresses = new ArrayList();
        if (agency.getAgencyAddresses() == null || agency.getAgencyAddresses().isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("agencyNumber", agency.getAgencyNumber());
            agencyAddresses = this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsAgencyAddress.class).getExternalizableBusinessObjectsList(ContractsAndGrantsAgencyAddress.class, (Map)map);
        } else {
            agencyAddresses = agency.getAgencyAddresses();
        }
        for (ContractsAndGrantsAgencyAddress agencyAddress : agencyAddresses) {
            CustomerAddress customerAddress = new CustomerAddress();
            customerAddress.setCustomerAddressName(this.truncateField(CustomerAddress.class, "customerAddressName", agencyAddress.getAgencyAddressName()));
            customerAddress.setCustomerAddressTypeCode(this.truncateField(CustomerAddress.class, "customerAddressTypeCode", agencyAddress.getCustomerAddressTypeCode()));
            customerAddress.setCustomerLine1StreetAddress(this.truncateField(CustomerAddress.class, "customerLine1StreetAddress", agencyAddress.getAgencyLine1StreetAddress()));
            customerAddress.setCustomerLine2StreetAddress(this.truncateField(CustomerAddress.class, "customerLine2StreetAddress", agencyAddress.getAgencyLine2StreetAddress()));
            customerAddress.setCustomerCityName(this.truncateField(CustomerAddress.class, "customerCityName", agencyAddress.getAgencyCityName()));
            customerAddress.setCustomerCountryCode(this.truncateField(CustomerAddress.class, "customerCountryCode", agencyAddress.getAgencyCountryCode()));
            customerAddress.setCustomerStateCode(this.truncateField(CustomerAddress.class, "customerStateCode", agencyAddress.getAgencyStateCode()));
            customerAddress.setCustomerZipCode(this.truncateField(CustomerAddress.class, "customerZipCode", agencyAddress.getAgencyZipCode()));
            customerAddress.setCustomerAddressInternationalProvinceName(this.truncateField(CustomerAddress.class, "customerAddressInternationalProvinceName", agencyAddress.getAgencyAddressInternationalProvinceName()));
            customerAddress.setCustomerInternationalMailCode(this.truncateField(CustomerAddress.class, "customerInternationalMailCode", agencyAddress.getAgencyInternationalMailCode()));
            customerAddress.setCustomerEmailAddress(this.truncateField(CustomerAddress.class, "customerEmailAddress", agencyAddress.getAgencyContactEmailAddress()));
            customer.getCustomerAddresses().add(customerAddress);
        }
        this.documentService.saveDocument((Document)doc);
        this.documentService.prepareWorkflowDocument((Document)doc);
        this.workflowDocumentService.route(doc.getDocumentHeader().getWorkflowDocument(), "", null);
        DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
        documentAttributeIndexingQueue.indexDocument(doc.getDocumentNumber());
        return customerNumber;
    }

    protected String truncateField(Class<? extends BusinessObject> boClass, String targetPropertyName, String value) {
        Integer maxLength = this.getDataDictionaryService().getAttributeMaxLength(boClass, targetPropertyName);
        if (StringUtils.isBlank((String)value) || ObjectUtils.isNull((Object)maxLength) || maxLength > value.length()) {
            return value;
        }
        return value.substring(0, maxLength);
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    @NonTransactional
    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        return this.maintenanceDocumentDictionaryService;
    }

    public void setMaintenanceDocumentDictionaryService(MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService) {
        this.maintenanceDocumentDictionaryService = maintenanceDocumentDictionaryService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

