/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.module.ar.batch.CustomerLoadInputFileType;
import org.kuali.kfs.module.ar.batch.vo.CustomerAddressVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerVO;
import org.kuali.kfs.module.ar.batch.vo.CustomersVO;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.impl.BatchInputFileServiceImpl;
import org.kuali.kfs.sys.exception.XmlErrorHandler;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.xml.sax.ErrorHandler;

@ExtendWith(value={MockitoExtension.class})
class CustomerLoadInputTypeTest {
    private static final String XML_SAMPLE_FILE = "org/kuali/kfs/module/ar/batch/sample/CustomerLoad-Sample.xml";
    private static final String SCHEMA_FILE = "org/kuali/kfs/module/ar/batch/customer.xsd";
    @Spy
    private CustomerLoadInputFileType cut;

    CustomerLoadInputTypeTest() {
    }

    @Test
    void validateSampleAgainstSchema() throws Exception {
        InputStream sampleInputStream = ClassLoader.getSystemResourceAsStream(XML_SAMPLE_FILE);
        StreamSource sampleSource = new StreamSource(sampleInputStream);
        URL schemaUrl = this.getClass().getClassLoader().getResource(SCHEMA_FILE);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        Validator validator = schema.newValidator();
        validator.setErrorHandler((ErrorHandler)new XmlErrorHandler());
        Assertions.assertDoesNotThrow(() -> validator.validate(sampleSource));
    }

    @Test
    void customerLoadInputFileType() throws Exception {
        BatchInputFileServiceImpl batchInputFileService = new BatchInputFileServiceImpl();
        this.cut.setSchemaLocation(SCHEMA_FILE);
        this.cut.setOutputClass(CustomersVO.class);
        URL schemaUrl = this.getClass().getClassLoader().getResource(SCHEMA_FILE);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        ((CustomerLoadInputFileType)Mockito.doReturn((Object)schema).when((Object)this.cut)).getSchema(SCHEMA_FILE);
        InputStream sampleFileStream = ClassLoader.getSystemResourceAsStream(XML_SAMPLE_FILE);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)sampleFileStream);
        CustomersVO parsedVO = (CustomersVO)batchInputFileService.parse((BatchInputFileType)this.cut, fileByteContent);
        List parsedCustomerList = parsedVO.getCustomerVOs();
        Assertions.assertEquals((int)2, (int)parsedCustomerList.size());
        Assertions.assertEquals((Object)"Sample Customer One", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerName());
        Assertions.assertEquals((Object)"johndoe@samplecustomerone.com", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerEmailAddress());
        Assertions.assertEquals((Object)"121231234", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerTaxNbr());
        Assertions.assertEquals((Object)"8005551212", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomer800PhoneNumber());
        Assertions.assertEquals((Object)"Y", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerActiveIndicator());
        Assertions.assertEquals((Object)"John Doe", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerContactName());
        Assertions.assertEquals((Object)"5205551212", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerContactPhoneNumber());
        Assertions.assertEquals((Object)"", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerCreditApprovedByName());
        Assertions.assertNull((Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerFaxNumber());
        Assertions.assertEquals((Object)"", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerParentCompanyNumber());
        Assertions.assertEquals((Object)"5205551212", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerPhoneNumber());
        Assertions.assertEquals((Object)"Y", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerTaxExemptIndicator());
        Assertions.assertEquals((Object)"FEIN", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerTaxTypeCode());
        Assertions.assertEquals((Object)"05", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerTypeCode());
        Assertions.assertEquals((Object)"2008-06-01", (Object)((CustomerVO)parsedCustomerList.get(0)).getCustomerLastActivityDate());
        Assertions.assertEquals((int)2, (int)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().size());
        Assertions.assertEquals((Object)"Headquarters", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerAddressName());
        Assertions.assertEquals((Object)"1234 N Any St", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerLine1StreetAddress());
        Assertions.assertEquals((Object)"Suite 440", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerLine2StreetAddress());
        Assertions.assertEquals((Object)"Phoenix", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerCityName());
        Assertions.assertEquals((Object)"AZ", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerStateCode());
        Assertions.assertEquals((Object)"85828", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerZipCode());
        Assertions.assertEquals((Object)"US", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerCountryCode());
        Assertions.assertEquals((Object)"", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerInternationalMailCode());
        Assertions.assertEquals((Object)"", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerAddressInternationalProvinceName());
        Assertions.assertEquals((Object)"support@samplecustomerone.com", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerEmailAddress());
        Assertions.assertEquals((Object)"P", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerAddressTypeCode());
        Assertions.assertEquals((Object)"2099-01-01", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerAddressEndDate());
        Assertions.assertEquals((Object)"Sales Office", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerAddressName());
        Assertions.assertEquals((Object)"4983 N Another St", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerLine1StreetAddress());
        Assertions.assertEquals((Object)"", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerLine2StreetAddress());
        Assertions.assertEquals((Object)"New York", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerCityName());
        Assertions.assertEquals((Object)"NY", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerStateCode());
        Assertions.assertEquals((Object)"01298", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerZipCode());
        Assertions.assertEquals((Object)"US", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerCountryCode());
        Assertions.assertEquals((Object)"", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerInternationalMailCode());
        Assertions.assertEquals((Object)"", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerAddressInternationalProvinceName());
        Assertions.assertEquals((Object)"sales@samplecustomerone.com", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerEmailAddress());
        Assertions.assertEquals((Object)"A", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerAddressTypeCode());
        Assertions.assertEquals((Object)"2099-01-01", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerAddressEndDate());
        Assertions.assertEquals((Object)"Jack Brown", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerName());
        Assertions.assertEquals((Object)"jackbrown@aol.com", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerEmailAddress());
        Assertions.assertEquals((Object)"111223333", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerTaxNbr());
        Assertions.assertEquals((Object)"", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomer800PhoneNumber());
        Assertions.assertEquals((Object)"Y", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerActiveIndicator());
        Assertions.assertEquals((Object)"Jack Brown", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerContactName());
        Assertions.assertEquals((Object)"5205551212", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerContactPhoneNumber());
        Assertions.assertEquals((Object)"", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerCreditApprovedByName());
        Assertions.assertNull((Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerFaxNumber());
        Assertions.assertEquals((Object)"", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerParentCompanyNumber());
        Assertions.assertEquals((Object)"5205551212", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerPhoneNumber());
        Assertions.assertEquals((Object)"N", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerTaxExemptIndicator());
        Assertions.assertEquals((Object)"SSN", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerTaxTypeCode());
        Assertions.assertEquals((Object)"08", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerTypeCode());
        Assertions.assertEquals((Object)"2008-09-16", (Object)((CustomerVO)parsedCustomerList.get(1)).getCustomerLastActivityDate());
        Assertions.assertEquals((int)1, (int)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().size());
        Assertions.assertEquals((Object)"Home", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerAddressName());
        Assertions.assertEquals((Object)"1234 N Any St", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerLine1StreetAddress());
        Assertions.assertEquals((Object)"", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerLine2StreetAddress());
        Assertions.assertEquals((Object)"Phoenix", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerCityName());
        Assertions.assertEquals((Object)"AZ", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerStateCode());
        Assertions.assertEquals((Object)"85828", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerZipCode());
        Assertions.assertEquals((Object)"US", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerCountryCode());
        Assertions.assertEquals((Object)"", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerInternationalMailCode());
        Assertions.assertEquals((Object)"", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerAddressInternationalProvinceName());
        Assertions.assertEquals((Object)"jackbrown@aol.com", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerEmailAddress());
        Assertions.assertEquals((Object)"P", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerAddressTypeCode());
        Assertions.assertEquals((Object)"2099-01-01", (Object)((CustomerAddressVO)((CustomerVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerAddressEndDate());
    }
}

