/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.businessobject.Bill;

class BillBuilderTest {
    private Bill.BillBuilder cut;

    BillBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new Bill.BillBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(true).setBillNumber("1").setBillDescription("bill 1").setBillDate(Date.valueOf(LocalDate.now())).setEstimatedAmount(new KualiDecimal(100.0));
    }

    @Test
    void milestoneBuilder_build_allFieldsPopulated_valid() {
        Bill milestone = this.cut.build();
        Assertions.assertNotNull((Object)milestone);
    }

    @Test
    void milestoneBuilder_build_onlyRequiredFieldsPopulated_valid() {
        this.cut.setBillDescription(null);
        Bill bill = this.cut.build();
        Assertions.assertNotNull((Object)bill);
    }

    @Test
    void milestoneBuilder_build_MissingProposalNumber_validateThrowsException() {
        this.cut.setProposalNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Proposal Number is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingChartOfAccountsCode_validateThrowsException() {
        this.cut.setChartOfAccountsCode("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Chart of Accounts Code is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingAccountNumber_validateThrowsException() {
        this.cut.setAccountNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Account Number is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingBillNumber_validateThrowsException() {
        this.cut.setBillNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Bill Number is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingEstimatedAmount_validateThrowsException() {
        this.cut.setEstimatedAmount(null);
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Estimated Amount is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneBuilder_build_MissingBillDate_validateThrowsException() {
        this.cut.setBillDate(null);
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Bill Date is required.", (Object)e.getMessage());
    }
}

