/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;

class PredeterminedBillingScheduleBuilderTest {
    private PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder cut;

    PredeterminedBillingScheduleBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400");
    }

    @Test
    void predeterminedBillingScheduleBuilder_build_withoutBills_valid() {
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assertions.assertNotNull((Object)predeterminedBillingSchedule);
    }

    @Test
    void predeterminedBillingScheduleBuilder_build_withOneBill_valid() {
        Bill bill = new Bill.BillBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(true).setBillNumber("1").setBillDate(Date.valueOf(LocalDate.now())).setEstimatedAmount(new KualiDecimal(100.0)).build();
        this.cut.addBill(bill);
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assertions.assertNotNull((Object)predeterminedBillingSchedule);
    }

    @Test
    void predeterminedBillingScheduleBuilder_build_withMultipleBills_valid() {
        Bill bill1 = new Bill.BillBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(true).setBillNumber("1").setBillDate(Date.valueOf(LocalDate.now().minusDays(1L))).setEstimatedAmount(new KualiDecimal(100.0)).build();
        Bill bill2 = new Bill.BillBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(true).setBillNumber("2").setBillDate(Date.valueOf(LocalDate.now().minusDays(1L))).setEstimatedAmount(new KualiDecimal(100.0)).build();
        this.cut.addBill(bill1).addBill(bill2);
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assertions.assertNotNull((Object)predeterminedBillingSchedule);
    }

    @Test
    void predeterminedBillingScheduleBuilder_build_MissingProposalNumber_validateThrowsException() {
        this.cut.setProposalNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Proposal Number is required.", (Object)e.getMessage());
    }

    @Test
    void predeterminedBillingScheduleBuilder_build_MissingChartOfAccountsCode_validateThrowsException() {
        this.cut.setChartOfAccountsCode("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Chart of Accounts Code is required.", (Object)e.getMessage());
    }

    @Test
    void predeterminedBillingScheduleBuilder_build_MissingAccountNumber_validateThrowsException() {
        this.cut.setAccountNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Account Number is required.", (Object)e.getMessage());
    }
}

