/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.admin.InvoiceTemplateAdminService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class InvoiceTemplateAdminServiceTest {
    private final InvoiceTemplateAdminService cut = new InvoiceTemplateAdminService();
    @Mock
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock;
    @Mock
    private DocumentDictionaryService documentDictionaryServiceMock;
    @Mock
    private PermissionService permissionServiceMock;

    InvoiceTemplateAdminServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut.setDocumentDictionaryService(this.documentDictionaryServiceMock);
        this.cut.setMaintenanceDocumentDictionaryService(this.maintenanceDocumentDictionarySvcMock);
        this.cut.setPermissionService(this.permissionServiceMock);
    }

    private Map<String, String> getRoleQualifications(Person personMock, InvoiceTemplate invoiceTemplate) {
        Map roleQualifications;
        try (MockedStatic kradServiceLocatorWebMockedStatic = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            kradServiceLocatorWebMockedStatic.when(KRADServiceLocatorWeb::getKualiModuleService).thenReturn(Mockito.mock(KualiModuleService.class));
            roleQualifications = this.cut.buildRoleQualifications((Object)invoiceTemplate, personMock.getPrincipalId());
        }
        return roleQualifications;
    }

    private InvoiceTemplate getRealInvoiceTemplate() {
        InvoiceTemplate invoiceTemplate = new InvoiceTemplate();
        invoiceTemplate.setBillByChartOfAccountCode("BL");
        invoiceTemplate.setBilledByOrganizationCode("PSY");
        return invoiceTemplate;
    }

    @Test
    void allowsCopy_nullBo_returnsFalse(@Mock(stubOnly=true) Person personMock) {
        Assertions.assertFalse((boolean)this.cut.allowsCopy(null, personMock));
    }

    @Test
    void allowsCopy_nullDocType_returnsFalse(@Mock(stubOnly=true) Person personMock) {
        InvoiceTemplate invoiceTemplate = this.getRealInvoiceTemplate();
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getDocumentTypeName(invoiceTemplate.getClass())).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)invoiceTemplate, personMock));
    }

    @Test
    void allowsCopy_allowsNewOrCopyFalse_returnsFalse(@Mock(stubOnly=true) Person personMock) {
        InvoiceTemplate invoiceTemplate = this.getRealInvoiceTemplate();
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getDocumentTypeName(invoiceTemplate.getClass())).thenReturn((Object)"ITM");
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getAllowsNewOrCopy("ITM")).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)invoiceTemplate, personMock));
    }

    @Test
    void allowsCopy_createMaintainPermissionTrue_returnsTrue(@Mock(stubOnly=true) Person personMock) {
        InvoiceTemplate invoiceTemplate = this.getRealInvoiceTemplate();
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getDocumentTypeName(invoiceTemplate.getClass())).thenReturn((Object)"ITM");
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getAllowsNewOrCopy("ITM")).thenReturn((Object)true);
        Mockito.when((Object)personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        Map<String, String> roleQualifications = this.getRoleQualifications(personMock, invoiceTemplate);
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(roleQualifications))).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.allowsCopy((BusinessObjectBase)invoiceTemplate, personMock));
    }

    @Test
    void allowsCopy_createMaintainPermissionFalse_returnsFalse(@Mock(stubOnly=true) MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock, @Mock(stubOnly=true) Person personMock) {
        InvoiceTemplate invoiceTemplate = this.getRealInvoiceTemplate();
        Assertions.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)invoiceTemplate, personMock));
    }

    @Test
    void allowsEdit_createMaintainPermissionTrue_returnsTrue(@Mock(stubOnly=true) Person personMock) {
        InvoiceTemplate invoiceTemplate = this.getRealInvoiceTemplate();
        Mockito.when((Object)personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        Map<String, String> roleQualifications = this.getRoleQualifications(personMock, invoiceTemplate);
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(roleQualifications))).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.allowsEdit((BusinessObjectBase)invoiceTemplate, personMock));
    }

    @Test
    void allowsEdit_createMaintainPermissionFalse_returnsFalse(@Mock(stubOnly=true) Person personMock) {
        InvoiceTemplate invoiceTemplate = this.getRealInvoiceTemplate();
        Mockito.when((Object)personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        Map<String, String> roleQualifications = this.getRoleQualifications(personMock, invoiceTemplate);
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(roleQualifications))).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cut.allowsEdit((BusinessObjectBase)invoiceTemplate, personMock));
    }
}

