/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.SecurityLoggingService;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.DunningCampaign;
import org.kuali.kfs.module.ar.businessobject.DunningLetterDistribution;
import org.kuali.kfs.module.ar.businessobject.DunningLetterTemplate;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.lookup.GenerateDunningLettersLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.DunningLetterService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.document.service.impl.DunningLetterServiceImpl;
import org.kuali.kfs.module.ar.fixture.DunningCampaignFixture;
import org.kuali.kfs.module.ar.fixture.DunningLetterDistributionFixture;
import org.kuali.kfs.module.ar.fixture.DunningLetterTemplateFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsReportHelperServiceImpl;
import org.kuali.kfs.module.ar.web.struts.GenerateDunningLettersLookupForm;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DunningLetterDistributionLookupableHelperServiceImplTest {
    private GenerateDunningLettersLookupableHelperServiceImpl cut;
    private final GenerateDunningLettersLookupForm generateDunningLettersLookupForm = new GenerateDunningLettersLookupForm();

    DunningLetterDistributionLookupableHelperServiceImplTest() {
    }

    private static void setupParameterService(ParameterService parameterSvcMck) {
        Mockito.when((Object)parameterSvcMck.getParameterValueAsString(DunningCampaign.class, "FINAL_DAYS_PAST_DUE", "0")).thenReturn((Object)"150");
        Mockito.when((Object)parameterSvcMck.getParameterValueAsString(DunningCampaign.class, "STATE_FINAL_DAYS_PAST_DUE", "0")).thenReturn((Object)"150");
    }

    private static void setupBusinessObjectServices(BusinessObjectDictionaryService businessObjectDictionarySvcMock, BusinessObjectMetaDataService businessObjectMetaDataSvcMock) {
        Mockito.when((Object)businessObjectDictionarySvcMock.getLookupDefaultSortFieldNames(null)).thenReturn(Collections.emptyList());
        Mockito.when((Object)businessObjectMetaDataSvcMock.listPrimaryKeyFieldNames(null)).thenReturn(Collections.emptyList());
    }

    private void setupCut(AccountService accountSvcMock, BusinessObjectAuthorizationService businessObjectAuthorizationSvcMock, BusinessObjectDictionaryService businessObjectDictionarySvcMock, BusinessObjectMetaDataService businessObjectMetaDataSvcMock, BusinessObjectService businessObjectSvcMock, ConfigurationService configurationSvcMock, ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock, DataDictionaryService dataDictionarySvcMock, MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock, ParameterService parameterSvcMck) {
        DunningLetterServiceImpl dunningLetterService = new DunningLetterServiceImpl();
        dunningLetterService.setContractsGrantsInvoiceDocumentService((ContractsGrantsInvoiceDocumentService)new ContractsGrantsInvoiceDocumentServiceImpl());
        this.cut = new GenerateDunningLettersLookupableHelperServiceImpl();
        this.cut.setAccountService(accountSvcMock);
        this.cut.setBusinessObjectAuthorizationService(businessObjectAuthorizationSvcMock);
        this.cut.setBusinessObjectDictionaryService(businessObjectDictionarySvcMock);
        this.cut.setBusinessObjectMetaDataService(businessObjectMetaDataSvcMock);
        this.cut.setBusinessObjectService(businessObjectSvcMock);
        this.cut.setConfigurationService(configurationSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentSvcMock);
        this.cut.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)new ContractsGrantsReportHelperServiceImpl());
        this.cut.setDataDictionaryService(dataDictionarySvcMock);
        this.cut.setDunningLetterService((DunningLetterService)dunningLetterService);
        this.cut.setMaintenanceDocumentDictionaryService(maintenanceDocumentDictionarySvcMock);
        this.cut.setParameterService(parameterSvcMck);
    }

    @Test
    void performLookup_InvoiceFound(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) AccountService accountSvcMock, @Mock(stubOnly=true) BusinessObjectAuthorizationService businessObjectAuthorizationSvcMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionarySvcMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataSvcMock, @Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ConfigurationService configurationSvcMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock, @Mock(stubOnly=true) DataDictionaryService dataDictionarySvcMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock, @Mock(stubOnly=true) MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock, @Mock(stubOnly=true) ParameterService parameterSvcMck, @Mock(stubOnly=true) Person personMock, @Mock(stubOnly=true) SecurityLoggingService securityLoggingSvcMock, @Mock(stubOnly=true) UserSession userSessionMock) {
        Collection lookupResults;
        DunningLetterDistributionLookupableHelperServiceImplTest.setupParameterService(parameterSvcMck);
        DunningLetterDistributionLookupableHelperServiceImplTest.setupBusinessObjectServices(businessObjectDictionarySvcMock, businessObjectMetaDataSvcMock);
        this.setupCut(accountSvcMock, businessObjectAuthorizationSvcMock, businessObjectDictionarySvcMock, businessObjectMetaDataSvcMock, businessObjectSvcMock, configurationSvcMock, contractsGrantsInvoiceDocumentSvcMock, dataDictionarySvcMock, maintenanceDocumentDictionarySvcMock, parameterSvcMck);
        ArrayList<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        Mockito.when((Object)contractsGrantsInvoiceDocumentSvcMock.canViewInvoice(contractsGrantsInvoiceDocumentMock, null)).thenReturn((Object)true);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAge()).thenReturn((Object)10);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber("C1");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        DunningCampaign dunningCampaign = DunningCampaignFixture.AR_DUNC1.createDunningCampaign();
        DunningLetterDistribution dunningLetterDistribution = DunningLetterDistributionFixture.AR_DLD1.createDunningLetterDistribution();
        dunningLetterDistribution.setActiveIndicator(true);
        dunningLetterDistribution.setSendDunningLetterIndicator(true);
        DunningLetterTemplate dunningLetterTemplate = DunningLetterTemplateFixture.CG_DLTS1.createDunningLetterTemplate();
        dunningLetterDistribution.setDunningLetterTemplate(dunningLetterTemplate.getDunningLetterTemplateCode());
        dunningCampaign.getDunningLetterDistributions().add(dunningLetterDistribution);
        Mockito.when((Object)awardMock.getDunningCampaign()).thenReturn((Object)dunningCampaign.getCampaignID());
        Mockito.when((Object)invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        contractsGrantsInvoiceDocuments.add(contractsGrantsInvoiceDocumentMock);
        Mockito.when((Object)((DunningCampaign)businessObjectSvcMock.findBySinglePrimaryKey(DunningCampaign.class, (Object)dunningCampaign.getCampaignID()))).thenReturn((Object)dunningCampaign);
        Mockito.when((Object)((DunningLetterTemplate)businessObjectSvcMock.findBySinglePrimaryKey(DunningLetterTemplate.class, (Object)dunningLetterDistribution.getDunningLetterTemplate()))).thenReturn((Object)dunningLetterTemplate);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put("documentNumber", "1");
        fieldValues.put("documentHeader.financialDocumentStatusCode", "A");
        fieldValues.put("openInvoiceIndicator", "true");
        Mockito.when((Object)contractsGrantsInvoiceDocumentSvcMock.retrieveAllCGInvoicesByCriteria(fieldValues)).thenReturn(contractsGrantsInvoiceDocuments);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
        invoiceAccountDetail.setChartOfAccountsCode("BL");
        invoiceAccountDetail.setAccountNumber("2336320");
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)accountMock.getAccountNumber()).thenReturn((Object)"2336320");
        Mockito.when((Object)accountSvcMock.getByPrimaryId("BL", "2336320")).thenReturn((Object)accountMock);
        Mockito.when((Object)businessObjectDictionarySvcMock.noLookupResultFieldInquiry(Account.class, "accountNumber")).thenReturn(null);
        Mockito.when((Object)businessObjectDictionarySvcMock.noLookupResultFieldInquiry(contractsGrantsInvoiceDocumentMock.getClass(), "age")).thenReturn(null);
        Mockito.when((Object)configurationSvcMock.getPropertyValueAsString("title.return.url.value.prependtext")).thenReturn((Object)"return value");
        LinkedHashMap<String, String> fieldsForLookup = new LinkedHashMap<String, String>();
        fieldsForLookup.put("invoiceDocumentNumber", "1");
        this.generateDunningLettersLookupForm.setFieldsForLookup(fieldsForLookup);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic knsServiceLocatorMockedStatic = Mockito.mockStatic(KNSServiceLocator.class);){
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            knsServiceLocatorMockedStatic.when(KNSServiceLocator::getSecurityLoggingService).thenReturn((Object)securityLoggingSvcMock);
            lookupResults = this.cut.performLookup((LookupForm)this.generateDunningLettersLookupForm, new ArrayList(), true);
        }
        Assertions.assertEquals((int)1, (int)lookupResults.size());
    }

    @Test
    void performLookup_InvoiceNotFound(@Mock(stubOnly=true) AccountService accountSvcMock, @Mock(stubOnly=true) BusinessObjectAuthorizationService businessObjectAuthorizationSvcMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionarySvcMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataSvcMock, @Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ConfigurationService configurationSvcMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock, @Mock(stubOnly=true) DataDictionaryService dataDictionarySvcMock, @Mock(stubOnly=true) MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock, @Mock(stubOnly=true) ParameterService parameterSvcMck, @Mock(stubOnly=true) Person personMock, @Mock(stubOnly=true) SecurityLoggingService securityLoggingSvcMock, @Mock(stubOnly=true) UserSession userSessionMock) {
        Collection lookupResults;
        DunningLetterDistributionLookupableHelperServiceImplTest.setupParameterService(parameterSvcMck);
        DunningLetterDistributionLookupableHelperServiceImplTest.setupBusinessObjectServices(businessObjectDictionarySvcMock, businessObjectMetaDataSvcMock);
        this.setupCut(accountSvcMock, businessObjectAuthorizationSvcMock, businessObjectDictionarySvcMock, businessObjectMetaDataSvcMock, businessObjectSvcMock, configurationSvcMock, contractsGrantsInvoiceDocumentSvcMock, dataDictionarySvcMock, maintenanceDocumentDictionarySvcMock, parameterSvcMck);
        LinkedHashMap<String, String> fieldsForLookup = new LinkedHashMap<String, String>();
        fieldsForLookup.put("invoiceDocumentNumber", "2");
        this.generateDunningLettersLookupForm.setFieldsForLookup(fieldsForLookup);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic knsServiceLocatorMockedStatic = Mockito.mockStatic(KNSServiceLocator.class);){
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            knsServiceLocatorMockedStatic.when(KNSServiceLocator::getSecurityLoggingService).thenReturn((Object)securityLoggingSvcMock);
            lookupResults = this.cut.performLookup((LookupForm)this.generateDunningLettersLookupForm, Collections.emptyList(), true);
        }
        Assertions.assertEquals((int)0, (int)lookupResults.size());
    }
}

