/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.lang.reflect.Field;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.cg.businessobject.Award;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.businessobject.lookup.ScheduleLookupableHelperServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;

@ExtendWith(value={MockitoExtension.class})
class ScheduleLookupableHelperServiceImplTest {
    @Spy
    private TestableScheduleLookupableHelperServiceImpl cutSpy;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private BusinessObjectMetaDataService businessObjectMetaDataSvcMock;
    @Mock
    private LookupService lookupSvcMock;
    private final Map<String, String> fieldValues = new HashMap<String, String>();

    ScheduleLookupableHelperServiceImplTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        DateTimeServiceImpl dateTimeService = new DateTimeServiceImpl();
        Field field = DateTimeServiceImpl.class.getDeclaredField("stringToDateFormats");
        field.setAccessible(true);
        field.set(dateTimeService, new String[]{"MM/dd/yyyy"});
        this.cutSpy.setBusinessObjectMetaDataService(this.businessObjectMetaDataSvcMock);
        this.cutSpy.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cutSpy.setDateTimeService((DateTimeService)dateTimeService);
        this.cutSpy.setLookupService(this.lookupSvcMock);
        this.setupFieldValues();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupFieldValues() {
        this.fieldValues.put("chartOfAccountsCode", "");
        this.fieldValues.put("award.awardEndingDate", "");
        this.fieldValues.put("proposalNumber", "");
        this.fieldValues.put("agencyNumber", "");
        this.fieldValues.put("accountNumber", "");
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "");
    }

    @Test
    void getSearchResults(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        milestoneSchedules.add(milestoneSchedule_80078);
        milestoneSchedules.add(milestoneSchedule_80080);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)3, (int)searchResults.size());
        Assertions.assertEquals(milestoneSchedules, (Object)searchResults);
    }

    @Test
    void getSearchResults_moreThanLimitReturned_listTruncated(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        milestoneSchedules.add(milestoneSchedule_80078);
        milestoneSchedules.add(milestoneSchedule_80080);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)2);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        List expectedSearchResults = milestoneSchedules.subList(0, 2);
        Assertions.assertEquals((int)2, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    void getSearchResults_filterOnAgency(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "55120");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResults_filterOnAgencyWithWildcardAsterisks(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "*551*");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResults_filterOnAgencyWithWildcardPercents(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "%551%");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResults_filterOnAgencyWithWildcardQuestionMark(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "551?0");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResults_filterOnAgencyWithLogicalAnd(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "55078&&55120");
        List expectedSearchResults = Collections.emptyList();
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)0, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    void getSearchResults_filterOnAgencyWithLogicalOr(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "55078|55120");
        ArrayList expectedSearchResults = new ArrayList(milestoneSchedules);
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)3, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    void getSearchResults_filterOnAwardExpirationDateFrom(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)milestoneSchedule_80090.getProposalNumber()).thenReturn((Object)"80090");
        Mockito.when((Object)milestoneSchedule_80090.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80090.getAccountNumber()).thenReturn((Object)"0211910");
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock_80090.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("award.awardEndingDate", ">=01/10/2019");
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().after(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80090", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211910", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2019-12-01"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResults_filterOnAwardExpirationDateTo(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)milestoneSchedule_80078.getProposalNumber()).thenReturn((Object)"80078");
        Mockito.when((Object)milestoneSchedule_80078.getAccountNumber()).thenReturn((Object)"0211603");
        Mockito.when((Object)milestoneSchedule_80078.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock_80078.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("award.awardEndingDate", "<=01/10/2018");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2018-01-10"))).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80078", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211603", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResults_filterOnAwardExpirationDateFromAndTo(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("award.awardEndingDate", "01/10/2018..01/10/2019");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().after(Date.valueOf("2018-01-10")) && milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResults_filterOnAgencyAndAwardExpirationDateFromAndTo(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)milestoneSchedule_80078.getProposalNumber()).thenReturn((Object)"80078");
        Mockito.when((Object)milestoneSchedule_80078.getAccountNumber()).thenReturn((Object)"0211603");
        Mockito.when((Object)milestoneSchedule_80078.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock_80078.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock_80090.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "55078");
        this.fieldValues.put("award.awardEndingDate", "01/10/2016..01/10/2019");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55078")).filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80078", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211603", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResultsUnbounded(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        milestoneSchedules.add(milestoneSchedule_80078);
        milestoneSchedules.add(milestoneSchedule_80080);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)3, (int)searchResults.size());
        Assertions.assertEquals(milestoneSchedules, (Object)searchResults);
    }

    @Test
    void getSearchResultsUnbounded_moreThanLimitReturned_listNotTruncated(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        milestoneSchedules.add(milestoneSchedule_80078);
        milestoneSchedules.add(milestoneSchedule_80080);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)2);
            searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        }
        Assertions.assertEquals((int)3, (int)searchResults.size());
        Assertions.assertEquals(milestoneSchedules, (Object)searchResults);
    }

    @Test
    void getSearchResultsUnbounded_filterOnAgency(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "55120");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResultsUnbounded_filterOnAgencyWithWildcardAsterisks(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "*551*");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResultsUnbounded_filterOnAgencyWithWildcardPercents(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "%551%");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResultsUnbounded_filterOnAgencyWithWildcardQuestionMark(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "551?0");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResultsUnbounded_filterOnAgencyWithLogicalAnd(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "55078&&55120");
        List expectedSearchResults = Collections.emptyList();
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)0, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    void getSearchResultsUnbounded_filterOnAgencyWithLogicalOr(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "55078|55120");
        ArrayList expectedSearchResults = new ArrayList(milestoneSchedules);
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)3, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    void getSearchResultsUnbounded_filterOnAwardExpirationDateFrom(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        List searchResults;
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)milestoneSchedule_80090.getProposalNumber()).thenReturn((Object)"80090");
        Mockito.when((Object)milestoneSchedule_80090.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80090.getAccountNumber()).thenReturn((Object)"0211910");
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock_80090.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("award.awardEndingDate", ">=01/10/2019");
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().after(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80090", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211910", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2019-12-01"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResultsUnbounded_filterOnAwardExpirationDateTo(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)milestoneSchedule_80078.getProposalNumber()).thenReturn((Object)"80078");
        Mockito.when((Object)milestoneSchedule_80078.getAccountNumber()).thenReturn((Object)"0211603");
        Mockito.when((Object)milestoneSchedule_80078.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock_80078.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("award.awardEndingDate", "<=01/10/2018");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2018-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80078", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211603", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResultsUnbounded_filterOnAwardExpirationDateFromAndTo(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)awardMock_80078.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)milestoneSchedule_80080.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)milestoneSchedule_80080.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneSchedule_80080.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock_80080.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("award.awardEndingDate", "01/10/2018..01/10/2019");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().after(Date.valueOf("2018-01-10")) && milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResultsUnbounded_filterOnAgencyAndAwardExpirationDateFromAndTo(@Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80078, @Mock(stubOnly=true) Award awardMock_80078, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80080, @Mock(stubOnly=true) Award awardMock_80080, @Mock(stubOnly=true) MilestoneSchedule milestoneSchedule_80090, @Mock(stubOnly=true) Award awardMock_80090) {
        ArrayList<MilestoneSchedule> milestoneSchedules = new ArrayList<MilestoneSchedule>();
        Mockito.when((Object)milestoneSchedule_80078.getProposalNumber()).thenReturn((Object)"80078");
        Mockito.when((Object)milestoneSchedule_80078.getAccountNumber()).thenReturn((Object)"0211603");
        Mockito.when((Object)milestoneSchedule_80078.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardMock_80078.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock_80078.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)milestoneSchedule_80078.getAward()).thenReturn((Object)awardMock_80078);
        milestoneSchedules.add(milestoneSchedule_80078);
        Mockito.when((Object)awardMock_80080.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)milestoneSchedule_80080.getAward()).thenReturn((Object)awardMock_80080);
        milestoneSchedules.add(milestoneSchedule_80080);
        Mockito.when((Object)awardMock_80090.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock_80090.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)milestoneSchedule_80090.getAward()).thenReturn((Object)awardMock_80090);
        milestoneSchedules.add(milestoneSchedule_80090);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(milestoneSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        this.fieldValues.put("agencyNumber", "55078");
        this.fieldValues.put("award.awardEndingDate", "01/10/2016..01/10/2019");
        List expectedSearchResults = milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55078")).filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80078", (Object)milestoneSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211603", (Object)milestoneSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void validateSearchParameters_emptyAwardEndingDate() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(MilestoneSchedule.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(MilestoneSchedule.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.cutSpy.validateSearchParameters(this.fieldValues);
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validateSearchParameters_validAwardEndingDateFrom() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(MilestoneSchedule.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(MilestoneSchedule.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        this.cutSpy.validateSearchParameters(this.fieldValues);
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validateSearchParameters_validAwardEndingDateTo() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(MilestoneSchedule.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(MilestoneSchedule.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("award.awardEndingDate", "01/10/2019");
        this.cutSpy.validateSearchParameters(this.fieldValues);
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validateSearchParameters_validAwardEndingDateFromAndTo() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(MilestoneSchedule.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(MilestoneSchedule.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("award.awardEndingDate", "01/10/2018");
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        this.cutSpy.validateSearchParameters(this.fieldValues);
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validateSearchParameters_validAwardEndingDateFromAndInvalidAwardEndingDateTo() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(MilestoneSchedule.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(MilestoneSchedule.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        this.fieldValues.put("award.awardEndingDate", "abc");
        Exception e = (Exception)Assertions.assertThrows(ValidationException.class, () -> this.cutSpy.validateSearchParameters(this.fieldValues));
        Assertions.assertEquals((Object)"errors in search criteria", (Object)e.getMessage());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("award.awardEndingDate")).get(0);
        Assertions.assertEquals((Object)"error.invalidDateTime", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Award Ending Date To", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void validateSearchParameters_invalidAwardEndingDateFromAndValidEndingDateTo() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(MilestoneSchedule.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(MilestoneSchedule.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "xyz");
        this.fieldValues.put("award.awardEndingDate", "01/10/2018");
        Exception e = (Exception)Assertions.assertThrows(ValidationException.class, () -> this.cutSpy.validateSearchParameters(this.fieldValues));
        Assertions.assertEquals((Object)"errors in search criteria", (Object)e.getMessage());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("rangeLowerBoundKeyPrefix_award.awardEndingDate")).get(0);
        Assertions.assertEquals((Object)"error.invalidDateTime", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Award Ending Date From", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void validateSearchParameters_invalidAwardEndingDateFromAndTo() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(MilestoneSchedule.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(MilestoneSchedule.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "xyz");
        this.fieldValues.put("award.awardEndingDate", "abc");
        Exception e = (Exception)Assertions.assertThrows(ValidationException.class, () -> this.cutSpy.validateSearchParameters(this.fieldValues));
        Assertions.assertEquals((Object)"errors in search criteria", (Object)e.getMessage());
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("award.awardEndingDate")).get(0);
        Assertions.assertEquals((Object)"error.invalidDateTime", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Award Ending Date To", (Object)errorMessage.getMessageParameters()[0]);
        ErrorMessage errorMessage2 = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("rangeLowerBoundKeyPrefix_award.awardEndingDate")).get(0);
        Assertions.assertEquals((Object)"error.invalidDateTime", (Object)errorMessage2.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage2.getMessageParameters().length);
        Assertions.assertEquals((Object)"Award Ending Date From", (Object)errorMessage2.getMessageParameters()[0]);
    }

    @Test
    void getSearchResults_moreThanLimitReturned_listTruncated_PDBS(@Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock1, @Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock2, @Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock3) {
        List searchResults;
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "xyz");
        this.fieldValues.put("award.awardEndingDate", "abc");
        ArrayList<PredeterminedBillingSchedule> predeterminedBillingSchedules = new ArrayList<PredeterminedBillingSchedule>();
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock1);
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock2);
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock3);
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(PredeterminedBillingSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(predeterminedBillingSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)2);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        List expectedSearchResults = predeterminedBillingSchedules.subList(0, 2);
        Assertions.assertEquals((int)2, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    void getSearchResults_filterOnAgency_PDBS(@Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock1, @Mock(stubOnly=true) Award awardMock1, @Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock2, @Mock(stubOnly=true) Award awardMock2, @Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock3, @Mock(stubOnly=true) Award awardMock3) {
        List searchResults;
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "xyz");
        this.fieldValues.put("award.awardEndingDate", "abc");
        this.fieldValues.put("agencyNumber", "55120");
        ArrayList<PredeterminedBillingSchedule> predeterminedBillingSchedules = new ArrayList<PredeterminedBillingSchedule>();
        Mockito.when((Object)awardMock1.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)predeterminedBillingScheduleMock1.getAward()).thenReturn((Object)awardMock1);
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock1);
        Mockito.when((Object)predeterminedBillingScheduleMock2.getProposalNumber()).thenReturn((Object)"80080");
        Mockito.when((Object)predeterminedBillingScheduleMock2.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)predeterminedBillingScheduleMock2.getAccountNumber()).thenReturn((Object)"0211802");
        Mockito.when((Object)awardMock2.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)awardMock2.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2018-02-05"));
        Mockito.when((Object)predeterminedBillingScheduleMock2.getAward()).thenReturn((Object)awardMock2);
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock2);
        Mockito.when((Object)awardMock3.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)predeterminedBillingScheduleMock3.getAward()).thenReturn((Object)awardMock3);
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock3);
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(PredeterminedBillingSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(predeterminedBillingSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        List expectedSearchResults = predeterminedBillingSchedules.stream().filter(predeterminedBillingSchedule -> predeterminedBillingSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        PredeterminedBillingSchedule predeterminedBillingSchedule2 = (PredeterminedBillingSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80080", (Object)predeterminedBillingSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)predeterminedBillingSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211802", (Object)predeterminedBillingSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55120", (Object)predeterminedBillingSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)predeterminedBillingSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    void getSearchResults_filterOnAgencyAndAwardExpirationDateFromAndTo_PDBS(@Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock1, @Mock(stubOnly=true) Award awardMock1, @Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock2, @Mock(stubOnly=true) Award awardMock2, @Mock(stubOnly=true) PredeterminedBillingSchedule predeterminedBillingScheduleMock3, @Mock(stubOnly=true) Award awardMock3) {
        List searchResults;
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "xyz");
        this.fieldValues.put("agencyNumber", "55078");
        this.fieldValues.put("award.awardEndingDate", "01/10/2016..01/10/2019");
        ArrayList<PredeterminedBillingSchedule> predeterminedBillingSchedules = new ArrayList<PredeterminedBillingSchedule>();
        Mockito.when((Object)predeterminedBillingScheduleMock1.getProposalNumber()).thenReturn((Object)"80078");
        Mockito.when((Object)predeterminedBillingScheduleMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)predeterminedBillingScheduleMock1.getAccountNumber()).thenReturn((Object)"0211603");
        Mockito.when((Object)awardMock1.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2017-02-05"));
        Mockito.when((Object)predeterminedBillingScheduleMock1.getAward()).thenReturn((Object)awardMock1);
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock1);
        Mockito.when((Object)awardMock2.getAgencyNumber()).thenReturn((Object)"55120");
        Mockito.when((Object)predeterminedBillingScheduleMock2.getAward()).thenReturn((Object)awardMock2);
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock2);
        Mockito.when((Object)awardMock3.getAgencyNumber()).thenReturn((Object)"55078");
        Mockito.when((Object)awardMock3.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2019-12-01"));
        Mockito.when((Object)predeterminedBillingScheduleMock3.getAward()).thenReturn((Object)awardMock3);
        predeterminedBillingSchedules.add(predeterminedBillingScheduleMock3);
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(PredeterminedBillingSchedule.class);
        ((TestableScheduleLookupableHelperServiceImpl)((Object)Mockito.doReturn(predeterminedBillingSchedules).when((Object)this.cutSpy))).getSearchResultsHelper(ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true));
        List expectedSearchResults = predeterminedBillingSchedules.stream().filter(predeterminedBillingSchedule -> predeterminedBillingSchedule.getAward().getAgencyNumber().equals("55078")).filter(predeterminedBillingSchedule -> predeterminedBillingSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        try (MockedStatic lookupUtilsMockedStatic = Mockito.mockStatic(LookupUtils.class);){
            lookupUtilsMockedStatic.when(() -> LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
            searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        }
        Assertions.assertEquals((int)1, (int)searchResults.size());
        Assertions.assertEquals(expectedSearchResults, (Object)searchResults);
        PredeterminedBillingSchedule predeterminedBillingSchedule2 = (PredeterminedBillingSchedule)searchResults.get(0);
        Assertions.assertEquals((Object)"80078", (Object)predeterminedBillingSchedule2.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)predeterminedBillingSchedule2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"0211603", (Object)predeterminedBillingSchedule2.getAccountNumber());
        Assertions.assertEquals((Object)"55078", (Object)predeterminedBillingSchedule2.getAward().getAgencyNumber());
        Assertions.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)predeterminedBillingSchedule2.getAward().getAwardEndingDate());
    }

    public static class TestableScheduleLookupableHelperServiceImpl
    extends ScheduleLookupableHelperServiceImpl {
        protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
            return List.of();
        }
    }
}

