/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.TicklersReport;
import org.kuali.kfs.module.ar.businessobject.lookup.TicklersReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsCollectionActivityDocumentService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsReportHelperServiceImpl;
import org.kuali.kfs.module.ar.web.struts.TicklersReportLookupForm;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class TicklersReportLookupableHelperServiceImplTest {
    private TicklersReportLookupableHelperServiceImpl cut;
    private TicklersReportLookupForm ticklersReportLookupForm;

    TicklersReportLookupableHelperServiceImplTest() {
    }

    private void setup(BusinessObjectAuthorizationService businessObjectAuthorizationSvcMock, BusinessObjectDictionaryService businessObjectDictionarySvcMock, BusinessObjectEntry businessObjectEntryMock, BusinessObjectMetaDataService businessObjectMetaDataSvcMock, BusinessObjectService businessObjectSvcMock, ConfigurationService configurationSvcMock, ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService, ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock, LookupService lookupSvcMock, MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock, Person personMock, UserSession userSessionMock) {
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        FieldUtils.setBusinessObjectDictionaryService((BusinessObjectDictionaryService)businessObjectDictionarySvcMock);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        Mockito.when((Object)businessObjectDictionarySvcMock.getBusinessObjectEntry(TicklersReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        ContractsGrantsReportHelperServiceImpl contractsGrantsReportHelperService = new ContractsGrantsReportHelperServiceImpl();
        contractsGrantsReportHelperService.setConfigurationService(configurationSvcMock);
        contractsGrantsReportHelperService.setBusinessObjectDictionaryService(businessObjectDictionarySvcMock);
        Mockito.when((Object)businessObjectMetaDataSvcMock.isLookupable(TicklersReport.class)).thenReturn((Object)true);
        ArrayList lookupFieldAttributeList = new ArrayList();
        Mockito.when((Object)businessObjectMetaDataSvcMock.getLookupableFieldNames(TicklersReport.class)).thenReturn(lookupFieldAttributeList);
        this.cut = new TicklersReportLookupableHelperServiceImpl();
        this.cut.setBusinessObjectAuthorizationService(businessObjectAuthorizationSvcMock);
        this.cut.setBusinessObjectDictionaryService(businessObjectDictionarySvcMock);
        this.cut.setBusinessObjectMetaDataService(businessObjectMetaDataSvcMock);
        this.cut.setBusinessObjectService(businessObjectSvcMock);
        this.cut.setConfigurationService(configurationSvcMock);
        this.cut.setContractsGrantsCollectionActivityDocumentService(contractsGrantsCollectionActivityDocumentService);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentSvcMock);
        this.cut.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)contractsGrantsReportHelperService);
        this.cut.setLookupService(lookupSvcMock);
        this.cut.setMaintenanceDocumentDictionaryService(maintenanceDocumentDictionarySvcMock);
        this.cut.setBusinessObjectClass(TicklersReport.class);
        this.ticklersReportLookupForm = new TicklersReportLookupForm();
        this.ticklersReportLookupForm.setFieldsForLookup(new LinkedHashMap());
    }

    @AfterEach
    void cleanUpAfterOurselfSoSubsequentTestsDoNotReuseOurMocking() {
        FieldUtils.setBusinessObjectDictionaryService(null);
    }

    @Test
    void performLookup(@Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) BusinessObjectAuthorizationService businessObjectAuthorizationSvcMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionarySvcMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataSvcMock, @Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ConfigurationService configurationSvcMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoice, @Mock(stubOnly=true) ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock, @Mock(stubOnly=true) DataDictionaryService dataDictionarySvcMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetail, @Mock(stubOnly=true) LookupService lookupSvcMock, @Mock(stubOnly=true) MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock, @Mock(stubOnly=true) Person personMock, @Mock(stubOnly=true) UserSession userSessionMock) {
        this.setup(businessObjectAuthorizationSvcMock, businessObjectDictionarySvcMock, businessObjectEntryMock, businessObjectMetaDataSvcMock, businessObjectSvcMock, configurationSvcMock, contractsGrantsCollectionActivityDocumentService, contractsGrantsInvoiceDocumentSvcMock, lookupSvcMock, maintenanceDocumentDictionarySvcMock, personMock, userSessionMock);
        Mockito.when((Object)configurationSvcMock.getPropertyValueAsString("workflow.documentsearch.base.url")).thenReturn((Object)"DocumentSearch.do");
        Mockito.when((Object)configurationSvcMock.getPropertyValueAsString("title.inquiry.url.value.prependtext")).thenReturn((Object)"Does not matter");
        Mockito.when((Object)configurationSvcMock.getPropertyValueAsString("message.inquiry.contractsGrantsCollectionActivity.title")).thenReturn((Object)"Does not matter");
        Mockito.when((Object)dataDictionarySvcMock.getAttributeLabel(TicklersReport.class, "proposalNumber")).thenReturn((Object)"Proposal Number");
        Mockito.when((Object)agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)agencyMock.getFullName()).thenReturn((Object)"U.S. AIR FORCE");
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)agencyMock);
        Mockito.when((Object)cgInvoice.isOpenInvoiceIndicator()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetail.getProposalNumber()).thenReturn((Object)"1");
        Mockito.when((Object)invoiceGeneralDetail.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)cgInvoice.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        Mockito.when((Object)cgInvoice.getSourceTotal()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)cgInvoice.getPaymentAmount()).thenReturn((Object)new KualiDecimal(100.0));
        CollectionEvent event = new CollectionEvent();
        event.setId(Long.valueOf(1L));
        event.setInvoiceNumber(cgInvoice.getDocumentNumber());
        event.setActivityCode("TEST");
        event.setUser(personMock);
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", 1L);
        Mockito.when((Object)((CollectionEvent)businessObjectSvcMock.findByPrimaryKey(CollectionEvent.class, primaryKeys))).thenReturn((Object)event);
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        Date today = new Date(ts.getTime());
        event.setFollowupDate(today);
        event.setInvoiceDocument(cgInvoice);
        event.setInvoiceNumber("1");
        ArrayList<CollectionEvent> collectionEvents = new ArrayList<CollectionEvent>();
        collectionEvents.add(event);
        HashMap<String, String> formProps = new HashMap<String, String>();
        formProps.put("followup", "true");
        Mockito.when((Object)lookupSvcMock.findCollectionBySearchUnbounded(CollectionEvent.class, formProps)).thenReturn(collectionEvents);
        Mockito.when((Object)contractsGrantsInvoiceDocumentSvcMock.canViewInvoice(cgInvoice, null)).thenReturn((Object)true);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic knsServiceLocatorMockedStatic = Mockito.mockStatic(KNSServiceLocator.class);){
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            knsServiceLocatorMockedStatic.when(KNSServiceLocator::getDataDictionaryService).thenReturn((Object)dataDictionarySvcMock);
            Collection lookupResults = this.cut.performLookup((LookupForm)this.ticklersReportLookupForm, new ArrayList(), true);
            Assertions.assertEquals((int)1, (int)lookupResults.size());
        }
    }

    @Test
    void performLookup_NoEventsFound(@Mock(stubOnly=true) BusinessObjectAuthorizationService businessObjectAuthorizationSvcMock, @Mock(stubOnly=true) BusinessObjectDictionaryService businessObjectDictionarySvcMock, @Mock(stubOnly=true) BusinessObjectEntry businessObjectEntryMock, @Mock(stubOnly=true) BusinessObjectMetaDataService businessObjectMetaDataSvcMock, @Mock(stubOnly=true) BusinessObjectService businessObjectSvcMock, @Mock(stubOnly=true) ConfigurationService configurationSvcMock, @Mock(stubOnly=true) ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoice, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock, @Mock(stubOnly=true) LookupService lookupSvcMock, @Mock(stubOnly=true) MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock, @Mock(stubOnly=true) Person personMock, @Mock(stubOnly=true) UserSession userSessionMock) {
        this.setup(businessObjectAuthorizationSvcMock, businessObjectDictionarySvcMock, businessObjectEntryMock, businessObjectMetaDataSvcMock, businessObjectSvcMock, configurationSvcMock, contractsGrantsCollectionActivityDocumentService, contractsGrantsInvoiceDocumentSvcMock, lookupSvcMock, maintenanceDocumentDictionarySvcMock, personMock, userSessionMock);
        CollectionEvent event = new CollectionEvent();
        event.setId(Long.valueOf(1L));
        event.setInvoiceNumber(cgInvoice.getDocumentNumber());
        event.setActivityCode("TEST");
        event.setUser(personMock);
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        Date today = new Date(ts.getTime());
        event.setFollowupDate(today);
        event.setInvoiceDocument(cgInvoice);
        event.setInvoiceNumber("1");
        ArrayList<CollectionEvent> collectionEvents = new ArrayList<CollectionEvent>();
        collectionEvents.add(event);
        HashMap<String, String> formProps1 = new HashMap<String, String>();
        formProps1.put("followup", "true");
        Mockito.when((Object)lookupSvcMock.findCollectionBySearchUnbounded(CollectionEvent.class, formProps1)).thenReturn(collectionEvents);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);){
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            HashMap<String, String> formProps = new HashMap<String, String>();
            formProps.put("followup", "true");
            Mockito.when((Object)lookupSvcMock.findCollectionBySearchUnbounded(CollectionEvent.class, formProps)).thenReturn(Collections.emptyList());
            Collection lookupResults = this.cut.performLookup((LookupForm)this.ticklersReportLookupForm, new ArrayList(), true);
            Assertions.assertEquals((int)0, (int)lookupResults.size());
        }
    }
}

