/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.dataaccess;

import java.util.HashMap;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.dataaccess.CustomerAgingReportDao;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerAgingReportDaoIntegTest
extends KualiIntegTestBase {
    private CustomerAgingReportDao customerAgingReportDao;
    private CustomerInvoiceDocument customerInvoiceDocument;
    private static final String CHART1 = "UA";
    private static final String CHART2 = "BL";
    private static final String ORGANIZATION = "VPIT";
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String ACCOUNT_NUMBER = "1031400";

    public void setUp() throws Exception {
        super.setUp();
        CustomerInvoiceDetailFixture customerInvoiceDetailFixture1 = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL;
        this.customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER_WITH_BILLING_INFO.createCustomerInvoiceDocument(new CustomerInvoiceDetailFixture[]{customerInvoiceDetailFixture1});
        this.customerAgingReportDao = (CustomerAgingReportDao)SpringContext.getBean(CustomerAgingReportDao.class);
    }

    public void testFindAppliedAmountByAccount() {
        HashMap map = this.customerAgingReportDao.findAppliedAmountByAccount(CHART2, ACCOUNT_NUMBER, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindAppliedAmountByBillingChartAndOrg() {
        HashMap map = this.customerAgingReportDao.findAppliedAmountByBillingChartAndOrg(CHART1, ORGANIZATION, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindAppliedAmountByProcessingChartAndOrg() {
        HashMap map = this.customerAgingReportDao.findAppliedAmountByProcessingChartAndOrg(CHART1, ORGANIZATION, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindDiscountAmountByAccount() {
        HashMap map = this.customerAgingReportDao.findDiscountAmountByAccount(CHART2, ACCOUNT_NUMBER, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindDiscountAmountByBillingChartAndOrg() {
        HashMap map = this.customerAgingReportDao.findDiscountAmountByBillingChartAndOrg(CHART1, ORGANIZATION, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindDiscountAmountByProcessingChartAndOrg() {
        HashMap map = this.customerAgingReportDao.findDiscountAmountByProcessingChartAndOrg(CHART1, ORGANIZATION, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindInvoiceAmountByAccount() {
        HashMap map = this.customerAgingReportDao.findInvoiceAmountByAccount(CHART2, ACCOUNT_NUMBER, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindInvoiceAmountByBillingChartAndOrg() {
        HashMap map = this.customerAgingReportDao.findInvoiceAmountByBillingChartAndOrg(CHART1, ORGANIZATION, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindInvoiceAmountByProcessingChartAndOrg() {
        HashMap map = this.customerAgingReportDao.findInvoiceAmountByProcessingChartAndOrg(CHART1, ORGANIZATION, null, null);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)map);
    }

    public void testFindWriteOffAmountByCustomerNumber() {
        KualiDecimal writeOffAmt = this.customerAgingReportDao.findWriteOffAmountByCustomerNumber(CUSTOMER_NUMBER);
        CustomerAgingReportDaoIntegTest.assertNull((Object)writeOffAmt);
        CustomerInvoiceWriteoffDocumentService writeoffService = (CustomerInvoiceWriteoffDocumentService)SpringContext.getBean(CustomerInvoiceWriteoffDocumentService.class);
        writeoffService.createCustomerInvoiceWriteoffDocument(this.customerInvoiceDocument.getDocumentNumber(), "Created by CustomerAgingReportDaoTest.testFindWriteOffAmountByCustomerNumber unit test.");
        writeOffAmt = this.customerAgingReportDao.findWriteOffAmountByCustomerNumber(CUSTOMER_NUMBER);
        CustomerAgingReportDaoIntegTest.assertNotNull((Object)writeOffAmt);
    }
}

