/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.math.BigDecimal;
import java.util.List;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.validation.impl.AccountingDocumentRuleBaseConstants;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerCreditMemoDocumentGeneralLedgerPostingIntegTest
extends KualiIntegTestBase {
    public void testGenerateGeneralLedgerPendingEntries_ReceivableChart() {
        CustomerCreditMemoDocument doc = this.getCustomerCreditMemoDocumentWithGLPEs(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE);
        CustomerInvoiceDetail testCustomerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE.createCustomerInvoiceDetail();
        testCustomerInvoiceDetail.refreshReferenceObject("chart");
        String receivableChartOfAccountsCode = testCustomerInvoiceDetail.getChartOfAccountsCode();
        String receivableAccountNumber = testCustomerInvoiceDetail.getAccountNumber();
        String receivableSubAccountNumber = testCustomerInvoiceDetail.getSubAccountNumber();
        String receivableFinancialObjectCode = testCustomerInvoiceDetail.getChart().getFinAccountsReceivableObjCode();
        String receivableFinancialSubObjectCode = AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankFinancialSubObjectCode();
        String receivableOrgRefId = testCustomerInvoiceDetail.getOrganizationReferenceId();
        this.checkReceivableGeneralLedgerPendingEntries(doc, receivableChartOfAccountsCode, receivableAccountNumber, receivableSubAccountNumber, receivableFinancialObjectCode, receivableFinancialSubObjectCode, receivableOrgRefId);
    }

    public CustomerCreditMemoDocument getCustomerCreditMemoDocumentWithGLPEs(CustomerInvoiceDocumentFixture customerInvoiceDocumentFixture, CustomerInvoiceDetailFixture customerInvoiceDetailFixture) {
        CustomerInvoiceDetailFixture[] customerInvoiceDetailFixtures = new CustomerInvoiceDetailFixture[]{customerInvoiceDetailFixture};
        CustomerInvoiceDocument invoice = customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerInvoiceDetailFixtures);
        CustomerCreditMemoDocument customerCreditMemoDocument = this.createCustomerCreditMemoDocument(invoice);
        ((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)customerCreditMemoDocument);
        return customerCreditMemoDocument;
    }

    public CustomerCreditMemoDocument createCustomerCreditMemoDocument(CustomerInvoiceDocument invoice) {
        CustomerCreditMemoDocument customerCreditMemoDocument = (CustomerCreditMemoDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), CustomerCreditMemoDocument.class);
        customerCreditMemoDocument.setFinancialDocumentReferenceInvoiceNumber(invoice.getDocumentNumber());
        List customerInvoiceDetails = invoice.getCustomerInvoiceDetailsWithoutDiscounts();
        if (customerInvoiceDetails == null) {
            return customerCreditMemoDocument;
        }
        for (CustomerInvoiceDetail customerInvoiceDetail : customerInvoiceDetails) {
            CustomerCreditMemoDetail customerCreditMemoDetail = new CustomerCreditMemoDetail();
            customerCreditMemoDetail.setDocumentNumber(customerCreditMemoDocument.getDocumentNumber());
            KualiDecimal invItemTaxAmount = customerInvoiceDetail.getInvoiceItemTaxAmount();
            if (invItemTaxAmount == null) {
                invItemTaxAmount = KualiDecimal.ZERO;
            }
            customerCreditMemoDetail.setCreditMemoItemTaxAmount((KualiDecimal)invItemTaxAmount.divide((AbstractKualiDecimal)new KualiDecimal(2)));
            customerCreditMemoDetail.setReferenceInvoiceItemNumber(customerInvoiceDetail.getSequenceNumber());
            BigDecimal itemQuantity = customerInvoiceDetail.getInvoiceItemQuantity().divide(new BigDecimal(2));
            customerCreditMemoDetail.setCreditMemoItemQuantity(itemQuantity);
            KualiDecimal itemAmount = (KualiDecimal)customerInvoiceDetail.getAmount().divide((AbstractKualiDecimal)new KualiDecimal(2));
            customerCreditMemoDetail.setCreditMemoItemTotalAmount(itemAmount);
            customerCreditMemoDetail.setFinancialDocumentReferenceInvoiceNumber(invoice.getDocumentNumber());
            customerCreditMemoDetail.setCustomerInvoiceDetail(customerInvoiceDetail);
            customerCreditMemoDocument.getCreditMemoDetails().add(customerCreditMemoDetail);
        }
        return customerCreditMemoDocument;
    }

    public void checkReceivableGeneralLedgerPendingEntries(CustomerCreditMemoDocument doc, String expectedReceivableChartOfAccountsCode, String expectedReceivableAccountNumber, String expectedReceivableSubAccountNumber, String expectedReceivableFinancialObjectCode, String expectedReceivableFinancialSubObjectCode, String expectedReceivableOrgRefId) {
        List glpEntries = doc.getGeneralLedgerPendingEntries();
        GeneralLedgerPendingEntry receivable = (GeneralLedgerPendingEntry)glpEntries.get(0);
        CustomerCreditMemoDocumentGeneralLedgerPostingIntegTest.assertEquals((String)("Receivable Chart of Accounts Code should be " + expectedReceivableChartOfAccountsCode + " but is actually " + receivable.getChartOfAccountsCode()), (String)expectedReceivableChartOfAccountsCode, (String)receivable.getChartOfAccountsCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingIntegTest.assertEquals((String)("Receivable Account Number should be " + expectedReceivableChartOfAccountsCode + " but is actually " + receivable.getAccountNumber()), (String)expectedReceivableAccountNumber, (String)receivable.getAccountNumber());
        CustomerCreditMemoDocumentGeneralLedgerPostingIntegTest.assertEquals((String)("Receivable Financial Object Code should be " + expectedReceivableFinancialObjectCode + " but is actually " + receivable.getFinancialObjectCode()), (String)expectedReceivableFinancialObjectCode, (String)receivable.getFinancialObjectCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingIntegTest.assertEquals((String)("Receivable Sub Account Number should be " + expectedReceivableSubAccountNumber + " but is actually " + receivable.getSubAccountNumber()), (String)expectedReceivableSubAccountNumber, (String)receivable.getSubAccountNumber());
        CustomerCreditMemoDocumentGeneralLedgerPostingIntegTest.assertEquals((String)("Receivable Financial Sub Object Code should be " + expectedReceivableFinancialSubObjectCode + " but is actually " + receivable.getFinancialSubObjectCode()), (String)expectedReceivableFinancialSubObjectCode, (String)receivable.getFinancialSubObjectCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingIntegTest.assertEquals((String)("Receivable Org Ref Id should be " + expectedReceivableOrgRefId + " but is actually " + receivable.getOrganizationReferenceId()), (String)expectedReceivableOrgRefId, (String)receivable.getOrganizationReferenceId());
    }
}

