/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PaymentApplicationDocumentTest {
    private PaymentApplicationDocument cut;

    PaymentApplicationDocumentTest() {
    }

    @BeforeEach
    void setUp() {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.cut = new PaymentApplicationDocument();
        }
        this.cut.setGlpeService((GeneralLedgerPendingEntryService)Mockito.mock(GeneralLedgerPendingEntryService.class));
    }

    @Test
    void doRouteStatusChange_Disapproved_CashControlUpdatedAndSaved(@Mock(stubOnly=true) WorkflowDocument workflowDocMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock BusinessObjectService businessObjectSvcMock) {
        this.cut.setBusinessObjectService(businessObjectSvcMock);
        this.cut.setDocumentHeader(documentHeaderMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocMock);
        Mockito.when((Object)workflowDocMock.isDisapproved()).thenReturn((Object)true);
        Mockito.when((Object)workflowDocMock.getStatus()).thenReturn((Object)DocumentStatus.DISAPPROVED);
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(new KualiDecimal(1000.0));
        this.cut.setCashControlDetail(cashControlDetail);
        DocumentRouteStatusChange statusChangeEvent = new DocumentRouteStatusChange(null, null, DocumentStatus.ENROUTE.getCode(), DocumentStatus.DISAPPROVED.getCode());
        this.cut.doRouteStatusChange(statusChangeEvent);
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)cashControlDetail.getFinancialDocumentLineAmount());
        ((BusinessObjectService)Mockito.verify((Object)businessObjectSvcMock)).save((PersistableBusinessObject)cashControlDetail);
    }

    @Test
    void doRouteStatusChange_Enroute_CashControlUnchanged(@Mock(stubOnly=true) WorkflowDocument workflowDocMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock BusinessObjectService businessObjectSvcMock) {
        this.cut.setBusinessObjectService(businessObjectSvcMock);
        this.cut.setDocumentHeader(documentHeaderMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocMock);
        Mockito.when((Object)workflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)workflowDocMock.getStatus()).thenReturn((Object)DocumentStatus.ENROUTE);
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(new KualiDecimal(1000.0));
        this.cut.setCashControlDetail(cashControlDetail);
        DocumentRouteStatusChange statusChangeEvent = new DocumentRouteStatusChange(null, null, DocumentStatus.SAVED.getCode(), DocumentStatus.ENROUTE.getCode());
        this.cut.doRouteStatusChange(statusChangeEvent);
        Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)cashControlDetail.getFinancialDocumentLineAmount());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{businessObjectSvcMock});
    }
}

