/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.sql.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.authorization.ContractsGrantsInvoiceDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.FinancialSystemWorkflowHelperService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsInvoiceDocumentPresentationControllerTest {
    private static final String FUNDS_MANAGER_ROUTE_NODE = "FundsManager";
    @Spy
    private ContractsGrantsInvoiceDocumentPresentationController cut;
    @Mock
    private ContractsGrantsInvoiceDocument documentMock;
    @Mock
    private DocumentHeader documentHeaderMock;
    @Mock
    private FinancialSystemWorkflowHelperService financialSystemWorkflowHelperSvcMock;
    @Mock
    private WorkflowDocument workflowDocumentMock;

    ContractsGrantsInvoiceDocumentPresentationControllerTest() {
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.setUserSession(null);
    }

    @Test
    void cannotCorrectAlreadyCorrectedDocument(@Mock(stubOnly=true) UniversityDateService universityDateSvcMock) {
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityDate(Date.valueOf("2014-07-02"));
        this.cut.setUniversityDateService(universityDateSvcMock);
        this.validateCanErrorCorrect(this.cut, null, "hi there, i am testing", false, false);
    }

    @Test
    void cannotCorrectReversedInvoice(@Mock(stubOnly=true) UniversityDateService universityDateSvcMock) {
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityDate(Date.valueOf("2014-07-02"));
        this.cut.setUniversityDateService(universityDateSvcMock);
        this.validateCanErrorCorrect(this.cut, null, "", true, false);
    }

    @Test
    void cannotCorrectNonFinalDocument(@Mock(stubOnly=true) UniversityDateService universityDateSvcMock) {
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityDate(Date.valueOf("2014-07-02"));
        this.cut.setUniversityDateService(universityDateSvcMock);
        ((ContractsGrantsInvoiceDocumentPresentationController)Mockito.doReturn((Object)true).when((Object)this.cut)).isDocFinalWithNoAppliedAmountsExceptDiscounts(null);
        Mockito.when((Object)this.cut.isDocFinalWithNoAppliedAmountsExceptDiscounts(null)).thenReturn((Object)false);
        this.validateCanErrorCorrect(this.cut, null, "", false, false);
    }

    @Test
    void canCorrectFinalDocumentWithAppliedInvoices(@Mock(stubOnly=true) UniversityDateService universityDateSvcMock) {
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityDate(Date.valueOf("2014-07-02"));
        this.cut.setUniversityDateService(universityDateSvcMock);
        ((ContractsGrantsInvoiceDocumentPresentationController)Mockito.doReturn((Object)true).when((Object)this.cut)).isDocFinalWithNoAppliedAmountsExceptDiscounts(null);
        this.validateCanErrorCorrect(this.cut, null, "", false, true);
    }

    @Test
    void canCorrectFinalDocumentWithAppliedInvoicesNullDate(@Mock(stubOnly=true) UniversityDateService universityDateSvcMock) {
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityDate(Date.valueOf("2014-07-02"));
        this.cut.setUniversityDateService(universityDateSvcMock);
        ((ContractsGrantsInvoiceDocumentPresentationController)Mockito.doReturn((Object)true).when((Object)this.cut)).isDocFinalWithNoAppliedAmountsExceptDiscounts(null);
        this.validateCanErrorCorrect(this.cut, null, "", false, true);
    }

    @Test
    void cannotCorrectPriorYearInvoice(@Mock(stubOnly=true) UniversityDateService universityDateSvcMock) {
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityDate(Date.valueOf("2014-07-02"));
        Mockito.when((Object)universityDateSvcMock.getFiscalYear((java.util.Date)ArgumentMatchers.any(java.util.Date.class))).thenReturn((Object)2015);
        Mockito.when((Object)universityDateSvcMock.getFirstDateOfFiscalYear(Integer.valueOf(ArgumentMatchers.anyInt()))).thenReturn((Object)Date.valueOf("2014-07-01"));
        this.cut.setUniversityDateService(universityDateSvcMock);
        this.validateCanErrorCorrect(this.cut, "2014-06-25", "", false, false);
    }

    @Test
    void canCorrectEarlierPriorYearInvoice(@Mock(stubOnly=true) UniversityDateService universityDateSvcMock) {
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityDate(Date.valueOf("2014-07-02"));
        Mockito.when((Object)universityDateSvcMock.getFiscalYear((java.util.Date)ArgumentMatchers.any(java.util.Date.class))).thenReturn((Object)2015);
        Mockito.when((Object)universityDateSvcMock.getFirstDateOfFiscalYear(Integer.valueOf(ArgumentMatchers.anyInt()))).thenReturn((Object)Date.valueOf("2014-07-01"));
        this.cut.setUniversityDateService(universityDateSvcMock);
        ((ContractsGrantsInvoiceDocumentPresentationController)Mockito.doReturn((Object)true).when((Object)this.cut)).isDocFinalWithNoAppliedAmountsExceptDiscounts(null);
        this.validateCanErrorCorrect(this.cut, "2014-07-01", "", false, true);
    }

    private void validateCanErrorCorrect(ContractsGrantsInvoiceDocumentPresentationController presentationController, String dateApprovedString, String correctedByDocumentId, boolean invoiceReversal, boolean expectedResult) {
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setCorrectedByDocumentId(correctedByDocumentId);
        DateTime dateApproved = null;
        if (dateApprovedString != null) {
            dateApproved = new DateTime((Object)Date.valueOf(dateApprovedString));
        }
        Assertions.assertEquals((Object)expectedResult, (Object)presentationController.canErrorCorrect(null, documentHeader, invoiceReversal, dateApproved), (String)"canErrorCorrect returned unexpected value ");
    }

    @Test
    void canEditDocumentOverview_notAtFundsManagerNode() {
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)((WorkflowDocument)Mockito.mock(WorkflowDocument.class)));
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Assertions.assertFalse((boolean)this.cut.canEditDocumentOverview((Document)this.documentMock));
    }

    @Test
    void canEditDocumentOverview_atFundsManagerNode_NoApprovalRequested() {
        Mockito.when((Object)this.workflowDocumentMock.getCurrentNodeNames()).thenReturn(Set.of(FUNDS_MANAGER_ROUTE_NODE));
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Assertions.assertFalse((boolean)this.cut.canEditDocumentOverview((Document)this.documentMock));
    }

    @Test
    void canEditDocumentOverview_atFundsManagerNode_approvalRequested_adhoc() {
        Mockito.when((Object)this.workflowDocumentMock.getCurrentNodeNames()).thenReturn(Set.of(FUNDS_MANAGER_ROUTE_NODE));
        Mockito.when((Object)this.workflowDocumentMock.isApprovalRequested()).thenReturn((Object)true);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        ContractsGrantsInvoiceDocumentPresentationControllerTest.setupUserSessionMock();
        Mockito.when((Object)this.financialSystemWorkflowHelperSvcMock.isAdhocApprovalRequestedForPrincipal((WorkflowDocument)ArgumentMatchers.eq((Object)this.workflowDocumentMock), ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.cut.setFinancialSystemWorkflowHelperService(this.financialSystemWorkflowHelperSvcMock);
        Assertions.assertFalse((boolean)this.cut.canEditDocumentOverview((Document)this.documentMock));
    }

    private static void setupUserSessionMock() {
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Mockito.when((Object)userSessionMock.getPrincipalId()).thenReturn((Object)"principalId");
        GlobalVariables.setUserSession((UserSession)userSessionMock);
    }

    @Test
    void canEditDocumentOverview_atFundsManagerNode_approvalRequested_isCorrectionDoc() {
        Mockito.when((Object)this.workflowDocumentMock.getCurrentNodeNames()).thenReturn(Set.of(FUNDS_MANAGER_ROUTE_NODE));
        Mockito.when((Object)this.workflowDocumentMock.isApprovalRequested()).thenReturn((Object)true);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.documentMock.isCorrectionDocument()).thenReturn((Object)true);
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        ContractsGrantsInvoiceDocumentPresentationControllerTest.setupUserSessionMock();
        this.cut.setFinancialSystemWorkflowHelperService(this.financialSystemWorkflowHelperSvcMock);
        Assertions.assertFalse((boolean)this.cut.canEditDocumentOverview((Document)this.documentMock));
    }

    @Test
    void canEditDocumentOverview_atFundsManagerNode_approvalRequested() {
        Mockito.when((Object)this.workflowDocumentMock.getCurrentNodeNames()).thenReturn(Set.of(FUNDS_MANAGER_ROUTE_NODE));
        Mockito.when((Object)this.workflowDocumentMock.isApprovalRequested()).thenReturn((Object)true);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        ContractsGrantsInvoiceDocumentPresentationControllerTest.setupUserSessionMock();
        this.cut.setFinancialSystemWorkflowHelperService(this.financialSystemWorkflowHelperSvcMock);
        Assertions.assertTrue((boolean)this.cut.canEditDocumentOverview((Document)this.documentMock));
    }
}

