/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsAgingOpenInvoicesReport;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsAgingOpenInvoicesReportServiceImpl;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsAgingReportServiceImpl;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsAgingOpenInvoicesReportServiceTest {
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    private ContractsGrantsAgingOpenInvoicesReportServiceImpl cut;
    @Mock(stubOnly=true)
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock(stubOnly=true)
    private ContractsGrantsReportHelperService contractsGrantsReportHelperSvcMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceDocumentService customerInvoiceDocumentSvcMock;
    @Mock(stubOnly=true)
    private KualiModuleService kualiModuleSvcMock;
    @Mock(stubOnly=true)
    private LookupService lookupSvcMock;

    ContractsGrantsAgingOpenInvoicesReportServiceTest() {
    }

    @BeforeEach
    void setUp() {
        ContractsGrantsAgingReportServiceImpl contractsGrantsAgingReportService = new ContractsGrantsAgingReportServiceImpl();
        contractsGrantsAgingReportService.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
        contractsGrantsAgingReportService.setContractsGrantsReportHelperService(this.contractsGrantsReportHelperSvcMock);
        contractsGrantsAgingReportService.setLookupService(this.lookupSvcMock);
        this.cut = new ContractsGrantsAgingOpenInvoicesReportServiceImpl();
        this.cut.setContractsGrantsAgingReportService((ContractsGrantsAgingReportService)contractsGrantsAgingReportService);
        this.cut.setCustomerInvoiceDocumentService(this.customerInvoiceDocumentSvcMock);
        this.cut.setKualiModuleService(this.kualiModuleSvcMock);
    }

    @Test
    void getPopulatedReportDetails(@Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) Customer customerMock, @Mock(stubOnly=true) CustomerInvoiceDetail customerInvoiceDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock, @Mock(stubOnly=true) ModuleService moduleSvcMock, @Mock(stubOnly=true) Person personMock, @Mock(stubOnly=true) UserSession userSessionMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"CINV");
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setWorkflowDocument(workflowDocumentMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber(CUSTOMER_NUMBER);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)new Date(new java.util.Date().getTime()));
        ArrayList<CustomerInvoiceDetail> details = new ArrayList<CustomerInvoiceDetail>();
        Mockito.when((Object)customerInvoiceDetailMock.getAccountNumber()).thenReturn((Object)"1234567");
        details.add(customerInvoiceDetailMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(details);
        Mockito.when((Object)customerMock.getCustomerNumber()).thenReturn((Object)CUSTOMER_NUMBER);
        Mockito.when((Object)customerMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getCustomer()).thenReturn((Object)customerMock);
        Mockito.when((Object)invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        HashMap<String, String> formProps = new HashMap<String, String>();
        formProps.put("accountsReceivableDocumentHeader.customerNumber", CUSTOMER_NUMBER);
        formProps.put("accountsReceivableDocumentHeader.customer.customerName", CUSTOMER_NAME);
        formProps.put("documentHeader.workflowDocumentTypeName", "CINV");
        formProps.put("openInvoiceIndicator", "true");
        ArrayList<ContractsGrantsInvoiceDocument> invoices = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoices.add(contractsGrantsInvoiceDocumentMock);
        Mockito.when((Object)this.lookupSvcMock.findCollectionBySearch(ContractsGrantsInvoiceDocument.class, formProps)).thenReturn(invoices);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentSvcMock.canViewInvoice(contractsGrantsInvoiceDocumentMock, null)).thenReturn((Object)true);
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getOpenAmountForCustomerInvoiceDocument((CustomerInvoiceDocument)contractsGrantsInvoiceDocumentMock)).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class)).thenReturn((Object)moduleSvcMock);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("customerNumber", CUSTOMER_NUMBER);
        Mockito.when((Object)((ContractsAndGrantsBillingAgency)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args))).thenReturn((Object)agencyMock);
        try (MockedStatic globalVariablesStaticMock = Mockito.mockStatic(GlobalVariables.class);){
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
            globalVariablesStaticMock.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            HashMap<String, String[]> urlParameters = new HashMap<String, String[]>();
            urlParameters.put("customerNumber", new String[]{CUSTOMER_NUMBER});
            urlParameters.put("customerName", new String[]{CUSTOMER_NAME});
            List populatedReportDetails = this.cut.getPopulatedReportDetails(urlParameters);
            Assertions.assertNotNull((Object)populatedReportDetails);
            Assertions.assertEquals((int)1, (int)populatedReportDetails.size());
            ContractsGrantsAgingOpenInvoicesReport reportDetails = (ContractsGrantsAgingOpenInvoicesReport)populatedReportDetails.get(0);
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), (Object)reportDetails.getDocumentType());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber(), (Object)reportDetails.getDocumentNumber());
            Assertions.assertEquals((Object)"", (Object)reportDetails.getDocumentDescription());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getBillingDate(), (Object)reportDetails.getBillingDate());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getInvoiceDueDate(), (Object)reportDetails.getDueApprovedDate());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader().getFinancialDocumentTotalAmount(), (Object)reportDetails.getDocumentPaymentAmount());
            Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)reportDetails.getUnpaidUnappliedAmount());
            Assertions.assertEquals((Object)"No", (Object)reportDetails.getFinalInvoice());
            Assertions.assertEquals((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getProposalNumber(), (Object)reportDetails.getProposalNumber());
            Assertions.assertEquals((Object)agencyMock.getAgencyNumber(), (Object)reportDetails.getAgencyNumber());
            Assertions.assertEquals((Object)"1234567", (Object)reportDetails.getAccountNumber());
        }
    }

    @Test
    void getPopulatedReportDetails_NoMatchingCustomers(@Mock(stubOnly=true) Person personMock, @Mock(stubOnly=true) UserSession userSessionMock) {
        try (MockedStatic globalVariablesStaticMock = Mockito.mockStatic(GlobalVariables.class);){
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
            globalVariablesStaticMock.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            HashMap<String, String[]> urlParameters = new HashMap<String, String[]>();
            urlParameters.put("customerNumber", new String[]{CUSTOMER_NUMBER});
            urlParameters.put("customerName", new String[]{"NO NAME"});
            List populatedReportDetails = this.cut.getPopulatedReportDetails(urlParameters);
            Assertions.assertNotNull((Object)populatedReportDetails);
            Assertions.assertEquals((int)0, (int)populatedReportDetails.size());
        }
    }
}

