/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsBillingAwardVerificationServiceImpl;
import org.kuali.kfs.sys.businessobject.ChartOrgHolderImpl;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.service.impl.FinancialSystemDocumentServiceImpl;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsBillingAwardVerificationServiceTest {
    private static final String ACCOUNT_NUMBER = "1234567";
    private static final String ANOTHER_ACCOUNT_NUMBER = "2345678";
    private static final String PROPOSAL_NUMBER = "1";
    private static final Date LAST_MONTH = Date.valueOf(LocalDate.now().minusMonths(1L));
    private static final Date TODAY = Date.valueOf(LocalDate.now());
    private static final Date NEXT_MONTH = Date.valueOf(LocalDate.now().plusMonths(1L));
    private static final KualiDecimal NON_ZERO_AMOUNT = new KualiDecimal(1000.0);
    private static final KualiDecimal ZERO_AMOUNT = new KualiDecimal(0.0);
    private static final String CHART_OF_ACCOUNTS_CODE_1 = "C1";
    private static final String ORGANIZATION_CODE_1 = "11111";
    private static final String CHART_OF_ACCOUNTS_CODE_2 = "C2";
    private static final String ORGANIZATION_CODE_2 = "22222";
    private static final Integer FISCAL_YEAR_2015 = 2015;
    private static final Map<String, Object> ORGANIZATION_CRITERIA = Map.of("universityFiscalYear", FISCAL_YEAR_2015, "chartOfAccountsCode", "C1", "organizationCode", "11111");
    private static final Map<String, Object> SYSTEM_CRITERIA = Map.of("universityFiscalYear", FISCAL_YEAR_2015, "processingChartOfAccountCode", "C2", "processingOrganizationCode", "22222");
    private static final Map<String, Object> BUSINESS_OBJECT_MAP_BILL = Map.of("proposalNumber", "1", "chartOfAccountsCode", "BL", "accountNumber", "1234567", "active", true);
    private ContractsGrantsBillingAwardVerificationServiceImpl cut;
    private FinancialSystemDocumentServiceImpl financialSystemDocumentService;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocSvcMock;
    @Mock
    private UniversityDateService universityDateSvcMock;
    @Mock
    private FinancialSystemUserService financialSystemUserServiceMock;

    ContractsGrantsBillingAwardVerificationServiceTest() {
    }

    @BeforeEach
    void setup() {
        this.financialSystemDocumentService = new FinancialSystemDocumentServiceImpl();
        this.cut = new ContractsGrantsBillingAwardVerificationServiceImpl();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
        this.cut.setFinancialSystemUserService(this.financialSystemUserServiceMock);
        this.cut.setFinancialSystemDocumentService((FinancialSystemDocumentService)this.financialSystemDocumentService);
    }

    private SubFundGroup newSubFundGroup(String subFundGroupCode) {
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(subFundGroupCode);
        return subFundGroup;
    }

    private void setupPrimaryAwardOrganization(Person fundManagerMock, ContractsAndGrantsFundManager awardFundManagerMock, ContractsAndGrantsBillingAward awardMock) {
        String FUND_MANAGER_PRINCIPAL_ID = "012345678";
        Mockito.when((Object)fundManagerMock.getPrincipalId()).thenReturn((Object)"012345678");
        Mockito.when((Object)awardFundManagerMock.getFundManager()).thenReturn((Object)fundManagerMock);
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        ChartOrgHolderImpl chartOrgHolder = new ChartOrgHolderImpl(CHART_OF_ACCOUNTS_CODE_1, ORGANIZATION_CODE_1);
        Mockito.when((Object)this.financialSystemUserServiceMock.getPrimaryOrganization("012345678", "KFS-AR")).thenReturn((Object)chartOrgHolder);
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_ChartAndOrgValid(@Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock, @Mock(stubOnly=true) Person fundManagerMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        this.setupPrimaryAwardOrganization(fundManagerMock, awardFundManagerMock, awardMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes(CHART_OF_ACCOUNTS_CODE_1, ORGANIZATION_CODE_1)).thenReturn(Arrays.asList(CHART_OF_ACCOUNTS_CODE_2, ORGANIZATION_CODE_2));
        Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, ORGANIZATION_CRITERIA))).thenReturn((Object)new OrganizationAccountingDefault());
        Mockito.when((Object)((SystemInformation)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, SYSTEM_CRITERIA))).thenReturn((Object)new SystemInformation());
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)FISCAL_YEAR_2015);
        Assertions.assertTrue((boolean)this.cut.isChartAndOrgSetupForInvoicing(awardMock));
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_NoAwardPrimaryFundManager(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Assertions.assertFalse((boolean)this.cut.isChartAndOrgSetupForInvoicing(awardMock));
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_NoProcessingFromBillingCodes(@Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock, @Mock(stubOnly=true) Person fundManagerMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        this.setupPrimaryAwardOrganization(fundManagerMock, awardFundManagerMock, awardMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes(CHART_OF_ACCOUNTS_CODE_1, ORGANIZATION_CODE_1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)FISCAL_YEAR_2015);
        Assertions.assertFalse((boolean)this.cut.isChartAndOrgSetupForInvoicing(awardMock));
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_NoOrganizationAccountingDefault(@Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock, @Mock(stubOnly=true) Person fundManagerMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        this.setupPrimaryAwardOrganization(fundManagerMock, awardFundManagerMock, awardMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes(CHART_OF_ACCOUNTS_CODE_1, ORGANIZATION_CODE_1)).thenReturn(Arrays.asList(CHART_OF_ACCOUNTS_CODE_2, ORGANIZATION_CODE_2));
        Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, ORGANIZATION_CRITERIA))).thenReturn(null);
        Mockito.when((Object)((SystemInformation)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, SYSTEM_CRITERIA))).thenReturn((Object)new SystemInformation());
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)FISCAL_YEAR_2015);
        Assertions.assertFalse((boolean)this.cut.isChartAndOrgSetupForInvoicing(awardMock));
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_NoSystemInformation(@Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock, @Mock(stubOnly=true) Person fundManagerMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        this.setupPrimaryAwardOrganization(fundManagerMock, awardFundManagerMock, awardMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes(CHART_OF_ACCOUNTS_CODE_1, ORGANIZATION_CODE_1)).thenReturn(Arrays.asList(CHART_OF_ACCOUNTS_CODE_2, ORGANIZATION_CODE_2));
        Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, ORGANIZATION_CRITERIA))).thenReturn((Object)new OrganizationAccountingDefault());
        Mockito.when((Object)((SystemInformation)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, SYSTEM_CRITERIA))).thenReturn(null);
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)FISCAL_YEAR_2015);
        Assertions.assertFalse((boolean)this.cut.isChartAndOrgSetupForInvoicing(awardMock));
    }

    @Test
    void hasBillsToInvoice_NotPredeterminedBilling(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(awardMock));
    }

    @Test
    void hasBillsToInvoice_NoBills(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(awardMock));
    }

    @Test
    void hasBillsToInvoice_NoUnbilledBills(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Bill billedBill, @Mock(stubOnly=true) Bill anotherBilledBill) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)billedBill.getBillDate()).thenReturn((Object)LAST_MONTH);
        Mockito.when((Object)billedBill.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)anotherBilledBill.getBillDate()).thenReturn((Object)LAST_MONTH);
        Mockito.when((Object)anotherBilledBill.isBilled()).thenReturn((Object)true);
        List<Bill> bills = List.of(billedBill, anotherBilledBill);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, BUSINESS_OBJECT_MAP_BILL)).thenReturn(bills);
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(awardMock));
    }

    @Test
    void hasBillsToInvoice_OneUnbilledBillsDueLastMonth(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Bill billedBill, @Mock(stubOnly=true) Bill unbilledBill) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)billedBill.getBillDate()).thenReturn((Object)LAST_MONTH);
        Mockito.when((Object)billedBill.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)unbilledBill.getBillDate()).thenReturn((Object)LAST_MONTH);
        Mockito.when((Object)unbilledBill.getEstimatedAmount()).thenReturn((Object)NON_ZERO_AMOUNT);
        Mockito.when((Object)unbilledBill.isBilled()).thenReturn((Object)false);
        List<Bill> bills = List.of(billedBill, unbilledBill);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, BUSINESS_OBJECT_MAP_BILL)).thenReturn(bills);
        Assertions.assertTrue((boolean)this.cut.hasBillsToInvoice(awardMock));
    }

    @Test
    void hasBillsToInvoice_OneUnbilledBillsDueNextMonth(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Bill billedBill, @Mock(stubOnly=true) Bill unbilledBill) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)billedBill.getBillDate()).thenReturn((Object)LAST_MONTH);
        Mockito.when((Object)billedBill.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)unbilledBill.getBillDate()).thenReturn((Object)NEXT_MONTH);
        List<Bill> bills = List.of(billedBill, unbilledBill);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, BUSINESS_OBJECT_MAP_BILL)).thenReturn(bills);
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(awardMock));
    }

    @Test
    void hasBillsToInvoice_OneUnbilledBillsDueToday(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Bill billedBill, @Mock(stubOnly=true) Bill unbilledBill) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)billedBill.getBillDate()).thenReturn((Object)LAST_MONTH);
        Mockito.when((Object)billedBill.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)unbilledBill.getBillDate()).thenReturn((Object)TODAY);
        Mockito.when((Object)unbilledBill.getEstimatedAmount()).thenReturn((Object)NON_ZERO_AMOUNT);
        List<Bill> bills = List.of(billedBill, unbilledBill);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, BUSINESS_OBJECT_MAP_BILL)).thenReturn(bills);
        Assertions.assertTrue((boolean)this.cut.hasBillsToInvoice(awardMock));
    }

    @Test
    void hasBillsToInvoice_OneUnbilledBillsDueToday_ZeroAmount(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Bill billedBill, @Mock(stubOnly=true) Bill unbilledBill) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)billedBill.getBillDate()).thenReturn((Object)LAST_MONTH);
        Mockito.when((Object)billedBill.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)unbilledBill.getBillDate()).thenReturn((Object)TODAY);
        Mockito.when((Object)unbilledBill.getEstimatedAmount()).thenReturn((Object)ZERO_AMOUNT);
        List<Bill> bills = List.of(billedBill, unbilledBill);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, BUSINESS_OBJECT_MAP_BILL)).thenReturn(bills);
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(awardMock));
    }

    @Test
    void hasMilestonesToInvoice_NotMilestoneBilling(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(awardMock));
    }

    @Test
    void hasMilestonesToInvoice_NoBills(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(awardMock));
    }

    @Test
    void hasMilestonesToInvoice_NoUnbilledBills(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(awardMock));
    }

    @Test
    void hasMilestonesToInvoice_OneUnbilledBillsDueLastMonth(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        List<Milestone> milestones = this.setupMilestones(LAST_MONTH);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", awardMock.getProposalNumber());
        map.put("chartOfAccountsCode", "BL");
        map.put("accountNumber", ACCOUNT_NUMBER);
        map.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, map)).thenReturn(milestones);
        Assertions.assertTrue((boolean)this.cut.hasMilestonesToInvoice(awardMock));
    }

    @Test
    void hasMilestonesToInvoice_OneUnbilledBillsDueNextMonth(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(awardMock));
    }

    @Test
    void hasMilestonesToInvoice_OneUnbilledBillsDueToday(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        List<Milestone> milestones = this.setupMilestones(TODAY);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", awardMock.getProposalNumber());
        map.put("chartOfAccountsCode", "BL");
        map.put("accountNumber", ACCOUNT_NUMBER);
        map.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, map)).thenReturn(milestones);
        Assertions.assertTrue((boolean)this.cut.hasMilestonesToInvoice(awardMock));
    }

    @Test
    void hasMilestonesToInvoice_OneUnbilledBillsDueToday_ZeroAmount(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(awardMock));
    }

    private List<Milestone> setupMilestones(Date milestoneCompletionDate) {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        Milestone milestone = new Milestone();
        milestone.setBilled(true);
        Milestone anotherMilestone = new Milestone();
        anotherMilestone.setBilled(false);
        if (milestoneCompletionDate != null) {
            anotherMilestone.setMilestoneActualCompletionDate(milestoneCompletionDate);
        }
        anotherMilestone.setMilestoneAmount(NON_ZERO_AMOUNT);
        milestones.add(milestone);
        milestones.add(anotherMilestone);
        return milestones;
    }

    @Test
    void isInvoiceInProgress_NoInvoices(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Assertions.assertFalse((boolean)this.cut.isInvoiceInProgress(awardMock));
    }

    private List<InvoiceAccountDetail> setupInvoiceAccountDetails(String accountNumber) {
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
        invoiceAccountDetail.setChartOfAccountsCode("BL");
        invoiceAccountDetail.setAccountNumber(accountNumber);
        accountDetails.add(invoiceAccountDetail);
        return accountDetails;
    }

    @Test
    void isInvoiceInProgress_InvoicesInProgressForDifferentAwardAccount(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceDocumentMockOtherAccount) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.financialSystemDocumentService.getPendingDocumentStatuses());
        List<InvoiceAccountDetail> accountDetails = this.setupInvoiceAccountDetails(ANOTHER_ACCOUNT_NUMBER);
        Mockito.when((Object)invoiceDocumentMockOtherAccount.getAccountDetails()).thenReturn(accountDetails);
        List<ContractsGrantsInvoiceDocument> invoiceDocuments = Collections.singletonList(invoiceDocumentMockOtherAccount);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(invoiceDocuments);
        Assertions.assertFalse((boolean)this.cut.isInvoiceInProgress(awardMock));
    }

    @Test
    void isInvoiceInProgress_HasInvoices(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceDocumentMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceDocumentMock2) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.financialSystemDocumentService.getPendingDocumentStatuses());
        List<InvoiceAccountDetail> accountDetails = this.setupInvoiceAccountDetails(ACCOUNT_NUMBER);
        Mockito.when((Object)invoiceDocumentMock1.getAccountDetails()).thenReturn(accountDetails);
        List<ContractsGrantsInvoiceDocument> invoiceDocuments = List.of(invoiceDocumentMock1, invoiceDocumentMock2);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(invoiceDocuments);
        Assertions.assertTrue((boolean)this.cut.isInvoiceInProgress(awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByAccount_HasCodes_Valid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Account accountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroup = this.newSubFundGroup("S");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"2");
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, "BL")).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
        Assertions.assertTrue((boolean)this.cut.hasIncomeAndReceivableObjectCodes(awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByAccount_DoesNotHaveCodes_Invalid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Account accountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroup = this.newSubFundGroup("S");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"2");
        Assertions.assertFalse((boolean)this.cut.hasIncomeAndReceivableObjectCodes(awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceBySchedule_HasCodes_Valid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Account accountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroup = this.newSubFundGroup("S");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"4");
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, "BL")).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
        Assertions.assertTrue((boolean)this.cut.hasIncomeAndReceivableObjectCodes(awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceBySchedule_DoesNotHaveCodes_Invalid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Account accountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroup = this.newSubFundGroup("S");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"4");
        Assertions.assertFalse((boolean)this.cut.hasIncomeAndReceivableObjectCodes(awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByContractControlAccount_HasCodes_Valid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account contractControlAccountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"3");
        Mockito.when((Object)contractControlAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroupC = this.newSubFundGroup("C");
        Mockito.when((Object)contractControlAccountMock.getSubFundGroup()).thenReturn((Object)subFundGroupC);
        Account activeAccountMock0 = ((ContractsAndGrantsBillingAwardAccount)awardMock.getActiveAwardAccounts().get(0)).getAccount();
        Mockito.when((Object)activeAccountMock0.getContractControlAccount()).thenReturn((Object)contractControlAccountMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroupC, "BL")).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
        Assertions.assertTrue((boolean)this.cut.hasIncomeAndReceivableObjectCodes(awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByContractControlAccount_DoesNotHaveCodes_Invalid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account contractControlAccountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"3");
        Mockito.when((Object)contractControlAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroup = this.newSubFundGroup("C");
        Mockito.when((Object)contractControlAccountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Mockito.when((Object)accountMock.getContractControlAccount()).thenReturn((Object)contractControlAccountMock);
        Assertions.assertFalse((boolean)this.cut.hasIncomeAndReceivableObjectCodes(awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByAward_HasCodes_Valid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Account accountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroup = this.newSubFundGroup("S");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        activeAwardAccounts.add(awardAccountMock);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, "BL")).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
        Assertions.assertTrue((boolean)this.cut.hasIncomeAndReceivableObjectCodes(awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByAward_DoesNotHaveCodes_Invalid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) Account accountMock) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroup = this.newSubFundGroup("S");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        SubFundGroup subFundGroupC = this.newSubFundGroup("C");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroupC);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        activeAwardAccounts.add(awardAccountMock);
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)PROPOSAL_NUMBER);
        Assertions.assertFalse((boolean)this.cut.hasIncomeAndReceivableObjectCodes(awardMock));
    }

    @Test
    void isAwardFinalInvoiceAlreadyBuilt_ShouldReturnFalse_OneAccountIsNotFinalBilled(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        Mockito.when((Object)awardAccountMock1.isFinalBilledIndicator()).thenReturn((Object)false);
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = List.of(awardAccountMock1, awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Assertions.assertFalse((boolean)this.cut.isAwardFinalInvoiceAlreadyBuilt(awardMock));
    }

    @Test
    void isAwardFinalInvoiceAlreadyBuilt_ShouldReturnTrue_AllAccountsAreFinalBilled(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        Mockito.when((Object)awardAccountMock1.isFinalBilledIndicator()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock2.isFinalBilledIndicator()).thenReturn((Object)true);
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = List.of(awardAccountMock1, awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Assertions.assertTrue((boolean)this.cut.isAwardFinalInvoiceAlreadyBuilt(awardMock));
    }
}

