/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.module.ar.document.service.FinalBilledIndicatorValidationService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class FinalBilledIndicatorValidationServiceTest {
    private FinalBilledIndicatorValidationService cut;
    @Mock
    private DocumentService documentSvcMock;
    @Mock
    private FinalBilledIndicatorDocument finalBilledIndicatorDocumentMock;
    private FinalBilledIndicatorEntry finalBilledIndicatorEntry;
    private List<FinalBilledIndicatorEntry> finalBilledIndicatorEntries;
    private InvoiceGeneralDetail invoiceGeneralDetail;
    @Mock
    private WorkflowDocument workflowDocumentMock;

    FinalBilledIndicatorValidationServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new FinalBilledIndicatorValidationService();
        this.cut.setDocumentService(this.documentSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupDocumentAndBusinessObjectMocks() {
        this.setupFinalBilledIndicatorEntries();
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock = this.setupWorkflowDocMocking(true);
        this.setupInvoiceGeneralDetailMock(contractsGrantsInvoiceDocumentMock);
    }

    private void setupFinalBilledIndicatorEntries() {
        this.finalBilledIndicatorEntries = new ArrayList<FinalBilledIndicatorEntry>();
        this.finalBilledIndicatorEntry = new FinalBilledIndicatorEntry();
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber("1");
        this.finalBilledIndicatorEntries.add(this.finalBilledIndicatorEntry);
        Mockito.when((Object)this.finalBilledIndicatorDocumentMock.getInvoiceEntries()).thenReturn(this.finalBilledIndicatorEntries);
    }

    private ContractsGrantsInvoiceDocument setupWorkflowDocMocking(boolean finalDoc) {
        Mockito.when((Object)this.workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"CINV");
        if (finalDoc) {
            Mockito.when((Object)this.workflowDocumentMock.isFinal()).thenReturn((Object)true);
        }
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.documentExists("1")).thenReturn((Object)true);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenReturn((Object)contractsGrantsInvoiceDocumentMock);
        return contractsGrantsInvoiceDocumentMock;
    }

    private void setupInvoiceGeneralDetailMock(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) {
        this.invoiceGeneralDetail = new InvoiceGeneralDetail();
        this.invoiceGeneralDetail.setFinalBillIndicator(true);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetail);
    }

    @Test
    void validateDocument() {
        this.setupDocumentAndBusinessObjectMocks();
        Assertions.assertTrue((boolean)this.cut.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validateDocument_NoFinalBilledEntries() {
        Mockito.when((Object)this.finalBilledIndicatorDocumentMock.getInvoiceEntries()).thenReturn(Collections.emptyList());
        Assertions.assertFalse((boolean)this.cut.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_NullEntry() {
        this.setupDocumentAndBusinessObjectMocks();
        this.finalBilledIndicatorEntries.add(null);
        Assertions.assertFalse((boolean)this.cut.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_NoInvoiceNumber() {
        this.setupFinalBilledIndicatorEntries();
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber(null);
        Assertions.assertFalse((boolean)this.cut.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_MissingDocument() {
        this.setupFinalBilledIndicatorEntries();
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber("2");
        Assertions.assertFalse((boolean)this.cut.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.invalid.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_InvalidDocumentType() {
        this.setupFinalBilledIndicatorEntries();
        this.setupWorkflowDocMocking(false);
        Mockito.when((Object)this.workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"LCR");
        Assertions.assertFalse((boolean)this.cut.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.invalid.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_DocumentEnroute() {
        this.setupFinalBilledIndicatorEntries();
        this.setupWorkflowDocMocking(false);
        Assertions.assertFalse((boolean)this.cut.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.invoice.not.final", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_NotMarkedFinal() {
        this.setupDocumentAndBusinessObjectMocks();
        this.invoiceGeneralDetail.setFinalBillIndicator(false);
        Assertions.assertFalse((boolean)this.cut.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.invoice.not.marked.final.bill", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }
}

