/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.ObjectTypeService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.search.SearchOperator;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.integration.cg.ContractAndGrantsProposal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.ContractsGrantsInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.fixture.InvoiceAccountDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceBillFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceDetailAccountObjectCodeFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceMilestoneFixture;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsBillingUtilityServiceImpl;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.service.impl.FinancialSystemDocumentServiceImpl;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsInvoiceDocumentServiceImplTest {
    private static final DateFormat FORMATTER = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
    private static final String DOCUMENT_NUMBER = "1";
    private static final String PROPOSAL_NUMBER = "1";
    private static final DateTime TODAY = DateTime.now();
    private static final DateTime YESTERDAY = TODAY.minusDays(1);
    private static final DateTime TOMORROW = TODAY.plusDays(1);
    private static final String TODAY_FORMATTED = FORMATTER.format(TODAY.toDate());
    private static final String YESTERDAY_FORMATTED = FORMATTER.format(YESTERDAY.toDate());
    private static final String TOMORROW_FORMATTED = FORMATTER.format(TOMORROW.toDate());
    private static final List<String> BASIC_EXPENSE_OBJECT_TYPES = List.of("EE", "ES", "EX");
    private ContractsGrantsInvoiceDocumentServiceImpl cut;
    @Mock(stubOnly=true)
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingSvcMock;
    @Mock(stubOnly=true)
    private ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDaoMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceDocumentService customerInvoiceDocumentSvcMock;
    @Mock(stubOnly=true)
    private DateTimeService dateTimeServiceMock;
    private FinancialSystemDocumentServiceImpl financialSystemDocumentService;
    @Mock(stubOnly=true)
    private KualiModuleService kualiModuleSvcMock;
    @Mock(stubOnly=true)
    private ObjectTypeService objectTypeSvcMock;
    @Mock(stubOnly=true)
    private ParameterService parameterSvcMock;
    @Mock(stubOnly=true)
    private UniversityDateService universityDateSvcMock;
    @Spy
    private InvoiceGeneralDetail invoiceGeneralDetailSpy;

    ContractsGrantsInvoiceDocumentServiceImplTest() {
    }

    @BeforeEach
    void setUp(@Mock(stubOnly=true) AccountsReceivablePendingEntryService accountsReceivablePendingEntrySvcMock, @Mock(stubOnly=true) ConfigurationService configurationServiceMock) {
        this.financialSystemDocumentService = new FinancialSystemDocumentServiceImpl();
        this.cut = new ContractsGrantsInvoiceDocumentServiceImpl();
        this.cut.setAccountsReceivablePendingEntryService(accountsReceivablePendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setConfigurationService(configurationServiceMock);
        this.cut.setContractsAndGrantsModuleBillingService(this.contractsAndGrantsModuleBillingSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentDao(this.contractsGrantsInvoiceDocumentDaoMock);
        this.cut.setContractsGrantsBillingUtilityService((ContractsGrantsBillingUtilityService)new ContractsGrantsBillingUtilityServiceImpl());
        this.cut.setCustomerInvoiceDocumentService(this.customerInvoiceDocumentSvcMock);
        this.cut.setDateTimeService(this.dateTimeServiceMock);
        this.cut.setFinancialSystemDocumentService((FinancialSystemDocumentService)this.financialSystemDocumentService);
        this.cut.setKualiModuleService(this.kualiModuleSvcMock);
        this.cut.setObjectTypeService(this.objectTypeSvcMock);
        this.cut.setParameterService(this.parameterSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
    }

    private void setupGlBalanceMockQuery(List<Balance> balances) {
        HashMap<String, Object> balanceKeys = new HashMap<String, Object>();
        balanceKeys.put("chartOfAccountsCode", "BL");
        balanceKeys.put("accountNumber", "0211401");
        balanceKeys.put("universityFiscalYear", 2019);
        balanceKeys.put("balanceTypeCode", "AC");
        balanceKeys.put("objectTypeCode", BASIC_EXPENSE_OBJECT_TYPES);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Balance.class, balanceKeys)).thenReturn(balances);
    }

    private <T extends BusinessObject> void setupBusinessObjectServiceFindMatchingMocking(String proposalNumber, String chartOfAccountsCode, String accountNumber, Class<T> clazz, List<T> listToReturn) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("proposalNumber", proposalNumber);
        if (StringUtils.isNotBlank((CharSequence)chartOfAccountsCode)) {
            fieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
        }
        if (StringUtils.isNotBlank((CharSequence)accountNumber)) {
            fieldValues.put("accountNumber", accountNumber);
        }
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(clazz, fieldValues)).thenReturn(listToReturn);
    }

    private void setupContractsGrantsInvoiceObjectCodeMockQuery() {
        ContractsGrantsInvoiceObjectCode contractsGrantsInvoiceObjectCode = new ContractsGrantsInvoiceObjectCode();
        contractsGrantsInvoiceObjectCode.setIncomeFinancialObjectCode("0110");
        contractsGrantsInvoiceObjectCode.setReceivableFinancialObjectCode("8118");
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("subFundGroupCode", "AUXAMB");
        fieldValues.put("chartOfAccountsCode", "BL");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(ContractsGrantsInvoiceObjectCode.class, fieldValues)).thenReturn(Collections.singletonList(contractsGrantsInvoiceObjectCode));
    }

    @Test
    void getBudgetAndActualsForAwardAccount_period1_includePeriod13(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) Balance balanceMock1, @Mock(stubOnly=true) Balance balanceMock2, @Mock(stubOnly=true) A21SubAccount a21SubAccountMock, @Mock(stubOnly=true) SubAccount subAccountMock, @Mock(stubOnly=true) Balance balanceMock3, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2019);
        Mockito.when((Object)balanceMock1.getContractsGrantsBeginningBalanceAmount()).thenReturn((Object)new KualiDecimal(220.0));
        KualiDecimal month13Amount = new KualiDecimal(30.0);
        KualiDecimal annualBalanceAmount = (KualiDecimal)((KualiDecimal)KualiDecimal.ZERO.add((AbstractKualiDecimal)KualiDecimal.ZERO)).add((AbstractKualiDecimal)month13Amount);
        Mockito.when((Object)balanceMock1.getAccountLineAnnualBalanceAmount()).thenReturn((Object)annualBalanceAmount);
        Mockito.when((Object)balanceMock2.getContractsGrantsBeginningBalanceAmount()).thenReturn((Object)new KualiDecimal(221.0));
        KualiDecimal month13Amount1 = new KualiDecimal(32.0);
        KualiDecimal annualBalanceAmount1 = (KualiDecimal)((KualiDecimal)KualiDecimal.ZERO.add((AbstractKualiDecimal)KualiDecimal.ZERO)).add((AbstractKualiDecimal)month13Amount1);
        Mockito.when((Object)balanceMock2.getAccountLineAnnualBalanceAmount()).thenReturn((Object)annualBalanceAmount1);
        Mockito.when((Object)a21SubAccountMock.getSubAccountTypeCode()).thenReturn((Object)"CS");
        Mockito.when((Object)subAccountMock.getA21SubAccount()).thenReturn((Object)a21SubAccountMock);
        Mockito.when((Object)balanceMock3.getSubAccount()).thenReturn((Object)subAccountMock);
        ArrayList<Balance> balancesFY19 = new ArrayList<Balance>();
        balancesFY19.add(balanceMock1);
        balancesFY19.add(balanceMock2);
        balancesFY19.add(balanceMock3);
        this.setupGlBalanceMockQuery(balancesFY19);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodCode()).thenReturn((Object)"01");
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(null)).thenReturn((Object)accountingPeriodMock);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(ContractsGrantsInvoiceDocument.class, "INCLUDE_PERIOD_13_IND", Boolean.FALSE)).thenReturn((Object)true);
        Mockito.when((Object)this.objectTypeSvcMock.getBasicExpenseObjectTypes(Integer.valueOf(2019))).thenReturn(BASIC_EXPENSE_OBJECT_TYPES);
        this.cut.setAccountingPeriodService(accountingPeriodSvcMock);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"0211401");
        String balanceTypeCode = "AC";
        KualiDecimal budgetAndActuals = this.cut.getBudgetAndActualsForAwardAccount(awardAccountMock, "AC");
        Assertions.assertEquals((Object)new KualiDecimal(503.0), (Object)budgetAndActuals);
    }

    @Test
    void getBudgetAndActualsForAwardAccount_period1_doNotIncludePeriod13(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) Balance balanceMock1, @Mock(stubOnly=true) Balance balanceMock2, @Mock(stubOnly=true) A21SubAccount a21SubAccountMock, @Mock(stubOnly=true) SubAccount subAccountMock, @Mock(stubOnly=true) Balance balanceMock3, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2019);
        Mockito.when((Object)balanceMock1.getContractsGrantsBeginningBalanceAmount()).thenReturn((Object)new KualiDecimal(220.0));
        KualiDecimal month13Amount = new KualiDecimal(30.0);
        KualiDecimal annualBalanceAmount = (KualiDecimal)((KualiDecimal)KualiDecimal.ZERO.add((AbstractKualiDecimal)KualiDecimal.ZERO)).add((AbstractKualiDecimal)month13Amount);
        Mockito.when((Object)balanceMock1.getAccountLineAnnualBalanceAmount()).thenReturn((Object)annualBalanceAmount);
        Mockito.when((Object)balanceMock1.getMonth13Amount()).thenReturn((Object)month13Amount);
        Mockito.when((Object)balanceMock2.getContractsGrantsBeginningBalanceAmount()).thenReturn((Object)new KualiDecimal(221.0));
        KualiDecimal month13Amount1 = new KualiDecimal(32.0);
        KualiDecimal annualBalanceAmount1 = (KualiDecimal)((KualiDecimal)KualiDecimal.ZERO.add((AbstractKualiDecimal)KualiDecimal.ZERO)).add((AbstractKualiDecimal)month13Amount1);
        Mockito.when((Object)balanceMock2.getAccountLineAnnualBalanceAmount()).thenReturn((Object)annualBalanceAmount1);
        Mockito.when((Object)balanceMock2.getMonth13Amount()).thenReturn((Object)month13Amount1);
        Mockito.when((Object)a21SubAccountMock.getSubAccountTypeCode()).thenReturn((Object)"CS");
        Mockito.when((Object)subAccountMock.getA21SubAccount()).thenReturn((Object)a21SubAccountMock);
        Mockito.when((Object)balanceMock3.getSubAccount()).thenReturn((Object)subAccountMock);
        ArrayList<Balance> balancesFY19 = new ArrayList<Balance>();
        balancesFY19.add(balanceMock1);
        balancesFY19.add(balanceMock2);
        balancesFY19.add(balanceMock3);
        this.setupGlBalanceMockQuery(balancesFY19);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodCode()).thenReturn((Object)"01");
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(null)).thenReturn((Object)accountingPeriodMock);
        this.cut.setAccountingPeriodService(accountingPeriodSvcMock);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"0211401");
        Mockito.when((Object)this.objectTypeSvcMock.getBasicExpenseObjectTypes(Integer.valueOf(2019))).thenReturn(BASIC_EXPENSE_OBJECT_TYPES);
        String balanceTypeCode = "AC";
        KualiDecimal budgetAndActuals = this.cut.getBudgetAndActualsForAwardAccount(awardAccountMock, "AC");
        Assertions.assertEquals((Object)new KualiDecimal(441.0), (Object)budgetAndActuals);
    }

    @Test
    void getBudgetAndActualsForAwardAccount_period2(@Mock(stubOnly=true) AccountingPeriodService accountingPeriodSvcMock, @Mock(stubOnly=true) Balance balanceMock1, @Mock(stubOnly=true) Balance balanceMock2, @Mock(stubOnly=true) A21SubAccount a21SubAccountMock, @Mock(stubOnly=true) SubAccount subAccountMock, @Mock(stubOnly=true) Balance balanceMock3, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2019);
        Mockito.when((Object)balanceMock1.getContractsGrantsBeginningBalanceAmount()).thenReturn((Object)new KualiDecimal(220.0));
        KualiDecimal month1Amount1 = new KualiDecimal(30.0);
        Mockito.when((Object)balanceMock1.getMonth1Amount()).thenReturn((Object)month1Amount1);
        Mockito.when((Object)balanceMock2.getContractsGrantsBeginningBalanceAmount()).thenReturn((Object)new KualiDecimal(221.0));
        KualiDecimal month1Amount2 = new KualiDecimal(32.0);
        Mockito.when((Object)balanceMock2.getMonth1Amount()).thenReturn((Object)month1Amount2);
        Mockito.when((Object)a21SubAccountMock.getSubAccountTypeCode()).thenReturn((Object)"CS");
        Mockito.when((Object)subAccountMock.getA21SubAccount()).thenReturn((Object)a21SubAccountMock);
        Mockito.when((Object)balanceMock3.getSubAccount()).thenReturn((Object)subAccountMock);
        ArrayList<Balance> balancesFY19 = new ArrayList<Balance>();
        balancesFY19.add(balanceMock1);
        balancesFY19.add(balanceMock2);
        balancesFY19.add(balanceMock3);
        this.setupGlBalanceMockQuery(balancesFY19);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodCode()).thenReturn((Object)"02");
        Mockito.when((Object)accountingPeriodSvcMock.getByDate(null)).thenReturn((Object)accountingPeriodMock);
        Mockito.when((Object)accountingPeriodSvcMock.getByDate((Date)ArgumentMatchers.any(Date.class))).thenReturn((Object)accountingPeriodMock);
        this.cut.setAccountingPeriodService(accountingPeriodSvcMock);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"0211401");
        Mockito.when((Object)this.objectTypeSvcMock.getBasicExpenseObjectTypes(Integer.valueOf(2019))).thenReturn(BASIC_EXPENSE_OBJECT_TYPES);
        String balanceTypeCode = "AC";
        KualiDecimal budgetAndActuals = this.cut.getBudgetAndActualsForAwardAccount(awardAccountMock, "AC");
        Assertions.assertEquals((Object)new KualiDecimal(503.0), (Object)budgetAndActuals);
    }

    @Test
    void getMilestonesBilledToDateAmount(@Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c) {
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        ArrayList<Milestone> milestonesByChartAccount = new ArrayList<Milestone>();
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401a);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401b);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Milestone.class, milestonesByChartAccount);
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211401";
        KualiDecimal billedToDateAmount = this.cut.getMilestonesBilledToDateAmount("1", "BL", "0211401");
        Assertions.assertEquals((Object)new KualiDecimal(250.0), (Object)billedToDateAmount);
    }

    @Test
    void getMilestonesBilledToDateAmount_NullAmount_DoesNotThrowException() {
        String proposalNumber = "4";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211403";
        KualiDecimal billedToDateAmount = this.cut.getMilestonesBilledToDateAmount("4", "BL", "0211403");
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    void getMilestonesBilledToDateAmount_NoMilestones() {
        String proposalNumber = "X";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211401";
        KualiDecimal billedToDateAmount = this.cut.getMilestonesBilledToDateAmount("X", "BL", "0211401");
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    void getMilestonesBilledToDateAmount_NoBilledMilestones() {
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211402";
        KualiDecimal billedToDateAmount = this.cut.getMilestonesBilledToDateAmount("1", "BL", "0211402");
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    void getPredeterminedBillingBilledToDateAmount(@Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401c) {
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        ArrayList<Bill> billsByChartAccount = new ArrayList<Bill>();
        billsByChartAccount.add(billProposal1ChartBlAccount0211401a);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401b);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Bill.class, billsByChartAccount);
        String proposalNumber = "2";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211401";
        KualiDecimal billedToDateAmount = this.cut.getPredeterminedBillingBilledToDateAmount("2", "BL", "0211401");
        Assertions.assertEquals((Object)new KualiDecimal(250.0), (Object)billedToDateAmount);
    }

    @Test
    void getPredeterminedBillingBilledToDateAmount_NullAmount_DoesNotThrowException() {
        String proposalNumber = "5";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211403";
        KualiDecimal billedToDateAmount = this.cut.getPredeterminedBillingBilledToDateAmount("5", "BL", "0211403");
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    void getPredeterminedBillingBilledToDateAmount_NoBills() {
        String proposalNumber = "X";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211401";
        KualiDecimal billedToDateAmount = this.cut.getPredeterminedBillingBilledToDateAmount("X", "BL", "0211401");
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    void getPredeterminedBillingBilledToDateAmount_NoBilledBills() {
        String proposalNumber = "2";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211402";
        KualiDecimal billedToDateAmount = this.cut.getPredeterminedBillingBilledToDateAmount("2", "BL", "0211402");
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    void calculatePreviouslyBilledAmounts_OneAccountMilestoneBilledZeroPreviouslyBilled(@Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        ArrayList<Milestone> milestonesByChartAccount = new ArrayList<Milestone>();
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401a);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401b);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Milestone.class, milestonesByChartAccount);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Bill.class, List.of());
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(200.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    private static InvoiceAccountDetail setupInvoiceAccountDetail(String chartOfAccountsCode, String accountNumber, KualiDecimal totalPreviouslyBilled, Account accountMock) {
        InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
        invoiceAccountDetail.setProposalNumber("1");
        invoiceAccountDetail.setChartOfAccountsCode(chartOfAccountsCode);
        invoiceAccountDetail.setAccountNumber(accountNumber);
        invoiceAccountDetail.setTotalPreviouslyBilled(totalPreviouslyBilled);
        invoiceAccountDetail.setAccount(accountMock);
        return invoiceAccountDetail;
    }

    private static InvoiceAccountDetail setupInvoiceAccountDetailWithInvoiceAmount(Account accountMock) {
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        invoiceAccountDetail.setInvoiceAmount(new KualiDecimal(100.0));
        return invoiceAccountDetail;
    }

    private static InvoiceAccountDetail setupInvoiceAccountDetailWithSubFundGroup(String accountNumber, KualiDecimal totalPreviouslyBilled, SubFundGroup subFundGroupMock, Account accountMock) {
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", accountNumber, totalPreviouslyBilled, accountMock);
        Mockito.when((Object)subFundGroupMock.getSubFundGroupCode()).thenReturn((Object)"AUXAMB");
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroupMock);
        return invoiceAccountDetail;
    }

    private static ContractsGrantsInvoiceDocument setupContractsGrantsInvoiceDocumentMock(String proposalNumber, List<InvoiceAccountDetail> invoiceAccountDetails, KualiDecimal totalPreviouslyBilled, KualiDecimal invoiceAmount, ContractsGrantsInvoiceDocument cgInvoiceDocumentMock, InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).getPreviouslyBilledTotal();
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).getPreviouslyBilledInvoiceAmount();
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).getTotalInvoiceInvoiceAmount();
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        Mockito.when((Object)invoiceGeneralDetailMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = new ContractsGrantsInvoiceDetail();
        totalCostInvoiceDetail.setTotalPreviouslyBilled(totalPreviouslyBilled);
        totalCostInvoiceDetail.setInvoiceAmount(invoiceAmount);
        Mockito.when((Object)cgInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)totalCostInvoiceDetail);
        return cgInvoiceDocumentMock;
    }

    @Test
    void calculatePreviouslyBilledAmounts_OneAccountMilestoneBilledSomePreviouslyBilled(@Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        ArrayList<Milestone> milestonesByChartAccount = new ArrayList<Milestone>();
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401a);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401b);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Milestone.class, milestonesByChartAccount);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Bill.class, List.of());
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_TwoAccountsMilestoneBilledZeroPreviouslyBilled(@Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBaAccount0211401, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account accountMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> milestonesByChartAccount = new ArrayList<Milestone>();
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401a);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401b);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Milestone.class, milestonesByChartAccount);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Bill.class, List.of());
        ArrayList<Milestone> milestonesByChartAccount2 = new ArrayList<Milestone>();
        milestonesByChartAccount2.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BA", "0211401", Milestone.class, milestonesByChartAccount2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BA", "0211401", Bill.class, List.of());
        InvoiceAccountDetail invoiceAccountDetail1 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        InvoiceAccountDetail invoiceAccountDetail2 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO, accountMock1);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail1);
        invoiceAccountDetails.add(invoiceAccountDetail2);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_TwoAccountMilestoneBilledSomePreviouslyBilled(@Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBaAccount0211401, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account accountMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> milestonesByChartAccount = new ArrayList<Milestone>();
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401a);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401b);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Milestone.class, milestonesByChartAccount);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Bill.class, List.of());
        ArrayList<Milestone> milestonesByChartAccount2 = new ArrayList<Milestone>();
        milestonesByChartAccount2.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BA", "0211401", Milestone.class, milestonesByChartAccount2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BA", "0211401", Bill.class, List.of());
        InvoiceAccountDetail invoiceAccountDetail1 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        InvoiceAccountDetail invoiceAccountDetail2 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO, accountMock1);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail1);
        invoiceAccountDetails.add(invoiceAccountDetail2);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_OneAccountNoMilestonesBilledZeroPreviouslyBilled(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("XX", "0211401", KualiDecimal.ZERO, accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(450.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_OneAccountNoMilestonesBilledSomePreviouslyBilled(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("XX", "0211401", KualiDecimal.ZERO, accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_OneAccountBillBilledZeroPreviouslyBilled(@Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        ArrayList<Bill> billsByChartAccount = new ArrayList<Bill>();
        billsByChartAccount.add(billProposal1ChartBlAccount0211401a);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401b);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Bill.class, billsByChartAccount);
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(200.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_OneAccountBillBilledSomePreviouslyBilled(@Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        ArrayList<Bill> billsByChartAccount = new ArrayList<Bill>();
        billsByChartAccount.add(billProposal1ChartBlAccount0211401a);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401b);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Bill.class, billsByChartAccount);
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_TwoAccountsBillBilledZeroPreviouslyBilled(@Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Bill billProposal1ChartBaAccount0211401, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account accountMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)billProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBaAccount0211401.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        ArrayList<Bill> billsByChartAccount = new ArrayList<Bill>();
        billsByChartAccount.add(billProposal1ChartBlAccount0211401a);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401b);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Bill.class, billsByChartAccount);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Milestone.class, List.of());
        ArrayList<Bill> billsByChartAccount2 = new ArrayList<Bill>();
        billsByChartAccount2.add(billProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BA", "0211401", Bill.class, billsByChartAccount2);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BA", "0211401", Milestone.class, List.of());
        InvoiceAccountDetail invoiceAccountDetail1 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        InvoiceAccountDetail invoiceAccountDetail2 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO, accountMock1);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail1);
        invoiceAccountDetails.add(invoiceAccountDetail2);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_TwoAccountBillBilledSomePreviouslyBilled(@Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Bill billProposal1ChartBaAccount0211401, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account accountMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)billProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBaAccount0211401.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        ArrayList<Bill> billsByChartAccount = new ArrayList<Bill>();
        billsByChartAccount.add(billProposal1ChartBlAccount0211401a);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401b);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Bill.class, billsByChartAccount);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Milestone.class, List.of());
        ArrayList<Bill> billsByChartAccount2 = new ArrayList<Bill>();
        billsByChartAccount2.add(billProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BA", "0211401", Bill.class, billsByChartAccount2);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BA", "0211401", Milestone.class, List.of());
        InvoiceAccountDetail invoiceAccountDetail1 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        InvoiceAccountDetail invoiceAccountDetail2 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO, accountMock1);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail1);
        invoiceAccountDetails.add(invoiceAccountDetail2);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_OneAccountNoBillsBilledZeroPreviouslyBilled(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("XX", "0211401", KualiDecimal.ZERO, accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(450.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_OneAccountNoBillsBilledSomePreviouslyBilled(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("XX", "0211401", KualiDecimal.ZERO, accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_TwoAccountMilestoneBilledSomePreviouslyBilled_ErrorCorrection(@Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBaAccount0211401, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account accountMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> milestonesByChartAccount = new ArrayList<Milestone>();
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401a);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401b);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Milestone.class, milestonesByChartAccount);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Bill.class, List.of());
        ArrayList<Milestone> milestonesByChartAccount2 = new ArrayList<Milestone>();
        milestonesByChartAccount2.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BA", "0211401", Milestone.class, milestonesByChartAccount2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BA", "0211401", Bill.class, List.of());
        InvoiceAccountDetail invoiceAccountDetail1 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        InvoiceAccountDetail invoiceAccountDetail2 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO, accountMock1);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail1);
        invoiceAccountDetails.add(invoiceAccountDetail2);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(-400.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        Mockito.when((Object)cgInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(-350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(-50.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void calculatePreviouslyBilledAmounts_TwoAccountBillBilledSomePreviouslyBilled_ErrorCorrection(@Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Bill billProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Bill billProposal1ChartBaAccount0211401, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account accountMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock1, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401a.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBlAccount0211401b.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)billProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)billProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billProposal1ChartBaAccount0211401.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        ArrayList<Bill> billsByChartAccount = new ArrayList<Bill>();
        billsByChartAccount.add(billProposal1ChartBlAccount0211401a);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401b);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Bill.class, billsByChartAccount);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Milestone.class, List.of());
        ArrayList<Bill> billsByChartAccount2 = new ArrayList<Bill>();
        billsByChartAccount2.add(billProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BA", "0211401", Bill.class, billsByChartAccount2);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BA", "0211401", Milestone.class, List.of());
        InvoiceAccountDetail invoiceAccountDetail1 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO, accountMock);
        InvoiceAccountDetail invoiceAccountDetail2 = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO, accountMock1);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail1);
        invoiceAccountDetails.add(invoiceAccountDetail2);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = ContractsGrantsInvoiceDocumentServiceImplTest.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(-400.0), cgInvoiceDocumentMock1, invoiceGeneralDetailMock);
        Mockito.when((Object)cgInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assertions.assertEquals((Object)new KualiDecimal(-350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assertions.assertEquals((Object)new KualiDecimal(-50.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    void updateBillsAndMilestones() {
        ArrayList<InvoiceBill> invoiceBills = new ArrayList<InvoiceBill>();
        InvoiceBill invoiceBill = InvoiceBillFixture.INV_BILL_1.createInvoiceBill();
        invoiceBill.setDocumentNumber("1");
        invoiceBills.add(invoiceBill);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        Bill bill = new Bill();
        bill.setBillIdentifier(invoiceBill.getBillIdentifier());
        bill.setBilled(false);
        bills.add(bill);
        HashMap fieldValues1 = new HashMap();
        ArrayList<Long> billIds = new ArrayList<Long>();
        billIds.add(invoiceBill.getBillIdentifier());
        fieldValues1.put("billIdentifier", billIds);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, fieldValues1)).thenReturn(bills);
        ArrayList<InvoiceMilestone> invoiceMilestones = new ArrayList<InvoiceMilestone>();
        InvoiceMilestone invoiceMilestone = InvoiceMilestoneFixture.INV_MLSTN_1.createInvoiceMilestone();
        invoiceMilestone.setDocumentNumber("1");
        invoiceMilestones.add(invoiceMilestone);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        Milestone milestone = new Milestone();
        milestone.setMilestoneIdentifier(invoiceMilestone.getMilestoneIdentifier());
        milestone.setBilled(false);
        milestones.add(milestone);
        HashMap fieldValues2 = new HashMap();
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        milestoneIds.add(invoiceMilestone.getMilestoneIdentifier());
        fieldValues2.put("milestoneIdentifier", milestoneIds);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, fieldValues2)).thenReturn(milestones);
        this.cut.updateBillsAndMilestones(true, invoiceMilestones, invoiceBills);
        for (Milestone updatedMilestone : milestones) {
            Assertions.assertTrue((boolean)updatedMilestone.isBilled());
        }
        for (Bill updatedBill : bills) {
            Assertions.assertTrue((boolean)updatedBill.isBilled());
        }
    }

    @Test
    void updateLastBilledDate_IsFinalBill(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2, @Mock(stubOnly=true) ModuleService moduleSvcMock) {
        String proposalNumber = "11";
        Date lastBilledDate = Date.valueOf("2011-10-01");
        Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn(null);
        Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn((Object)lastBilledDate);
        Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn(null);
        Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn((Object)lastBilledDate);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.isFinalBillIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getLastBilledDate()).thenReturn((Object)lastBilledDate);
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proposalNumber", "11");
        Mockito.when((Object)((ContractsAndGrantsBillingAward)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map))).thenReturn((Object)awardMock);
        Mockito.when((Object)this.kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAward.class)).thenReturn((Object)moduleSvcMock);
        this.cut.updateLastBilledDate(contractsGrantsInvoiceDocumentMock);
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", invoiceAccountDetail1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", invoiceAccountDetail1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", "11");
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setFinalBilledAndLastBilledDateToAwardAccount(mapKey, true, false, lastBilledDate);
        mapKey.put("accountNumber", invoiceAccountDetail2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", invoiceAccountDetail2.getChartOfAccountsCode());
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setFinalBilledAndLastBilledDateToAwardAccount(mapKey, true, false, lastBilledDate);
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setLastBilledDateToAward("11", lastBilledDate);
    }

    @Test
    void updateLastBilledDate_NotFinalBill(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2, @Mock(stubOnly=true) ModuleService moduleSvcMock) {
        String proposalNumber = "11";
        Date lastBilledDate = Date.valueOf("2011-10-01");
        Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn(null);
        Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn((Object)lastBilledDate);
        Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn(null);
        Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn((Object)lastBilledDate);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.isFinalBillIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getLastBilledDate()).thenReturn((Object)lastBilledDate);
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proposalNumber", "11");
        Mockito.when((Object)((ContractsAndGrantsBillingAward)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map))).thenReturn((Object)awardMock);
        Mockito.when((Object)this.kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAward.class)).thenReturn((Object)moduleSvcMock);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.isFinalBillIndicator()).thenReturn((Object)false);
        this.cut.updateLastBilledDate(contractsGrantsInvoiceDocumentMock);
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", invoiceAccountDetail1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", invoiceAccountDetail1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", "11");
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setLastBilledDateToAwardAccount(mapKey, false, lastBilledDate);
        mapKey.put("accountNumber", invoiceAccountDetail2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", invoiceAccountDetail2.getChartOfAccountsCode());
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setLastBilledDateToAwardAccount(mapKey, false, lastBilledDate);
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setLastBilledDateToAward("11", lastBilledDate);
    }

    @Test
    void getLastBilledDate(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        Date lastBilledDate = Date.valueOf("2011-10-01");
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)lastBilledDate);
        Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn(null);
        Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn((Object)lastBilledDate);
        Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn(null);
        Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn((Object)lastBilledDate);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Date expectedLastBilledDate = awardMock.getLastBilledDate();
        Assertions.assertEquals((Object)expectedLastBilledDate, (Object)this.cut.getLastBilledDate(awardMock));
    }

    @Test
    void getLastBilledDate_WithOneNullAwardAccount(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1a, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2a, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1b, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2b) {
        Date lastBilledDate = Date.valueOf("2011-10-01");
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)lastBilledDate);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocksA = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocksA.add(awardAccountMock1a);
        awardAccountMocksA.add(awardAccountMock2a);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocksA);
        Mockito.when((Object)awardAccountMock1b.getCurrentLastBilledDate()).thenReturn(null);
        Mockito.when((Object)awardAccountMock1b.getCurrentLastBilledDate()).thenReturn((Object)lastBilledDate);
        Mockito.when((Object)awardAccountMock2b.getCurrentLastBilledDate()).thenReturn(null);
        Mockito.when((Object)awardAccountMock2b.getCurrentLastBilledDate()).thenReturn(null);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocksB = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocksB.add(awardAccountMock1b);
        awardAccountMocksB.add(awardAccountMock2b);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocksB);
        Assertions.assertEquals((Object)awardMock.getLastBilledDate(), (Object)this.cut.getLastBilledDate(awardMock));
    }

    @Test
    void getLastBilledDate_LatestLastBilledAwardAccount(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        Date lastBilledDate = Date.valueOf("2011-10-01");
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)lastBilledDate);
        Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn((Object)lastBilledDate);
        Date oneMonthPriorLastBillDate = new Date(new DateTime(lastBilledDate.getTime()).minusMonths(1).toDate().getTime());
        Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn((Object)oneMonthPriorLastBillDate);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Assertions.assertEquals((Object)awardMock.getLastBilledDate(), (Object)this.cut.getLastBilledDate(awardMock));
    }

    @Test
    void correctContractsGrantsInvoiceDocument(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDaoMock) {
        String proposalNumber = "11";
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails0 = new ArrayList<InvoiceAccountDetail>();
        accountDetails0.add(invoiceAccountDetail1);
        accountDetails0.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails0);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
        invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetail.setInitialTransmissionDate(Date.valueOf(LocalDate.now()));
        invoiceAddressDetails.add(invoiceAddressDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        InvoiceAccountDetail invoiceAccountDetail = InvoiceAccountDetailFixture.INV_ACCT_DTL3.createInvoiceAccountDetail();
        KualiDecimal invoiceAmount = invoiceAccountDetail.getInvoiceAmount();
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)invoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)invoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        Mockito.when((Object)invoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)invoiceAmount);
        invoiceDocuments.add(invoiceDocumentMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(ArgumentMatchers.anyMap())).thenReturn(invoiceDocuments);
        this.cut.setContractsGrantsInvoiceDocumentDao(contractsGrantsInvoiceDocumentDaoMock);
        ArrayList<ContractsGrantsInvoiceDetail> directCostInvoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        ContractsGrantsInvoiceDetail directCostInvoiceDetail = new ContractsGrantsInvoiceDetail();
        KualiDecimal originalInvoiceAmount = new KualiDecimal(1.0);
        directCostInvoiceDetail.setInvoiceAmount(originalInvoiceAmount);
        directCostInvoiceDetails.add(directCostInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDirectCostInvoiceDetails()).thenReturn(directCostInvoiceDetails);
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode1 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD1.createInvoiceDetailAccountObjectCode();
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode2 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD2.createInvoiceDetailAccountObjectCode();
        KualiDecimal originalCurrentExpenditures1 = new KualiDecimal(3.01);
        KualiDecimal originalCurrentExpenditures2 = new KualiDecimal(2.02);
        invoiceDetailAccountObjectCode1.setCurrentExpenditures(originalCurrentExpenditures1);
        invoiceDetailAccountObjectCode2.setCurrentExpenditures(originalCurrentExpenditures2);
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode1);
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        ArrayList<InvoiceAccountDetail> newAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail newInvoiceAccountDetail = InvoiceAccountDetailFixture.INV_ACCT_DTL4.createInvoiceAccountDetail();
        newInvoiceAccountDetail.setInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        newAccountDetails.add(newInvoiceAccountDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(newAccountDetails);
        KualiDecimal originalAccountDetailInvoiceAmount = newInvoiceAccountDetail.getInvoiceAmount();
        this.cut.correctContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        for (Object invoiceAddressDetail0 : contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()) {
            Assertions.assertNull((Object)invoiceAddressDetail0.getInitialTransmissionDate());
        }
        Assertions.assertEquals((Object)new KualiDecimal(2.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
        Assertions.assertEquals((Object)originalInvoiceAmount.negated(), (Object)((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocumentMock.getDirectCostInvoiceDetails().get(0)).getInvoiceAmount());
        List updatedInvoiceDetailAccountObjectCodes = contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : updatedInvoiceDetailAccountObjectCodes) {
            if (invoiceDetailAccountObjectCode.getAccountNumber().equals(invoiceDetailAccountObjectCode1.getAccountNumber())) {
                Assertions.assertEquals((Object)originalCurrentExpenditures1.negated(), (Object)invoiceDetailAccountObjectCode.getCurrentExpenditures());
                continue;
            }
            Assertions.assertEquals((Object)originalCurrentExpenditures2.negated(), (Object)invoiceDetailAccountObjectCode.getCurrentExpenditures());
        }
        InvoiceAccountDetail accountDetail = (InvoiceAccountDetail)contractsGrantsInvoiceDocumentMock.getAccountDetails().get(0);
        Assertions.assertEquals((Object)originalAccountDetailInvoiceAmount, (Object)accountDetail.getTotalPreviouslyBilled());
        Assertions.assertEquals((Object)originalAccountDetailInvoiceAmount.negated(), (Object)accountDetail.getCumulativeExpenditures());
        Assertions.assertEquals((Object)originalAccountDetailInvoiceAmount.negated(), (Object)accountDetail.getInvoiceAmount());
        Assertions.assertNull((Object)accountDetail.getInvoiceDocument());
    }

    @Test
    void correctContractsGrantsInvoiceDocument_Milestone(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) {
        String proposalNumber = "11";
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
        invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetail.setInitialTransmissionDate(Date.valueOf(LocalDate.now()));
        invoiceAddressDetails.add(invoiceAddressDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        ArrayList<InvoiceMilestone> invoiceMilestones = new ArrayList<InvoiceMilestone>();
        InvoiceMilestone invoiceMilestone = InvoiceMilestoneFixture.INV_MLSTN_1.createInvoiceMilestone();
        invoiceMilestone.setDocumentNumber("1");
        invoiceMilestones.add(invoiceMilestone);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceMilestones()).thenReturn(invoiceMilestones);
        KualiDecimal originalMilestoneAmount = invoiceMilestone.getMilestoneAmount();
        this.cut.correctContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        for (InvoiceAddressDetail invoiceAddressDetail0 : contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()) {
            Assertions.assertNull((Object)invoiceAddressDetail0.getInitialTransmissionDate());
        }
        Assertions.assertEquals((Object)originalMilestoneAmount.negated(), (Object)invoiceMilestone.getMilestoneAmount());
        Assertions.assertEquals((Object)new KualiDecimal(-1.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    void correctContractsGrantsInvoiceDocument_Bill(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) {
        String proposalNumber = "11";
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail1 = new InvoiceAddressDetail();
        invoiceAddressDetail1.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail1.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetail1.setInitialTransmissionDate(Date.valueOf(LocalDate.now()));
        invoiceAddressDetails.add(invoiceAddressDetail1);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList<InvoiceBill> invoiceBills = new ArrayList<InvoiceBill>();
        InvoiceBill invoiceBill = InvoiceBillFixture.INV_BILL_1.createInvoiceBill();
        invoiceBill.setDocumentNumber("1");
        invoiceBills.add(invoiceBill);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceBills()).thenReturn(invoiceBills);
        KualiDecimal originalBillAmount = invoiceBill.getEstimatedAmount();
        this.cut.correctContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        for (InvoiceAddressDetail invoiceAddressDetail : contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()) {
            Assertions.assertNull((Object)invoiceAddressDetail.getInitialTransmissionDate());
        }
        Assertions.assertEquals((Object)originalBillAmount.negated(), (Object)invoiceBill.getEstimatedAmount());
        Assertions.assertEquals((Object)new KualiDecimal(-1.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    void updateUnfinalizationToAwardAccount(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) {
        String proposalNumber = "11";
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        this.cut.updateUnfinalizationToAwardAccount(contractsGrantsInvoiceDocumentMock.getAccountDetails(), contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getProposalNumber());
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", invoiceAccountDetail1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", invoiceAccountDetail1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", "11");
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setFinalBilledToAwardAccount(mapKey, false);
        mapKey.put("accountNumber", invoiceAccountDetail2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", invoiceAccountDetail2.getChartOfAccountsCode());
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setFinalBilledToAwardAccount(mapKey, false);
    }

    @Test
    void createSourceAccountingLinesByAward_ThreeAccountsZeroPreviouslyBilled(@Mock(stubOnly=true) AccountService accountServiceMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock, @Mock(stubOnly=true) SubFundGroup subFundGroupMock, @Mock(stubOnly=true) Account accountMock) {
        List sourceAccountingLines;
        ContractsGrantsInvoiceObjectCode contractsGrantsInvoiceObjectCode = new ContractsGrantsInvoiceObjectCode();
        contractsGrantsInvoiceObjectCode.setIncomeFinancialObjectCode("0110");
        contractsGrantsInvoiceObjectCode.setReceivableFinancialObjectCode("8118");
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("subFundGroupCode", "AUXAMB");
        fieldValues.put("chartOfAccountsCode", "BL");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(ContractsGrantsInvoiceObjectCode.class, fieldValues)).thenReturn(Collections.singletonList(contractsGrantsInvoiceObjectCode));
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(Bill.class), ArgumentMatchers.anyMap())).thenReturn(List.of());
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(Milestone.class), ArgumentMatchers.anyMap())).thenReturn(List.of());
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211905", KualiDecimal.ZERO, subFundGroupMock, accountMock));
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211906", KualiDecimal.ZERO, subFundGroupMock, accountMock));
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211907", KualiDecimal.ZERO, subFundGroupMock, accountMock));
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211905", "4100", "S&E", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211905", "2008", "SAL", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211906", "4100", "S&E", new KualiDecimal(50.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211906", "2008", "SAL", new KualiDecimal(50.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211907", "4100", "S&E", new KualiDecimal(125.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211907", "2008", "SAL", new KualiDecimal(175.0), KualiDecimal.ZERO));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        HashMap<String, KualiDecimal> expectedAmounts = new HashMap<String, KualiDecimal>();
        expectedAmounts.put("0211905", new KualiDecimal(50.0));
        expectedAmounts.put("0211906", new KualiDecimal(100.0));
        expectedAmounts.put("0211907", new KualiDecimal(300.0));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)accountServiceMock);
            sourceAccountingLines = this.cut.createSourceAccountingLinesByAward(cgInvoiceDocumentMock);
        }
        Assertions.assertNotNull((Object)sourceAccountingLines);
        Assertions.assertEquals((int)3, (int)sourceAccountingLines.size());
        for (CustomerInvoiceDetail sourceAccountingLine : sourceAccountingLines) {
            Assertions.assertEquals(expectedAmounts.get(sourceAccountingLine.getAccountNumber()), (Object)sourceAccountingLine.getAmount());
            Assertions.assertEquals((Object)"0110", (Object)sourceAccountingLine.getFinancialObjectCode());
            Assertions.assertEquals((Object)"8118", (Object)sourceAccountingLine.getAccountsReceivableObjectCode());
        }
    }

    private static InvoiceDetailAccountObjectCode setupInvoiceDetailAccountObjectCode(String accountNumber, String financialObjectCode, String categoryCode, KualiDecimal currentExpenditures, KualiDecimal totalBilled) {
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = new InvoiceDetailAccountObjectCode();
        invoiceDetailAccountObjectCode.setChartOfAccountsCode("BL");
        invoiceDetailAccountObjectCode.setAccountNumber(accountNumber);
        invoiceDetailAccountObjectCode.setFinancialObjectCode(financialObjectCode);
        invoiceDetailAccountObjectCode.setCategoryCode(categoryCode);
        invoiceDetailAccountObjectCode.setCurrentExpenditures(currentExpenditures);
        invoiceDetailAccountObjectCode.setTotalBilled(totalBilled);
        return invoiceDetailAccountObjectCode;
    }

    private static InvoiceDetailAccountObjectCode setupInvoiceDetailAccountObjectCode() {
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = new InvoiceDetailAccountObjectCode();
        invoiceDetailAccountObjectCode.setCurrentExpenditures(new KualiDecimal(100.0));
        return invoiceDetailAccountObjectCode;
    }

    @Test
    void createSourceAccountingLinesByAward_ThreeAccountsBillsPreviouslyBilled(@Mock(stubOnly=true) Bill billMock1, @Mock(stubOnly=true) Bill billMock2, @Mock(stubOnly=true) Bill billMock3, @Mock(stubOnly=true) Bill billMock4, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock, @Mock(stubOnly=true) AccountService accountServiceMock, @Mock(stubOnly=true) SubFundGroup subFundGroupMock, @Mock(stubOnly=true) Account accountMock) {
        List sourceAccountingLines;
        this.setupContractsGrantsInvoiceObjectCodeMockQuery();
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211905", KualiDecimal.ZERO, subFundGroupMock, accountMock));
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211906", KualiDecimal.ZERO, subFundGroupMock, accountMock));
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211907", KualiDecimal.ZERO, subFundGroupMock, accountMock));
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211905", "4100", "S&E", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211905", "2008", "SAL", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211906", "4100", "S&E", new KualiDecimal(50.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211906", "2008", "SAL", new KualiDecimal(50.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211907", "4100", "S&E", new KualiDecimal(125.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211907", "2008", "SAL", new KualiDecimal(175.0), KualiDecimal.ZERO));
        ArrayList<Bill> bills = new ArrayList<Bill>();
        Mockito.when((Object)billMock1.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock1.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(50.0));
        bills.add(billMock1);
        Mockito.when((Object)billMock2.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock2.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(100.0));
        bills.add(billMock2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211905", Bill.class, bills);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211905", Milestone.class, List.of());
        ArrayList<Bill> bills1 = new ArrayList<Bill>();
        Mockito.when((Object)billMock3.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock3.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(50.0));
        bills1.add(billMock3);
        Mockito.when((Object)billMock4.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock4.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(50.0));
        bills1.add(billMock4);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211906", Bill.class, bills1);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211906", Milestone.class, List.of());
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = new ContractsGrantsInvoiceDetail();
        totalCostInvoiceDetail.setTotalPreviouslyBilled(new KualiDecimal(0.0));
        totalCostInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        HashMap<String, KualiDecimal> expectedAmounts = new HashMap<String, KualiDecimal>();
        expectedAmounts.put("0211905", new KualiDecimal(-100.0));
        expectedAmounts.put("0211906", KualiDecimal.ZERO);
        expectedAmounts.put("0211907", new KualiDecimal(300.0));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)accountServiceMock);
            sourceAccountingLines = this.cut.createSourceAccountingLinesByAward(cgInvoiceDocumentMock);
        }
        Assertions.assertNotNull((Object)sourceAccountingLines);
        Assertions.assertEquals((int)3, (int)sourceAccountingLines.size());
        for (CustomerInvoiceDetail sourceAccountingLine : sourceAccountingLines) {
            Assertions.assertEquals(expectedAmounts.get(sourceAccountingLine.getAccountNumber()), (Object)sourceAccountingLine.getAmount());
            Assertions.assertEquals((Object)"0110", (Object)sourceAccountingLine.getFinancialObjectCode());
            Assertions.assertEquals((Object)"8118", (Object)sourceAccountingLine.getAccountsReceivableObjectCode());
        }
    }

    @Test
    void createSourceAccountingLinesByAward_ThreeAccountsBillsAndMonthlyPreviouslyBilled(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock, @Mock(stubOnly=true) AccountService accountServiceMock, @Mock(stubOnly=true) SubFundGroup subFundGroupMock, @Mock(stubOnly=true) Account accountMock) {
        List sourceAccountingLines;
        this.setupContractsGrantsInvoiceObjectCodeMockQuery();
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211905", new KualiDecimal(50.0), subFundGroupMock, accountMock));
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211906", new KualiDecimal(100.0), subFundGroupMock, accountMock));
        invoiceAccountDetails.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithSubFundGroup("0211907", new KualiDecimal(300.0), subFundGroupMock, accountMock));
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211905", "4100", "S&E", KualiDecimal.ZERO, new KualiDecimal(25.0)));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211905", "2008", "SAL", new KualiDecimal(200.0), new KualiDecimal(25.0)));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211906", "6000", "TRAV", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211906", "4100", "S&E", KualiDecimal.ZERO, new KualiDecimal(50.0)));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211906", "2008", "SAL", new KualiDecimal(25.0), new KualiDecimal(50.0)));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211907", "6000", "TRAV", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211907", "4100", "S&E", KualiDecimal.ZERO, new KualiDecimal(125.0)));
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode("0211907", "2008", "SAL", new KualiDecimal(25.0), new KualiDecimal(175.0)));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        HashMap<String, KualiDecimal> expectedAmounts = new HashMap<String, KualiDecimal>();
        expectedAmounts.put("0211905", new KualiDecimal(200.0));
        expectedAmounts.put("0211906", new KualiDecimal(50.0));
        expectedAmounts.put("0211907", new KualiDecimal(50.0));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)accountServiceMock);
            sourceAccountingLines = this.cut.createSourceAccountingLinesByAward(cgInvoiceDocumentMock);
        }
        Assertions.assertNotNull((Object)sourceAccountingLines);
        Assertions.assertEquals((int)3, (int)sourceAccountingLines.size());
        for (CustomerInvoiceDetail sourceAccountingLine : sourceAccountingLines) {
            Assertions.assertEquals(expectedAmounts.get(sourceAccountingLine.getAccountNumber()), (Object)sourceAccountingLine.getAmount());
            Assertions.assertEquals((Object)"0110", (Object)sourceAccountingLine.getFinancialObjectCode());
            Assertions.assertEquals((Object)"8118", (Object)sourceAccountingLine.getAccountsReceivableObjectCode());
        }
    }

    @Test
    void getAwardBilledToDateAmount_NoInvoices() {
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, Collections.emptyList());
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmount("1");
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)awardBilledToDateAmount);
    }

    @Test
    void getAwardBilledToDateAmount_CostReimbursableMilestoneAndPredeterminedBillingInvoices(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceMock2, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceMock3, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceMock4, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceMock5, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument invoiceMock6, @Mock(stubOnly=true) Bill billMock1, @Mock(stubOnly=true) Bill billMock2, @Mock(stubOnly=true) Milestone milestoneMock1, @Mock(stubOnly=true) Milestone milestoneMock2, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) {
        InvoiceGeneralDetail invoiceGeneralDetail1 = new InvoiceGeneralDetail();
        invoiceGeneralDetail1.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)invoiceMock1.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail1);
        InvoiceGeneralDetail invoiceGeneralDetail2 = new InvoiceGeneralDetail();
        invoiceGeneralDetail2.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)invoiceMock2.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail2);
        InvoiceGeneralDetail invoiceGeneralDetail3 = new InvoiceGeneralDetail();
        invoiceGeneralDetail3.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)invoiceMock3.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail3);
        InvoiceGeneralDetail invoiceGeneralDetail4 = new InvoiceGeneralDetail();
        invoiceGeneralDetail4.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)invoiceMock4.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail4);
        InvoiceGeneralDetail invoiceGeneralDetail5 = new InvoiceGeneralDetail();
        invoiceGeneralDetail5.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)invoiceMock5.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail5);
        Mockito.when((Object)invoiceMock5.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(500.0));
        InvoiceGeneralDetail invoiceGeneralDetail6 = new InvoiceGeneralDetail();
        invoiceGeneralDetail6.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)invoiceMock6.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail6);
        Mockito.when((Object)invoiceMock6.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(600.0));
        ArrayList<ContractsGrantsInvoiceDocument> invoiceMocks = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceMocks.add(invoiceMock1);
        invoiceMocks.add(invoiceMock2);
        invoiceMocks.add(invoiceMock3);
        invoiceMocks.add(invoiceMock4);
        invoiceMocks.add(invoiceMock5);
        invoiceMocks.add(invoiceMock6);
        Mockito.when((Object)billMock1.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock1.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(300.0));
        Mockito.when((Object)billMock2.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock2.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(400.0));
        ArrayList<Bill> priorBills = new ArrayList<Bill>();
        priorBills.add(billMock1);
        priorBills.add(billMock2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Bill.class, priorBills);
        Mockito.when((Object)milestoneMock1.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneMock1.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneMock2.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(200.0));
        Mockito.when((Object)milestoneMock2.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> priorMilestones = new ArrayList<Milestone>();
        priorMilestones.add(milestoneMock1);
        priorMilestones.add(milestoneMock2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, priorMilestones);
        ContractsGrantsInvoiceDocument invoiceMockWithDocumentNumber = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceMock(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), new KualiDecimal(700.0), contractsGrantsInvoiceDocumentMock);
        invoiceMocks.add(invoiceMockWithDocumentNumber);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceMocks);
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmount("1");
        Assertions.assertEquals((Object)new KualiDecimal(2800.0), (Object)awardBilledToDateAmount);
    }

    private static ContractsGrantsInvoiceDocument setupInvoiceMock(String billingFrequencyCode, KualiDecimal amount, ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) {
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setBillingFrequencyCode(billingFrequencyCode);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)amount);
        return contractsGrantsInvoiceDocumentMock;
    }

    @Test
    void getAwardBilledToDateAmountExcludingDocument_NoInvoices() {
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, Collections.emptyList());
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmountExcludingDocument("1", "1");
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)awardBilledToDateAmount);
    }

    @Test
    void getAwardBilledToDateAmountExcludingDocument_CostReimbursableMilestoneAndPredeterminedBillingInvoices(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock2, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock3, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock4, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock5, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock6, @Mock(stubOnly=true) Bill billMock1, @Mock(stubOnly=true) Bill billMock2, @Mock(stubOnly=true) Milestone milestoneMock1, @Mock(stubOnly=true) Milestone milestoneMock2) {
        InvoiceGeneralDetail invoiceGeneralDetail1 = new InvoiceGeneralDetail();
        invoiceGeneralDetail1.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock1.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail1);
        InvoiceGeneralDetail invoiceGeneralDetail2 = new InvoiceGeneralDetail();
        invoiceGeneralDetail2.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock2.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail2);
        InvoiceGeneralDetail invoiceGeneralDetail3 = new InvoiceGeneralDetail();
        invoiceGeneralDetail3.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock3.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail3);
        InvoiceGeneralDetail invoiceGeneralDetail4 = new InvoiceGeneralDetail();
        invoiceGeneralDetail4.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock4.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail4);
        InvoiceGeneralDetail invoiceGeneralDetail5 = new InvoiceGeneralDetail();
        invoiceGeneralDetail5.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock5.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail5);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock5.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(500.0));
        InvoiceGeneralDetail invoiceGeneralDetail6 = new InvoiceGeneralDetail();
        invoiceGeneralDetail6.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock6.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail6);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock6.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(600.0));
        ArrayList<ContractsGrantsInvoiceDocument> invoiceMocks = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock1);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock2);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock3);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock4);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock5);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock6);
        Mockito.when((Object)billMock1.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock1.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(300.0));
        Mockito.when((Object)billMock2.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock2.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(400.0));
        ArrayList<Bill> priorBills = new ArrayList<Bill>();
        priorBills.add(billMock1);
        priorBills.add(billMock2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Bill.class, priorBills);
        Mockito.when((Object)milestoneMock1.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneMock1.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneMock2.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(200.0));
        Mockito.when((Object)milestoneMock2.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> priorMilestones = new ArrayList<Milestone>();
        priorMilestones.add(milestoneMock1);
        priorMilestones.add(milestoneMock2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, priorMilestones);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        fieldValues.put("documentNumber", SearchOperator.NOT + "1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceMocks);
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmountExcludingDocument("1", "1");
        Assertions.assertEquals((Object)new KualiDecimal(2100.0), (Object)awardBilledToDateAmount);
    }

    @Test
    void getAwardBilledToDateAmountExcludingDocument_InvoicesWithNullAmounts_DoNotThrowException(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock1, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock2, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock3, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock4, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock5, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock6, @Mock(stubOnly=true) Bill billMock1, @Mock(stubOnly=true) Bill billMock2, @Mock(stubOnly=true) Milestone milestoneMock1, @Mock(stubOnly=true) Milestone milestoneMock2) {
        InvoiceGeneralDetail invoiceGeneralDetail1 = new InvoiceGeneralDetail();
        invoiceGeneralDetail1.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock1.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail1);
        InvoiceGeneralDetail invoiceGeneralDetail2 = new InvoiceGeneralDetail();
        invoiceGeneralDetail2.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock2.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail2);
        InvoiceGeneralDetail invoiceGeneralDetail3 = new InvoiceGeneralDetail();
        invoiceGeneralDetail3.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock3.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail3);
        InvoiceGeneralDetail invoiceGeneralDetail4 = new InvoiceGeneralDetail();
        invoiceGeneralDetail4.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock4.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail4);
        InvoiceGeneralDetail invoiceGeneralDetail5 = new InvoiceGeneralDetail();
        invoiceGeneralDetail5.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock5.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail5);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock5.getTotalInvoiceAmount()).thenReturn(null);
        InvoiceGeneralDetail invoiceGeneralDetail6 = new InvoiceGeneralDetail();
        invoiceGeneralDetail6.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock6.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail6);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock6.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(600.0));
        ArrayList<ContractsGrantsInvoiceDocument> invoiceMocks = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock1);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock2);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock3);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock4);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock5);
        invoiceMocks.add(contractsGrantsInvoiceDocumentMock6);
        Mockito.when((Object)billMock1.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock1.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(300.0));
        Mockito.when((Object)billMock2.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)billMock2.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(400.0));
        ArrayList<Bill> priorBills = new ArrayList<Bill>();
        priorBills.add(billMock1);
        priorBills.add(billMock2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Bill.class, priorBills);
        Mockito.when((Object)milestoneMock1.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneMock1.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneMock2.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(200.0));
        Mockito.when((Object)milestoneMock2.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> priorMilestones = new ArrayList<Milestone>();
        priorMilestones.add(milestoneMock1);
        priorMilestones.add(milestoneMock2);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, priorMilestones);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        fieldValues.put("documentNumber", SearchOperator.NOT + "1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceMocks);
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmountExcludingDocument("1", "1");
        Assertions.assertEquals((Object)new KualiDecimal(1600.0), (Object)awardBilledToDateAmount);
    }

    @Test
    void recalculateTotalAmountBilledToDate_NoPriorBilled_OneInvoice(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) {
        String proposalNumber = "11";
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(100.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        this.cut.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    void recalculateTotalAmountBilledToDate_NoPriorBilled_TwoInvoices(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock) {
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, Collections.emptyList());
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(100.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithInvoiceAmount(accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceDocuments.add(cgInvoiceDocumentMock);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("invoiceGeneralDetail.billingPeriod", null);
        String docNumberCriteriaString = SearchOperator.NOT + "1";
        fieldValues.put("documentNumber", docNumberCriteriaString);
        fieldValues.put("documentHeader.financialDocumentStatusCode", SearchOperator.NOT + "P" + SearchOperator.NOT + "A");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceDocuments);
        HashMap<String, String> fieldValues2 = new HashMap<String, String>();
        fieldValues2.put("documentHeader.workflowDocumentStatusCode", "P|F");
        fieldValues2.put("invoiceGeneralDetail.proposalNumber", "1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues2)).thenReturn(List.of());
        this.cut.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(200.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    void recalculateTotalAmountBilledToDate_PriorBilled_OneInvoice(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211402, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBaAccount0211401) {
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211402.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> allMilestonesProposal1 = new ArrayList<Milestone>();
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401a);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401b);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401c);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211402);
        allMilestonesProposal1.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, allMilestonesProposal1);
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        this.cut.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(450.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    void recalculateTotalAmountBilledToDate_PriorBilled_TwoInvoices(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211402, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBaAccount0211401, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock) {
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211402.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> allMilestonesProposal1 = new ArrayList<Milestone>();
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401a);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401b);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401c);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211402);
        allMilestonesProposal1.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, allMilestonesProposal1);
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithInvoiceAmount(accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceDocuments.add(cgInvoiceDocumentMock);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("invoiceGeneralDetail.billingPeriod", null);
        String docNumberCriteriaString = SearchOperator.NOT + "1";
        fieldValues.put("documentNumber", docNumberCriteriaString);
        fieldValues.put("documentHeader.financialDocumentStatusCode", SearchOperator.NOT + "P" + SearchOperator.NOT + "A");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceDocuments);
        HashMap<String, String> fieldValues2 = new HashMap<String, String>();
        fieldValues2.put("documentHeader.workflowDocumentStatusCode", "P|F");
        fieldValues2.put("invoiceGeneralDetail.proposalNumber", "1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues2)).thenReturn(List.of());
        this.cut.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(550.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    void recalculateTotalAmountBilledToDate_PriorBilledMilestoneAndMonthly_OneInvoice(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211402, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBaAccount0211401, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211402.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> allMilestonesProposal1 = new ArrayList<Milestone>();
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401a);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401b);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401c);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211402);
        allMilestonesProposal1.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, allMilestonesProposal1);
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(450.0));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceDocuments.add(cgInvoiceDocumentMock);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceDocuments);
        this.cut.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(900.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    void recalculateTotalAmountBilledToDate_PriorBilledMilestoneAndMonthly_TwoInvoices(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401a, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401b, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211401c, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBlAccount0211402, @Mock(stubOnly=true) Milestone milestoneProposal1ChartBaAccount0211401, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument cgInvoiceDocumentMock2, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail3 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail3);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401a.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(150.0));
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401b.isBilled()).thenReturn((Object)true);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211401c.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBlAccount0211402.isBilled()).thenReturn((Object)false);
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)milestoneProposal1ChartBaAccount0211401.isBilled()).thenReturn((Object)true);
        ArrayList<Milestone> allMilestonesProposal1 = new ArrayList<Milestone>();
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401a);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401b);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401c);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211402);
        allMilestonesProposal1.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, allMilestonesProposal1);
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(450.0));
        InvoiceAccountDetail invoiceAccountDetail = ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceAccountDetailWithInvoiceAmount(accountMock);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail);
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceDocuments.add(cgInvoiceDocumentMock);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("invoiceGeneralDetail.billingPeriod", null);
        String docNumberCriteriaString = SearchOperator.NOT + "1";
        fieldValues.put("documentNumber", docNumberCriteriaString);
        fieldValues.put("documentHeader.financialDocumentStatusCode", SearchOperator.NOT + "P" + SearchOperator.NOT + "A");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceDocuments);
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock2)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock2)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock2)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)cgInvoiceDocumentMock2.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        cgInvoiceDocumentMock2.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock2.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock2.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock2.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments2 = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceDocuments2.add(cgInvoiceDocumentMock2);
        HashMap<String, String> fieldValues2 = new HashMap<String, String>();
        fieldValues2.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues2.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues2)).thenReturn(invoiceDocuments2);
        this.cut.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocumentMock);
        Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    void recalculateObjectCodeByCategory(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock) {
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(1000.0));
        KualiDecimal total = new KualiDecimal(1000.0);
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode());
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode());
        invoiceDetailAccountObjectCodes.add(ContractsGrantsInvoiceDocumentServiceImplTest.setupInvoiceDetailAccountObjectCode());
        this.cut.recalculateObjectCodeByCategory(contractsGrantsInvoiceDocumentMock, contractsGrantsInvoiceDetail, total, invoiceDetailAccountObjectCodes);
        Assertions.assertEquals((Object)new KualiDecimal(333.34), (Object)((InvoiceDetailAccountObjectCode)invoiceDetailAccountObjectCodes.get(0)).getCurrentExpenditures());
        Assertions.assertEquals((Object)new KualiDecimal(333.33), (Object)((InvoiceDetailAccountObjectCode)invoiceDetailAccountObjectCodes.get(1)).getCurrentExpenditures());
        Assertions.assertEquals((Object)new KualiDecimal(333.33), (Object)((InvoiceDetailAccountObjectCode)invoiceDetailAccountObjectCodes.get(2)).getCurrentExpenditures());
    }

    @Test
    void getTemplateParameterList_Monthly(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2, @Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager primaryFundManagerMock, @Mock(stubOnly=true) Person fundManagerMock, @Mock(stubOnly=true) ContractAndGrantsProposal proposalMock, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account contractControlAccountMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock, @Mock(stubOnly=true) Customer customerMock, @Mock(stubOnly=true) CustomerAddress customerAddressMock, @Mock(stubOnly=true) SystemInformation sysInfoMock, @Mock(stubOnly=true) AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetailMock, @Mock(stubOnly=true) CostCategory costCategoryMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDetail directCostInvoiceDetailMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDetail indirectCostInvoiceDetailMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDetail totalCostInvoiceDetailMock) {
        ((DateTimeService)Mockito.doReturn((Object)TODAY_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(TODAY.toDate());
        ((DateTimeService)Mockito.doReturn((Object)YESTERDAY_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(YESTERDAY.toDate());
        ((DateTimeService)Mockito.doReturn((Object)TOMORROW_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(TOMORROW.toDate());
        String proposalNumber = "11";
        Date lastBilledDate = Date.valueOf("2011-10-01");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.isFinalBillIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getLastBilledDate()).thenReturn((Object)lastBilledDate);
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        ContractsGrantsInvoiceDocumentServiceImplTest.setupCostReimbursableMockingForTemplateTest(contractsGrantsInvoiceDocumentMock, contractsGrantsInvoiceDetailMock, costCategoryMock, directCostInvoiceDetailMock, indirectCostInvoiceDetailMock, totalCostInvoiceDetailMock);
        ((InvoiceGeneralDetail)Mockito.doReturn((Object)this.contractsAndGrantsModuleBillingSvcMock).when((Object)this.invoiceGeneralDetailSpy)).getContractsAndGrantsModuleBillingService();
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getLastBilledDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAwardDateRange()).thenReturn((Object)"2011-05-02 - 2012-04-30");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingPeriod()).thenReturn((Object)"2011-06-01 to 2011-07-01");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getInstrumentTypeCode()).thenReturn((Object)"GTCS");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAwardTotal()).thenReturn((Object)new KualiDecimal(12000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAmountRemainingToBill()).thenReturn((Object)new KualiDecimal(11000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getTotalPreviouslyBilled()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getCostShareAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-10-01"));
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock1.getAwardDirectCostAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.getAwardIndirectCostAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.getMinInvoiceAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.isExcludedFromInvoicing()).thenReturn((Object)false);
        Mockito.when((Object)awardMock1.isActive()).thenReturn((Object)true);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardMock1.getAutoApproveIndicator()).thenReturn((Object)true);
        Mockito.when((Object)agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)agencyMock.getFullName()).thenReturn((Object)"U.S. AIR FORCE");
        Mockito.when((Object)awardMock1.getAgency()).thenReturn((Object)agencyMock);
        String agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock1.getAgencyNumber()).thenReturn((Object)agencyNumber);
        Date awardBeginningDate = Date.valueOf("2011-05-02");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)awardBeginningDate);
        ((DateTimeService)Mockito.doReturn((Object)"05/02/2011").when((Object)this.dateTimeServiceMock)).toDateString((java.util.Date)awardBeginningDate);
        Date awardEndingDate = Date.valueOf("2012-04-30");
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)awardEndingDate);
        ((DateTimeService)Mockito.doReturn((Object)"04/30/2012").when((Object)this.dateTimeServiceMock)).toDateString((java.util.Date)awardEndingDate);
        Mockito.when((Object)awardMock1.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        Mockito.when((Object)awardMock1.getAwardAddendumNumber()).thenReturn((Object)"awardAddendumNumber");
        Mockito.when((Object)awardMock1.getAwardAllocatedUniversityComputingServicesAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock1.getFederalPassThroughFundedAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock1.getAwardEntryDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)awardMock1.getAgencyFuture1Amount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)awardMock1.getAgencyFuture2Amount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock1.getAgencyFuture3Amount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)awardMock1.getAwardDocumentNumber()).thenReturn((Object)"awardDocumentNumber");
        Mockito.when((Object)awardMock1.getFederalPassThroughIndicator()).thenReturn((Object)true);
        Mockito.when((Object)awardMock1.getAwardDirectCostAmount()).thenReturn((Object)new KualiDecimal(6000.0));
        Mockito.when((Object)awardMock1.getAwardIndirectCostAmount()).thenReturn((Object)new KualiDecimal(4000.0));
        Mockito.when((Object)awardMock1.getGrantDescriptionCode()).thenReturn((Object)"grantDescriptionCode");
        Mockito.when((Object)awardMock1.getFederalPassThroughAgencyNumber()).thenReturn((Object)"federalPassThroughAgencyNumber");
        Mockito.when((Object)awardMock1.getAgencyAnalystName()).thenReturn((Object)"agencyAnalystName");
        Mockito.when((Object)awardMock1.getAnalystTelephoneNumber()).thenReturn((Object)"analystTelephoneNumber");
        Mockito.when((Object)awardMock1.getAwardProjectTitle()).thenReturn((Object)"awardProjectTitle");
        Mockito.when((Object)awardMock1.getAwardPurposeCode()).thenReturn((Object)"awardPurposeCode");
        Mockito.when((Object)awardMock1.getBillingFrequencyCode()).thenReturn((Object)"billingFrequencyCode");
        Mockito.when((Object)awardMock1.getMinInvoiceAmount()).thenReturn((Object)new KualiDecimal(50.0));
        Mockito.when((Object)awardMock1.getInstrumentTypeCode()).thenReturn((Object)"instrumentTypeCode");
        Mockito.when((Object)awardMock1.getFundingExpirationDate()).thenReturn((Object)new Date(TOMORROW.toDate().getTime()));
        Mockito.when((Object)awardMock1.getAdditionalFormsDescription()).thenReturn((Object)"additionalFormsDescription");
        Mockito.when((Object)awardMock1.isExcludedFromInvoicing()).thenReturn((Object)false);
        Mockito.when((Object)fundManagerMock.getName()).thenReturn((Object)"primaryFundManager.name");
        Mockito.when((Object)fundManagerMock.getEmailAddress()).thenReturn((Object)"primaryFundManager.email");
        Mockito.when((Object)fundManagerMock.getPhoneNumber()).thenReturn((Object)"primaryFundManager.phone");
        Mockito.when((Object)primaryFundManagerMock.getFundManager()).thenReturn((Object)fundManagerMock);
        Mockito.when((Object)awardMock1.getAwardPrimaryFundManager()).thenReturn((Object)primaryFundManagerMock);
        Mockito.when((Object)proposalMock.getGrantNumber()).thenReturn((Object)"grantNumber");
        Mockito.when((Object)awardMock1.getProposal()).thenReturn((Object)proposalMock);
        ContractsAndGrantsBillingAwardAccount awardAccountMock = (ContractsAndGrantsBillingAwardAccount)awardMock1.getActiveAwardAccounts().get(0);
        Mockito.when((Object)contractControlAccountMock.getAccountNumber()).thenReturn((Object)"1000000");
        Mockito.when((Object)accountMock.getContractControlAccount()).thenReturn((Object)contractControlAccountMock);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAward()).thenReturn((Object)awardMock1);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeaderMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountingPeriod()).thenReturn((Object)accountingPeriodMock);
        Mockito.when((Object)workflowDocumentMock.getDateCreated()).thenReturn((Object)YESTERDAY);
        Mockito.when((Object)workflowDocumentMock.getDateApproved()).thenReturn((Object)TODAY);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)customerMock.getCustomerName()).thenReturn((Object)"jane doe");
        Mockito.when((Object)customerAddressMock.getCustomerLine1StreetAddress()).thenReturn((Object)"123 Main St.");
        Mockito.when((Object)customerAddressMock.getCustomerCityName()).thenReturn((Object)"New York");
        Mockito.when((Object)customerAddressMock.getCustomerStateCode()).thenReturn((Object)"NY");
        Mockito.when((Object)customerAddressMock.getCustomerZipCode()).thenReturn((Object)"10001");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getCustomerAddress()).thenReturn((Object)customerAddressMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getCustomer()).thenReturn((Object)customerMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingAddressName()).thenReturn((Object)"NSF");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingLine1StreetAddress()).thenReturn((Object)"1234 Main Street");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingLine2StreetAddress()).thenReturn((Object)"Box 2");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingCityName()).thenReturn((Object)"Buffalo");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingStateCode()).thenReturn((Object)"NY");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingZipCode()).thenReturn((Object)"14202");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(ArgumentMatchers.anyMap())).thenReturn(Collections.singletonList(contractsGrantsInvoiceDocumentMock));
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(ContractsGrantsInvoiceDocument.class), ArgumentMatchers.anyMap())).thenReturn(Collections.singletonList(contractsGrantsInvoiceDocumentMock));
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(Bill.class), ArgumentMatchers.anyMap())).thenReturn(List.of());
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(Milestone.class), ArgumentMatchers.anyMap())).thenReturn(List.of());
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.calculateAppliedPaymentAmount((CustomerInvoiceDocument)contractsGrantsInvoiceDocumentMock)).thenReturn((Object)new KualiDecimal(500.0));
        Mockito.when((Object)sysInfoMock.getUniversityFederalEmployerIdentificationNumber()).thenReturn((Object)"10-123456789");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToAddressName()).thenReturn((Object)"Kuali University");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToLine1StreetAddress()).thenReturn((Object)"1 Main St");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToLine2StreetAddress()).thenReturn((Object)"PO Box 1");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToCityName()).thenReturn((Object)"Lehi");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToStateCode()).thenReturn((Object)"UT");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToZipCode()).thenReturn((Object)"84005");
        Mockito.when((Object)((SystemInformation)this.businessObjectSvcMock.findByPrimaryKey((Class)ArgumentMatchers.eq(SystemInformation.class), ArgumentMatchers.anyMap()))).thenReturn((Object)sysInfoMock);
        Map templateParameterList = this.cut.getTemplateParameterList(contractsGrantsInvoiceDocumentMock);
        ContractsGrantsInvoiceDocumentServiceImplTest.validateCommonFields(templateParameterList);
        ContractsGrantsInvoiceDocumentServiceImplTest.validateCostReimbursableFields(templateParameterList);
        Assertions.assertEquals((int)113, (int)templateParameterList.size());
    }

    private static void setupCostReimbursableMockingForTemplateTest(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetailMock, CostCategory costCategoryMock, ContractsGrantsInvoiceDetail directCostInvoiceDetailMock, ContractsGrantsInvoiceDetail indirectCostInvoiceDetailMock, ContractsGrantsInvoiceDetail totalCostInvoiceDetailMock) {
        Mockito.when((Object)costCategoryMock.getCategoryName()).thenReturn((Object)"category");
        Mockito.when((Object)contractsGrantsInvoiceDetailMock.getCostCategory()).thenReturn((Object)costCategoryMock);
        Mockito.when((Object)contractsGrantsInvoiceDetailMock.getTotalBudget()).thenReturn((Object)new KualiDecimal(10000.0));
        Mockito.when((Object)contractsGrantsInvoiceDetailMock.getInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)contractsGrantsInvoiceDetailMock.getCumulativeExpenditures()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)contractsGrantsInvoiceDetailMock.getBudgetRemaining()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)contractsGrantsInvoiceDetailMock.getTotalPreviouslyBilled()).thenReturn((Object)new KualiDecimal(4900.0));
        Mockito.when((Object)contractsGrantsInvoiceDetailMock.getTotalAmountBilledToDate()).thenReturn((Object)new KualiDecimal(5100.0));
        Mockito.when((Object)contractsGrantsInvoiceDetailMock.getAmountRemainingToBill()).thenReturn((Object)new KualiDecimal(5100.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDirectCostInvoiceDetails()).thenReturn(Collections.singletonList(contractsGrantsInvoiceDetailMock));
        Mockito.when((Object)directCostInvoiceDetailMock.getTotalBudget()).thenReturn((Object)new KualiDecimal(6000.0));
        Mockito.when((Object)directCostInvoiceDetailMock.getInvoiceAmount()).thenReturn((Object)new KualiDecimal(60.0));
        Mockito.when((Object)directCostInvoiceDetailMock.getCumulativeExpenditures()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)directCostInvoiceDetailMock.getBudgetRemaining()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)directCostInvoiceDetailMock.getTotalPreviouslyBilled()).thenReturn((Object)new KualiDecimal(2900.0));
        Mockito.when((Object)directCostInvoiceDetailMock.getTotalAmountBilledToDate()).thenReturn((Object)new KualiDecimal(3100.0));
        Mockito.when((Object)directCostInvoiceDetailMock.getAmountRemainingToBill()).thenReturn((Object)new KualiDecimal(3100.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalDirectCostInvoiceDetail()).thenReturn((Object)directCostInvoiceDetailMock);
        Mockito.when((Object)indirectCostInvoiceDetailMock.getTotalBudget()).thenReturn((Object)new KualiDecimal(4000.0));
        Mockito.when((Object)indirectCostInvoiceDetailMock.getInvoiceAmount()).thenReturn((Object)new KualiDecimal(40.0));
        Mockito.when((Object)indirectCostInvoiceDetailMock.getCumulativeExpenditures()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)indirectCostInvoiceDetailMock.getBudgetRemaining()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)indirectCostInvoiceDetailMock.getTotalPreviouslyBilled()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)indirectCostInvoiceDetailMock.getTotalAmountBilledToDate()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)indirectCostInvoiceDetailMock.getAmountRemainingToBill()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalIndirectCostInvoiceDetail()).thenReturn((Object)indirectCostInvoiceDetailMock);
        Mockito.when((Object)totalCostInvoiceDetailMock.getTotalBudget()).thenReturn((Object)new KualiDecimal(10000.0));
        Mockito.when((Object)totalCostInvoiceDetailMock.getInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)totalCostInvoiceDetailMock.getCumulativeExpenditures()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)totalCostInvoiceDetailMock.getBudgetRemaining()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)totalCostInvoiceDetailMock.getTotalPreviouslyBilled()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)totalCostInvoiceDetailMock.getTotalAmountBilledToDate()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)totalCostInvoiceDetailMock.getAmountRemainingToBill()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)totalCostInvoiceDetailMock);
    }

    private static void validateCommonFields(Map<String, String> templateParameterList) {
        Assertions.assertEquals((Object)"1", (Object)templateParameterList.get("documentNumber"));
        Assertions.assertEquals((Object)YESTERDAY_FORMATTED, (Object)templateParameterList.get("date"));
        Assertions.assertEquals((Object)TODAY_FORMATTED, (Object)templateParameterList.get("finalStatusDate"));
        Assertions.assertEquals((Object)"11", (Object)templateParameterList.get("proposalNumber"));
        Assertions.assertEquals((Object)"2011-05-02 - 2012-04-30", (Object)templateParameterList.get("invoiceGeneralDetail.awardDateRange"));
        Assertions.assertEquals((Object)"MNTH", (Object)templateParameterList.get("invoiceGeneralDetail.billingFrequencyCode"));
        Assertions.assertEquals((Object)"Yes", (Object)templateParameterList.get("invoiceGeneralDetail.finalBillIndicator"));
        Assertions.assertEquals((Object)"2011-06-01 to 2011-07-01", (Object)templateParameterList.get("invoiceGeneralDetail.billingPeriod"));
        Assertions.assertEquals((Object)"$12,000.00", (Object)templateParameterList.get("invoiceGeneralDetail.awardTotal"));
        Assertions.assertEquals((Object)"$1,000.00", (Object)templateParameterList.get("totalAmountDue"));
        Assertions.assertEquals((Object)"$11,000.00", (Object)templateParameterList.get("invoiceGeneralDetail.amountRemainingToBill"));
        Assertions.assertEquals((Object)"$1,000.00", (Object)templateParameterList.get("invoiceGeneralDetail.totalPreviouslyBilled"));
        Assertions.assertEquals((Object)"$1,000.00", (Object)templateParameterList.get("invoiceGeneralDetail.costShareAmount"));
        Assertions.assertEquals((Object)TODAY_FORMATTED, (Object)templateParameterList.get("invoiceGeneralDetail.lastBilledDate"));
        Assertions.assertEquals((Object)"9000000", (Object)templateParameterList.get("accountDetails[0].accountNumber"));
        Assertions.assertEquals((Object)"80072", (Object)templateParameterList.get("accountDetails[0].proposalNumber"));
        Assertions.assertEquals((Object)"IN", (Object)templateParameterList.get("accountDetails[0].chartOfAccountsCode"));
        Assertions.assertEquals((Object)"$300.00", (Object)templateParameterList.get("accountDetails[0].totalBudget"));
        Assertions.assertEquals((Object)"$0.00", (Object)templateParameterList.get("accountDetails[0].invoiceAmount"));
        Assertions.assertEquals((Object)"$300.00", (Object)templateParameterList.get("accountDetails[0].budgetRemaining"));
        Assertions.assertEquals((Object)"9000001", (Object)templateParameterList.get("accountDetails[1].accountNumber"));
        Assertions.assertEquals((Object)"80072", (Object)templateParameterList.get("accountDetails[1].proposalNumber"));
        Assertions.assertEquals((Object)"IN", (Object)templateParameterList.get("accountDetails[1].chartOfAccountsCode"));
        Assertions.assertEquals((Object)"$120.00", (Object)templateParameterList.get("accountDetails[1].totalBudget"));
        Assertions.assertEquals((Object)"$0.00", (Object)templateParameterList.get("accountDetails[1].invoiceAmount"));
        Assertions.assertEquals((Object)"$120.00", (Object)templateParameterList.get("accountDetails[1].budgetRemaining"));
        Assertions.assertEquals((Object)"No", (Object)templateParameterList.get("advanceFlag"));
        Assertions.assertEquals((Object)"Yes", (Object)templateParameterList.get("reimbursementFlag"));
        Assertions.assertEquals((Object)"1000000", (Object)templateParameterList.get("accountDetails.contractControlAccountNumber"));
        Assertions.assertEquals((Object)"NSF", (Object)templateParameterList.get("payee.name"));
        Assertions.assertEquals((Object)"1234 Main Street", (Object)templateParameterList.get("payee.addressLine1"));
        Assertions.assertEquals((Object)"Box 2", (Object)templateParameterList.get("payee.addressLine2"));
        Assertions.assertEquals((Object)"Buffalo", (Object)templateParameterList.get("payee.city"));
        Assertions.assertEquals((Object)"NY", (Object)templateParameterList.get("payee.state"));
        Assertions.assertEquals((Object)"14202", (Object)templateParameterList.get("payee.zipcode"));
        Assertions.assertEquals((Object)"10-123456789", (Object)templateParameterList.get("systemInformation.feinNumber"));
        Assertions.assertEquals((Object)"Kuali University", (Object)templateParameterList.get("systemInformation.name"));
        Assertions.assertEquals((Object)"1 Main St", (Object)templateParameterList.get("systemInformation.addressLine1"));
        Assertions.assertEquals((Object)"PO Box 1", (Object)templateParameterList.get("systemInformation.addressLine2"));
        Assertions.assertEquals((Object)"Lehi", (Object)templateParameterList.get("systemInformation.city"));
        Assertions.assertEquals((Object)"UT", (Object)templateParameterList.get("systemInformation.state"));
        Assertions.assertEquals((Object)"84005", (Object)templateParameterList.get("systemInformation.zipcode"));
        Assertions.assertEquals((Object)"jane doe", (Object)templateParameterList.get("customer.customerName"));
        Assertions.assertEquals((Object)"123 Main St.\nNew York, NY 10001", (Object)templateParameterList.get("customer.fullAddress"));
        Assertions.assertEquals((Object)"11", (Object)templateParameterList.get("award.proposalNumber"));
        Assertions.assertEquals((Object)"05/02/2011", (Object)templateParameterList.get("award.awardBeginningDate"));
        Assertions.assertEquals((Object)"04/30/2012", (Object)templateParameterList.get("award.awardEndingDate"));
        Assertions.assertEquals((Object)"$10,000.00", (Object)templateParameterList.get("award.awardTotalAmount"));
        Assertions.assertEquals((Object)"awardAddendumNumber", (Object)templateParameterList.get("award.awardAddendumNumber"));
        Assertions.assertEquals((Object)"$2,000.00", (Object)templateParameterList.get("award.awardAllocatedUniversityComputingServicesAmount"));
        Assertions.assertEquals((Object)"$2,000.00", (Object)templateParameterList.get("award.federalPassThroughFundedAmount"));
        Assertions.assertEquals((Object)TODAY_FORMATTED, (Object)templateParameterList.get("award.awardEntryDate"));
        Assertions.assertEquals((Object)"$1,000.00", (Object)templateParameterList.get("award.agencyFuture1Amount"));
        Assertions.assertEquals((Object)"$2,000.00", (Object)templateParameterList.get("award.agencyFuture2Amount"));
        Assertions.assertEquals((Object)"$3,000.00", (Object)templateParameterList.get("award.agencyFuture3Amount"));
        Assertions.assertEquals((Object)"awardDocumentNumber", (Object)templateParameterList.get("award.awardDocumentNumber"));
        Assertions.assertEquals((Object)"Yes", (Object)templateParameterList.get("award.federalPassThroughIndicator"));
        Assertions.assertEquals((Object)"$6,000.00", (Object)templateParameterList.get("award.awardDirectCostAmount"));
        Assertions.assertEquals((Object)"$4,000.00", (Object)templateParameterList.get("award.awardIndirectCostAmount"));
        Assertions.assertEquals((Object)"grantDescriptionCode", (Object)templateParameterList.get("award.grantDescriptionCode"));
        Assertions.assertEquals((Object)"grantNumber", (Object)templateParameterList.get("award.grantNumber"));
        Assertions.assertEquals((Object)"11505", (Object)templateParameterList.get("agencyNumber"));
        Assertions.assertEquals((Object)"U.S. AIR FORCE", (Object)templateParameterList.get("agency.fullName"));
        Assertions.assertEquals((Object)"federalPassThroughAgencyNumber", (Object)templateParameterList.get("award.federalPassThroughAgencyNumber"));
        Assertions.assertEquals((Object)"agencyAnalystName", (Object)templateParameterList.get("award.agencyAnalystName"));
        Assertions.assertEquals((Object)"analystTelephoneNumber", (Object)templateParameterList.get("award.analystTelephoneNumber"));
        Assertions.assertEquals((Object)"awardProjectTitle", (Object)templateParameterList.get("award.awardProjectTitle"));
        Assertions.assertEquals((Object)"awardPurposeCode", (Object)templateParameterList.get("award.awardPurposeCode"));
        Assertions.assertEquals((Object)"Yes", (Object)templateParameterList.get("award.active"));
        Assertions.assertEquals((Object)"billingFrequencyCode", (Object)templateParameterList.get("award.billingFrequencyCode"));
        Assertions.assertEquals((Object)"$50.00", (Object)templateParameterList.get("award.minInvoiceAmount"));
        Assertions.assertEquals((Object)"Yes", (Object)templateParameterList.get("award.autoApprove"));
        Assertions.assertEquals((Object)"instrumentTypeCode", (Object)templateParameterList.get("award.instrumentTypeCode"));
        Assertions.assertEquals((Object)TOMORROW_FORMATTED, (Object)templateParameterList.get("award.fundingExpirationDate"));
        Assertions.assertEquals((Object)"No", (Object)templateParameterList.get("award.additionalFormsRequired"));
        Assertions.assertEquals((Object)"additionalFormsDescription", (Object)templateParameterList.get("award.additionalFormsDescription"));
        Assertions.assertEquals((Object)"No", (Object)templateParameterList.get("award.excludedFromInvoicing"));
        Assertions.assertEquals((Object)"primaryFundManager.name", (Object)templateParameterList.get("award.primaryFundManager.name"));
        Assertions.assertEquals((Object)"primaryFundManager.email", (Object)templateParameterList.get("award.primaryFundManager.email"));
        Assertions.assertEquals((Object)"primaryFundManager.phone", (Object)templateParameterList.get("award.primaryFundManager.phone"));
        Assertions.assertEquals((Object)"$1,000.00", (Object)templateParameterList.get("award.billings"));
        Assertions.assertEquals((Object)"$500.00", (Object)templateParameterList.get("award.payments"));
        Assertions.assertEquals((Object)"$500.00", (Object)templateParameterList.get("award.receivables"));
    }

    private static void validateCostReimbursableFields(Map<String, String> templateParameterList) {
        Assertions.assertEquals((Object)"category", (Object)templateParameterList.get("invoiceDetail[0].category"));
        Assertions.assertEquals((Object)"$10,000.00", (Object)templateParameterList.get("invoiceDetail[0].totalBudget"));
        Assertions.assertEquals((Object)"$100.00", (Object)templateParameterList.get("invoiceDetail[0].invoiceAmount"));
        Assertions.assertEquals((Object)"$5,000.00", (Object)templateParameterList.get("invoiceDetail[0].cumulativeExpenditures"));
        Assertions.assertEquals((Object)"$5,000.00", (Object)templateParameterList.get("invoiceDetail[0].budgetRemaining"));
        Assertions.assertEquals((Object)"$4,900.00", (Object)templateParameterList.get("invoiceDetail[0].totalPreviouslyBilled"));
        Assertions.assertEquals((Object)"$5,100.00", (Object)templateParameterList.get("invoiceDetail[0].totalAmountBilledToDate"));
        Assertions.assertEquals((Object)"$5,100.00", (Object)templateParameterList.get("invoiceDetail[0].amountRemainingToBill"));
        Assertions.assertEquals((Object)"$6,000.00", (Object)templateParameterList.get("directCostInvoiceDetail.totalBudget"));
        Assertions.assertEquals((Object)"$60.00", (Object)templateParameterList.get("directCostInvoiceDetail.invoiceAmount"));
        Assertions.assertEquals((Object)"$3,000.00", (Object)templateParameterList.get("directCostInvoiceDetail.cumulativeExpenditures"));
        Assertions.assertEquals((Object)"$3,000.00", (Object)templateParameterList.get("directCostInvoiceDetail.budgetRemaining"));
        Assertions.assertEquals((Object)"$2,900.00", (Object)templateParameterList.get("directCostInvoiceDetail.totalPreviouslyBilled"));
        Assertions.assertEquals((Object)"$3,100.00", (Object)templateParameterList.get("directCostInvoiceDetail.totalAmountBilledToDate"));
        Assertions.assertEquals((Object)"$3,100.00", (Object)templateParameterList.get("directCostInvoiceDetail.amountRemainingToBill"));
        Assertions.assertEquals((Object)"$4,000.00", (Object)templateParameterList.get("inDirectCostInvoiceDetail.totalBudget"));
        Assertions.assertEquals((Object)"$40.00", (Object)templateParameterList.get("inDirectCostInvoiceDetail.invoiceAmount"));
        Assertions.assertEquals((Object)"$2,000.00", (Object)templateParameterList.get("inDirectCostInvoiceDetail.cumulativeExpenditures"));
        Assertions.assertEquals((Object)"$2,000.00", (Object)templateParameterList.get("inDirectCostInvoiceDetail.budgetRemaining"));
        Assertions.assertEquals((Object)"$2,000.00", (Object)templateParameterList.get("inDirectCostInvoiceDetail.totalPreviouslyBilled"));
        Assertions.assertEquals((Object)"$2,000.00", (Object)templateParameterList.get("inDirectCostInvoiceDetail.totalAmountBilledToDate"));
        Assertions.assertEquals((Object)"$2,000.00", (Object)templateParameterList.get("inDirectCostInvoiceDetail.amountRemainingToBill"));
        Assertions.assertEquals((Object)"$10,000.00", (Object)templateParameterList.get("totalInvoiceDetail.totalBudget"));
        Assertions.assertEquals((Object)"$100.00", (Object)templateParameterList.get("totalInvoiceDetail.invoiceAmount"));
        Assertions.assertEquals((Object)"$5,000.00", (Object)templateParameterList.get("totalInvoiceDetail.cumulativeExpenditures"));
        Assertions.assertEquals((Object)"$5,000.00", (Object)templateParameterList.get("totalInvoiceDetail.budgetRemaining"));
        Assertions.assertEquals((Object)"$5,000.00", (Object)templateParameterList.get("totalInvoiceDetail.totalPreviouslyBilled"));
        Assertions.assertEquals((Object)"$5,000.00", (Object)templateParameterList.get("totalInvoiceDetail.totalAmountBilledToDate"));
        Assertions.assertEquals((Object)"$5,000.00", (Object)templateParameterList.get("totalInvoiceDetail.amountRemainingToBill"));
    }

    @Test
    void getTemplateParameterList_Milestone(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2, @Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager primaryFundManagerMock, @Mock(stubOnly=true) Person fundManagerMock, @Mock(stubOnly=true) ContractAndGrantsProposal proposalMock, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account contractControlAccountMock, @Mock(stubOnly=true) AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock, @Mock(stubOnly=true) Customer customerMock, @Mock(stubOnly=true) CustomerAddress customerAddressMock, @Mock(stubOnly=true) SystemInformation sysInfoMock, @Mock(stubOnly=true) InvoiceMilestone invoiceMilestoneMock1, @Mock(stubOnly=true) InvoiceMilestone invoiceMilestoneMock2) {
        ((DateTimeService)Mockito.doReturn((Object)TODAY_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(TODAY.toDate());
        ((DateTimeService)Mockito.doReturn((Object)YESTERDAY_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(YESTERDAY.toDate());
        ((DateTimeService)Mockito.doReturn((Object)TOMORROW_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(TOMORROW.toDate());
        String proposalNumber = "11";
        Date lastBilledDate = Date.valueOf("2011-10-01");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.isFinalBillIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getLastBilledDate()).thenReturn((Object)lastBilledDate);
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        ((InvoiceGeneralDetail)Mockito.doReturn((Object)this.contractsAndGrantsModuleBillingSvcMock).when((Object)this.invoiceGeneralDetailSpy)).getContractsAndGrantsModuleBillingService();
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getLastBilledDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAwardDateRange()).thenReturn((Object)"2011-05-02 - 2012-04-30");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingPeriod()).thenReturn((Object)"2011-06-01 to 2011-07-01");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getInstrumentTypeCode()).thenReturn((Object)"GTCS");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAwardTotal()).thenReturn((Object)new KualiDecimal(12000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAmountRemainingToBill()).thenReturn((Object)new KualiDecimal(11000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getTotalPreviouslyBilled()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getCostShareAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-10-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardDirectCostAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getAwardIndirectCostAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getMinInvoiceAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)false);
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardMock.getAutoApproveIndicator()).thenReturn((Object)true);
        Mockito.when((Object)agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)agencyMock.getFullName()).thenReturn((Object)"U.S. AIR FORCE");
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)agencyMock);
        String agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        Date awardBeginningDate = Date.valueOf("2011-05-02");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)awardBeginningDate);
        ((DateTimeService)Mockito.doReturn((Object)"05/02/2011").when((Object)this.dateTimeServiceMock)).toDateString((java.util.Date)awardBeginningDate);
        Date awardEndingDate = Date.valueOf("2012-04-30");
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)awardEndingDate);
        ((DateTimeService)Mockito.doReturn((Object)"04/30/2012").when((Object)this.dateTimeServiceMock)).toDateString((java.util.Date)awardEndingDate);
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        Mockito.when((Object)awardMock.getAwardAddendumNumber()).thenReturn((Object)"awardAddendumNumber");
        Mockito.when((Object)awardMock.getAwardAllocatedUniversityComputingServicesAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock.getFederalPassThroughFundedAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock.getAwardEntryDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)awardMock.getAgencyFuture1Amount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)awardMock.getAgencyFuture2Amount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock.getAgencyFuture3Amount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)awardMock.getAwardDocumentNumber()).thenReturn((Object)"awardDocumentNumber");
        Mockito.when((Object)awardMock.getFederalPassThroughIndicator()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getAwardDirectCostAmount()).thenReturn((Object)new KualiDecimal(6000.0));
        Mockito.when((Object)awardMock.getAwardIndirectCostAmount()).thenReturn((Object)new KualiDecimal(4000.0));
        Mockito.when((Object)awardMock.getGrantDescriptionCode()).thenReturn((Object)"grantDescriptionCode");
        Mockito.when((Object)awardMock.getFederalPassThroughAgencyNumber()).thenReturn((Object)"federalPassThroughAgencyNumber");
        Mockito.when((Object)awardMock.getAgencyAnalystName()).thenReturn((Object)"agencyAnalystName");
        Mockito.when((Object)awardMock.getAnalystTelephoneNumber()).thenReturn((Object)"analystTelephoneNumber");
        Mockito.when((Object)awardMock.getAwardProjectTitle()).thenReturn((Object)"awardProjectTitle");
        Mockito.when((Object)awardMock.getAwardPurposeCode()).thenReturn((Object)"awardPurposeCode");
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)"billingFrequencyCode");
        Mockito.when((Object)awardMock.getMinInvoiceAmount()).thenReturn((Object)new KualiDecimal(50.0));
        Mockito.when((Object)awardMock.getInstrumentTypeCode()).thenReturn((Object)"instrumentTypeCode");
        Mockito.when((Object)awardMock.getFundingExpirationDate()).thenReturn((Object)new Date(TOMORROW.toDate().getTime()));
        Mockito.when((Object)awardMock.getAdditionalFormsDescription()).thenReturn((Object)"additionalFormsDescription");
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)false);
        Mockito.when((Object)fundManagerMock.getName()).thenReturn((Object)"primaryFundManager.name");
        Mockito.when((Object)fundManagerMock.getEmailAddress()).thenReturn((Object)"primaryFundManager.email");
        Mockito.when((Object)fundManagerMock.getPhoneNumber()).thenReturn((Object)"primaryFundManager.phone");
        Mockito.when((Object)primaryFundManagerMock.getFundManager()).thenReturn((Object)fundManagerMock);
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)primaryFundManagerMock);
        Mockito.when((Object)proposalMock.getGrantNumber()).thenReturn((Object)"grantNumber");
        Mockito.when((Object)awardMock.getProposal()).thenReturn((Object)proposalMock);
        ContractsAndGrantsBillingAwardAccount awardAccountMock = (ContractsAndGrantsBillingAwardAccount)awardMock.getActiveAwardAccounts().get(0);
        Mockito.when((Object)contractControlAccountMock.getAccountNumber()).thenReturn((Object)"1000000");
        Mockito.when((Object)accountMock.getContractControlAccount()).thenReturn((Object)contractControlAccountMock);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeaderMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountingPeriod()).thenReturn((Object)accountingPeriodMock);
        Mockito.when((Object)workflowDocumentMock.getDateCreated()).thenReturn((Object)YESTERDAY);
        Mockito.when((Object)workflowDocumentMock.getDateApproved()).thenReturn((Object)TODAY);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)customerMock.getCustomerName()).thenReturn((Object)"jane doe");
        Mockito.when((Object)customerAddressMock.getCustomerLine1StreetAddress()).thenReturn((Object)"123 Main St.");
        Mockito.when((Object)customerAddressMock.getCustomerCityName()).thenReturn((Object)"New York");
        Mockito.when((Object)customerAddressMock.getCustomerStateCode()).thenReturn((Object)"NY");
        Mockito.when((Object)customerAddressMock.getCustomerZipCode()).thenReturn((Object)"10001");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getCustomerAddress()).thenReturn((Object)customerAddressMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getCustomer()).thenReturn((Object)customerMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingAddressName()).thenReturn((Object)"NSF");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingLine1StreetAddress()).thenReturn((Object)"1234 Main Street");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingLine2StreetAddress()).thenReturn((Object)"Box 2");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingCityName()).thenReturn((Object)"Buffalo");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingStateCode()).thenReturn((Object)"NY");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingZipCode()).thenReturn((Object)"14202");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(ArgumentMatchers.anyMap())).thenReturn(Collections.singletonList(contractsGrantsInvoiceDocumentMock));
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(ContractsGrantsInvoiceDocument.class), ArgumentMatchers.anyMap())).thenReturn(Collections.singletonList(contractsGrantsInvoiceDocumentMock));
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(Bill.class), ArgumentMatchers.anyMap())).thenReturn(List.of());
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(Milestone.class), ArgumentMatchers.anyMap())).thenReturn(List.of());
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.calculateAppliedPaymentAmount((CustomerInvoiceDocument)contractsGrantsInvoiceDocumentMock)).thenReturn((Object)new KualiDecimal(500.0));
        Mockito.when((Object)sysInfoMock.getUniversityFederalEmployerIdentificationNumber()).thenReturn((Object)"10-123456789");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToAddressName()).thenReturn((Object)"Kuali University");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToLine1StreetAddress()).thenReturn((Object)"1 Main St");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToLine2StreetAddress()).thenReturn((Object)"PO Box 1");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToCityName()).thenReturn((Object)"Lehi");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToStateCode()).thenReturn((Object)"UT");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToZipCode()).thenReturn((Object)"84005");
        Mockito.when((Object)((SystemInformation)this.businessObjectSvcMock.findByPrimaryKey((Class)ArgumentMatchers.eq(SystemInformation.class), ArgumentMatchers.anyMap()))).thenReturn((Object)sysInfoMock);
        ContractsGrantsInvoiceDocumentServiceImplTest.setupMilestoneMockingForTemplateTest(contractsGrantsInvoiceDocumentMock, invoiceMilestoneMock1, invoiceMilestoneMock2);
        Map templateParameterList = this.cut.getTemplateParameterList(contractsGrantsInvoiceDocumentMock);
        ContractsGrantsInvoiceDocumentServiceImplTest.validateCommonFields(templateParameterList);
        ContractsGrantsInvoiceDocumentServiceImplTest.validateMilestoneFields(templateParameterList);
        Assertions.assertEquals((int)99, (int)templateParameterList.size());
    }

    private static void setupMilestoneMockingForTemplateTest(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, InvoiceMilestone invoiceMilestoneMock0, InvoiceMilestone invoiceMilestoneMock1) {
        Mockito.when((Object)invoiceMilestoneMock0.getMilestoneNumber()).thenReturn((Object)"milestoneNumber0");
        Mockito.when((Object)invoiceMilestoneMock0.getMilestoneDescription()).thenReturn((Object)"milestoneDescription0");
        Mockito.when((Object)invoiceMilestoneMock0.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(50.0));
        Mockito.when((Object)invoiceMilestoneMock0.getMilestoneActualCompletionDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)invoiceMilestoneMock1.getMilestoneNumber()).thenReturn((Object)"milestoneNumber1");
        Mockito.when((Object)invoiceMilestoneMock1.getMilestoneDescription()).thenReturn((Object)"milestoneDescription1");
        Mockito.when((Object)invoiceMilestoneMock1.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(50.0));
        Mockito.when((Object)invoiceMilestoneMock1.getMilestoneActualCompletionDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceMilestones()).thenReturn(Arrays.asList(invoiceMilestoneMock0, invoiceMilestoneMock1));
    }

    private static void validateMilestoneFields(Map<String, String> templateParameterList) {
        Assertions.assertEquals((Object)"milestoneNumber0", (Object)templateParameterList.get("invoiceMilestones[0].milestoneNumber"));
        Assertions.assertEquals((Object)"milestoneDescription0", (Object)templateParameterList.get("invoiceMilestones[0].milestoneDescription"));
        Assertions.assertEquals((Object)"$50.00", (Object)templateParameterList.get("invoiceMilestones[0].milestoneAmount"));
        Assertions.assertEquals((Object)TODAY_FORMATTED, (Object)templateParameterList.get("invoiceMilestones[0].milestoneActualCompletionDate"));
        Assertions.assertEquals((Object)"milestoneNumber1", (Object)templateParameterList.get("invoiceMilestones[1].milestoneNumber"));
        Assertions.assertEquals((Object)"milestoneDescription1", (Object)templateParameterList.get("invoiceMilestones[1].milestoneDescription"));
        Assertions.assertEquals((Object)"$50.00", (Object)templateParameterList.get("invoiceMilestones[1].milestoneAmount"));
        Assertions.assertEquals((Object)TODAY_FORMATTED, (Object)templateParameterList.get("invoiceMilestones[1].milestoneActualCompletionDate"));
        Assertions.assertEquals((Object)"$1,000.00", (Object)templateParameterList.get("totalAmountDue"));
    }

    @Test
    void getTemplateParameterList_PDBS(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2, @Mock(stubOnly=true) ContractsAndGrantsBillingAgency agencyMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager primaryFundManagerMock, @Mock(stubOnly=true) Person fundManagerMock, @Mock(stubOnly=true) ContractAndGrantsProposal proposalMock, @Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) Account contractControlAccountMock, @Mock(stubOnly=true) AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock, @Mock(stubOnly=true) AccountingPeriod accountingPeriodMock, @Mock(stubOnly=true) DocumentHeader documentHeaderMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock, @Mock(stubOnly=true) Customer customerMock, @Mock(stubOnly=true) CustomerAddress customerAddressMock, @Mock(stubOnly=true) SystemInformation sysInfoMock, @Mock(stubOnly=true) InvoiceBill invoiceBillMock1, @Mock(stubOnly=true) InvoiceBill invoiceBillMock2) {
        ((DateTimeService)Mockito.doReturn((Object)TODAY_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(TODAY.toDate());
        ((DateTimeService)Mockito.doReturn((Object)YESTERDAY_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(YESTERDAY.toDate());
        ((DateTimeService)Mockito.doReturn((Object)TOMORROW_FORMATTED).when((Object)this.dateTimeServiceMock)).toDateString(TOMORROW.toDate());
        String proposalNumber = "11";
        Date lastBilledDate = Date.valueOf("2011-10-01");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.isFinalBillIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getLastBilledDate()).thenReturn((Object)lastBilledDate);
        this.invoiceGeneralDetailSpy.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailSpy);
        InvoiceAccountDetail invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail1);
        accountDetails.add(invoiceAccountDetail2);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)contractsGrantsInvoiceDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        ContractsGrantsInvoiceDocumentServiceImplTest.setupBillMockingForTemplateTest(contractsGrantsInvoiceDocumentMock, invoiceBillMock1, invoiceBillMock2);
        ((InvoiceGeneralDetail)Mockito.doReturn((Object)this.contractsAndGrantsModuleBillingSvcMock).when((Object)this.invoiceGeneralDetailSpy)).getContractsAndGrantsModuleBillingService();
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getLastBilledDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAwardDateRange()).thenReturn((Object)"2011-05-02 - 2012-04-30");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getBillingPeriod()).thenReturn((Object)"2011-06-01 to 2011-07-01");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getInstrumentTypeCode()).thenReturn((Object)"GTCS");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAwardTotal()).thenReturn((Object)new KualiDecimal(12000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAmountRemainingToBill()).thenReturn((Object)new KualiDecimal(11000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getTotalPreviouslyBilled()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getCostShareAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-10-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardDirectCostAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getAwardIndirectCostAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getMinInvoiceAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)false);
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardMock.getAutoApproveIndicator()).thenReturn((Object)true);
        Mockito.when((Object)agencyMock.getAgencyNumber()).thenReturn((Object)"11505");
        Mockito.when((Object)agencyMock.getFullName()).thenReturn((Object)"U.S. AIR FORCE");
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)agencyMock);
        String agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        Date awardBeginningDate = Date.valueOf("2011-05-02");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)awardBeginningDate);
        ((DateTimeService)Mockito.doReturn((Object)"05/02/2011").when((Object)this.dateTimeServiceMock)).toDateString((java.util.Date)awardBeginningDate);
        Date awardEndingDate = Date.valueOf("2012-04-30");
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)awardEndingDate);
        ((DateTimeService)Mockito.doReturn((Object)"04/30/2012").when((Object)this.dateTimeServiceMock)).toDateString((java.util.Date)awardEndingDate);
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(10000.0));
        Mockito.when((Object)awardMock.getAwardAddendumNumber()).thenReturn((Object)"awardAddendumNumber");
        Mockito.when((Object)awardMock.getAwardAllocatedUniversityComputingServicesAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock.getFederalPassThroughFundedAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock.getAwardEntryDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)awardMock.getAgencyFuture1Amount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)awardMock.getAgencyFuture2Amount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)awardMock.getAgencyFuture3Amount()).thenReturn((Object)new KualiDecimal(3000.0));
        Mockito.when((Object)awardMock.getAwardDocumentNumber()).thenReturn((Object)"awardDocumentNumber");
        Mockito.when((Object)awardMock.getFederalPassThroughIndicator()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getAwardDirectCostAmount()).thenReturn((Object)new KualiDecimal(6000.0));
        Mockito.when((Object)awardMock.getAwardIndirectCostAmount()).thenReturn((Object)new KualiDecimal(4000.0));
        Mockito.when((Object)awardMock.getGrantDescriptionCode()).thenReturn((Object)"grantDescriptionCode");
        Mockito.when((Object)awardMock.getFederalPassThroughAgencyNumber()).thenReturn((Object)"federalPassThroughAgencyNumber");
        Mockito.when((Object)awardMock.getAgencyAnalystName()).thenReturn((Object)"agencyAnalystName");
        Mockito.when((Object)awardMock.getAnalystTelephoneNumber()).thenReturn((Object)"analystTelephoneNumber");
        Mockito.when((Object)awardMock.getAwardProjectTitle()).thenReturn((Object)"awardProjectTitle");
        Mockito.when((Object)awardMock.getAwardPurposeCode()).thenReturn((Object)"awardPurposeCode");
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)"billingFrequencyCode");
        Mockito.when((Object)awardMock.getMinInvoiceAmount()).thenReturn((Object)new KualiDecimal(50.0));
        Mockito.when((Object)awardMock.getInstrumentTypeCode()).thenReturn((Object)"instrumentTypeCode");
        Mockito.when((Object)awardMock.getFundingExpirationDate()).thenReturn((Object)new Date(TOMORROW.toDate().getTime()));
        Mockito.when((Object)awardMock.getAdditionalFormsDescription()).thenReturn((Object)"additionalFormsDescription");
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)false);
        Mockito.when((Object)fundManagerMock.getName()).thenReturn((Object)"primaryFundManager.name");
        Mockito.when((Object)fundManagerMock.getEmailAddress()).thenReturn((Object)"primaryFundManager.email");
        Mockito.when((Object)fundManagerMock.getPhoneNumber()).thenReturn((Object)"primaryFundManager.phone");
        Mockito.when((Object)primaryFundManagerMock.getFundManager()).thenReturn((Object)fundManagerMock);
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)primaryFundManagerMock);
        Mockito.when((Object)proposalMock.getGrantNumber()).thenReturn((Object)"grantNumber");
        Mockito.when((Object)awardMock.getProposal()).thenReturn((Object)proposalMock);
        ContractsAndGrantsBillingAwardAccount awardAccountMock = (ContractsAndGrantsBillingAwardAccount)awardMock.getActiveAwardAccounts().get(0);
        Mockito.when((Object)contractControlAccountMock.getAccountNumber()).thenReturn((Object)"1000000");
        Mockito.when((Object)accountMock.getContractControlAccount()).thenReturn((Object)contractControlAccountMock);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeaderMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountingPeriod()).thenReturn((Object)accountingPeriodMock);
        Mockito.when((Object)workflowDocumentMock.getDateCreated()).thenReturn((Object)YESTERDAY);
        Mockito.when((Object)workflowDocumentMock.getDateApproved()).thenReturn((Object)TODAY);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)customerMock.getCustomerName()).thenReturn((Object)"jane doe");
        Mockito.when((Object)customerAddressMock.getCustomerLine1StreetAddress()).thenReturn((Object)"123 Main St.");
        Mockito.when((Object)customerAddressMock.getCustomerCityName()).thenReturn((Object)"New York");
        Mockito.when((Object)customerAddressMock.getCustomerStateCode()).thenReturn((Object)"NY");
        Mockito.when((Object)customerAddressMock.getCustomerZipCode()).thenReturn((Object)"10001");
        Mockito.when((Object)this.invoiceGeneralDetailSpy.getCustomerAddress()).thenReturn((Object)customerAddressMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getCustomer()).thenReturn((Object)customerMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingAddressName()).thenReturn((Object)"NSF");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingLine1StreetAddress()).thenReturn((Object)"1234 Main Street");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingLine2StreetAddress()).thenReturn((Object)"Box 2");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingCityName()).thenReturn((Object)"Buffalo");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingStateCode()).thenReturn((Object)"NY");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingZipCode()).thenReturn((Object)"14202");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(ArgumentMatchers.anyMap())).thenReturn(Collections.singletonList(contractsGrantsInvoiceDocumentMock));
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(ContractsGrantsInvoiceDocument.class), ArgumentMatchers.anyMap())).thenReturn(Collections.singletonList(contractsGrantsInvoiceDocumentMock));
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(Bill.class), ArgumentMatchers.anyMap())).thenReturn(List.of());
        Mockito.when((Object)this.businessObjectSvcMock.findMatching((Class)ArgumentMatchers.eq(Milestone.class), ArgumentMatchers.anyMap())).thenReturn(List.of());
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.calculateAppliedPaymentAmount((CustomerInvoiceDocument)contractsGrantsInvoiceDocumentMock)).thenReturn((Object)new KualiDecimal(500.0));
        Mockito.when((Object)sysInfoMock.getUniversityFederalEmployerIdentificationNumber()).thenReturn((Object)"10-123456789");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToAddressName()).thenReturn((Object)"Kuali University");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToLine1StreetAddress()).thenReturn((Object)"1 Main St");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToLine2StreetAddress()).thenReturn((Object)"PO Box 1");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToCityName()).thenReturn((Object)"Lehi");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToStateCode()).thenReturn((Object)"UT");
        Mockito.when((Object)sysInfoMock.getOrganizationRemitToZipCode()).thenReturn((Object)"84005");
        Mockito.when((Object)((SystemInformation)this.businessObjectSvcMock.findByPrimaryKey((Class)ArgumentMatchers.eq(SystemInformation.class), ArgumentMatchers.anyMap()))).thenReturn((Object)sysInfoMock);
        Map templateParameterList = this.cut.getTemplateParameterList(contractsGrantsInvoiceDocumentMock);
        ContractsGrantsInvoiceDocumentServiceImplTest.validateCommonFields(templateParameterList);
        ContractsGrantsInvoiceDocumentServiceImplTest.validateBillFields(templateParameterList);
        Assertions.assertEquals((int)99, (int)templateParameterList.size());
    }

    private static void setupBillMockingForTemplateTest(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, InvoiceBill invoiceBillMock0, InvoiceBill invoiceBillMock1) {
        Mockito.when((Object)invoiceBillMock0.getBillNumber()).thenReturn((Object)"billNumber0");
        Mockito.when((Object)invoiceBillMock0.getBillDescription()).thenReturn((Object)"billDescription0");
        Mockito.when((Object)invoiceBillMock0.getBillDate()).thenReturn((Object)new Date(YESTERDAY.toDate().getTime()));
        Mockito.when((Object)invoiceBillMock0.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(50.0));
        Mockito.when((Object)invoiceBillMock1.getBillNumber()).thenReturn((Object)"billNumber1");
        Mockito.when((Object)invoiceBillMock1.getBillDescription()).thenReturn((Object)"billDescription1");
        Mockito.when((Object)invoiceBillMock1.getBillDate()).thenReturn((Object)new Date(TODAY.toDate().getTime()));
        Mockito.when((Object)invoiceBillMock1.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(75.0));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceBills()).thenReturn(Arrays.asList(invoiceBillMock0, invoiceBillMock1));
    }

    private static void validateBillFields(Map<String, String> templateParameterList) {
        Assertions.assertEquals((Object)"billNumber0", (Object)templateParameterList.get("invoiceBills[0].billNumber"));
        Assertions.assertEquals((Object)"billDescription0", (Object)templateParameterList.get("invoiceBills[0].billDescription"));
        Assertions.assertEquals((Object)YESTERDAY_FORMATTED, (Object)templateParameterList.get("invoiceBills[0].billDate"));
        Assertions.assertEquals((Object)"$50.00", (Object)templateParameterList.get("invoiceBills[0].estimatedAmount"));
        Assertions.assertEquals((Object)"billNumber1", (Object)templateParameterList.get("invoiceBills[1].billNumber"));
        Assertions.assertEquals((Object)"billDescription1", (Object)templateParameterList.get("invoiceBills[1].billDescription"));
        Assertions.assertEquals((Object)TODAY_FORMATTED, (Object)templateParameterList.get("invoiceBills[1].billDate"));
        Assertions.assertEquals((Object)"$75.00", (Object)templateParameterList.get("invoiceBills[1].estimatedAmount"));
    }
}

