/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.coa.service.ProjectCodeService;
import org.kuali.kfs.coa.service.SubAccountService;
import org.kuali.kfs.coa.service.SubObjectCodeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.module.ar.document.service.impl.PaymentApplicationAdjustmentDocumentService;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class PaymentApplicationAdjustmentDocumentServiceTest {
    @Mock(stubOnly=true)
    private PaymentApplicationAdjustmentDocument appaDocMock;
    @Mock(stubOnly=true)
    private AccountService accountServiceMock;
    @Mock
    private BusinessObjectService businessObjectServiceMock;
    @Mock(stubOnly=true)
    private ChartService chartServiceMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceDetailService customerInvoiceDetailServiceMock;
    @Mock(stubOnly=true)
    private CustomerInvoiceDocumentService customerInvoiceDocumentServiceMock;
    @Mock(stubOnly=true)
    private DataDictionaryService dataDictionaryServiceMock;
    @Mock
    private DocumentService documentServiceMock;
    @Mock(stubOnly=true)
    private FinancialSystemUserService financialSystemUserServiceMock;
    @Mock(stubOnly=true)
    private GeneralLedgerPendingEntryService generalLedgerPendingEntryServiceMock;
    @Mock
    private NoteService noteServiceMock;
    @Mock(stubOnly=true)
    private ObjectCodeService objectCodeServiceMock;
    @Mock(stubOnly=true)
    private OffsetDefinitionService offsetDefinitionServiceMock;
    @Mock(stubOnly=true)
    private ProjectCodeService projectCodeServiceMock;
    @Mock(stubOnly=true)
    private SubAccountService subAccountServiceMock;
    @Mock(stubOnly=true)
    private SubObjectCodeService subObjectCodeServiceMock;
    @Mock(stubOnly=true)
    private SystemInformationService systemInformationServiceMock;
    @Mock
    private UniversityDateService universityDateServiceMock;
    private PaymentApplicationAdjustmentDocumentService cut;

    PaymentApplicationAdjustmentDocumentServiceTest() {
    }

    @BeforeEach
    void setup() {
        this.cut = new PaymentApplicationAdjustmentDocumentService(this.accountServiceMock, this.businessObjectServiceMock, this.chartServiceMock, this.customerInvoiceDetailServiceMock, this.customerInvoiceDocumentServiceMock, this.dataDictionaryServiceMock, this.documentServiceMock, this.financialSystemUserServiceMock, this.generalLedgerPendingEntryServiceMock, this.noteServiceMock, this.objectCodeServiceMock, this.offsetDefinitionServiceMock, this.projectCodeServiceMock, this.subAccountServiceMock, this.subObjectCodeServiceMock, this.systemInformationServiceMock, this.universityDateServiceMock);
    }

    @ParameterizedTest
    @MethodSource(value={"constructionInvalidArgs"})
    void construction_invalid(AccountService accountService, BusinessObjectService businessObjectService, ChartService chartService, CustomerInvoiceDetailService customerInvoiceDetailService, CustomerInvoiceDocumentService customerInvoiceDocumentService, DataDictionaryService dataDictionaryService, DocumentService documentService, FinancialSystemUserService financialSystemUserService, GeneralLedgerPendingEntryService generalLedgerPendingEntryService, NoteService noteService, ObjectCodeService objectCodeService, OffsetDefinitionService offsetDefinitionService, ProjectCodeService projectCodeService, SubAccountService subAccountService, SubObjectCodeService subObjectCodeService, SystemInformationService systemInformationService, UniversityDateService universityDateService, String paramName) {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new PaymentApplicationAdjustmentDocumentService(accountService, businessObjectService, chartService, customerInvoiceDetailService, customerInvoiceDocumentService, dataDictionaryService, documentService, financialSystemUserService, generalLedgerPendingEntryService, noteService, objectCodeService, offsetDefinitionService, projectCodeService, subAccountService, subObjectCodeService, systemInformationService, universityDateService));
        String expectedMessage = String.format("%s must be provided", paramName);
        Assertions.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    private static Stream<Arguments> constructionInvalidArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "accountService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), null, Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "businessObjectService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), null, Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "chartService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), null, Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "customerInvoiceDetailService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), null, Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "customerInvoiceDocumentService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), null, Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "dataDictionaryService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), null, Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "documentService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), null, Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "financialSystemUserService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), null, Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "generalLedgerPendingEntryService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), null, Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "noteService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), null, Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "objectCodeService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), null, Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "offsetDefinitionService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), null, Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "projectCodeService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), null, Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "subAccountService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), null, Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), "subObjectCodeService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), null, Mockito.mock(UniversityDateService.class), "systemInformationService"}), Arguments.of((Object[])new Object[]{Mockito.mock(AccountService.class), Mockito.mock(BusinessObjectService.class), Mockito.mock(ChartService.class), Mockito.mock(CustomerInvoiceDetailService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(ObjectCodeService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(ProjectCodeService.class), Mockito.mock(SubAccountService.class), Mockito.mock(SubObjectCodeService.class), Mockito.mock(SystemInformationService.class), null, "universityDateService"}));
    }

    private void mockUniversityDateService() {
        Mockito.when((Object)this.universityDateServiceMock.getCurrentFiscalYear()).thenReturn((Object)1000);
        UniversityDate universityDateMock = (UniversityDate)Mockito.mock(UniversityDate.class);
        Mockito.when((Object)this.universityDateServiceMock.getCurrentUniversityDate()).thenReturn((Object)universityDateMock);
        AccountingPeriod accountingPeriodMock = (AccountingPeriod)Mockito.mock(AccountingPeriod.class);
        Mockito.when((Object)universityDateMock.getAccountingPeriod()).thenReturn((Object)accountingPeriodMock);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodCode()).thenReturn((Object)"ABC");
    }

    private static Stream<Arguments> fillInFiscalPeriodYearArgs() {
        Integer currentYear = ZonedDateTime.now().getYear();
        return Stream.of(Arguments.of((Object[])new Object[]{"currentFiscalPeriod", null, "Year is null"}), Arguments.of((Object[])new Object[]{null, currentYear, "Period is null"}), Arguments.of((Object[])new Object[]{"", currentYear, "Period is empty"}), Arguments.of((Object[])new Object[]{" ", currentYear, "Period is blank"}), Arguments.of((Object[])new Object[]{null, null, "Period & Year are null"}), Arguments.of((Object[])new Object[]{"", null, "Period is empty & Year is null"}), Arguments.of((Object[])new Object[]{" ", null, "Period is blank & Year is null"}));
    }

    @Nested
    class PostProcess {
        PostProcess() {
        }

        @Test
        void invoiceWasRemoved() {
            String principalName = "pn1";
            PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.cut);
            ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
            InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            String adjusteeInvoiceNumber = "1";
            Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            Mockito.when((Object)adjusteeIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock);
            List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
            PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
            Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
            List adjustmentInvoicePaidApplieds = List.of();
            String documentNumber = "dn1";
            PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
            Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
            String noteText = String.format("Reopened by %s with APPA %s", "pn1", "dn1");
            Note noteMock = (Note)Mockito.mock(Note.class);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock.createNoteFromDocument((Document)invoiceMock, noteText)).thenReturn((Object)noteMock);
            localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setOpenInvoiceIndicator(true);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setClosedDate(null);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).addNote(noteMock);
            ((NoteService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.noteServiceMock)).save(noteMock);
            ((DocumentService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock)).updateDocument((Document)invoiceMock);
        }

        @Test
        void invoiceWasDecreasedAndAppliedAmountIsNowZero() {
            PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.cut);
            String principalName = "pn1";
            ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
            InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            String adjusteeInvoiceNumber = "1";
            Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            KualiDecimal adjusteeAppliedAmount = new KualiDecimal(2);
            Mockito.when((Object)adjusteeIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeAppliedAmount);
            List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
            PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
            Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
            InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            KualiDecimal adjustmentAppliedAmount = new KualiDecimal(0);
            Mockito.when((Object)adjustmentIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentAppliedAmount);
            CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            Mockito.when((Object)adjustmentIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock);
            List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
            String documentNumber = "dn1";
            PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
            Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
            String noteText = String.format("Reopened by %s with APPA %s", "pn1", "dn1");
            Note noteMock = (Note)Mockito.mock(Note.class);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock.createNoteFromDocument((Document)invoiceMock, noteText)).thenReturn((Object)noteMock);
            localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setOpenInvoiceIndicator(true);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setClosedDate(null);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).addNote(noteMock);
            ((NoteService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.noteServiceMock)).save(noteMock);
            ((DocumentService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock)).updateDocument((Document)invoiceMock);
        }

        @Test
        void invoicePaidAppliedsMarkedAsAdjusted() {
            PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.cut);
            InvoicePaidApplied adjusteeIpaMock1 = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            String adjusteeInvoiceNumber = "1";
            Mockito.when((Object)adjusteeIpaMock1.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            Mockito.when((Object)adjusteeIpaMock1.getInvoiceItemAppliedAmount()).thenReturn((Object)new KualiDecimal(1));
            Integer adjusteeIpaItemNumber = 1;
            Mockito.when((Object)adjusteeIpaMock1.getInvoiceItemNumber()).thenReturn((Object)adjusteeIpaItemNumber);
            InvoicePaidApplied adjusteeIpaMock2 = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            Mockito.when((Object)adjusteeIpaMock2.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            Mockito.when((Object)adjusteeIpaMock2.getInvoiceItemNumber()).thenReturn((Object)2);
            List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock1, adjusteeIpaMock2);
            PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
            Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
            InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            Mockito.when((Object)adjustmentIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)new KualiDecimal(3));
            Mockito.when((Object)adjustmentIpaMock.getInvoiceItemOpenAmount()).thenReturn((Object)new KualiDecimal(3));
            Mockito.when((Object)adjustmentIpaMock.getInvoiceItemNumber()).thenReturn((Object)adjusteeIpaItemNumber);
            CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
            String documentNumber = "dn1";
            PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
            Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
            localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
            ((InvoicePaidApplied)Mockito.verify((Object)adjusteeIpaMock1)).setAdjusted(true);
            ((InvoicePaidApplied)Mockito.verify((Object)adjusteeIpaMock2, (VerificationMode)Mockito.times((int)0))).setAdjusted(true);
            ((BusinessObjectService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.businessObjectServiceMock)).save((PersistableBusinessObject)adjusteeIpaMock1);
        }

        @Test
        void invoiceWasAddedAndOpenAmountIsZero() {
            PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.cut);
            String principalName = "pn1";
            ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
            Date now = new Date(new java.util.Date().getTime());
            ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)now).when((Object)localCutSpy)).determineNow();
            InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            String adjusteeInvoiceNumber = "1";
            Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
            PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
            Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
            CustomerInvoiceDocument adjusteeInvoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            Mockito.when((Object)adjusteeIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)adjusteeInvoiceMock);
            InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            String adjustmentInvoiceNumber = "2";
            Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"2");
            Mockito.when((Object)adjustmentIpaMock.getInvoiceItemOpenAmount()).thenReturn((Object)KualiDecimal.ZERO);
            CustomerInvoiceDocument adjustmentInvoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            Mockito.when((Object)adjustmentIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)adjustmentInvoiceMock);
            List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
            String documentNumber = "dn1";
            PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
            Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
            String reopenedNoteText = String.format("Reopened by %s with APPA %s", "pn1", "dn1");
            Note reopenedNoteMock = (Note)Mockito.mock(Note.class);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock.createNoteFromDocument((Document)adjusteeInvoiceMock, reopenedNoteText)).thenReturn((Object)reopenedNoteMock);
            String closedNoteText = String.format("Closed by %s with APPA %s", "pn1", "dn1");
            Note closedNoteMock = (Note)Mockito.mock(Note.class);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock.createNoteFromDocument((Document)adjustmentInvoiceMock, closedNoteText)).thenReturn((Object)closedNoteMock);
            localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
            ((CustomerInvoiceDocument)Mockito.verify((Object)adjusteeInvoiceMock)).setOpenInvoiceIndicator(true);
            ((CustomerInvoiceDocument)Mockito.verify((Object)adjusteeInvoiceMock)).setClosedDate(null);
            ((CustomerInvoiceDocument)Mockito.verify((Object)adjusteeInvoiceMock)).addNote(reopenedNoteMock);
            ((NoteService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.noteServiceMock)).save(reopenedNoteMock);
            ((CustomerInvoiceDocument)Mockito.verify((Object)adjustmentInvoiceMock)).setOpenInvoiceIndicator(false);
            ((CustomerInvoiceDocument)Mockito.verify((Object)adjustmentInvoiceMock)).setClosedDate(now);
            ((CustomerInvoiceDocument)Mockito.verify((Object)adjustmentInvoiceMock)).addNote(closedNoteMock);
            ((NoteService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.noteServiceMock)).save(closedNoteMock);
            ((DocumentService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock)).updateDocument((Document)adjusteeInvoiceMock);
            ((DocumentService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock)).updateDocument((Document)adjustmentInvoiceMock);
        }

        @Test
        void invoiceWasIncreasedAndOpenAmountIsNowZero() {
            PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.cut);
            String principalName = "pn1";
            ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
            Date now = new Date(new java.util.Date().getTime());
            ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)now).when((Object)localCutSpy)).determineNow();
            InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            String adjusteeInvoiceNumber = "1";
            Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            KualiDecimal adjusteeAppliedAmount = new KualiDecimal(2);
            Mockito.when((Object)adjusteeIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeAppliedAmount);
            List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
            PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
            Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
            InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            KualiDecimal adjustmentAppliedAmount = new KualiDecimal(3);
            Mockito.when((Object)adjustmentIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentAppliedAmount);
            Mockito.when((Object)adjustmentIpaMock.getInvoiceItemOpenAmount()).thenReturn((Object)KualiDecimal.ZERO);
            CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            Mockito.when((Object)adjustmentIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock);
            List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
            String documentNumber = "dn1";
            PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
            Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
            String noteText = String.format("Closed by %s with APPA %s", "pn1", "dn1");
            Note noteMock = (Note)Mockito.mock(Note.class);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock.createNoteFromDocument((Document)invoiceMock, noteText)).thenReturn((Object)noteMock);
            localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setOpenInvoiceIndicator(false);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setClosedDate(now);
            ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).addNote(noteMock);
            ((NoteService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.noteServiceMock)).save(noteMock);
            ((DocumentService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock)).updateDocument((Document)invoiceMock);
        }

        @Test
        void invoicePaidAppliedOpenAmountsAreUpdated() {
            InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            String adjusteeInvoiceNumber = "1";
            Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
            PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
            Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
            KualiDecimal invoiceItemOpenAmount = new KualiDecimal(10);
            CustomerInvoiceDetail customerInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
            Mockito.when((Object)customerInvoiceDetailMock.getAmountOpen()).thenReturn((Object)invoiceItemOpenAmount);
            InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
            Mockito.when((Object)adjusteeIpaMock.getInvoiceItemNumber()).thenReturn((Object)1);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.customerInvoiceDetailServiceMock.getCustomerInvoiceDetail("1", adjustmentIpaMock.getInvoiceItemNumber())).thenReturn((Object)customerInvoiceDetailMock);
            List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
            String documentNumber = "dn1";
            PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
            Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
            ((InvoicePaidApplied)Mockito.verify((Object)adjustmentIpaMock)).setInvoiceItemOpenAmount(invoiceItemOpenAmount);
        }
    }

    @Nested
    class RemoveZeroAmountInvoicePaidAppliedsFromDocument {
        RemoveZeroAmountInvoicePaidAppliedsFromDocument() {
        }

        @Test
        void zeroAmountInvoice_deletesPaidApplied() {
            String documentNumber = "123";
            String refDocNumber = "456";
            int sequenceNumber = 10;
            InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(0), Integer.valueOf(0), Integer.valueOf(2000), "A");
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds()).thenReturn(new ArrayList<InvoicePaidApplied>(Arrays.asList(matchingInvoicePaidApplied)));
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.removeZeroAmountInvoicePaidAppliedsFromDocument(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock);
            Assertions.assertTrue((boolean)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds().isEmpty());
        }

        @Test
        void nonZeroAmountInvoice_doesntDeletePaidApplied() {
            String documentNumber = "123";
            String refDocNumber = "456";
            int sequenceNumber = 10;
            InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(0), Integer.valueOf(2000), "A");
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds()).thenReturn(new ArrayList<InvoicePaidApplied>(Arrays.asList(matchingInvoicePaidApplied)));
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.removeZeroAmountInvoicePaidAppliedsFromDocument(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock);
            Assertions.assertEquals((int)1, (int)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds().size());
        }
    }

    @Nested
    class UpdateInvoicePaidApplieds {
        UpdateInvoicePaidApplieds() {
        }

        @Test
        void matchingInvoiceAndSequence_updatesAmount() {
            String documentNumber = "123";
            String refDocNumber = "456";
            int sequenceNumber = 10;
            InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(0), Integer.valueOf(2000), "A");
            PaymentApplicationAdjustmentDocumentServiceTest.this.mockUniversityDateService();
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds()).thenReturn(Arrays.asList(matchingInvoicePaidApplied));
            PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail invoiceDetail = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(new KualiDecimal(2000), Integer.valueOf(10));
            PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("A", "456", List.of(invoiceDetail));
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.updateInvoicePaidApplieds(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock, List.of(invoiceApplication));
            Assertions.assertEquals((Object)invoiceDetail.getAmountApplied(), (Object)matchingInvoicePaidApplied.getInvoiceItemAppliedAmount());
        }

        @Test
        void noMatchingDocumentInvoice_matchingInvoiceDetail_doesNotCreateNewInvoiceApplied() {
            String documentNumber = "123";
            String refDocNumber = "456";
            int sequenceNumber = 10;
            int paidAppliedItemNumber = 10;
            InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(10), Integer.valueOf(2000), "A");
            ArrayList invoicePaidApplieds = new ArrayList();
            Collections.addAll(invoicePaidApplieds, matchingInvoicePaidApplied);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds()).thenReturn(invoicePaidApplieds);
            KualiDecimal invoiceApplicationDetailAmountApplied = KualiDecimal.ZERO;
            int invoiceApplicationDetailSequenceNumber = 12;
            PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail invoiceDetail = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(invoiceApplicationDetailAmountApplied, Integer.valueOf(12));
            PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("A", "456", List.of(invoiceDetail));
            PaymentApplicationAdjustmentDocumentServiceTest.this.mockUniversityDateService();
            CustomerInvoiceDetail customerInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
            Mockito.when((Object)customerInvoiceDetailMock.getInvoiceItemNumber()).thenReturn((Object)12);
            Mockito.when((Object)customerInvoiceDetailMock.getAmountApplied()).thenReturn((Object)invoiceApplicationDetailAmountApplied);
            List<CustomerInvoiceDetail> invoiceDetailMocks = List.of(customerInvoiceDetailMock);
            CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            Mockito.when((Object)customerInvoiceDocumentMock.getCustomerInvoiceDetailsWithoutDiscounts()).thenReturn(invoiceDetailMocks);
            Mockito.when((Object)((CustomerInvoiceDocument)PaymentApplicationAdjustmentDocumentServiceTest.this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"456"))).thenReturn((Object)customerInvoiceDocumentMock);
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.updateInvoicePaidApplieds(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock, List.of(invoiceApplication));
            Assertions.assertEquals((int)1, (int)invoicePaidApplieds.size());
            Assertions.assertEquals((Object)matchingInvoicePaidApplied, invoicePaidApplieds.get(0));
        }

        @Test
        void noMatchingInvoice_createsNewInvoiceApplied() {
            String documentNumber = "123";
            String refDocNumber = "456";
            int sequenceNumber = 10;
            int paidAppliedItemNumber = 10;
            InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(10), Integer.valueOf(2000), "A");
            ArrayList<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>(List.of(matchingInvoicePaidApplied));
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds()).thenReturn(invoicePaidApplieds);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getDocumentNumber()).thenReturn((Object)"123");
            KualiDecimal invoiceApplicationDetailAmountApplied = new KualiDecimal(2000);
            int invoiceApplicationDetailSequenceNumber = 11;
            PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail invoiceDetail = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(invoiceApplicationDetailAmountApplied, Integer.valueOf(11));
            PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("A", "456", List.of(invoiceDetail));
            PaymentApplicationAdjustmentDocumentServiceTest.this.mockUniversityDateService();
            CustomerInvoiceDetail customerInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
            Mockito.when((Object)customerInvoiceDetailMock.getInvoiceItemNumber()).thenReturn((Object)11);
            Mockito.when((Object)customerInvoiceDetailMock.getAmountApplied()).thenReturn((Object)((KualiDecimal)invoiceApplicationDetailAmountApplied.add((AbstractKualiDecimal)new KualiDecimal("5"))));
            List<CustomerInvoiceDetail> invoiceDetailMocks = List.of(customerInvoiceDetailMock);
            CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            Mockito.when((Object)customerInvoiceDocumentMock.getCustomerInvoiceDetailsWithoutDiscounts()).thenReturn(invoiceDetailMocks);
            Mockito.when((Object)((CustomerInvoiceDocument)PaymentApplicationAdjustmentDocumentServiceTest.this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"456"))).thenReturn((Object)customerInvoiceDocumentMock);
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.updateInvoicePaidApplieds(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock, List.of(invoiceApplication));
            Assertions.assertEquals((Object)new KualiDecimal(1000), (Object)matchingInvoicePaidApplied.getInvoiceItemAppliedAmount());
            Assertions.assertEquals((int)2, (int)invoicePaidApplieds.size());
            InvoicePaidApplied newlyAddedInvoicePaidApplied = invoicePaidApplieds.stream().filter(invoicePaidApplied -> invoicePaidApplied.getInvoiceItemNumber().equals(invoiceDetail.getSequenceNumber())).findFirst().orElse(null);
            Assertions.assertEquals((Object)invoiceDetail.getAmountApplied(), (Object)newlyAddedInvoicePaidApplied.getInvoiceItemAppliedAmount());
            Assertions.assertEquals((Object)"123", (Object)newlyAddedInvoicePaidApplied.getDocumentNumber());
            Assertions.assertEquals((Object)"456", (Object)newlyAddedInvoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber());
            Assertions.assertEquals((Integer)invoiceDetail.getSequenceNumber(), (Integer)newlyAddedInvoicePaidApplied.getInvoiceItemNumber());
            Assertions.assertEquals((int)11, (Integer)newlyAddedInvoicePaidApplied.getInvoiceItemNumber());
            Assertions.assertEquals((Integer)PaymentApplicationAdjustmentDocumentServiceTest.this.universityDateServiceMock.getCurrentFiscalYear(), (Integer)newlyAddedInvoicePaidApplied.getUniversityFiscalYear());
            Assertions.assertEquals((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.universityDateServiceMock.getCurrentUniversityDate().getAccountingPeriod().getUniversityFiscalPeriodCode(), (Object)newlyAddedInvoicePaidApplied.getUniversityFiscalPeriodCode());
        }

        @Test
        void invoiceOmitted_deletesPaidApplied() {
            PaymentApplicationAdjustmentDocumentServiceTest.this.mockUniversityDateService();
            InvoicePaidApplied invoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(0), Integer.valueOf(2000), "A");
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds()).thenReturn(new ArrayList<InvoicePaidApplied>(List.of(invoicePaidApplied)));
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.updateInvoicePaidApplieds(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock, Collections.emptyList());
            Assertions.assertTrue((boolean)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getInvoicePaidApplieds().isEmpty());
        }
    }

    @Nested
    class UpdateNonAppliedHoldings {
        UpdateNonAppliedHoldings() {
        }

        @Test
        void matchingCustomerNumber_updatesAmount() {
            String matchingCustomerNumber = "123";
            NonAppliedHolding matchingNonAppliedHolding = new NonAppliedHolding();
            matchingNonAppliedHolding.setCustomerNumber("123");
            matchingNonAppliedHolding.setFinancialDocumentLineAmount(new KualiDecimal(1000));
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getNonAppliedHoldings()).thenReturn(Arrays.asList(matchingNonAppliedHolding));
            PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHolding = new PaymentApplicationAdjustmentRequest.NonAppliedHolding(new KualiDecimal(3000), "123");
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.updateNonAppliedHoldings(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock, List.of(nonAppliedHolding));
            Assertions.assertEquals((Object)nonAppliedHolding.getAmount(), (Object)matchingNonAppliedHolding.getFinancialDocumentLineAmount());
            Assertions.assertEquals((int)1, (int)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getNonAppliedHoldings().size());
        }

        @Test
        void noMatchingCustomerNumber_createsNewNonAppliedHolding() {
            String documentNumber = "ABC";
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getNonAppliedHoldings()).thenReturn(new ArrayList());
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getDocumentNumber()).thenReturn((Object)"ABC");
            PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHoldingRequest = new PaymentApplicationAdjustmentRequest.NonAppliedHolding(new KualiDecimal(3000), "888");
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.updateNonAppliedHoldings(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock, Arrays.asList(nonAppliedHoldingRequest));
            Assertions.assertEquals((int)1, (int)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getNonAppliedHoldings().size());
            NonAppliedHolding addedNonAppliedHolding = (NonAppliedHolding)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getNonAppliedHoldings().get(0);
            Assertions.assertEquals((Object)nonAppliedHoldingRequest.getCustomerNumber(), (Object)addedNonAppliedHolding.getCustomerNumber());
            Assertions.assertEquals((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getDocumentNumber(), (Object)addedNonAppliedHolding.getReferenceFinancialDocumentNumber());
            Assertions.assertEquals((Object)nonAppliedHoldingRequest.getAmount(), (Object)addedNonAppliedHolding.getFinancialDocumentLineAmount());
        }

        @Test
        void customerNumberOmitted_removedNonAppliedHolding() {
            String customerNumber = "123";
            NonAppliedHolding nonAppliedHolding = new NonAppliedHolding();
            nonAppliedHolding.setCustomerNumber("123");
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getNonAppliedHoldings()).thenReturn(new ArrayList<NonAppliedHolding>(List.of(nonAppliedHolding)));
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.updateNonAppliedHoldings(PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock, Collections.emptyList());
            Assertions.assertTrue((boolean)PaymentApplicationAdjustmentDocumentServiceTest.this.appaDocMock.getNonAppliedHoldings().isEmpty());
        }
    }

    @Nested
    class FillInFiscalPeriodYear {
        FillInFiscalPeriodYear() {
        }

        @Test
        void early_return_for_empty_collection() {
            List glpes = List.of();
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.fillInFiscalPeriodYear(glpes);
            ((UniversityDateService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.universityDateServiceMock, (VerificationMode)Mockito.times((int)0))).getCurrentUniversityDate();
        }

        @Test
        void both_pieces_of_data_present_is_a_noop() {
            String glpeFiscalPeriod = "glpeFiscalPeriod";
            Integer glpeFiscalYear = ZonedDateTime.now().getYear();
            GeneralLedgerPendingEntry glpeMock = (GeneralLedgerPendingEntry)Mockito.mock(GeneralLedgerPendingEntry.class);
            Mockito.when((Object)glpeMock.getUniversityFiscalPeriodCode()).thenReturn((Object)"glpeFiscalPeriod");
            Mockito.when((Object)glpeMock.getUniversityFiscalYear()).thenReturn((Object)glpeFiscalYear);
            List<GeneralLedgerPendingEntry> glpes = List.of(glpeMock);
            String universityFiscalAccountingPeriod = "universityFiscalAccountingPeriod";
            Integer universityFiscalYear = 1999;
            UniversityDate universityDateMock = (UniversityDate)Mockito.mock(UniversityDate.class);
            Mockito.when((Object)universityDateMock.getUniversityFiscalAccountingPeriod()).thenReturn((Object)"universityFiscalAccountingPeriod");
            Mockito.when((Object)universityDateMock.getUniversityFiscalYear()).thenReturn((Object)universityFiscalYear);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.universityDateServiceMock.getCurrentUniversityDate()).thenReturn((Object)universityDateMock);
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.fillInFiscalPeriodYear(glpes);
            ((UniversityDateService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.universityDateServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentUniversityDate();
            ((GeneralLedgerPendingEntry)Mockito.verify((Object)glpeMock, (VerificationMode)Mockito.times((int)0))).setUniversityFiscalPeriodCode(ArgumentMatchers.anyString());
            ((GeneralLedgerPendingEntry)Mockito.verify((Object)glpeMock, (VerificationMode)Mockito.times((int)0))).setUniversityFiscalYear(Integer.valueOf(ArgumentMatchers.anyInt()));
        }

        @ParameterizedTest(name="{2}")
        @MethodSource(value={"org.kuali.kfs.module.ar.document.service.impl.PaymentApplicationAdjustmentDocumentServiceTest#fillInFiscalPeriodYearArgs"})
        void at_least_one_piece_of_data_is_missing_so_both_should_be_updated(String glpeFiscalPeriod, Integer glpeFiscalYear, String description) {
            GeneralLedgerPendingEntry glpeMock = (GeneralLedgerPendingEntry)Mockito.mock(GeneralLedgerPendingEntry.class);
            Mockito.when((Object)glpeMock.getUniversityFiscalPeriodCode()).thenReturn((Object)glpeFiscalPeriod);
            Mockito.when((Object)glpeMock.getUniversityFiscalYear()).thenReturn((Object)glpeFiscalYear);
            List<GeneralLedgerPendingEntry> glpes = List.of(glpeMock);
            String universityFiscalAccountingPeriod = "universityFiscalAccountingPeriod";
            Integer universityFiscalYear = 1999;
            UniversityDate universityDateMock = (UniversityDate)Mockito.mock(UniversityDate.class);
            Mockito.when((Object)universityDateMock.getUniversityFiscalAccountingPeriod()).thenReturn((Object)"universityFiscalAccountingPeriod");
            Mockito.when((Object)universityDateMock.getUniversityFiscalYear()).thenReturn((Object)universityFiscalYear);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.universityDateServiceMock.getCurrentUniversityDate()).thenReturn((Object)universityDateMock);
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.fillInFiscalPeriodYear(glpes);
            ((UniversityDateService)Mockito.verify((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.universityDateServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentUniversityDate();
            ((GeneralLedgerPendingEntry)Mockito.verify((Object)glpeMock)).setUniversityFiscalPeriodCode("universityFiscalAccountingPeriod");
            ((GeneralLedgerPendingEntry)Mockito.verify((Object)glpeMock)).setUniversityFiscalYear(universityFiscalYear);
        }
    }

    @Nested
    class CreatePaymentApplicationAdjustment {
        CreatePaymentApplicationAdjustment() {
        }

        @Test
        void does_not_include_invoice_with_an_appliedamount_of_zero() throws Exception {
            DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
            PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock.getNewDocument(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)adjustmentDocumentMock);
            CustomerInvoiceDocument invoiceMock1 = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            InvoicePaidApplied ipaMock1 = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            Mockito.when((Object)ipaMock1.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock1);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.customerInvoiceDocumentServiceMock.getPaidAppliedTotalForInvoice(invoiceMock1)).thenReturn((Object)KualiDecimal.ZERO);
            CustomerInvoiceDocument invoiceMock2 = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
            InvoicePaidApplied ipaMock2 = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
            Mockito.when((Object)ipaMock2.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock2);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.customerInvoiceDocumentServiceMock.getPaidAppliedTotalForInvoice(invoiceMock2)).thenReturn((Object)new KualiDecimal(7));
            List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(ipaMock1, ipaMock2);
            AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock = (AccountsReceivableDocumentHeader)Mockito.mock(AccountsReceivableDocumentHeader.class);
            PaymentApplicationAdjustmentDocument adjusteeDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
            Mockito.when((Object)adjusteeDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeaderMock);
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.createPaymentApplicationAdjustment(adjusteeDocumentMock);
            ((PaymentApplicationAdjustmentDocument)Mockito.verify((Object)adjustmentDocumentMock)).setInvoicePaidApplieds(List.of(ipaMock2));
        }

        @Test
        void does_not_include_nonappliedholdings_with_a_financialdocumentlineamount_of_zero() throws Exception {
            DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
            PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.documentServiceMock.getNewDocument(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)adjustmentDocumentMock);
            NonAppliedHolding nahMock1 = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
            Mockito.when((Object)nahMock1.getFinancialDocumentLineAmount()).thenReturn((Object)KualiDecimal.ZERO);
            NonAppliedHolding nahMock2 = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
            Mockito.when((Object)nahMock2.getFinancialDocumentLineAmount()).thenReturn((Object)new KualiDecimal("7.00"));
            List<NonAppliedHolding> adjusteeNonAppliedHoldings = List.of(nahMock1, nahMock2);
            AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock = (AccountsReceivableDocumentHeader)Mockito.mock(AccountsReceivableDocumentHeader.class);
            PaymentApplicationAdjustmentDocument adjusteeDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
            Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
            Mockito.when((Object)adjusteeDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeaderMock);
            PaymentApplicationAdjustmentDocumentServiceTest.this.cut.createPaymentApplicationAdjustment(adjusteeDocumentMock);
            ((PaymentApplicationAdjustmentDocument)Mockito.verify((Object)adjustmentDocumentMock)).setNonAppliedHoldings(List.of(nahMock2));
        }
    }

    @Nested
    class CreatePendingEntries {
        private static final String DASH = "-";
        private static final String APPA_DOCUMENT_TYPE_CODE = "APPA";

        CreatePendingEntries() {
        }

        private void setupSystemInformationMockingForAdjusteeDocumentInitiator(DocumentHeader documentHeaderMock, String initiatorChartOfAccountsCode, String initiatorOrganizationCode, Account universityClearingAccountMock, String universityClearingAccountNumber, String universityClearingAccountChartOfAccounts, String unappliedSubAccountNumber, String unappliedObjectCode, String unappliedObjectTypeCode, String unappliedSubObjectCode, Integer currentYear) {
            String initiatorPrincipalId = "adjusteeInitiator";
            Mockito.when((Object)documentHeaderMock.getInitiatorPrincipalId()).thenReturn((Object)"adjusteeInitiator");
            this.setupSystemInformationMockingForCurrentInitiator(initiatorChartOfAccountsCode, initiatorOrganizationCode, universityClearingAccountMock, universityClearingAccountNumber, universityClearingAccountChartOfAccounts, unappliedSubAccountNumber, unappliedObjectCode, unappliedObjectTypeCode, unappliedSubObjectCode, "adjusteeInitiator", currentYear);
        }

        private void setupSystemInformationMockingForCurrentInitiator(String initiatorChartOfAccountsCode, String initiatorOrganizationCode, Account universityClearingAccountMock, String universityClearingAccountNumber, String universityClearingAccountChartOfAccounts, String unappliedSubAccountNumber, String unappliedObjectCode, String unappliedObjectTypeCode, String unappliedSubObjectCode, String principalId, Integer currentYear) {
            ChartOrgHolder adjusteeChartOrgHolderMock = (ChartOrgHolder)Mockito.mock(ChartOrgHolder.class);
            Mockito.when((Object)adjusteeChartOrgHolderMock.getChartOfAccountsCode()).thenReturn((Object)initiatorChartOfAccountsCode);
            Mockito.when((Object)adjusteeChartOrgHolderMock.getOrganizationCode()).thenReturn((Object)initiatorOrganizationCode);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.financialSystemUserServiceMock.getPrimaryOrganization(principalId, "KFS-AR")).thenReturn((Object)adjusteeChartOrgHolderMock);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.universityDateServiceMock.getCurrentFiscalYear()).thenReturn((Object)currentYear);
            Mockito.when((Object)universityClearingAccountMock.getAccountNumber()).thenReturn((Object)universityClearingAccountNumber);
            Mockito.when((Object)universityClearingAccountMock.getChartOfAccountsCode()).thenReturn((Object)universityClearingAccountChartOfAccounts);
            ObjectCode adjusteeUniversityClearingObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
            Mockito.when((Object)adjusteeUniversityClearingObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)unappliedObjectTypeCode);
            SystemInformation adjusteeSystemInformationMock = (SystemInformation)Mockito.mock(SystemInformation.class);
            Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingAccount()).thenReturn((Object)universityClearingAccountMock);
            Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingSubAccountNumber()).thenReturn((Object)unappliedSubAccountNumber);
            Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingObjectCode()).thenReturn((Object)unappliedObjectCode);
            Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingObject()).thenReturn((Object)adjusteeUniversityClearingObjectMock);
            if (unappliedSubObjectCode != null) {
                Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingSubObjectCode()).thenReturn((Object)unappliedSubObjectCode);
            }
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.systemInformationServiceMock.getByProcessingChartOrgAndFiscalYear(initiatorChartOfAccountsCode, initiatorOrganizationCode, currentYear)).thenReturn((Object)adjusteeSystemInformationMock);
        }

        private void setupOffsetDefinitionMocking(String offsetDefinitionFinancialObjectFinancialObjectTypeCode, String offsetDefinitionFinancialObjectCode, Integer currentYear, String chartOfAccountsCode, String financialDocumentTypeCode) {
            ObjectCode offsetDefinitionFinancialObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
            Mockito.when((Object)offsetDefinitionFinancialObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)offsetDefinitionFinancialObjectFinancialObjectTypeCode);
            OffsetDefinition offsetDefinitionMock = (OffsetDefinition)Mockito.mock(OffsetDefinition.class);
            Mockito.when((Object)offsetDefinitionMock.getFinancialObjectCode()).thenReturn((Object)offsetDefinitionFinancialObjectCode);
            Mockito.when((Object)offsetDefinitionMock.getFinancialObject()).thenReturn((Object)offsetDefinitionFinancialObjectMock);
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.offsetDefinitionServiceMock.getByPrimaryId(currentYear, chartOfAccountsCode, financialDocumentTypeCode, "AC")).thenReturn((Object)offsetDefinitionMock);
        }

        private void setupStubbingForSequenceHelper(@Mock(stubOnly=true) GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock, int initialSequenceNumber) {
            Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        }

        private void setupStubbingForDataDictionaryService(String appaDocumentTypeCode) {
            Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)appaDocumentTypeCode);
        }

        @Nested
        class NonArAccountingLines {
            NonArAccountingLines() {
            }

            @Test
            void newOne_with_amount_of_zero_does_not_result_in_a_glpe(@Mock(stubOnly=true) PaymentApplicationDocument adjusteeDocument, @Mock(stubOnly=true) PaymentApplicationAdjustmentDocument adjustmentDocument, @Mock(stubOnly=true) GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock, @Mock(stubOnly=true) SourceAccountingLine nonArAccountingLineMock) throws Exception {
                Mockito.when((Object)nonArAccountingLineMock.getAmount()).thenReturn((Object)KualiDecimal.ZERO);
                List<SourceAccountingLine> nonArAccountingLines = List.of(nonArAccountingLineMock);
                Mockito.when((Object)adjustmentDocument.getNonArAccountingLines()).thenReturn(nonArAccountingLines);
                Integer postingYear = Year.now(ZoneId.of("America/New_York")).getValue();
                List glpes = PaymentApplicationAdjustmentDocumentServiceTest.this.cut.createPendingEntries((Document)adjusteeDocument, adjustmentDocument, postingYear, sequenceHelperMock);
                Assertions.assertTrue((boolean)glpes.isEmpty());
            }

            @Test
            void newOne_accounting_line_minimally_populated(@Mock(stubOnly=true) PaymentApplicationDocument adjusteeDocument, @Mock(stubOnly=true) PaymentApplicationAdjustmentDocument adjustmentDocument, @Mock(stubOnly=true) DocumentHeader adjustmentDocumentHeaderMock, @Mock(stubOnly=true) SourceAccountingLine adjustmentNonArAccountingLineMock, @Mock(stubOnly=true) GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock, @Mock(stubOnly=true) OffsetDefinition offsetDefinitionMock, @Mock(stubOnly=true) ObjectCode offsetObjectCodeMock) throws Exception {
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                String accountNumber = "accountNumber";
                KualiDecimal amount = new KualiDecimal(7);
                String chartOfAccountsCode = "chartOfAccountsCode";
                String financialObjectCode = "financialObjectCode";
                String objectTypeCode = "objectTypeCode";
                this.setupMinimalStubbingForSourceAccountingLine(adjustmentNonArAccountingLineMock, "accountNumber", amount, "chartOfAccountsCode", "financialObjectCode", "objectTypeCode");
                List<SourceAccountingLine> nonArAccountingLines = List.of(adjustmentNonArAccountingLineMock);
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                this.setupStubbingForDocumentHeader(adjustmentDocumentHeaderMock, "adjustmentDocumentHeaderDocumentDescription", "adjustmentDocumentHeaderOrganizationDocumentNumber");
                this.setupStubbingForDocument(adjustmentDocument, adjustmentDocumentHeaderMock, nonArAccountingLines);
                int initialSequenceNumber = 1;
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                Integer postingYear = Year.now(ZoneId.of("America/New_York")).getValue();
                String offsetFinancialObjectCode = "offsetFinancialObjectCode";
                String offsetFinancialObjectTypeCode = "offsetFinancialObjectTypeCode";
                this.setupStubbingForOffsetDefinition(postingYear, "chartOfAccountsCode", offsetDefinitionMock, "offsetFinancialObjectCode", "offsetFinancialObjectTypeCode", offsetObjectCodeMock);
                PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.cut);
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)localCutSpy)).getDashFinancialSubObjectCode();
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)localCutSpy)).getDashProjectCode();
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)localCutSpy)).getDashSubAccountNumber();
                List glpes = localCutSpy.createPendingEntries((Document)adjusteeDocument, adjustmentDocument, postingYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)glpes.size());
                GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)glpes.get(0);
                Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"accountNumber", (Object)actualCredit.getAccountNumber());
                Assertions.assertEquals((Object)"chartOfAccountsCode", (Object)actualCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"financialObjectCode", (Object)actualCredit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"objectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualCredit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualCredit.getProjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)amount, (Object)actualCredit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
                Assertions.assertEquals((Integer)postingYear, (Integer)actualCredit.getUniversityFiscalYear());
                Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
                GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)glpes.get(1);
                Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"accountNumber", (Object)offsetDebit.getAccountNumber());
                Assertions.assertEquals((Object)"chartOfAccountsCode", (Object)offsetDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"offsetFinancialObjectCode", (Object)offsetDebit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"offsetFinancialObjectTypeCode", (Object)offsetDebit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getProjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)amount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetDebit.getTransactionLedgerEntryDescription());
                Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetDebit.getTransactionLedgerEntrySequenceNumber());
                Assertions.assertEquals((Integer)postingYear, (Integer)offsetDebit.getUniversityFiscalYear());
                Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
            }

            private void setupStubbingForOffsetDefinition(Integer postingYear, String chartOfAccountsCode, OffsetDefinition offsetDefinitionMock, String offsetFinancialObjectCode, String offsetFinancialObjectTypeCode, ObjectCode offsetObjectCodeMock) {
                Mockito.when((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.offsetDefinitionServiceMock.getByPrimaryId(postingYear, chartOfAccountsCode, CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, "AC")).thenReturn((Object)offsetDefinitionMock);
                Mockito.when((Object)offsetDefinitionMock.getFinancialObjectCode()).thenReturn((Object)offsetFinancialObjectCode);
                Mockito.when((Object)offsetObjectCodeMock.getFinancialObjectTypeCode()).thenReturn((Object)offsetFinancialObjectTypeCode);
                Mockito.when((Object)offsetDefinitionMock.getFinancialObject()).thenReturn((Object)offsetObjectCodeMock);
            }

            private void setupStubbingForDocumentHeader(DocumentHeader adjustmentDocumentHeaderMock, String adjustmentDocumentHeaderDocumentDescription, String adjustmentDocumentHeaderOrganizationDocumentNumber) {
                if (adjustmentDocumentHeaderDocumentDescription != null) {
                    Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)adjustmentDocumentHeaderDocumentDescription);
                }
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)adjustmentDocumentHeaderOrganizationDocumentNumber);
            }

            private void setupStubbingForDocument(PaymentApplicationAdjustmentDocument adjustmentDocument, DocumentHeader adjustmentDocumentHeaderMock, List<SourceAccountingLine> nonArAccountingLines) {
                Mockito.when((Object)adjustmentDocument.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                Mockito.when((Object)adjustmentDocument.getNonArAccountingLines()).thenReturn(nonArAccountingLines);
            }

            private void setupMinimalStubbingForSourceAccountingLine(SourceAccountingLine adjustmentNonArAccountingLineMock, String accountNumber, KualiDecimal amount, String chartOfAccountsCode, String financialObjectCode, String objectTypeCode) {
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getAccountNumber()).thenReturn((Object)accountNumber);
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getAmount()).thenReturn((Object)amount);
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getFinancialObjectCode()).thenReturn((Object)financialObjectCode);
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getObjectTypeCode()).thenReturn((Object)objectTypeCode);
            }

            @Test
            void newOne_accounting_line_fully_populated(@Mock(stubOnly=true) PaymentApplicationDocument adjusteeDocument, @Mock(stubOnly=true) PaymentApplicationAdjustmentDocument adjustmentDocument, @Mock(stubOnly=true) DocumentHeader adjustmentDocumentHeaderMock, @Mock(stubOnly=true) SourceAccountingLine adjustmentNonArAccountingLineMock, @Mock(stubOnly=true) GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock, @Mock(stubOnly=true) OffsetDefinition offsetDefinitionMock, @Mock(stubOnly=true) ObjectCode offsetObjectCodeMock) throws Exception {
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                String accountNumber = "accountNumber";
                KualiDecimal amount = new KualiDecimal(7);
                String chartOfAccountsCode = "chartOfAccountsCode";
                String financialObjectCode = "financialObjectCode";
                String objectTypeCode = "objectTypeCode";
                String financialSubObjectCode = "financialSubObjectCode";
                String projectCode = "projectCode";
                String subAccountNumber = "subAccountNumber";
                String financialDocumentLineDescription = "financialDocumentLineDescription";
                this.setupCompleteStubbingForSourceAccountingLine(adjustmentNonArAccountingLineMock, "accountNumber", amount, "chartOfAccountsCode", "financialObjectCode", "objectTypeCode", "financialSubObjectCode", "projectCode", "subAccountNumber", "financialDocumentLineDescription");
                List<SourceAccountingLine> nonArAccountingLines = List.of(adjustmentNonArAccountingLineMock);
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                this.setupStubbingForDocumentHeader(adjustmentDocumentHeaderMock, null, "adjustmentDocumentHeaderOrganizationDocumentNumber");
                this.setupStubbingForDocument(adjustmentDocument, adjustmentDocumentHeaderMock, nonArAccountingLines);
                int initialSequenceNumber = 1;
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                Integer postingYear = Year.now(ZoneId.of("America/New_York")).getValue();
                String offsetFinancialObjectCode = "offsetFinancialObjectCode";
                String offsetFinancialObjectTypeCode = "offsetFinancialObjectTypeCode";
                this.setupStubbingForOffsetDefinition(postingYear, "chartOfAccountsCode", offsetDefinitionMock, "offsetFinancialObjectCode", "offsetFinancialObjectTypeCode", offsetObjectCodeMock);
                PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.cut);
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)localCutSpy)).getDashFinancialSubObjectCode();
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)localCutSpy)).getDashProjectCode();
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)localCutSpy)).getDashSubAccountNumber();
                List glpes = localCutSpy.createPendingEntries((Document)adjusteeDocument, adjustmentDocument, postingYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)glpes.size());
                GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)glpes.get(0);
                Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"accountNumber", (Object)actualCredit.getAccountNumber());
                Assertions.assertEquals((Object)"chartOfAccountsCode", (Object)actualCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"financialObjectCode", (Object)actualCredit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"objectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)"projectCode", (Object)actualCredit.getProjectCode());
                Assertions.assertEquals((Object)"subAccountNumber", (Object)actualCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)amount, (Object)actualCredit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"financialDocumentLineDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
                Assertions.assertEquals((Integer)postingYear, (Integer)actualCredit.getUniversityFiscalYear());
                Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
                GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)glpes.get(1);
                Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"accountNumber", (Object)offsetDebit.getAccountNumber());
                Assertions.assertEquals((Object)"chartOfAccountsCode", (Object)offsetDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"offsetFinancialObjectCode", (Object)offsetDebit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"offsetFinancialObjectTypeCode", (Object)offsetDebit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getProjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)amount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetDebit.getTransactionLedgerEntryDescription());
                Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetDebit.getTransactionLedgerEntrySequenceNumber());
                Assertions.assertEquals((Integer)postingYear, (Integer)offsetDebit.getUniversityFiscalYear());
                Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
            }

            private void setupCompleteStubbingForSourceAccountingLine(SourceAccountingLine adjustmentNonArAccountingLineMock, String accountNumber, KualiDecimal amount, String chartOfAccountsCode, String financialObjectCode, String objectTypeCode, String financialSubObjectCode, String projectCode, String subAccountNumber, String financialDocumentLineDescription) {
                this.setupMinimalStubbingForSourceAccountingLine(adjustmentNonArAccountingLineMock, accountNumber, amount, chartOfAccountsCode, financialObjectCode, objectTypeCode);
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getFinancialSubObjectCode()).thenReturn((Object)financialSubObjectCode);
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getProjectCode()).thenReturn((Object)projectCode);
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getSubAccountNumber()).thenReturn((Object)subAccountNumber);
                Mockito.when((Object)adjustmentNonArAccountingLineMock.getFinancialDocumentLineDescription()).thenReturn((Object)financialDocumentLineDescription);
            }
        }

        @Nested
        class InvoicePaidApplieds {
            InvoicePaidApplieds() {
            }

            @Test
            void newOne() throws Exception {
                Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
                List adjusteeInvoicePaidApplieds = List.of();
                PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
                Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
                String adjustmentIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
                KualiDecimal adjustmentIpaInvoiceItemAppliedAmount = new KualiDecimal(3);
                String invoiceDetailAccountAccountNumber = "invoiceDetailAccountAccountNumber";
                String invoiceDetailAccountChartOfAccounts = "invoiceDetailAccountChartOfAccounts";
                Account invoiceDetailAccountMock = (Account)Mockito.mock(Account.class);
                Mockito.when((Object)invoiceDetailAccountMock.getAccountNumber()).thenReturn((Object)"invoiceDetailAccountAccountNumber");
                Mockito.when((Object)invoiceDetailAccountMock.getChartOfAccountsCode()).thenReturn((Object)"invoiceDetailAccountChartOfAccounts");
                String invoiceDetailAccountsReceivableObjectCode = "invoiceDetailAccountsReceivableObjectCode";
                String financialObjectCode = "financialObjectCode";
                String financialObjectTypeCode = "financialObjectTypeCode";
                ObjectCode invoiceDetailAccountsReceivableObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
                Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectCode()).thenReturn((Object)"financialObjectCode");
                Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)"financialObjectTypeCode");
                String adjustmentInvoiceDetailProjectCode = "adjustmentInvoiceDetailProjectCode";
                String adjustmentInvoiceDetailSubAccountNumber = "adjustmentInvoiceDetailSubAccountNumber";
                String financialSubObjectCode = "financialSubObjectCode";
                CustomerInvoiceDetail adjustmentInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccount()).thenReturn((Object)invoiceDetailAccountMock);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObjectCode()).thenReturn((Object)"invoiceDetailAccountsReceivableObjectCode");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObject()).thenReturn((Object)invoiceDetailAccountsReceivableObjectMock);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getProjectCode()).thenReturn((Object)"adjustmentInvoiceDetailProjectCode");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getSubAccountNumber()).thenReturn((Object)"adjustmentInvoiceDetailSubAccountNumber");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getFinancialSubObjectCode()).thenReturn((Object)"financialSubObjectCode");
                CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
                InvoicePaidApplied adjustmentInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentIpaInvoiceItemAppliedAmount);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceDetail()).thenReturn((Object)adjustmentInvoiceDetailMock);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocumentMock);
                List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentInvoicePaidAppliedMock);
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
                PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
                Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
                Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                int initialSequenceNumber = 1;
                GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List pendingEntries = PaymentApplicationAdjustmentDocumentServiceTest.this.cut.createPendingEntries((Document)adjusteeDocumentMock, adjustmentDocumentMock, currentYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)pendingEntries.size());
                GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
                Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)actualCredit.getAccountNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)actualCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"financialObjectCode", (Object)actualCredit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"financialObjectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)actualCredit.getProjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)actualCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)adjustmentIpaInvoiceItemAppliedAmount, (Object)actualCredit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)actualCredit.getUniversityFiscalYear());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
                GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
                Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)offsetDebit.getAccountNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)offsetDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)offsetDebit.getProjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)offsetDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)adjustmentIpaInvoiceItemAppliedAmount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
                Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)offsetDebit.getUniversityFiscalYear());
            }

            @Test
            void increased() throws Exception {
                Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
                String adjusteeIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
                KualiDecimal adjusteeIpaInvoiceItemAppliedAmount = new KualiDecimal(1);
                InvoicePaidApplied adjusteeInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
                Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
                Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeIpaInvoiceItemAppliedAmount);
                List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeInvoicePaidAppliedMock);
                PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
                Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
                String adjustmentIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
                KualiDecimal adjustmentIpaInvoiceItemAppliedAmount = new KualiDecimal(3);
                String invoiceDetailAccountAccountNumber = "invoiceDetailAccountAccountNumber";
                String invoiceDetailAccountChartOfAccounts = "invoiceDetailAccountChartOfAccounts";
                Account invoiceDetailAccountMock = (Account)Mockito.mock(Account.class);
                Mockito.when((Object)invoiceDetailAccountMock.getAccountNumber()).thenReturn((Object)"invoiceDetailAccountAccountNumber");
                Mockito.when((Object)invoiceDetailAccountMock.getChartOfAccountsCode()).thenReturn((Object)"invoiceDetailAccountChartOfAccounts");
                String invoiceDetailAccountsReceivableObjectCode = "invoiceDetailAccountsReceivableObjectCode";
                String financialObjectCode = "financialObjectCode";
                String financialObjectTypeCode = "financialObjectTypeCode";
                ObjectCode invoiceDetailAccountsReceivableObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
                Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectCode()).thenReturn((Object)"financialObjectCode");
                Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)"financialObjectTypeCode");
                String adjustmentInvoiceDetailProjectCode = "adjustmentInvoiceDetailProjectCode";
                String adjustmentInvoiceDetailSubAccountNumber = "adjustmentInvoiceDetailSubAccountNumber";
                String financialSubObjectCode = "financialSubObjectCode";
                CustomerInvoiceDetail adjustmentInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccount()).thenReturn((Object)invoiceDetailAccountMock);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObjectCode()).thenReturn((Object)"invoiceDetailAccountsReceivableObjectCode");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObject()).thenReturn((Object)invoiceDetailAccountsReceivableObjectMock);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getProjectCode()).thenReturn((Object)"adjustmentInvoiceDetailProjectCode");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getSubAccountNumber()).thenReturn((Object)"adjustmentInvoiceDetailSubAccountNumber");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getFinancialSubObjectCode()).thenReturn((Object)"financialSubObjectCode");
                CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
                InvoicePaidApplied adjustmentInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentIpaInvoiceItemAppliedAmount);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceDetail()).thenReturn((Object)adjustmentInvoiceDetailMock);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocumentMock);
                List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentInvoicePaidAppliedMock);
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
                PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
                Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
                Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                int initialSequenceNumber = 1;
                GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List pendingEntries = PaymentApplicationAdjustmentDocumentServiceTest.this.cut.createPendingEntries((Document)adjusteeDocumentMock, adjustmentDocumentMock, currentYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)pendingEntries.size());
                KualiDecimal expectedAmount = (KualiDecimal)adjustmentIpaInvoiceItemAppliedAmount.subtract((AbstractKualiDecimal)adjusteeIpaInvoiceItemAppliedAmount);
                GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
                Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)actualCredit.getAccountNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)actualCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"financialObjectCode", (Object)actualCredit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"financialObjectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)actualCredit.getProjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)actualCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)expectedAmount, (Object)actualCredit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)actualCredit.getUniversityFiscalYear());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
                GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
                Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)offsetDebit.getAccountNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)offsetDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)offsetDebit.getProjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)offsetDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)expectedAmount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
                Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)offsetDebit.getUniversityFiscalYear());
            }

            @Test
            void decreased() throws Exception {
                Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
                String adjusteeIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
                KualiDecimal adjusteeIpaInvoiceItemAppliedAmount = new KualiDecimal(3);
                InvoicePaidApplied adjusteeInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
                Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
                Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeIpaInvoiceItemAppliedAmount);
                List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeInvoicePaidAppliedMock);
                PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
                Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
                String adjustmentIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
                KualiDecimal adjustmentIpaInvoiceItemAppliedAmount = new KualiDecimal(1);
                String invoiceDetailAccountAccountNumber = "invoiceDetailAccountAccountNumber";
                String invoiceDetailAccountChartOfAccounts = "invoiceDetailAccountChartOfAccounts";
                Account invoiceDetailAccountMock = (Account)Mockito.mock(Account.class);
                Mockito.when((Object)invoiceDetailAccountMock.getAccountNumber()).thenReturn((Object)"invoiceDetailAccountAccountNumber");
                Mockito.when((Object)invoiceDetailAccountMock.getChartOfAccountsCode()).thenReturn((Object)"invoiceDetailAccountChartOfAccounts");
                String invoiceDetailAccountsReceivableObjectCode = "invoiceDetailAccountsReceivableObjectCode";
                String financialObjectCode = "financialObjectCode";
                String financialObjectTypeCode = "financialObjectTypeCode";
                ObjectCode invoiceDetailAccountsReceivableObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
                Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectCode()).thenReturn((Object)"financialObjectCode");
                Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)"financialObjectTypeCode");
                String adjustmentInvoiceDetailProjectCode = "adjustmentInvoiceDetailProjectCode";
                String adjustmentInvoiceDetailSubAccountNumber = "adjustmentInvoiceDetailSubAccountNumber";
                String financialSubObjectCode = "financialSubObjectCode";
                CustomerInvoiceDetail adjustmentInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccount()).thenReturn((Object)invoiceDetailAccountMock);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObjectCode()).thenReturn((Object)"invoiceDetailAccountsReceivableObjectCode");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObject()).thenReturn((Object)invoiceDetailAccountsReceivableObjectMock);
                Mockito.when((Object)adjustmentInvoiceDetailMock.getProjectCode()).thenReturn((Object)"adjustmentInvoiceDetailProjectCode");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getSubAccountNumber()).thenReturn((Object)"adjustmentInvoiceDetailSubAccountNumber");
                Mockito.when((Object)adjustmentInvoiceDetailMock.getFinancialSubObjectCode()).thenReturn((Object)"financialSubObjectCode");
                CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
                InvoicePaidApplied adjustmentInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentIpaInvoiceItemAppliedAmount);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceDetail()).thenReturn((Object)adjustmentInvoiceDetailMock);
                Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocumentMock);
                List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentInvoicePaidAppliedMock);
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
                PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
                Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
                Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                int initialSequenceNumber = 1;
                GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List pendingEntries = PaymentApplicationAdjustmentDocumentServiceTest.this.cut.createPendingEntries((Document)adjusteeDocumentMock, adjustmentDocumentMock, currentYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)pendingEntries.size());
                KualiDecimal expectedAmount = (KualiDecimal)adjusteeIpaInvoiceItemAppliedAmount.subtract((AbstractKualiDecimal)adjustmentIpaInvoiceItemAppliedAmount);
                GeneralLedgerPendingEntry actualDebit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
                Assertions.assertEquals((Object)"D", (Object)actualDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)actualDebit.getAccountNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)actualDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"financialObjectCode", (Object)actualDebit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"financialObjectTypeCode", (Object)actualDebit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualDebit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)actualDebit.getProjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)actualDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)expectedAmount, (Object)actualDebit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualDebit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)actualDebit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)actualDebit.getUniversityFiscalYear());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualDebit.getTransactionLedgerEntrySequenceNumber());
                GeneralLedgerPendingEntry offsetCredit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
                Assertions.assertEquals((Object)"C", (Object)offsetCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)offsetCredit.getAccountNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)offsetCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)offsetCredit.getProjectCode());
                Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)offsetCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)expectedAmount, (Object)offsetCredit.getTransactionLedgerEntryAmount());
                Assertions.assertNull((Object)offsetCredit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)offsetCredit.getUniversityFiscalYear());
            }

            @Test
            void removed() throws Exception {
                Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
                String adjusteeIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
                KualiDecimal adjusteeIpaInvoiceItemAppliedAmount = new KualiDecimal(1);
                String invoiceDetailAccountAccountNumber = "invoiceDetailAccountAccountNumber";
                String invoiceDetailAccountChartOfAccounts = "invoiceDetailAccountChartOfAccounts";
                Account invoiceDetailAccountMock = (Account)Mockito.mock(Account.class);
                Mockito.when((Object)invoiceDetailAccountMock.getAccountNumber()).thenReturn((Object)"invoiceDetailAccountAccountNumber");
                Mockito.when((Object)invoiceDetailAccountMock.getChartOfAccountsCode()).thenReturn((Object)"invoiceDetailAccountChartOfAccounts");
                String invoiceDetailAccountsReceivableObjectCode = "invoiceDetailAccountsReceivableObjectCode";
                String financialObjectCode = "financialObjectCode";
                String financialObjectTypeCode = "financialObjectTypeCode";
                ObjectCode invoiceDetailAccountsReceivableObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
                Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectCode()).thenReturn((Object)"financialObjectCode");
                Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)"financialObjectTypeCode");
                String adjusteeInvoiceDetailProjectCode = "adjusteeInvoiceDetailProjectCode";
                String adjusteeInvoiceDetailSubAccountNumber = "adjusteeInvoiceDetailSubAccountNumber";
                String financialSubObjectCode = "financialSubObjectCode";
                CustomerInvoiceDetail adjusteeInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
                Mockito.when((Object)adjusteeInvoiceDetailMock.getAccount()).thenReturn((Object)invoiceDetailAccountMock);
                Mockito.when((Object)adjusteeInvoiceDetailMock.getAccountsReceivableObjectCode()).thenReturn((Object)"invoiceDetailAccountsReceivableObjectCode");
                Mockito.when((Object)adjusteeInvoiceDetailMock.getAccountsReceivableObject()).thenReturn((Object)invoiceDetailAccountsReceivableObjectMock);
                Mockito.when((Object)adjusteeInvoiceDetailMock.getProjectCode()).thenReturn((Object)"adjusteeInvoiceDetailProjectCode");
                Mockito.when((Object)adjusteeInvoiceDetailMock.getSubAccountNumber()).thenReturn((Object)"adjusteeInvoiceDetailSubAccountNumber");
                Mockito.when((Object)adjusteeInvoiceDetailMock.getFinancialSubObjectCode()).thenReturn((Object)"financialSubObjectCode");
                CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
                InvoicePaidApplied adjusteeInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
                Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
                Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeIpaInvoiceItemAppliedAmount);
                Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getInvoiceDetail()).thenReturn((Object)adjusteeInvoiceDetailMock);
                Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocumentMock);
                List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeInvoicePaidAppliedMock);
                PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
                Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
                List adjustmentInvoicePaidApplieds = List.of();
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
                PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
                Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
                Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                int initialSequenceNumber = 1;
                GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List pendingEntries = PaymentApplicationAdjustmentDocumentServiceTest.this.cut.createPendingEntries((Document)adjusteeDocumentMock, adjustmentDocumentMock, currentYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)pendingEntries.size());
                GeneralLedgerPendingEntry actualDebit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
                Assertions.assertEquals((Object)"D", (Object)actualDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)actualDebit.getAccountNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)actualDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"financialObjectCode", (Object)actualDebit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"financialObjectTypeCode", (Object)actualDebit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualDebit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)"adjusteeInvoiceDetailProjectCode", (Object)actualDebit.getProjectCode());
                Assertions.assertEquals((Object)"adjusteeInvoiceDetailSubAccountNumber", (Object)actualDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)adjusteeIpaInvoiceItemAppliedAmount, (Object)actualDebit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualDebit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)actualDebit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)actualDebit.getUniversityFiscalYear());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualDebit.getTransactionLedgerEntrySequenceNumber());
                GeneralLedgerPendingEntry offsetCredit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
                Assertions.assertEquals((Object)"C", (Object)offsetCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)offsetCredit.getAccountNumber());
                Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)offsetCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"adjusteeInvoiceDetailProjectCode", (Object)offsetCredit.getProjectCode());
                Assertions.assertEquals((Object)"adjusteeInvoiceDetailSubAccountNumber", (Object)offsetCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)adjusteeIpaInvoiceItemAppliedAmount, (Object)offsetCredit.getTransactionLedgerEntryAmount());
                Assertions.assertNull((Object)offsetCredit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)offsetCredit.getUniversityFiscalYear());
            }
        }

        @Nested
        class NonAppliedHoldings {
            PaymentApplicationAdjustmentDocumentService localCutSpy;

            NonAppliedHoldings() {
            }

            @BeforeEach
            void setup() {
                this.localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)PaymentApplicationAdjustmentDocumentServiceTest.this.cut);
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)this.localCutSpy)).getDashFinancialSubObjectCode();
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)this.localCutSpy)).getDashProjectCode();
                ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)CreatePendingEntries.DASH).when((Object)this.localCutSpy)).getDashSubAccountNumber();
            }

            @Test
            void newOne() throws Exception {
                String currentUserPrincipalId = "currentUserPrincipalId";
                Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
                List adjusteeNonAppliedHoldings = List.of();
                PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
                Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
                String initiatorChartOfAccountsCode = "initiatorChartOfAccountsCode";
                String initiatorOrganizationCode = "initiatorOrganizationCode";
                Account universityClearingAccountMock = (Account)Mockito.mock(Account.class);
                String universityClearingAccountNumber = "universityClearingAccountNumber";
                String universityClearingAccountChartOfAccounts = "universityClearingAccountChartOfAccounts";
                String unappliedSubAccountNumber = "unappliedSubAccountNumber";
                String unappliedObjectCode = "unappliedObjectCode";
                String unappliedObjectTypeCode = "unappliedObjectTypeCode";
                String unappliedSubObjectCode = "unappliedSubObjectCode";
                CreatePendingEntries.this.setupSystemInformationMockingForCurrentInitiator("initiatorChartOfAccountsCode", "initiatorOrganizationCode", universityClearingAccountMock, "universityClearingAccountNumber", "universityClearingAccountChartOfAccounts", "unappliedSubAccountNumber", "unappliedObjectCode", "unappliedObjectTypeCode", "unappliedSubObjectCode", "currentUserPrincipalId", currentYear);
                String offsetDefinitionFinancialObjectFinancialObjectTypeCode = "offsetDefinitionFinancialObjectFinancialObjectTypeCode";
                String offsetDefinitionFinancialObjectCode = "offsetDefinitionFinancialObjectCode";
                CreatePendingEntries.this.setupOffsetDefinitionMocking("offsetDefinitionFinancialObjectFinancialObjectTypeCode", "offsetDefinitionFinancialObjectCode", currentYear, "universityClearingAccountChartOfAccounts", CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                String adjustmentNahCustomerNumber = "CN1";
                KualiDecimal adjustmentNahFinancialDocumentLineAmount = new KualiDecimal(3);
                NonAppliedHolding adjustmentNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
                Mockito.when((Object)adjustmentNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
                Mockito.when((Object)adjustmentNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjustmentNahFinancialDocumentLineAmount);
                List<NonAppliedHolding> adjustmentNonAppliedHoldings = List.of(adjustmentNonAppliedHoldingMock);
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getInitiatorPrincipalId()).thenReturn((Object)"currentUserPrincipalId");
                PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
                Mockito.when((Object)adjustmentDocumentMock.getNonAppliedHoldings()).thenReturn(adjustmentNonAppliedHoldings);
                Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                int initialSequenceNumber = 1;
                GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List pendingEntries = this.localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, adjustmentDocumentMock, currentYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)pendingEntries.size());
                GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
                Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)actualCredit.getAccountNumber());
                Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)actualCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"unappliedObjectCode", (Object)actualCredit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"unappliedObjectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)"unappliedSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualCredit.getProjectCode());
                Assertions.assertEquals((Object)"unappliedSubAccountNumber", (Object)actualCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)adjustmentNahFinancialDocumentLineAmount, (Object)actualCredit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)actualCredit.getUniversityFiscalYear());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
                GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
                Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)offsetDebit.getAccountNumber());
                Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)offsetDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectCode", (Object)offsetDebit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectFinancialObjectTypeCode", (Object)offsetDebit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getProjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)adjustmentNahFinancialDocumentLineAmount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetDebit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)offsetDebit.getUniversityFiscalYear());
                Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetDebit.getTransactionLedgerEntrySequenceNumber());
            }

            @Test
            void increased() throws Exception {
                String currentUserPrincipalId = "currentUserPrincipalId";
                Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
                String adjusteeNahCustomerNumber = "CN1";
                KualiDecimal adjusteeNahFinancialDocumentLineAmount = new KualiDecimal(1);
                NonAppliedHolding adjusteeNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
                Mockito.when((Object)adjusteeNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
                Mockito.when((Object)adjusteeNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjusteeNahFinancialDocumentLineAmount);
                List<NonAppliedHolding> adjusteeNonAppliedHoldings = List.of(adjusteeNonAppliedHoldingMock);
                PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
                Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
                String initiatorChartOfAccountsCode = "initiatorChartOfAccountsCode";
                String initiatorOrganizationCode = "initiatorOrganizationCode";
                Account universityClearingAccountMock = (Account)Mockito.mock(Account.class);
                String universityClearingAccountNumber = "universityClearingAccountNumber";
                String universityClearingAccountChartOfAccounts = "universityClearingAccountChartOfAccounts";
                String unappliedSubAccountNumber = "unappliedSubAccountNumber";
                String unappliedObjectCode = "unappliedObjectCode";
                String unappliedObjectTypeCode = "unappliedObjectTypeCode";
                String unappliedSubObjectCode = "unappliedSubObjectCode";
                CreatePendingEntries.this.setupSystemInformationMockingForCurrentInitiator("initiatorChartOfAccountsCode", "initiatorOrganizationCode", universityClearingAccountMock, "universityClearingAccountNumber", "universityClearingAccountChartOfAccounts", "unappliedSubAccountNumber", "unappliedObjectCode", "unappliedObjectTypeCode", "unappliedSubObjectCode", "currentUserPrincipalId", currentYear);
                String offsetDefinitionFinancialObjectFinancialObjectTypeCode = "offsetDefinitionFinancialObjectFinancialObjectTypeCode";
                String offsetDefinitionFinancialObjectCode = "offsetDefinitionFinancialObjectCode";
                CreatePendingEntries.this.setupOffsetDefinitionMocking("offsetDefinitionFinancialObjectFinancialObjectTypeCode", "offsetDefinitionFinancialObjectCode", currentYear, "universityClearingAccountChartOfAccounts", CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                String adjustmentNahCustomerNumber = "CN1";
                KualiDecimal adjustmentNahFinancialDocumentLineAmount = new KualiDecimal(3);
                NonAppliedHolding adjustmentNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
                Mockito.when((Object)adjustmentNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
                Mockito.when((Object)adjustmentNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjustmentNahFinancialDocumentLineAmount);
                List<NonAppliedHolding> adjustmentNonAppliedHoldings = List.of(adjustmentNonAppliedHoldingMock);
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getInitiatorPrincipalId()).thenReturn((Object)"currentUserPrincipalId");
                PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
                Mockito.when((Object)adjustmentDocumentMock.getNonAppliedHoldings()).thenReturn(adjustmentNonAppliedHoldings);
                Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                int initialSequenceNumber = 1;
                GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List pendingEntries = this.localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, adjustmentDocumentMock, currentYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)pendingEntries.size());
                KualiDecimal expectedAmount = (KualiDecimal)adjustmentNahFinancialDocumentLineAmount.subtract((AbstractKualiDecimal)adjusteeNahFinancialDocumentLineAmount);
                GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
                Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)actualCredit.getAccountNumber());
                Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)actualCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"unappliedObjectCode", (Object)actualCredit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"unappliedObjectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)"unappliedSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualCredit.getProjectCode());
                Assertions.assertEquals((Object)"unappliedSubAccountNumber", (Object)actualCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)expectedAmount, (Object)actualCredit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)actualCredit.getUniversityFiscalYear());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
                GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
                Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)offsetDebit.getAccountNumber());
                Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)offsetDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectCode", (Object)offsetDebit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectFinancialObjectTypeCode", (Object)offsetDebit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getProjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)expectedAmount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetDebit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)offsetDebit.getUniversityFiscalYear());
                Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetDebit.getTransactionLedgerEntrySequenceNumber());
            }

            @Test
            void decreased() throws Exception {
                Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
                String adjusteeNahCustomerNumber = "CN1";
                KualiDecimal adjusteeNahFinancialDocumentLineAmount = new KualiDecimal(3);
                NonAppliedHolding adjusteeNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
                Mockito.when((Object)adjusteeNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
                Mockito.when((Object)adjusteeNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjusteeNahFinancialDocumentLineAmount);
                List<NonAppliedHolding> adjusteeNonAppliedHoldings = List.of(adjusteeNonAppliedHoldingMock);
                DocumentHeader adjusteeDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
                Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
                Mockito.when((Object)adjusteeDocumentMock.getDocumentHeader()).thenReturn((Object)adjusteeDocumentHeaderMock);
                String initiatorChartOfAccountsCode = "initiatorChartOfAccountsCode";
                String initiatorOrganizationCode = "initiatorOrganizationCode";
                Account universityClearingAccountMock = (Account)Mockito.mock(Account.class);
                String universityClearingAccountNumber = "universityClearingAccountNumber";
                String universityClearingAccountChartOfAccounts = "universityClearingAccountChartOfAccounts";
                String unappliedSubAccountNumber = "unappliedSubAccountNumber";
                String unappliedObjectCode = "unappliedObjectCode";
                String unappliedObjectTypeCode = "unappliedObjectTypeCode";
                CreatePendingEntries.this.setupSystemInformationMockingForAdjusteeDocumentInitiator(adjusteeDocumentHeaderMock, "initiatorChartOfAccountsCode", "initiatorOrganizationCode", universityClearingAccountMock, "universityClearingAccountNumber", "universityClearingAccountChartOfAccounts", "unappliedSubAccountNumber", "unappliedObjectCode", "unappliedObjectTypeCode", null, currentYear);
                String offsetDefinitionFinancialObjectFinancialObjectTypeCode = "offsetDefinitionFinancialObjectFinancialObjectTypeCode";
                String offsetDefinitionFinancialObjectCode = "offsetDefinitionFinancialObjectCode";
                CreatePendingEntries.this.setupOffsetDefinitionMocking("offsetDefinitionFinancialObjectFinancialObjectTypeCode", "offsetDefinitionFinancialObjectCode", currentYear, "universityClearingAccountChartOfAccounts", CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                String adjustmentNahCustomerNumber = "CN1";
                KualiDecimal adjustmentNahFinancialDocumentLineAmount = new KualiDecimal(1);
                NonAppliedHolding adjustmentNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
                Mockito.when((Object)adjustmentNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
                Mockito.when((Object)adjustmentNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjustmentNahFinancialDocumentLineAmount);
                List<NonAppliedHolding> adjustmentNonAppliedHoldings = List.of(adjustmentNonAppliedHoldingMock);
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
                PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
                Mockito.when((Object)adjustmentDocumentMock.getNonAppliedHoldings()).thenReturn(adjustmentNonAppliedHoldings);
                Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                int initialSequenceNumber = 1;
                GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List pendingEntries = this.localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, adjustmentDocumentMock, currentYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)pendingEntries.size());
                KualiDecimal expectedAmount = (KualiDecimal)adjusteeNahFinancialDocumentLineAmount.subtract((AbstractKualiDecimal)adjustmentNahFinancialDocumentLineAmount);
                GeneralLedgerPendingEntry actualDebit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
                Assertions.assertEquals((Object)"D", (Object)actualDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)actualDebit.getAccountNumber());
                Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)actualDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"unappliedObjectCode", (Object)actualDebit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"unappliedObjectTypeCode", (Object)actualDebit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualDebit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualDebit.getProjectCode());
                Assertions.assertEquals((Object)"unappliedSubAccountNumber", (Object)actualDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)expectedAmount, (Object)actualDebit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualDebit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)actualDebit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)actualDebit.getUniversityFiscalYear());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualDebit.getTransactionLedgerEntrySequenceNumber());
                GeneralLedgerPendingEntry offsetCredit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
                Assertions.assertEquals((Object)"C", (Object)offsetCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)offsetCredit.getAccountNumber());
                Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)offsetCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectCode", (Object)offsetCredit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectFinancialObjectTypeCode", (Object)offsetCredit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetCredit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetCredit.getProjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)expectedAmount, (Object)offsetCredit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetCredit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)offsetCredit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)offsetCredit.getUniversityFiscalYear());
                Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetCredit.getTransactionLedgerEntrySequenceNumber());
            }

            @Test
            void removed() throws Exception {
                Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
                String adjusteeNahCustomerNumber = "CN1";
                KualiDecimal adjusteeNahFinancialDocumentLineAmount = new KualiDecimal(3);
                NonAppliedHolding adjusteeNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
                Mockito.when((Object)adjusteeNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
                Mockito.when((Object)adjusteeNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjusteeNahFinancialDocumentLineAmount);
                List<NonAppliedHolding> adjusteeNonAppliedHoldings = List.of(adjusteeNonAppliedHoldingMock);
                DocumentHeader adjusteeDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
                Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
                Mockito.when((Object)adjusteeDocumentMock.getDocumentHeader()).thenReturn((Object)adjusteeDocumentHeaderMock);
                String initiatorChartOfAccountsCode = "initiatorChartOfAccountsCode";
                String initiatorOrganizationCode = "initiatorOrganizationCode";
                Account universityClearingAccountMock = (Account)Mockito.mock(Account.class);
                String universityClearingAccountNumber = "universityClearingAccountNumber";
                String universityClearingAccountChartOfAccounts = "universityClearingAccountChartOfAccounts";
                String unappliedSubAccountNumber = "unappliedSubAccountNumber";
                String unappliedObjectCode = "unappliedObjectCode";
                String unappliedObjectTypeCode = "unappliedObjectTypeCode";
                CreatePendingEntries.this.setupSystemInformationMockingForAdjusteeDocumentInitiator(adjusteeDocumentHeaderMock, "initiatorChartOfAccountsCode", "initiatorOrganizationCode", universityClearingAccountMock, "universityClearingAccountNumber", "universityClearingAccountChartOfAccounts", "unappliedSubAccountNumber", "unappliedObjectCode", "unappliedObjectTypeCode", null, currentYear);
                String offsetDefinitionFinancialObjectFinancialObjectTypeCode = "offsetDefinitionFinancialObjectFinancialObjectTypeCode";
                String offsetDefinitionFinancialObjectCode = "offsetDefinitionFinancialObjectCode";
                CreatePendingEntries.this.setupOffsetDefinitionMocking("offsetDefinitionFinancialObjectFinancialObjectTypeCode", "offsetDefinitionFinancialObjectCode", currentYear, "universityClearingAccountChartOfAccounts", CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List adjustmentNonAppliedHoldings = List.of();
                String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
                String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
                DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
                Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
                Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
                PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
                Mockito.when((Object)adjustmentDocumentMock.getNonAppliedHoldings()).thenReturn(adjustmentNonAppliedHoldings);
                Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
                int initialSequenceNumber = 1;
                GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
                CreatePendingEntries.this.setupStubbingForSequenceHelper(sequenceHelperMock, initialSequenceNumber);
                CreatePendingEntries.this.setupStubbingForDataDictionaryService(CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE);
                List pendingEntries = this.localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, adjustmentDocumentMock, currentYear, sequenceHelperMock);
                Assertions.assertEquals((int)2, (int)pendingEntries.size());
                GeneralLedgerPendingEntry actualDebit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
                Assertions.assertEquals((Object)"D", (Object)actualDebit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)actualDebit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)actualDebit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)actualDebit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualDebit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)actualDebit.getAccountNumber());
                Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)actualDebit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"unappliedObjectCode", (Object)actualDebit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"unappliedObjectTypeCode", (Object)actualDebit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualDebit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)actualDebit.getProjectCode());
                Assertions.assertEquals((Object)"unappliedSubAccountNumber", (Object)actualDebit.getSubAccountNumber());
                Assertions.assertEquals((Object)adjusteeNahFinancialDocumentLineAmount, (Object)actualDebit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualDebit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)actualDebit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)actualDebit.getUniversityFiscalYear());
                Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualDebit.getTransactionLedgerEntrySequenceNumber());
                GeneralLedgerPendingEntry offsetCredit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
                Assertions.assertEquals((Object)"C", (Object)offsetCredit.getTransactionDebitCreditCode());
                Assertions.assertEquals((Object)"AC", (Object)offsetCredit.getFinancialBalanceTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.APPA_DOCUMENT_TYPE_CODE, (Object)offsetCredit.getFinancialDocumentTypeCode());
                Assertions.assertEquals((Object)"01", (Object)offsetCredit.getFinancialSystemOriginationCode());
                Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetCredit.getOrganizationDocumentNumber());
                Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)offsetCredit.getAccountNumber());
                Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)offsetCredit.getChartOfAccountsCode());
                Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectCode", (Object)offsetCredit.getFinancialObjectCode());
                Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectFinancialObjectTypeCode", (Object)offsetCredit.getFinancialObjectTypeCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetCredit.getFinancialSubObjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetCredit.getProjectCode());
                Assertions.assertEquals((Object)CreatePendingEntries.DASH, (Object)offsetCredit.getSubAccountNumber());
                Assertions.assertEquals((Object)adjusteeNahFinancialDocumentLineAmount, (Object)offsetCredit.getTransactionLedgerEntryAmount());
                Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetCredit.getTransactionLedgerEntryDescription());
                Assertions.assertNull((Object)offsetCredit.getUniversityFiscalPeriodCode());
                Assertions.assertEquals((Integer)currentYear, (Integer)offsetCredit.getUniversityFiscalYear());
                Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetCredit.getTransactionLedgerEntrySequenceNumber());
            }
        }
    }
}

