/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.service.MilestoneScheduleMaintenanceService;
import org.kuali.kfs.module.ar.document.validation.MilestoneScheduleRule;
import org.kuali.kfs.module.ar.service.impl.AccountsReceivableModuleBillingServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class MilestoneScheduleRuleTest {
    private static final String CHART_CODE = "BL";
    private static final String ACCT_NUM = "1234567";
    private static final String PROPOSAL_NUM = "1";
    @Spy
    private MilestoneScheduleRule cutSpy = new MilestoneScheduleRule();
    @Mock(stubOnly=true)
    private AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock;
    @Mock(stubOnly=true)
    private ContractsAndGrantsBillingAward awardMock;
    @Mock(stubOnly=true)
    private ContractsAndGrantsBillingAwardAccount awardAccountMock;
    @Mock(stubOnly=true)
    private DictionaryValidationService dictionaryValidationSvcMock;
    @Mock(stubOnly=true)
    private MaintenanceDocument milestoneScheduleMaintDocMock;
    @Mock(stubOnly=true)
    private Milestone milestone1Mock;
    @Mock(stubOnly=true)
    private Milestone milestone2Mock;
    @Mock(stubOnly=true)
    private MilestoneSchedule milestoneScheduleMock;
    @Mock(stubOnly=true)
    private MilestoneScheduleMaintenanceService milestoneScheduleMaintenanceSvcMock;

    MilestoneScheduleRuleTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().getErrorMessages().clear();
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.milestone1Mock);
        milestones.add(this.milestone2Mock);
        Mockito.when((Object)this.milestoneScheduleMock.getMilestones()).thenReturn(milestones);
    }

    void additionalSetup() {
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)this.awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(this.awardAccountMock));
        Mockito.when((Object)this.awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.milestoneScheduleMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.milestoneScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.milestoneScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.milestoneScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((MilestoneScheduleRule)Mockito.doReturn((Object)this.accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        this.cutSpy.newMilestoneScheduleCopy = this.milestoneScheduleMock;
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Milestone.class))).thenReturn((Object)new DictionaryValidationResult());
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
    }

    @AfterEach
    void tearDown() {
        this.cutSpy.setDictionaryValidationService(null);
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    private void setupMilestoneMocks() {
        MilestoneScheduleRuleTest.setupMilestoneMock(this.milestone1Mock, "test*1");
        MilestoneScheduleRuleTest.setupMilestoneMock(this.milestone2Mock, "test*2");
    }

    private static void setupMilestoneMock(Milestone milestoneMock, String milestoneNumber) {
        Mockito.when((Object)milestoneMock.getMilestoneNumber()).thenReturn((Object)milestoneNumber);
        Mockito.when((Object)milestoneMock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)milestoneMock.isActive()).thenReturn((Object)true);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_Valid() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomAddCollectionLineBusinessRules_Valid(@Mock(stubOnly=true) Milestone newMilestoneMock) {
        this.cutSpy.newMilestoneScheduleCopy = this.milestoneScheduleMock;
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        Mockito.when((Object)this.milestone1Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)this.milestone2Mock.getMilestoneNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)newMilestoneMock.getMilestoneNumber()).thenReturn((Object)"test*3");
        Assertions.assertTrue((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Milestones", (PersistableBusinessObject)newMilestoneMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomAddCollectionLineBusinessRules_DuplicateMilestoneNumber(@Mock(stubOnly=true) Milestone newMilestoneMock) {
        this.cutSpy.newMilestoneScheduleCopy = this.milestoneScheduleMock;
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        Mockito.when((Object)this.milestone1Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)newMilestoneMock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Assertions.assertFalse((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Milestones", (PersistableBusinessObject)newMilestoneMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.Milestones")).get(0);
        Assertions.assertEquals((Object)"error.duplicate.milestone.number", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)0, (int)messageParameters.length);
    }

    @Test
    void processCustomAddCollectionLineBusinessRules_ActualCompletionDateInFuture(@Mock(stubOnly=true) Milestone newMilestoneMock) {
        this.cutSpy.newMilestoneScheduleCopy = this.milestoneScheduleMock;
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        Mockito.when((Object)this.milestone1Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)this.milestone2Mock.getMilestoneNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)newMilestoneMock.getMilestoneNumber()).thenReturn((Object)"test*3");
        Mockito.when((Object)newMilestoneMock.getMilestoneActualCompletionDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Milestones", (PersistableBusinessObject)newMilestoneMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.Milestones")).get(0);
        Assertions.assertEquals((Object)"error.milestone.actual.completion.date.in.future", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)0, (int)messageParameters.length);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillingFrequencyNotMilestone() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup")).get(0);
        Assertions.assertEquals((Object)"error.cg.award.milestone.schedule.incorrect.billing.frequency", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_DuplicateMilestoneNumbers_OneCopiedToInvoice() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        ((MilestoneScheduleRule)Mockito.doReturn((Object)this.milestoneScheduleMaintenanceSvcMock).when((Object)this.cutSpy)).getMilestoneScheduleMaintenanceService();
        Mockito.when((Object)this.milestone2Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        String errorPath = "milestones[1].milestoneNumber";
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.milestones[1].milestoneNumber")).get(0);
        Assertions.assertEquals((Object)"error.duplicate.milestone.number", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_DuplicateMilestoneNumbers_NoneCopiedToInvoice() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        ((MilestoneScheduleRule)Mockito.doReturn((Object)this.milestoneScheduleMaintenanceSvcMock).when((Object)this.cutSpy)).getMilestoneScheduleMaintenanceService();
        Mockito.when((Object)this.milestone2Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        String errorPath = "milestones[0].milestoneNumber";
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assertions.assertEquals((Object)"error.duplicate.milestone.number", (Object)errorMessage.getErrorKey());
        errorPath = "milestones[1].milestoneNumber";
        errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assertions.assertEquals((Object)"error.duplicate.milestone.number", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneAmountGreaterThanAwardAmount_CurrentSchedule() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.milestone1Mock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.totalScheduledAccount");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.milestone.total.exceeds.award.total", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneInactiveWithLargeAmount_CurrentSchedule() {
        this.additionalSetup();
        Mockito.when((Object)this.milestone1Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)this.milestone1Mock.isActive()).thenReturn((Object)true);
        MilestoneScheduleRuleTest.setupMilestoneMock(this.milestone2Mock, "test*2");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.milestone1Mock.isActive()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneAmountGreaterThanAwardAmount_AllSchedules() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        Mockito.when((Object)this.milestone1Mock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(5000.0));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.totalScheduledAccount");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.milestone.total.exceeds.award.total", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneInactiveWithLargeAmount_AllSchedules() {
        this.additionalSetup();
        Mockito.when((Object)this.milestone1Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)this.milestone1Mock.isActive()).thenReturn((Object)true);
        MilestoneScheduleRuleTest.setupMilestoneMock(this.milestone2Mock, "test*2");
        Mockito.when((Object)this.milestone1Mock.isActive()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneWithNullAmount() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        Mockito.when((Object)this.milestone1Mock.getMilestoneAmount()).thenReturn(null);
        Mockito.when((Object)this.milestone1Mock.isActive()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_ChartAccountDoesNotExistOnAward() {
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)this.awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(this.awardAccountMock));
        Mockito.when((Object)this.awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.milestoneScheduleMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.milestoneScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.milestoneScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.milestoneScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        ((MilestoneScheduleRule)Mockito.doReturn((Object)this.accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        this.cutSpy.newMilestoneScheduleCopy = this.milestoneScheduleMock;
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Milestone.class))).thenReturn((Object)new DictionaryValidationResult());
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        this.setupMilestoneMocks();
        Mockito.when((Object)this.milestoneScheduleMock.getAccountNumber()).thenReturn((Object)"9876543");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, "9876543")).thenReturn((Object)KualiDecimal.ZERO);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.accountNumber");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.milestone.schedule.account.does.not.exist.on.award", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_AwardDoesNotExist_NullAward() {
        Mockito.when((Object)this.milestoneScheduleMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.milestoneScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        this.cutSpy.newMilestoneScheduleCopy = this.milestoneScheduleMock;
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Milestone.class))).thenReturn((Object)new DictionaryValidationResult());
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        Mockito.when((Object)this.milestone1Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)this.milestone2Mock.getMilestoneNumber()).thenReturn((Object)"test*2");
        Mockito.when((Object)this.milestoneScheduleMock.getAward()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.award.does.not.exist", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_AwardDoesNotExist_NullProposalNumber() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.award.does.not.exist", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_ActualCompletionDateInFuture() {
        this.additionalSetup();
        this.setupMilestoneMocks();
        Mockito.when((Object)this.milestone2Mock.getMilestoneActualCompletionDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.milestones[1].milestoneActualCompletionDate");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.milestone.actual.completion.date.in.future", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)0, (int)messageParameters.length);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillFailsDataDictionaryValidation(@Mock(stubOnly=true) DictionaryValidationResult dictionaryValidationResultMock) {
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)this.awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(this.awardAccountMock));
        Mockito.when((Object)this.awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.milestoneScheduleMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.milestoneScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.milestoneScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.milestoneScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((MilestoneScheduleRule)Mockito.doReturn((Object)this.accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        this.cutSpy.newMilestoneScheduleCopy = this.milestoneScheduleMock;
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        this.setupMilestoneMocks();
        Mockito.when((Object)dictionaryValidationResultMock.getNumberOfErrors()).thenReturn((Object)1);
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Milestone.class))).thenReturn((Object)dictionaryValidationResultMock);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
    }
}

