/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.rules.DocumentRuleBase;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsCollectionActivityInvoiceDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsCollectionActivityDocument;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsCollectionActivityDocumentRule;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsCollectionActivityDocumentRuleTest {
    private static final String ERROR_KEY_PREFIX = "document.";
    private static final String ACTIVITY_CODE = "LSTS";
    private ContractsGrantsCollectionActivityDocumentRule cut;
    private ContractsGrantsCollectionActivityDocument contractsGrantsCollectionActivityDocument;

    ContractsGrantsCollectionActivityDocumentRuleTest() {
    }

    @BeforeEach
    void setUp(@Mock(stubOnly=true) DocumentHeaderService documentHeaderServiceMock) {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.cut = (ContractsGrantsCollectionActivityDocumentRule)Mockito.spy((Object)new ContractsGrantsCollectionActivityDocumentRule());
            this.contractsGrantsCollectionActivityDocument = new ContractsGrantsCollectionActivityDocument();
        }
        this.contractsGrantsCollectionActivityDocument.getDocumentHeader().setDocumentDescription("Testing document");
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validateCollectionActivityDocument_Valid_True() {
        this.contractsGrantsCollectionActivityDocument.setProposalNumber("11");
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        ArrayList<ContractsGrantsCollectionActivityInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsCollectionActivityInvoiceDetail>();
        ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
        invoiceDetails.add(invoiceDetail);
        this.contractsGrantsCollectionActivityDocument.setInvoiceDetails(invoiceDetails);
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assertions.assertTrue((boolean)result);
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validateCollectionActivityDocument_Invalid_False(@Mock(stubOnly=true) DataDictionaryService dataDictionaryServiceMock) {
        ContractsGrantsCollectionActivityDocumentRuleTest.setupDataDictionaryService(dataDictionaryServiceMock);
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assertions.assertFalse((boolean)result);
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)2, (int)errorMessages.size());
        AutoPopulatingList proposalNumberErrorMessages = (AutoPopulatingList)errorMessages.get("document.proposalNumber");
        ErrorMessage errorMessage = (ErrorMessage)proposalNumberErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.required", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Proposal Number", (Object)errorMessage.getMessageParameters()[0]);
        AutoPopulatingList invoiceDetailsErrorMessages = (AutoPopulatingList)errorMessages.get("document.invoiceDetails");
        ErrorMessage errorMessage1 = (ErrorMessage)invoiceDetailsErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.collectionActvity.noInvoiceSelected", (Object)errorMessage1.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage1.getMessageParameters().length);
    }

    private static void setupDataDictionaryService(DataDictionaryService dataDictionaryServiceMock) {
        Mockito.when((Object)dataDictionaryServiceMock.getAttributeLabel(ContractsGrantsCollectionActivityDocument.class, "proposalNumber")).thenReturn((Object)"Proposal Number");
        DocumentRuleBase.setDataDictionaryService((DataDictionaryService)dataDictionaryServiceMock);
    }

    @Test
    void validateCollectionActivityDocument_missingProposalNumber_False(@Mock(stubOnly=true) DataDictionaryService dataDictionaryServiceMock) {
        ContractsGrantsCollectionActivityDocumentRuleTest.setupDataDictionaryService(dataDictionaryServiceMock);
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        ArrayList<ContractsGrantsCollectionActivityInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsCollectionActivityInvoiceDetail>();
        ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
        invoiceDetails.add(invoiceDetail);
        this.contractsGrantsCollectionActivityDocument.setInvoiceDetails(invoiceDetails);
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assertions.assertFalse((boolean)result);
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        AutoPopulatingList proposalNumberErrorMessages = (AutoPopulatingList)errorMessages.get("document.proposalNumber");
        ErrorMessage errorMessage = (ErrorMessage)proposalNumberErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.required", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Proposal Number", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void validateCollectionActivityDocument__missingInvoiceDetails_False() {
        this.contractsGrantsCollectionActivityDocument.setProposalNumber("11");
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assertions.assertFalse((boolean)result);
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        AutoPopulatingList invoiceDetailsErrorMessages = (AutoPopulatingList)errorMessages.get("document.invoiceDetails");
        ErrorMessage errorMessage1 = (ErrorMessage)invoiceDetailsErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.collectionActvity.noInvoiceSelected", (Object)errorMessage1.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage1.getMessageParameters().length);
    }
}

