/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsInvoiceDocumentValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedRouteDocumentEvent;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsInvoiceDocumentValidationTest {
    private static final String STD_INVOICE_TEMPLATE = "STD";
    private ContractsGrantsInvoiceDocumentValidation cut;

    ContractsGrantsInvoiceDocumentValidationTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cut = new ContractsGrantsInvoiceDocumentValidation();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_HasOneTransmissionDetailToSend_HasTemplate_VALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    private static void setupContractsGrantsInvoiceDocument(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, InvoiceAddressDetail invoiceAddressDetailMock, InvoiceGeneralDetail invoiceGeneralDetailMock) {
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(Collections.singletonList(invoiceAddressDetailMock));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
    }

    @Test
    void validate_HasOneTransmissionQueued_HasTemplate_VALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)invoiceAddressDetailMock.isQueued()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_HasOneTransmissionSent_HasTemplate_VALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)invoiceAddressDetailMock.isSent()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_HasNoneQueuedSentOrToSend_HasTemplate_INVALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.invoiceAddressDetails[0].sendIndicator");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.one.transmission.detail.queue.required", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validate_HasNoneQueuedSentOrToSend_HasTemplate_CorrectionDoc_VALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock) {
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_HasOneTransmissionDetailToSend_NoTemplate_INVALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.invoiceGeneralDetail.customerInvoiceTemplateCode");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.contractsGrantsInvoice.template.code.required", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validate_HasOneTransmissionDetailToSend_NoTemplate_CorrectionDoc_VALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock) {
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_RouteEvent_NoAccountingLines_VALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)contractsGrantsInvoiceDocumentMock)));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_RouteEvent_NoIncomeObjectCode_INVALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setAccountsReceivableObjectCode("8118");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(Collections.singletonList(customerInvoiceDetail));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)contractsGrantsInvoiceDocumentMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.submission.missing.cgbi.object.code");
    }

    @Test
    void validate_RouteEvent_NoReceivableObjectCode_INVALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setFinancialObjectCode("5000");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(Collections.singletonList(customerInvoiceDetail));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)contractsGrantsInvoiceDocumentMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.submission.missing.cgbi.object.code");
    }

    @Test
    void validate_HasIncomeAndReceivableObjectCodes_VALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setFinancialObjectCode("5000");
        customerInvoiceDetail.setAccountsReceivableObjectCode("8118");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(Collections.singletonList(customerInvoiceDetail));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)contractsGrantsInvoiceDocumentMock)));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validate_RouteEvent_InvoiceTotalZero_INVALID(@Mock(stubOnly=true) ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock, @Mock(stubOnly=true) InvoiceAddressDetail invoiceAddressDetailMock, @Mock(stubOnly=true) InvoiceGeneralDetail invoiceGeneralDetailMock) {
        ContractsGrantsInvoiceDocumentValidationTest.setupContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock, invoiceAddressDetailMock, invoiceGeneralDetailMock);
        this.cut.setContractsGrantsInvoiceDocument(contractsGrantsInvoiceDocumentMock);
        this.cut.setContractsGrantsInvoiceDocumentService(contractsGrantsInvoiceDocumentServiceMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentServiceMock.getInvoiceMilestoneTotal((ContractsGrantsInvoiceDocument)ArgumentMatchers.any(ContractsGrantsInvoiceDocument.class))).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)contractsGrantsInvoiceDocumentServiceMock.getBillAmountTotal((ContractsGrantsInvoiceDocument)ArgumentMatchers.any(ContractsGrantsInvoiceDocument.class))).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setFinancialObjectCode("5000");
        customerInvoiceDetail.setAccountsReceivableObjectCode("8118");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(Collections.singletonList(customerInvoiceDetail));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)contractsGrantsInvoiceDocumentMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        GlobalVariables.getMessageMap().containsMessageKey("error.document.contractsGrantsInvoice.invoice.total.amount.invalid");
    }
}

