/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.rules.DocumentRuleBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsInvoiceObjectCodeRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsInvoiceObjectCodeRuleTest {
    private static final String BL_CHART = "BL";
    private ContractsGrantsInvoiceObjectCodeRule cut;
    private ContractsGrantsInvoiceObjectCode contractsGrantsInvoiceObjectCode;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;

    ContractsGrantsInvoiceObjectCodeRuleTest() {
    }

    @BeforeEach
    void setUp() {
        this.contractsGrantsInvoiceObjectCode = new ContractsGrantsInvoiceObjectCode();
        this.contractsGrantsInvoiceObjectCode.setChartOfAccountsCode(BL_CHART);
        this.contractsGrantsInvoiceObjectCode.setUniversityFiscalYear(Integer.valueOf(2017));
        this.cut = new ContractsGrantsInvoiceObjectCodeRule();
        this.cut.setBoService(this.businessObjectSvcMock);
        DocumentRuleBase.setDataDictionaryService((DataDictionaryService)this.dataDictionarySvcMock);
        this.cut.cgiObjectCode = this.contractsGrantsInvoiceObjectCode;
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterAll
    static void tearDown() {
        DocumentRuleBase.setDataDictionaryService(null);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void checkFundFields_noFundFields_Invalid() {
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.one.fund.field.required"));
    }

    @Test
    void checkFundFields_uniqueFundGroupCode_Valid() {
        this.contractsGrantsInvoiceObjectCode.setFundGroupCode("CG");
        Assertions.assertTrue((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkFundFields_uniqueSubFundGroupCode_Valid() {
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupCode("FEDERA");
        Assertions.assertTrue((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkFundFields_uniqueSubFundGroupTypeCode_Valid() {
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupTypeCode("S");
        Assertions.assertTrue((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkFundFields_duplicateFundGroupCode_Invalid() {
        this.contractsGrantsInvoiceObjectCode.setFundGroupCode("CG");
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("fundGroupCode", "CG");
        criteria.put("universityFiscalYear", 2017);
        criteria.put("chartOfAccountsCode", BL_CHART);
        criteria.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.countMatching(ContractsGrantsInvoiceObjectCode.class, criteria, new HashMap())).thenReturn((Object)1);
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.code.already.used"));
    }

    @Test
    void checkFundFields_duplicateSubFundGroupCode_Invalid() {
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupCode("FEDERA");
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("subFundGroupCode", "FEDERA");
        criteria.put("chartOfAccountsCode", BL_CHART);
        criteria.put("universityFiscalYear", 2017);
        criteria.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.countMatching(ContractsGrantsInvoiceObjectCode.class, criteria, new HashMap())).thenReturn((Object)1);
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.code.already.used"));
    }

    @Test
    void checkFundFields_duplicateSubFundGroupTypeCode_Invalid() {
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupTypeCode("S");
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("subFundGroupTypeCode", "S");
        criteria.put("chartOfAccountsCode", BL_CHART);
        criteria.put("universityFiscalYear", 2017);
        criteria.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.countMatching(ContractsGrantsInvoiceObjectCode.class, criteria, new HashMap())).thenReturn((Object)1);
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.code.already.used"));
    }

    @Test
    void checkFundFields_multipleFundFields_FundGroupCodeAndSubFundGroupCode_Invalid() {
        this.contractsGrantsInvoiceObjectCode.setFundGroupCode("CG");
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupCode("FEDERA");
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.only.one.fund.field.allowed"));
    }

    @Test
    void checkFundFields_multipleFundFields_FundGroupCodeAndSubFundGroupTypeCode_Invalid() {
        this.contractsGrantsInvoiceObjectCode.setFundGroupCode("CG");
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupTypeCode("S");
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.only.one.fund.field.allowed"));
    }

    @Test
    void checkFundFields_multipleFundFields_SubFundGroupCodeAndSubFundGroupTypeCode_Invalid() {
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupCode("FEDERA");
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupTypeCode("S");
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.only.one.fund.field.allowed"));
    }

    @Test
    void checkFundFields_multipleFundFields_AllThree_Invalid() {
        this.contractsGrantsInvoiceObjectCode.setFundGroupCode("CG");
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupCode("FEDERA");
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupTypeCode("S");
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.only.one.fund.field.allowed"));
    }

    @Test
    void checkFundFields_multipleFundFields_DuplicateFundGroupCodeAndUnniqueSubFundGroupCode_Invalid() {
        this.contractsGrantsInvoiceObjectCode.setFundGroupCode("CG");
        this.contractsGrantsInvoiceObjectCode.setSubFundGroupCode("FEDERA");
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("fundGroupCode", "CG");
        criteria.put("chartOfAccountsCode", BL_CHART);
        criteria.put("universityFiscalYear", 2017);
        criteria.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.countMatching(ContractsGrantsInvoiceObjectCode.class, criteria, new HashMap())).thenReturn((Object)1);
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.only.one.fund.field.allowed"));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.code.already.used"));
    }

    @Test
    void checkFundFields_uniqueFundGroupCode_AlreadyExists_Valid() {
        this.contractsGrantsInvoiceObjectCode.setFundGroupCode("CG");
        this.contractsGrantsInvoiceObjectCode.setInvoiceObjectCodeIdentifier(Long.valueOf(1L));
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("fundGroupCode", "CG");
        criteria.put("chartOfAccountsCode", BL_CHART);
        criteria.put("universityFiscalYear", 2017);
        criteria.put("active", true);
        Map<String, Long> negativeCriteria = Collections.singletonMap("invoiceObjectCodeIdentifier", 1L);
        Mockito.when((Object)this.businessObjectSvcMock.countMatching(ContractsGrantsInvoiceObjectCode.class, criteria, negativeCriteria)).thenReturn((Object)1);
        Assertions.assertFalse((boolean)this.cut.checkFundFields());
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.object.code.already.used"));
    }
}

