/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableTaxService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.impl.CustomerInvoiceDetailServiceImpl;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailDiscountGreaterThanParentValidation;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerInvoiceDetailDiscountGreaterThanParentValidationTest {
    private CustomerInvoiceDetailDiscountGreaterThanParentValidation cut;

    CustomerInvoiceDetailDiscountGreaterThanParentValidationTest() {
    }

    @BeforeEach
    void setUp() {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            CustomerInvoiceDocument customerInvoiceDocument = new CustomerInvoiceDocument();
            CustomerInvoiceDetailServiceImpl customerInvoiceDetailService = new CustomerInvoiceDetailServiceImpl();
            customerInvoiceDetailService.setAccountsReceivableTaxService((AccountsReceivableTaxService)Mockito.mock(AccountsReceivableTaxService.class));
            this.cut = new CustomerInvoiceDetailDiscountGreaterThanParentValidation();
            this.cut.setCustomerInvoiceDetailService((CustomerInvoiceDetailService)customerInvoiceDetailService);
            this.cut.setCustomerInvoiceDocument(customerInvoiceDocument);
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void discountAmountNotGreaterThanParentAmount() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            this.cut.setDiscountCustomerInvoiceDetail(CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail());
            this.cut.getDiscountCustomerInvoiceDetail().setParentDiscountCustomerInvoiceDetail(CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail());
            Assertions.assertTrue((boolean)this.cut.validate(null));
        }
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void discountAmountGreaterThanParentAmount() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            this.cut.setDiscountCustomerInvoiceDetail(CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail());
            this.cut.getDiscountCustomerInvoiceDetail().setParentDiscountCustomerInvoiceDetail(CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail());
            Assertions.assertFalse((boolean)this.cut.validate(null));
        }
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.discountAmountGreaterThanParentAmount"));
    }
}

