/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceItemCode;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceItemCodeRule;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleIntegTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceItemCodeRuleIntegTest
extends MaintenanceRuleIntegTestBase {
    private CustomerInvoiceItemCode cut;
    private static String CHART_CODE = "BA";
    private static String POSITIVE_VALUE = "1";
    private static String NON_POSITIVE_VALUE = "0";

    protected void setUp() throws Exception {
        super.setUp();
        this.cut = new CustomerInvoiceItemCode();
        this.cut.setChartOfAccountsCode(CHART_CODE);
        String ORGANIZATION_CODE = "ACAC";
        this.cut.setOrganizationCode(ORGANIZATION_CODE);
        String INVOICE_ITEM_CODE = "TRE";
        this.cut.setInvoiceItemCode(INVOICE_ITEM_CODE);
        String INVOICE_ITEM_DESCRIPTION = "TEST";
        this.cut.setInvoiceItemDescription(INVOICE_ITEM_DESCRIPTION);
        boolean ACTIVE_INDEX = true;
        this.cut.setActive(ACTIVE_INDEX);
    }

    public void testIsCustomerInvoiceItemCodeObjectValid_True() {
        String INCOME_OBJECT_CODE = "0110";
        this.cut.setDefaultInvoiceFinancialObjectCode(INCOME_OBJECT_CODE);
        this.cut.setDefaultInvoiceChartOfAccountsCode(CHART_CODE);
        this.cut.refreshReferenceObject("defaultInvoiceFinancialObject");
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.cut), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.isCustomerInvoiceItemCodeObjectValid(this.cut);
        CustomerInvoiceItemCodeRuleIntegTest.assertTrue((String)("When default invoice financial  is " + INCOME_OBJECT_CODE + ", isDefaultInvoiceFinancialObjectValidIncome should return true. "), (boolean)result);
    }

    public void testIsCustomerInvoiceItemCodeObjectValid_False() {
        String EXPENSE_OBJECT_CODE = "2000";
        this.cut.setDefaultInvoiceFinancialObjectCode(EXPENSE_OBJECT_CODE);
        this.cut.setDefaultInvoiceChartOfAccountsCode(CHART_CODE);
        this.cut.refreshReferenceObject("defaultInvoiceFinancialObject");
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.cut), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.isCustomerInvoiceItemCodeObjectValid(this.cut);
        CustomerInvoiceItemCodeRuleIntegTest.assertFalse((String)("When default invoice financial  is " + EXPENSE_OBJECT_CODE + ", isDefaultInvoiceFinancialObjectValidIncome should return false. "), (boolean)result);
    }

    public void testValidateItemDefaultPrice_True() {
        this.cut.setItemDefaultPrice(new KualiDecimal(POSITIVE_VALUE));
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.cut), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.validateItemDefaultPrice(this.cut);
        CustomerInvoiceItemCodeRuleIntegTest.assertTrue((String)("When item default price is " + POSITIVE_VALUE + ", validateItemDefaultPrice should return true. "), (boolean)result);
    }

    public void testValidateItemDefaultPrice_False() {
        this.cut.setItemDefaultPrice(new KualiDecimal(NON_POSITIVE_VALUE));
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.cut), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.validateItemDefaultPrice(this.cut);
        CustomerInvoiceItemCodeRuleIntegTest.assertFalse((String)("When item default price is " + NON_POSITIVE_VALUE + ", validateItemDefaultPrice should return false. "), (boolean)result);
    }

    public void testValidItemDefaultQuantity_True() {
        this.cut.setItemDefaultQuantity(new BigDecimal(POSITIVE_VALUE));
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.cut), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.validateItemDefaultQuantity(this.cut);
        CustomerInvoiceItemCodeRuleIntegTest.assertTrue((String)("When item default quantity is " + POSITIVE_VALUE + ", validItemDefaultQuantity should return true. "), (boolean)result);
    }

    public void testValidItemDefaultQuantity_False() {
        this.cut.setItemDefaultQuantity(new BigDecimal(NON_POSITIVE_VALUE));
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.cut), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.validateItemDefaultQuantity(this.cut);
        CustomerInvoiceItemCodeRuleIntegTest.assertFalse((String)("When item default quantity is " + NON_POSITIVE_VALUE + ", validateItemDefaultQuantity should return false. "), (boolean)result);
    }
}

