/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerType;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerTypeRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerTypeRuleTest {
    private static final String CUSTOMER_TYPE_CODE = "XY";
    private static final String CUSTOMER_TYPE_DESC_FEDERAL = "Federal";
    private CustomerTypeRule cut;
    private CustomerType customerType;
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    CustomerTypeRuleTest() {
    }

    @BeforeEach
    void setUp() {
        this.setupExistingCustomerType();
        this.cut = new CustomerTypeRule();
        this.cut.setBoService(this.businessObjectSvcMock);
        this.customerType = new CustomerType();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupExistingCustomerType() {
        CustomerType customerType = new CustomerType();
        customerType.setCustomerTypeCode("01");
        customerType.setCustomerTypeDescription(CUSTOMER_TYPE_DESC_FEDERAL);
        List<CustomerType> customerTypes = List.of(customerType);
        Mockito.when((Object)this.businessObjectSvcMock.findAll(CustomerType.class)).thenReturn(customerTypes);
    }

    @Test
    void validateCustomerTypeDescription_DoesNotExist() {
        this.customerType.setCustomerTypeCode(CUSTOMER_TYPE_CODE);
        String CUSTOMER_TYPE_DESC_MISC = "Whatever";
        this.customerType.setCustomerTypeDescription(CUSTOMER_TYPE_DESC_MISC);
        boolean result = this.cut.validateCustomerTypeDescription(this.customerType);
        Assertions.assertTrue((boolean)result, (String)("When customer type desc is " + CUSTOMER_TYPE_DESC_MISC + ", validateCustomerTypeDescription should return true."));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validateCustomerTypeDescription_AlreadyExists() {
        this.customerType.setCustomerTypeCode(CUSTOMER_TYPE_CODE);
        this.customerType.setCustomerTypeDescription(CUSTOMER_TYPE_DESC_FEDERAL);
        boolean result = this.cut.validateCustomerTypeDescription(this.customerType);
        Assertions.assertFalse((boolean)result, (String)"When customer type desc is Federal, validateCustomerTypeDescription should return false.");
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerType.duplicateValue"));
    }
}

