/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsLetterOfCreditFund;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.LetterOfCreditRemainingAmountSuspensionCategory;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class LetterOfCreditRemainingAmountSuspensionCategoryTest {
    private LetterOfCreditRemainingAmountSuspensionCategory cut;
    @Mock
    private ContractsAndGrantsBillingAward awardMock;
    @Mock
    private ContractsGrantsInvoiceDocument contractGrantsInvoiceDocMock;
    @Mock
    private InvoiceGeneralDetail invoiceGeneralDetailMock;

    LetterOfCreditRemainingAmountSuspensionCategoryTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.contractGrantsInvoiceDocMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailMock);
        this.cut = new LetterOfCreditRemainingAmountSuspensionCategory();
    }

    @Test
    void shouldSuspend_isNotLetterOfCredit_false() {
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractGrantsInvoiceDocMock));
    }

    @ParameterizedTest(name="With a total amount billed to date of 100 and letter of credit fund amount of {0}, expect to have {1} returned.")
    @MethodSource(value={"shouldSuspendArgs"})
    void shouldSuspend_isLetterOfCredit(KualiDecimal letterOfCreditFundAmount, boolean expected) {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getTotalAmountBilledToDate()).thenReturn((Object)new KualiDecimal(100));
        ContractsAndGrantsLetterOfCreditFund letterOfCreditFundMock = (ContractsAndGrantsLetterOfCreditFund)Mockito.mock(ContractsAndGrantsLetterOfCreditFund.class);
        Mockito.when((Object)letterOfCreditFundMock.getLetterOfCreditFundAmount()).thenReturn((Object)letterOfCreditFundAmount);
        Mockito.when((Object)this.awardMock.getLetterOfCreditFund()).thenReturn((Object)letterOfCreditFundMock);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Assertions.assertEquals((Object)expected, (Object)this.cut.shouldSuspend(this.contractGrantsInvoiceDocMock));
    }

    private static Stream<Arguments> shouldSuspendArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{new KualiDecimal(200), false}), Arguments.of((Object[])new Object[]{new KualiDecimal(100), false}), Arguments.of((Object[])new Object[]{KualiDecimal.ZERO, true}));
    }
}

