/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectTypeService;
import org.kuali.kfs.coa.service.impl.ObjectTypeServiceImpl;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.validation.impl.OrganizationAccountingDefaultRule;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class OrganizationAccountingDefaultRuleTest {
    private static final int FISCAL_YEAR = 2018;
    private static final String EXPENSE_OBJECT_CODE = "3310";
    private static final String INCOME_OBJECT_CODE = "0776";
    private static final String LIABILITY_OBJECT_CODE = "9400";
    private OrganizationAccountingDefaultRule cut;
    private OrganizationAccountingDefault organizationAccountingDefault;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    private ObjectCode incomeObjectCode;
    private ObjectCode expenseObjectCode;
    private ObjectCode liabilityObjectCode;

    OrganizationAccountingDefaultRuleTest() {
    }

    @BeforeEach
    void setUp() {
        this.incomeObjectCode = new ObjectCode();
        this.incomeObjectCode.setFinancialObjectCode(INCOME_OBJECT_CODE);
        this.incomeObjectCode.setFinancialObjectTypeCode("IN");
        this.expenseObjectCode = new ObjectCode();
        this.expenseObjectCode.setFinancialObjectCode(EXPENSE_OBJECT_CODE);
        this.expenseObjectCode.setFinancialObjectTypeCode("EX");
        this.liabilityObjectCode = new ObjectCode();
        this.liabilityObjectCode.setFinancialObjectCode(LIABILITY_OBJECT_CODE);
        this.liabilityObjectCode.setFinancialObjectTypeCode("LI");
        SystemOptions systemOptions = new SystemOptions();
        systemOptions.setUniversityFiscalYear(Integer.valueOf(2018));
        systemOptions.setFinObjectTypeIncomecashCode("IN");
        systemOptions.setFinObjTypeIncomeNotCashCd("IC");
        systemOptions.setFinObjTypeCshNotIncomeCd("CH");
        Mockito.when((Object)((SystemOptions)this.businessObjectSvcMock.findBySinglePrimaryKey(SystemOptions.class, (Object)2018))).thenReturn((Object)systemOptions);
        ObjectTypeServiceImpl objectTypeService = new ObjectTypeServiceImpl();
        objectTypeService.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut = new OrganizationAccountingDefaultRule();
        this.cut.setObjectTypeService((ObjectTypeService)objectTypeService);
        this.organizationAccountingDefault = new OrganizationAccountingDefault();
        this.organizationAccountingDefault.setUniversityFiscalYear(Integer.valueOf(2018));
        this.organizationAccountingDefault.setChartOfAccountsCode("IU");
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void isLateChargeObjectValidIncome_IncomeObjectCode() {
        this.organizationAccountingDefault.setOrganizationLateChargeObject(this.incomeObjectCode);
        boolean result = this.cut.isLateChargeObjectValidIncome(this.organizationAccountingDefault);
        Assertions.assertTrue((boolean)result, (String)"When late charge object code is 0776, isLateChargeObjectValidIncome should return true. ");
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void isLateChargeObjectValidIncome_ExpenseObjectCode() {
        this.organizationAccountingDefault.setOrganizationLateChargeObject(this.expenseObjectCode);
        boolean result = this.cut.isLateChargeObjectValidIncome(this.organizationAccountingDefault);
        Assertions.assertFalse((boolean)result, (String)"When late charge object code is 3310, isLateChargeObjectValidIncome should return false. ");
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List defaultInvoiceChartOfAccountsCodeErrorMessages = (List)errorMessages.get("document.newMaintainableObject.organizationLateChargeObjectCode");
        Assertions.assertEquals((int)1, (int)defaultInvoiceChartOfAccountsCodeErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)defaultInvoiceChartOfAccountsCodeErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.organizationAccountingDefaultMaintenance.lateChargeObjectCodeInvalid", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)EXPENSE_OBJECT_CODE, (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void isDefaultInvoiceFinancialObjectValidIncome_IncomeObjectCode() {
        this.organizationAccountingDefault.setDefaultInvoiceFinancialObject(this.incomeObjectCode);
        boolean result = this.cut.isDefaultInvoiceFinancialObjectValidIncome(this.organizationAccountingDefault);
        Assertions.assertTrue((boolean)result, (String)"When default invoice financial  is 0776, isDefaultInvoiceFinancialObjectValidIncome should return true. ");
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void isDefaultInvoiceFinancialObjectValidIncome_LiabilityObjectCode() {
        this.organizationAccountingDefault.setDefaultInvoiceFinancialObject(this.liabilityObjectCode);
        boolean result = this.cut.isDefaultInvoiceFinancialObjectValidIncome(this.organizationAccountingDefault);
        Assertions.assertTrue((boolean)result, (String)"When default invoice financial  is 9400, isDefaultInvoiceFinancialObjectValidIncome should return true. ");
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void isDefaultInvoiceFinancialObjectValidIncome_ExpenseObjectCode() {
        this.organizationAccountingDefault.setDefaultInvoiceFinancialObject(this.expenseObjectCode);
        boolean result = this.cut.isDefaultInvoiceFinancialObjectValidIncome(this.organizationAccountingDefault);
        Assertions.assertFalse((boolean)result, (String)"When default invoice financial object code is 3310, isDefaultInvoiceFinancialObjectValidIncome should return false. ");
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List defaultInvoiceChartOfAccountsCodeErrorMessages = (List)errorMessages.get("document.newMaintainableObject.defaultInvoiceChartOfAccountsCode");
        Assertions.assertEquals((int)1, (int)defaultInvoiceChartOfAccountsCodeErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)defaultInvoiceChartOfAccountsCodeErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.organizationAccountingDefaultMaintenance.defaultInvoiceFinancialObjectCodeInvalid", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)EXPENSE_OBJECT_CODE, (Object)errorMessage.getMessageParameters()[0]);
    }
}

