/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.validation.impl.PaymentApplicationAdjustmentDocumentRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PaymentApplicationAdjustmentDocumentRuleTest {
    @Mock(stubOnly=true)
    private PaymentApplicationAdjustmentDocument paymentApplicationAdjustmentDocumentMock;
    private final PaymentApplicationAdjustmentDocumentRule cut = new PaymentApplicationAdjustmentDocumentRule();

    PaymentApplicationAdjustmentDocumentRuleTest() {
    }

    @BeforeEach
    void setup() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().clearWarningMessages();
    }

    @AfterAll
    static void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().clearWarningMessages();
    }

    @Test
    @DisplayName(value="Previously applied amount is 50.00, open amount is 50.00, newly applied amount is 150.00; error message will be present")
    void processCustomRouteDocumentBusinessRules_invoiceAmounts() {
        double previouslyAppliedAmount = 50.0;
        double openAmount = 50.0;
        double newlyAppliedAmount = 150.0;
        InvoicePaidApplied invoicePaidApplied = PaymentApplicationAdjustmentDocumentRuleTest.createInvoicePaidApplied(50.0, 50.0, 150.0);
        Mockito.when((Object)invoicePaidApplied.getInvoiceItemNumber()).thenReturn((Object)1);
        Mockito.when((Object)invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1234");
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(List.of(invoicePaidApplied));
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getUnallocatedBalance()).thenReturn((Object)KualiDecimal.ZERO);
        boolean actual = this.cut.processCustomRouteDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock);
        Assertions.assertFalse((boolean)actual);
        String invoiceErrorKey = PaymentApplicationAdjustmentDocumentRuleTest.errorKeyForInvoice(invoicePaidApplied);
        Assertions.assertNotNull((Object)GlobalVariables.getMessageMap().getErrorMessagesForProperty("modal.title"));
        Assertions.assertNotNull((Object)GlobalVariables.getMessageMap().getErrorMessagesForProperty("modal.message"));
        Assertions.assertNotNull((Object)GlobalVariables.getMessageMap().getErrorMessagesForProperty(invoiceErrorKey));
    }

    @ParameterizedTest(name="Previously applied amount is {0}, open amount is {1}, newly applied amount is {2};error message will not be present")
    @MethodSource(value={"invoiceDetailAmounts"})
    void processCustomRouteDocumentBusinessRules_invoiceAmounts(InvoicePaidApplied invoicePaidApplied) {
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(List.of(invoicePaidApplied));
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getUnallocatedBalance()).thenReturn((Object)KualiDecimal.ZERO);
        boolean actual = this.cut.processCustomRouteDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock);
        Assertions.assertTrue((boolean)actual);
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    @DisplayName(value="Previously applied amount is 50.00, open amount is 50.00, newly applied amount is 150.00; error message will be present")
    void processCustomSaveDocumentBusinessRules_invoiceAmounts() {
        double previouslyAppliedAmount = 50.0;
        double openAmount = 50.0;
        double newlyAppliedAmount = 150.0;
        InvoicePaidApplied invoicePaidApplied = PaymentApplicationAdjustmentDocumentRuleTest.createInvoicePaidApplied(50.0, 50.0, 150.0);
        Mockito.when((Object)invoicePaidApplied.getInvoiceItemNumber()).thenReturn((Object)1);
        Mockito.when((Object)invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1234");
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(List.of(invoicePaidApplied));
        boolean actual = this.cut.processCustomSaveDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock);
        Assertions.assertTrue((boolean)actual);
        String invoiceErrorKey = PaymentApplicationAdjustmentDocumentRuleTest.errorKeyForInvoice(invoicePaidApplied);
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getWarningCount());
        Assertions.assertNotNull((Object)GlobalVariables.getMessageMap().getWarningMessagesForProperty(invoiceErrorKey));
    }

    @ParameterizedTest(name="Previously applied amount is {0}, open amount is {1} newly applied amount is {2};error message will not be present")
    @MethodSource(value={"invoiceDetailAmounts"})
    void processCustomSaveDocumentBusinessRules_invoiceAmounts(InvoicePaidApplied invoicePaidApplied) {
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(List.of(invoicePaidApplied));
        boolean actual = this.cut.processCustomSaveDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock);
        Assertions.assertTrue((boolean)actual);
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getWarningCount());
    }

    private static Stream<Arguments> invoiceDetailAmounts() {
        return Stream.of(Arguments.of((Object[])new Object[]{PaymentApplicationAdjustmentDocumentRuleTest.createInvoicePaidApplied(50.0, 50.0, 100.0)}), Arguments.of((Object[])new Object[]{PaymentApplicationAdjustmentDocumentRuleTest.createInvoicePaidApplied(50.0, 50.0, 0.0)}), Arguments.of((Object[])new Object[]{PaymentApplicationAdjustmentDocumentRuleTest.createInvoicePaidApplied(100.0, 50.0, 50.0)}));
    }

    private static String errorKeyForInvoice(InvoicePaidApplied invoicePaidApplied) {
        return String.format("invoiceApplications.%s.detailApplications.%d.amountApplied", invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber(), invoicePaidApplied.getInvoiceItemNumber() - 1);
    }

    @Test
    @DisplayName(value="With an document open amount of 0.00, validation should return true")
    void processCustomRouteDocumentBusinessRules_openAmount_valid() {
        KualiDecimal openAmount = KualiDecimal.ZERO;
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getUnallocatedBalance()).thenReturn((Object)openAmount);
        boolean actual = this.cut.processCustomRouteDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock);
        Assertions.assertTrue((boolean)actual);
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    @DisplayName(value="With an document open amount of 100.00, validation should return false")
    void processCustomRouteDocumentBusinessRules_openAmount() {
        KualiDecimal openAmount = new KualiDecimal(100);
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getUnallocatedBalance()).thenReturn((Object)openAmount);
        boolean actual = this.cut.processCustomRouteDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock);
        Assertions.assertFalse((boolean)actual);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assertions.assertEquals((Object)"error.modal.paymentApplicationAdjustment.openAmountIsNonZero.title", (Object)((ErrorMessage)messageMap.getErrorMessagesForProperty("modal.title").get(0)).getErrorKey());
        Assertions.assertEquals((Object)"error.modal.paymentApplicationAdjustment.openAmountIsNonZero.message", (Object)((ErrorMessage)messageMap.getErrorMessagesForProperty("modal.message").get(0)).getErrorKey());
    }

    private static InvoicePaidApplied createInvoicePaidApplied(double previouslyAppliedAmount, double openAmount, double newlyAppliedAmount) {
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)customerInvoiceDetail.getAmountOpen()).thenReturn((Object)new KualiDecimal(openAmount));
        Mockito.when((Object)customerInvoiceDetail.getAmountApplied()).thenReturn((Object)new KualiDecimal(previouslyAppliedAmount));
        InvoicePaidApplied invoicePaidApplied = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)invoicePaidApplied.getInvoiceItemAppliedAmount()).thenReturn((Object)new KualiDecimal(newlyAppliedAmount));
        Mockito.when((Object)invoicePaidApplied.getInvoiceDetail()).thenReturn((Object)customerInvoiceDetail);
        return invoicePaidApplied;
    }
}

