/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.fixture;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.SpringContext;

public enum CustomerInvoiceDocumentFixture {
    BASE_CIDOC_WITH_CUSTOMER("ABB2", "UA", "VPIT", null, null, null),
    BASE_CIDOC_WITH_CUSTOMER_WITH_BILLING_INFO("ABB2", "UA", "VPIT", null, "UA", "VPIT");

    public String customerNumber;
    public String processingChartOfAccountsCode;
    public String processingOrganizationCode;
    public String financialDocumentInErrorNumber;
    public String billByChartOfAccountsCode;
    public String billedByOrganizationCode;

    private CustomerInvoiceDocumentFixture(String customerNumber, String processingChartOfAccountsCode, String processingOrganizationCode, String financialDocumentInErrorNumber, String billByChartOfAccountsCode, String billedByOrganizationCode) {
        this.customerNumber = customerNumber;
        this.processingOrganizationCode = processingOrganizationCode;
        this.processingChartOfAccountsCode = processingChartOfAccountsCode;
        this.financialDocumentInErrorNumber = financialDocumentInErrorNumber;
        this.billByChartOfAccountsCode = billByChartOfAccountsCode;
        this.billedByOrganizationCode = billedByOrganizationCode;
    }

    public CustomerInvoiceDocument createCustomerInvoiceDocument(CustomerInvoiceDetailFixture[] customerInvoiceDetailFixtures) {
        AccountsReceivableDocumentHeader arDocHeader;
        CustomerInvoiceDocument customerInvoiceDocument = (CustomerInvoiceDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), CustomerInvoiceDocument.class);
        ((CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class)).setupDefaultValuesForNewCustomerInvoiceDocument(customerInvoiceDocument);
        customerInvoiceDocument.getDocumentHeader().setFinancialDocumentInErrorNumber(this.financialDocumentInErrorNumber);
        if (StringUtils.isNotEmpty((CharSequence)this.billByChartOfAccountsCode)) {
            customerInvoiceDocument.setBillByChartOfAccountCode(this.billByChartOfAccountsCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.billedByOrganizationCode)) {
            customerInvoiceDocument.setBilledByOrganizationCode(this.billedByOrganizationCode);
        }
        if (ObjectUtils.isNull((Object)customerInvoiceDocument.getAccountsReceivableDocumentHeader())) {
            arDocHeader = new AccountsReceivableDocumentHeader();
            customerInvoiceDocument.setAccountsReceivableDocumentHeader(arDocHeader);
        } else {
            arDocHeader = customerInvoiceDocument.getAccountsReceivableDocumentHeader();
        }
        arDocHeader.setCustomerNumber(this.customerNumber);
        arDocHeader.setProcessingChartOfAccountCode(this.processingChartOfAccountsCode);
        arDocHeader.setProcessingOrganizationCode(this.processingOrganizationCode);
        arDocHeader.setDocumentNumber(customerInvoiceDocument.getDocumentNumber());
        arDocHeader.refresh();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerShipToAddress = customerAddressService.getPrimaryAddress(this.customerNumber);
        if (ObjectUtils.isNotNull((Object)customerShipToAddress)) {
            customerInvoiceDocument.setCustomerShipToAddress(customerShipToAddress);
            customerInvoiceDocument.setCustomerShipToAddressOnInvoice(customerShipToAddress);
            customerInvoiceDocument.setCustomerShipToAddressIdentifier(customerShipToAddress.getCustomerAddressIdentifier());
            customerInvoiceDocument.setCustomerBillToAddress(customerShipToAddress);
            customerInvoiceDocument.setCustomerBillToAddressOnInvoice(customerShipToAddress);
            customerInvoiceDocument.setCustomerBillToAddressIdentifier(customerShipToAddress.getCustomerAddressIdentifier());
        }
        AccountsReceivablePendingEntryService accountsReceivablePendingEntryService = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        if (customerInvoiceDetailFixtures != null) {
            for (CustomerInvoiceDetailFixture customerInvoiceDetailFixture : customerInvoiceDetailFixtures) {
                CustomerInvoiceDetail detail = customerInvoiceDetailFixture.addTo(customerInvoiceDocument);
                String accountsReceivableObjectCode = accountsReceivablePendingEntryService.getAccountsReceivableObjectCode(detail);
                detail.setAccountsReceivableObjectCode(accountsReceivableObjectCode);
            }
        }
        ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)customerInvoiceDocument);
        customerInvoiceDocument = (CustomerInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(customerInvoiceDocument.getDocumentNumber());
        return customerInvoiceDocument;
    }
}

