/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutePersonRequest;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRouteWorkgroupRequest;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutingRequest;

class AdHocRoutingRequestTest {
    private static final JsonMapper MAPPER = new JsonMapper();
    private static final String CUT_AS_JSON = "{    \"groups\": [{    \"name\":\"aName\",    \"namespaceCode\":\"aNamespaceCode\",    \"action\":\"anAction\"}],    \"persons\": [{    \"principalName\": \"aPrincipalName\",    \"action\": \"anAction\"}]}";
    private static final AdHocRoutingRequest cut = new AdHocRoutingRequest(List.of(new AdHocRouteWorkgroupRequest("aName", "aNamespaceCode", "anAction")), List.of(new AdHocRoutePersonRequest("aPrincipalName", "anAction")));

    AdHocRoutingRequestTest() {
    }

    @DisplayName(value="Given valid JSON, it should be deserialized to the equivalent instance")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeValidArgs"})
    void deserialize_valid(String requestJson) throws Exception {
        AdHocRoutingRequest actual = (AdHocRoutingRequest)MAPPER.readValue(requestJson, AdHocRoutingRequest.class);
        Assertions.assertEquals((Object)cut, (Object)actual);
    }

    private static Stream<Arguments> deserializeValidArgs() {
        String withUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON.substring(1);
        return Stream.of(Arguments.of((Object[])new Object[]{CUT_AS_JSON}), Arguments.of((Object[])new Object[]{withUnknown}));
    }

    @DisplayName(value="Given invalid JSON, deserialization should fail")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeInvalidArgs"})
    void deserialize_invalid(String requestJson) {
        Assertions.assertThrows(JsonProcessingException.class, () -> MAPPER.readValue(requestJson, AdHocRoutingRequest.class));
    }

    private static Stream<Arguments> deserializeInvalidArgs() {
        String personsMissing = "{    \"groups\":[{    \"name\":\"aName\",    \"namespaceCode\":\"aNamespaceCode\",    \"action\":\"anAction\"}]}";
        String groupsMissing = "{    \"persons\":[{    \"principalName\": \"aPrincipalName\",    \"action\": \"anAction\"}]}";
        return Stream.of(Arguments.of((Object[])new Object[]{"{    \"groups\":[{    \"name\":\"aName\",    \"namespaceCode\":\"aNamespaceCode\",    \"action\":\"anAction\"}]}"}), Arguments.of((Object[])new Object[]{"{    \"persons\":[{    \"principalName\": \"aPrincipalName\",    \"action\": \"anAction\"}]}"}));
    }
}

