/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.rest.resource.requests.AccountingLineTest;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutePersonRequest;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRouteWorkgroupRequest;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutingRequest;
import org.kuali.kfs.module.ar.rest.resource.requests.InvoiceApplicationDetailTest;
import org.kuali.kfs.module.ar.rest.resource.requests.InvoiceApplicationTest;
import org.kuali.kfs.module.ar.rest.resource.requests.NonAppliedHoldingTest;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;

class PaymentApplicationAdjustmentRequestTest {
    private static final JsonMapper MAPPER = new JsonMapper();
    private static final String DESCRIPTION = "description";
    private static final String EXPLANATION = "explanation";
    private static final String ORG_DOC_NUMBER = "orgDocNumber";
    private static final String CUT_AS_JSON = "{    \"description\": \"description\",    \"explanation\": \"explanation\",    \"orgDocNumber\": \"orgDocNumber\",    \"invoiceApplications\": [" + InvoiceApplicationTest.CUT_AS_JSON + "    ],    \"nonAppliedHoldings\": [" + NonAppliedHoldingTest.CUT_AS_JSON + "    ],    \"accountingLines\": [" + AccountingLineTest.CUT_AS_JSON + "    ]}";
    private final PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail detailApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(InvoiceApplicationDetailTest.AMOUNT_APPLIED, InvoiceApplicationDetailTest.SEQUENCE_NUMBER);
    private final PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("CN", "DN", List.of(this.detailApplication));
    private final List<PaymentApplicationAdjustmentRequest.InvoiceApplication> invoiceApplications = List.of(this.invoiceApplication);
    private final PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHolding = new PaymentApplicationAdjustmentRequest.NonAppliedHolding(NonAppliedHoldingTest.AMOUNT, "CN");
    private final List<PaymentApplicationAdjustmentRequest.NonAppliedHolding> nonAppliedHoldings = List.of(this.nonAppliedHolding);
    final PaymentApplicationAdjustmentRequest.AccountingLine nonArAccountingLine = new PaymentApplicationAdjustmentRequest.AccountingLine(AccountingLineTest.SEQUENCE_NUMBER, "CHART_CODE", "ACCOUNT_NUMBER", "SUB_ACCOUNT_NUMBER", "OBJECT", "SUB_OBJECT", "PROJECT_CODE", "ORG_REF_ID", "DESCRIPTION", AccountingLineTest.AMOUNT);
    private final List<PaymentApplicationAdjustmentRequest.AccountingLine> nonArAccountingLines = List.of(this.nonArAccountingLine);
    private final AdHocRouteWorkgroupRequest workgroupRequest = new AdHocRouteWorkgroupRequest("aName", "aNamespaceCode", "anAction");
    private final AdHocRoutePersonRequest personRequest = new AdHocRoutePersonRequest("aPrincipalName", "anAction");
    private final AdHocRoutingRequest adHocRoutingRequest = new AdHocRoutingRequest(List.of(this.workgroupRequest), List.of(this.personRequest));
    private final PaymentApplicationAdjustmentRequest cut = new PaymentApplicationAdjustmentRequest("description", "explanation", "orgDocNumber", this.adHocRoutingRequest, this.invoiceApplications, this.nonAppliedHoldings, this.nonArAccountingLines);

    PaymentApplicationAdjustmentRequestTest() {
    }

    @DisplayName(value="Given valid JSON, it should be deserialized to the equivalent instance")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeValidArgs"})
    void deserialize_valid(String requestJson) throws Exception {
        PaymentApplicationAdjustmentRequest actual = (PaymentApplicationAdjustmentRequest)MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.class);
        Assertions.assertEquals((Object)this.cut, (Object)actual);
    }

    private static Stream<Arguments> deserializeValidArgs() {
        String withUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON.substring(1);
        return Stream.of(Arguments.of((Object[])new Object[]{CUT_AS_JSON}), Arguments.of((Object[])new Object[]{withUnknown}));
    }

    @DisplayName(value="Given invalid JSON, deserialization should fail")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeInvalidArgs"})
    void deserialize_invalid(String requestJson, String expectedErrorMessage) {
        Exception e = (Exception)Assertions.assertThrows(JsonProcessingException.class, () -> MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.class));
        System.out.println(e.getMessage());
        Assertions.assertTrue((boolean)e.getMessage().contains(expectedErrorMessage));
    }

    private static Stream<Arguments> deserializeInvalidArgs() {
        String invoiceApplicationsMissing = "{    \"description\": \"description\",    \"explanation\": \"explanation\",    \"orgDocNumber\": \"orgDocNumber\",    \"nonAppliedHoldings\": [" + NonAppliedHoldingTest.CUT_AS_JSON + "    ],    \"accountingLines\": [" + AccountingLineTest.CUT_AS_JSON + "    ]}";
        String invoiceApplicationsNull = "{    \"description\": \"description\",    \"explanation\": \"explanation\",    \"orgDocNumber\": \"orgDocNumber\",    \"invoiceApplications\": null,    \"nonAppliedHoldings\": [" + NonAppliedHoldingTest.CUT_AS_JSON + "    ],    \"accountingLines\": [" + AccountingLineTest.CUT_AS_JSON + "    ]}";
        String nonAppliedHoldingsMissing = "{    \"description\": \"description\",    \"explanation\": \"explanation\",    \"orgDocNumber\": \"orgDocNumber\",    \"invoiceApplications\": [" + InvoiceApplicationTest.CUT_AS_JSON + "    ],    \"accountingLines\": [" + AccountingLineTest.CUT_AS_JSON + "    ]}";
        String nonAppliedHoldingsNull = "{    \"description\": \"description\",    \"explanation\": \"explanation\",    \"orgDocNumber\": \"orgDocNumber\",    \"invoiceApplications\": [" + InvoiceApplicationTest.CUT_AS_JSON + "    ],    \"nonAppliedHoldings\": null,    \"accountingLines\": [" + AccountingLineTest.CUT_AS_JSON + "    ]}";
        String accountingLinesIsMissing = "{    \"description\": \"description\",    \"explanation\": \"explanation\",    \"orgDocNumber\": \"orgDocNumber\",    \"invoiceApplications\": [" + InvoiceApplicationTest.CUT_AS_JSON + "    ],    \"nonAppliedHoldings\": [" + NonAppliedHoldingTest.CUT_AS_JSON + "    ]}";
        String accountingLinesIsNull = "{    \"description\": \"description\",    \"explanation\": \"explanation\",    \"orgDocNumber\": \"orgDocNumber\",    \"invoiceApplications\": [" + InvoiceApplicationTest.CUT_AS_JSON + "    ],    \"nonAppliedHoldings\": [" + NonAppliedHoldingTest.CUT_AS_JSON + "    ],    \"accountingLines\": null}";
        return Stream.of(Arguments.of((Object[])new Object[]{invoiceApplicationsMissing, "invoiceApplications must be supplied"}), Arguments.of((Object[])new Object[]{invoiceApplicationsNull, "invoiceApplications must be supplied"}), Arguments.of((Object[])new Object[]{nonAppliedHoldingsMissing, "nonAppliedHoldings must be supplied"}), Arguments.of((Object[])new Object[]{nonAppliedHoldingsNull, "nonAppliedHoldings must be supplied"}), Arguments.of((Object[])new Object[]{accountingLinesIsMissing, "accountingLines must be supplied"}), Arguments.of((Object[])new Object[]{accountingLinesIsNull, "accountingLines must be supplied"}));
    }
}

