/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.responses;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.rest.resource.responses.PaymentApplicationAdjustmentInvoiceResponse;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

@ExtendWith(value={MockitoExtension.class})
class PaymentApplicationAdjustmentInvoiceResponseTest {
    private static final String DOCUMENT_NUMBER = "1234";
    private static final String CUSTOMER_URL = "customerUrl";
    private static final String DOCUMENT_URL = "documentUrl";
    private static final JsonMapper MAPPER = new JsonMapper();

    PaymentApplicationAdjustmentInvoiceResponseTest() {
    }

    @ParameterizedTest(name="Construction throws IllegalArgumentException with {arguments}")
    @MethodSource(value={"invalidConstructorArgs"})
    void failedConstructionPath(String docNumber, CustomerInvoiceDocument invoice, List<InvoicePaidApplied> invoicePaidApplieds, String documentUrl, String customerUrl) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PaymentApplicationAdjustmentInvoiceResponse(docNumber, invoice, invoicePaidApplieds, documentUrl, customerUrl));
    }

    private static Stream<Arguments> invalidConstructorArgs() {
        List invoicePaidApplieds = Collections.emptyList();
        return Stream.of(Arguments.of((Object[])new Object[]{null, Mockito.mock(CustomerInvoiceDocument.class), invoicePaidApplieds, DOCUMENT_URL, CUSTOMER_URL}), Arguments.of((Object[])new Object[]{DOCUMENT_NUMBER, null, invoicePaidApplieds, DOCUMENT_URL, CUSTOMER_URL}), Arguments.of((Object[])new Object[]{DOCUMENT_NUMBER, Mockito.mock(CustomerInvoiceDocument.class), null, DOCUMENT_URL, CUSTOMER_URL}), Arguments.of((Object[])new Object[]{DOCUMENT_NUMBER, Mockito.mock(CustomerInvoiceDocument.class), invoicePaidApplieds, null, CUSTOMER_URL}), Arguments.of((Object[])new Object[]{DOCUMENT_NUMBER, Mockito.mock(CustomerInvoiceDocument.class), invoicePaidApplieds, DOCUMENT_URL, null}));
    }

    @Test
    void serialize(@Mock(stubOnly=true) CustomerInvoiceDocument invoiceDocumentMock, @Mock(stubOnly=true) CustomerInvoiceDetail firstCustomerDetailMock, @Mock(stubOnly=true) CustomerInvoiceDetail secondCustomerDetailMock, @Mock(stubOnly=true) InvoicePaidApplied firstInvoicePaidAppliedMock, @Mock(stubOnly=true) InvoicePaidApplied secondInvoicePaidAppliedMock, @Mock(stubOnly=true) Customer customerMock) throws Exception {
        String invoiceDocNumber = "5555";
        Date billingDate = new Date(123L);
        String customerNumber = "6789";
        String invoiceHeaderText = "header text";
        String customerName = "customerName";
        KualiDecimal invoiceTotalAmount = new KualiDecimal(100);
        String firstDetailChartCode = "A";
        String firstDetailAccountNumber = "5790";
        Integer firstDetailSequenceNumber = 1;
        String firstDetailInvoiceItemDescription = "firstDescription";
        KualiDecimal firstDetailAmount = new KualiDecimal(10);
        KualiDecimal firstDetailAppliedAmount = new KualiDecimal(1);
        String secondDetailChartCode = "B";
        String secondDetailAccountNumber = "8890";
        Integer secondDetailSequenceNumber = 2;
        String secondDetailInvoiceItemDescription = "secondDescription";
        KualiDecimal secondDetailAmount = new KualiDecimal(5);
        KualiDecimal secondDetailAppliedAmount = new KualiDecimal(2);
        Mockito.when((Object)invoiceDocumentMock.getCustomer()).thenReturn((Object)customerMock);
        Mockito.when((Object)invoiceDocumentMock.getCustomerInvoiceDetailsWithoutDiscounts()).thenReturn(List.of(firstCustomerDetailMock, secondCustomerDetailMock));
        Mockito.when((Object)firstCustomerDetailMock.getChartOfAccountsCode()).thenReturn((Object)"A");
        Mockito.when((Object)firstCustomerDetailMock.getAccountNumber()).thenReturn((Object)"5790");
        Mockito.when((Object)firstCustomerDetailMock.getInvoiceItemNumber()).thenReturn((Object)firstDetailSequenceNumber);
        Mockito.when((Object)firstCustomerDetailMock.getInvoiceItemDescription()).thenReturn((Object)"firstDescription");
        Mockito.when((Object)firstCustomerDetailMock.getAmount()).thenReturn((Object)firstDetailAmount);
        Mockito.when((Object)firstInvoicePaidAppliedMock.getInvoiceItemNumber()).thenReturn((Object)firstDetailSequenceNumber);
        Mockito.when((Object)firstInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)firstDetailAppliedAmount);
        Mockito.when((Object)secondCustomerDetailMock.getChartOfAccountsCode()).thenReturn((Object)"B");
        Mockito.when((Object)secondCustomerDetailMock.getAccountNumber()).thenReturn((Object)"8890");
        Mockito.when((Object)secondCustomerDetailMock.getInvoiceItemNumber()).thenReturn((Object)secondDetailSequenceNumber);
        Mockito.when((Object)secondCustomerDetailMock.getInvoiceItemDescription()).thenReturn((Object)"secondDescription");
        Mockito.when((Object)secondCustomerDetailMock.getAmount()).thenReturn((Object)secondDetailAmount);
        Mockito.when((Object)secondInvoicePaidAppliedMock.getInvoiceItemNumber()).thenReturn((Object)secondDetailSequenceNumber);
        Mockito.when((Object)secondInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)secondDetailAppliedAmount);
        Mockito.when((Object)invoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"5555");
        Mockito.when((Object)invoiceDocumentMock.getBillingDate()).thenReturn((Object)billingDate);
        Mockito.when((Object)invoiceDocumentMock.getInvoiceHeaderText()).thenReturn((Object)"header text");
        Mockito.when((Object)invoiceDocumentMock.getTotalDollarAmount()).thenReturn((Object)invoiceTotalAmount);
        Mockito.when((Object)customerMock.getCustomerName()).thenReturn((Object)"customerName");
        Mockito.when((Object)customerMock.getCustomerNumber()).thenReturn((Object)"6789");
        PaymentApplicationAdjustmentInvoiceResponse cut = new PaymentApplicationAdjustmentInvoiceResponse(DOCUMENT_NUMBER, invoiceDocumentMock, List.of(firstInvoicePaidAppliedMock, secondInvoicePaidAppliedMock), DOCUMENT_URL, CUSTOMER_URL);
        Account openAccountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)openAccountMock.isClosed()).thenReturn((Object)false);
        Account closedAccountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)closedAccountMock.isClosed()).thenReturn((Object)true);
        AccountService accountServiceMock = (AccountService)Mockito.mock(AccountService.class);
        Mockito.when((Object)accountServiceMock.getByPrimaryId("A", "5790")).thenReturn((Object)openAccountMock);
        Mockito.when((Object)accountServiceMock.getByPrimaryId("B", "8890")).thenReturn((Object)closedAccountMock);
        cut.setAccountService(accountServiceMock);
        KualiDecimal expectedAmountToApply = (KualiDecimal)firstDetailAppliedAmount.add((AbstractKualiDecimal)secondDetailAppliedAmount);
        String actual = MAPPER.writeValueAsString((Object)cut);
        String expected = "{\"documentNumber\": \"5555\",\"customerNumber\": \"6789\",\"invoiceBillingDate\": " + billingDate.getTime() + ",\"headerText\": \"header text\",\"customerName\": \"customerName\",\"totalAmount\": " + invoiceTotalAmount + ",\"amountToApply\": " + expectedAmountToApply + ",\"openAmount\": " + invoiceTotalAmount.subtract((AbstractKualiDecimal)expectedAmountToApply) + ",\"detailApplications\": [{\"chartOfAccountsCode\": \"A\",\"accountNumber\": \"5790\",\"isAccountClosed\": false,\"invoiceItemDescription\": \"firstDescription\",\"sequenceNumber\": " + firstDetailSequenceNumber + ",\"amount\": " + firstDetailAmount + ",\"amountApplied\": " + firstDetailAppliedAmount + ",\"amountOpen\": " + firstDetailAmount.subtract((AbstractKualiDecimal)firstDetailAppliedAmount) + "},{\"chartOfAccountsCode\": \"B\",\"accountNumber\": \"8890\",\"isAccountClosed\": true,\"invoiceItemDescription\": \"secondDescription\",\"sequenceNumber\": " + secondDetailSequenceNumber + ",\"amount\": " + secondDetailAmount + ",\"amountApplied\": " + secondDetailAppliedAmount + ",\"amountOpen\": " + secondDetailAmount.subtract((AbstractKualiDecimal)secondDetailAppliedAmount) + "}],\"documentLink\": {\"type\": \"link\",\"url\": \"documentUrl\",\"value\": \"5555\"},\"customerLink\": {\"type\": \"link\",\"url\": \"customerUrl\",\"value\": \"6789\"}}";
        JSONAssert.assertEquals((String)expected, (String)actual, (JSONCompareMode)JSONCompareMode.STRICT);
    }
}

