/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentService;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorMessage;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PerformValidationTest {
    private static final Set<String> PENDING_DOCUMENT_STATUSES = Set.of("I", "S", "R", "E");
    private ContractsGrantsInvoiceCreateDocumentServiceImpl cut;
    @Mock
    private ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationService;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    @Mock
    private VerifyBillingFrequencyService verifyBillingFrequencyService;
    @Mock
    private FinancialSystemDocumentService financialSystemDocumentService;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private ConfigurationService configSvcMock;
    @Mock
    private OptionsService optionsSvcMock;
    @Mock
    private DateTimeService dateTimeSvcMock;
    @Mock
    private AccountService accountSvcMock;

    PerformValidationTest() {
    }

    @BeforeEach
    void setup() {
        this.cut = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.cut.setContractsGrantsBillingAwardVerificationService(this.contractsGrantsBillingAwardVerificationService);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentService);
        this.cut.setVerifyBillingFrequencyService(this.verifyBillingFrequencyService);
        this.cut.setFinancialSystemDocumentService(this.financialSystemDocumentService);
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setConfigurationService(this.configSvcMock);
        this.cut.setOptionsService(this.optionsSvcMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
        this.cut.setAccountService(this.accountSvcMock);
    }

    @Test
    void validateAwards_StartDateMissing(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-10-01"));
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn(null);
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"2336320");
        Mockito.when((Object)awardAccountMock2.getChartOfAccountsCode()).thenReturn((Object)"IN");
        Mockito.when((Object)awardAccountMock2.getAccountNumber()).thenReturn((Object)"1292016");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.startDate.missing")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_InvalidBillingFrequency(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-10-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"2336320");
        Mockito.when((Object)awardAccountMock2.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock2.getAccountNumber()).thenReturn((Object)"1292016");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.billing.missing.frequency")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_InvalidBillingPeriod(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2012-01-01"));
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)new Date(DateTimeUtils.currentTimeMillis()));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"2336320");
        Mockito.when((Object)awardAccountMock2.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock2.getAccountNumber()).thenReturn((Object)"1292016");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.not.eligible.invoice")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_ValidAward(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size(), (String)"qualifiedAwards should contain one award.");
        Assertions.assertEquals(((List)qualifiedAwards).get(0), (Object)awardMock, (String)"qualifiedAwards should contain our initial award.");
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_AwardInvoicingSuspended(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_AwardWithLetterOfCreditBillingFrequency_batchCreation(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"11");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.locb.billing.frequency")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_AwardWithLetterOfCreditBillingFrequency_letterOfCreditCreation(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.LOC);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size(), (String)"qualifiedAwards should not be empty.");
        Assertions.assertEquals(((List)qualifiedAwards).get(0), (Object)awardMock, (String)"qualifiedAwards should contain our initial award.");
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_InactiveAward(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)false);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.inactive")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_SuspendedAndInactiveAward(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_TwoInvalidAwards(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock1.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock1.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock1.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardFundManagerMock1.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock1.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock1);
        Account account1 = new Account();
        Mockito.when((Object)awardAccountMock1.getAccount()).thenReturn((Object)account1);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock1), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock1)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock1.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock1.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock1), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1021887");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        HashMap<String, Object> fieldValues2 = new HashMap<String, Object>();
        fieldValues2.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues2.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments2 = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues2)).thenReturn(pendingDocuments2);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount1 : awardMock1.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount1, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.inactive")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock1, awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)2, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
        List errorMessages2 = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(1)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages2.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages2.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_OneValidOneInvalidAward(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock1.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock1.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Account account1 = new Account();
        Mockito.when((Object)awardAccountMock1.getAccount()).thenReturn((Object)account1);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock1), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock1)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock1.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock1.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock1), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1021887");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        HashMap<String, Object> fieldValues1 = new HashMap<String, Object>();
        fieldValues1.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues1.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments1 = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues1)).thenReturn(pendingDocuments1);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock1, awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size(), (String)"qualifiedAwards should contain one award.");
        Assertions.assertEquals(((List)qualifiedAwards).get(0), (Object)awardMock1, (String)"qualifiedAwards should contain our initial award.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_MissingAwardInvoicingOption(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.missing")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_PredeterminedBilling_MultipleAccounts(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1021887");
        List awardAccountMocks = awardMock.getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasBillsToInvoice(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size());
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_MilestoneBilling_MultipleAccounts(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1021887");
        List awardAccountMocks = awardMock.getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasMilestonesToInvoice(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size());
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_NoActiveAccounts(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.no.active.accounts.assigned")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_AwardFinalInvoiceAlreadyBilled(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isAwardFinalInvoiceAlreadyBuilt(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.already.billed")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoValidMilestonesToInvoice(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.not.valid.milestones")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoValidBillsToInvoice(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.not.valid.bills")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_OneValidOneInvalidAwardAccounts(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1021887");
        List awardAccountMocks = awardMock.getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock1.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size(), (String)"qualifiedAwards should contain one award.");
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_AgencyHasNoMatchingCustomer(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.award.not.valid.customer")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoValidAwardAccounts(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock, @Mock(stubOnly=true) ContractsGrantsInvoiceDocument document) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        InvoiceAccountDetail detail = new InvoiceAccountDetail();
        ContractsAndGrantsBillingAwardAccount awardAccount = (ContractsAndGrantsBillingAwardAccount)awardMock.getActiveAwardAccounts().get(0);
        detail.setAccountNumber(awardAccount.getAccountNumber());
        detail.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
        Mockito.when((Object)document.getAccountDetails()).thenReturn(Collections.singletonList(detail));
        Mockito.when((Object)this.accountSvcMock.getByPrimaryId(awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber())).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList<ContractsGrantsInvoiceDocument> pendingDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        pendingDocuments.add(document);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cgivoice.award.not.valid.accounts")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount1 : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount1, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoContractControlAccountsByCCA(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        ArrayList<String> ccaErrors = new ArrayList<String>();
        ccaErrors.add("error.cg.no.control.account");
        ccaErrors.add("");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(ccaErrors);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cg.no.control.account")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoSysInfo(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cginvoice.sys.info.not.setup")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_InvoicesInProgressMilestone(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasMilestonesToInvoice(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isInvoiceInProgress(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cgivoice.award.not.valid.accounts")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_InvoicesInProgressPredeterminedBilling(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasBillsToInvoice(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isInvoiceInProgress(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.cgivoice.award.not.valid.accounts")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_MissingIncomeAndReceivableObjectCodes_Invalid(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(awardMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        ArrayList pendingDocuments = new ArrayList();
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(pendingDocuments);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)awardMock), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)false);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString("error.contracts.grants.invoice.missing.cgbi.object.code")).thenReturn((Object)"Error");
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardMock.getActiveAwardAccounts()) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
        }
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        List<ContractsAndGrantsBillingAward> awards = List.of(awardMock);
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }
}

