/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentService;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ValidateAwardsTest {
    private static final Set<String> PENDING_DOCUMENT_STATUSES = Set.of("I", "S", "R", "E");
    private ContractsGrantsInvoiceCreateDocumentServiceImpl cut;
    @Mock
    private ContractsGrantsBillingAwardVerificationService cgbAwardVerificationSvcMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService cgInvoiceDocSvcMock;
    @Mock
    private VerifyBillingFrequencyService verifyBillingFrequencySvcMock;
    @Mock
    private FinancialSystemDocumentService financialSystemDocSvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private ConfigurationService configSvcMock;
    @Mock
    private OptionsService optionsSvcMock;
    @Mock
    private DateTimeService dateTimeSvcMock;

    ValidateAwardsTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.cut.setContractsGrantsBillingAwardVerificationService(this.cgbAwardVerificationSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.cgInvoiceDocSvcMock);
        this.cut.setVerifyBillingFrequencyService(this.verifyBillingFrequencySvcMock);
        this.cut.setFinancialSystemDocumentService(this.financialSystemDocSvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setConfigurationService(this.configSvcMock);
        this.cut.setOptionsService(this.optionsSvcMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
    }

    @Test
    void validateManualAwards_OneValidAward(@Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        awardAccountMocks.add(awardAccountMock);
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        this.prepareMocks(awardMock);
        awards.add(awardMock);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertTrue((boolean)contractsGrantsInvoiceDocumentErrorLogs.isEmpty());
        Assertions.assertEquals((int)1, (int)validAwards.size());
        Assertions.assertTrue((boolean)validAwards.contains(awards.get(0)));
    }

    @Test
    void validateManualAwards_OneInvalidAward(@Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(2000));
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)true);
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        Assertions.assertTrue((boolean)validAwards.isEmpty());
        Assertions.assertTrue((boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, (ContractsAndGrantsBillingAward)awards.get(0)));
    }

    @Test
    void validateManualAwards_TwoValidAwards(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1) {
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(new ArrayList());
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock1.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock1.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1021887");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock1)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues1 = new HashMap<String, Object>();
        fieldValues1.put("invoiceGeneralDetail.proposalNumber", awardMock1.getProposalNumber());
        fieldValues1.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(ContractsAndGrantsBillingAwardAccount.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        awards.add(awardMock1);
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertTrue((boolean)contractsGrantsInvoiceDocumentErrorLogs.isEmpty());
        Assertions.assertEquals((int)2, (int)validAwards.size());
        Assertions.assertTrue((boolean)validAwards.contains(awards.get(0)));
        Assertions.assertTrue((boolean)validAwards.contains(awards.get(1)));
    }

    @Test
    void validateManualAwards_TwoInvalidAwards(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock1) {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock1.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1021887");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardFundManagerMock1.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock1.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock1);
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        awards.add(awardMock1);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)2, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        Assertions.assertTrue((boolean)validAwards.isEmpty());
        Assertions.assertTrue((boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, (ContractsAndGrantsBillingAward)awards.get(0)));
        Assertions.assertTrue((boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, (ContractsAndGrantsBillingAward)awards.get(1)));
    }

    @Test
    void validateManualAwards_OneValidOneInvalidAwards(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock1) {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(new ArrayList());
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock1.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1021887");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardFundManagerMock1.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock1.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock1);
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        HashMap<String, Object> fieldValues1 = new HashMap<String, Object>();
        fieldValues1.put("invoiceGeneralDetail.proposalNumber", awardMock1.getProposalNumber());
        fieldValues1.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(ContractsAndGrantsBillingAwardAccount.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        awards.add(awardMock1);
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        Assertions.assertEquals((int)1, (int)validAwards.size());
        Assertions.assertTrue((boolean)validAwards.contains(awards.get(0)));
        Assertions.assertTrue((boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, (ContractsAndGrantsBillingAward)awards.get(1)));
    }

    @Test
    void validateBatchAwards_OneValidAward(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock) {
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        this.prepareMocks(awardMock);
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertEquals((int)1, (int)validAwards.size());
        Assertions.assertTrue((boolean)validAwards.contains(awardMock));
    }

    @Test
    void validateBatchAwards_OneInvalidAward(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock) {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertTrue((boolean)validAwards.isEmpty());
    }

    @Test
    void validateBatchAwards_TwoValidAwards(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1) {
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(new ArrayList());
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock1.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock1.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1021887");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock1)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues1 = new HashMap<String, Object>();
        fieldValues1.put("invoiceGeneralDetail.proposalNumber", awardMock1.getProposalNumber());
        fieldValues1.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(ContractsAndGrantsBillingAwardAccount.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        awards.add(awardMock1);
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertEquals((int)2, (int)validAwards.size());
        Assertions.assertTrue((boolean)validAwards.contains(awardMock));
        Assertions.assertTrue((boolean)validAwards.contains(awardMock1));
    }

    @Test
    void validateBatchAwards_TwoInvalidAwards(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock1) {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock1.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1021887");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardFundManagerMock1.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock1.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock1);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        awards.add(awardMock1);
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertTrue((boolean)validAwards.isEmpty());
    }

    @Test
    void validateBatchAwards_OneValidOneInvalidAwards(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock1) {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(new ArrayList());
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock1.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.isExcludedFromInvoicing()).thenReturn((Object)true);
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1021887");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardFundManagerMock1.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock1.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock1);
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        HashMap<String, Object> fieldValues1 = new HashMap<String, Object>();
        fieldValues1.put("invoiceGeneralDetail.proposalNumber", awardMock1.getProposalNumber());
        fieldValues1.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(ContractsAndGrantsBillingAwardAccount.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        awards.add(awardMock1);
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertEquals((int)1, (int)validAwards.size());
        Assertions.assertTrue((boolean)validAwards.contains(awardMock));
    }

    @Test
    void validate_DuplicateAccount(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock(stubOnly=true) ContractsAndGrantsFundManager awardFundManagerMock1) {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)awardFundManagerMock.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(new ArrayList());
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-09-22"));
        Mockito.when((Object)awardMock1.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)awardMock1.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock1.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock1.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)awardFundManagerMock1.getPrincipalId()).thenReturn((Object)"1137304513");
        Mockito.when((Object)awardMock1.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock1);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock1)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues1 = new HashMap<String, Object>();
        fieldValues1.put("invoiceGeneralDetail.proposalNumber", awardMock1.getProposalNumber());
        fieldValues1.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(ContractsAndGrantsBillingAwardAccount.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        this.expectError("error.cginvoice.account.on.multiple.awards");
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        awards.add(awardMock1);
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertTrue((boolean)validAwards.isEmpty());
    }

    @Test
    void validate_NonDuplicateAccountsWithDifferentChart(@Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock, @Mock(stubOnly=true) ContractsAndGrantsBillingAward awardMock1, @Mock(stubOnly=true) ContractsAndGrantsBillingAwardAccount awardAccountMock1) {
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(new ArrayList());
        Mockito.when((Object)awardMock1.getProposalNumber()).thenReturn((Object)"111");
        Mockito.when((Object)awardMock1.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-01-01"));
        Mockito.when((Object)awardMock1.getInvoicingOptionCode()).thenReturn((Object)"1");
        Mockito.when((Object)awardMock1.isActive()).thenReturn((Object)true);
        Mockito.when((Object)awardMock1.getBillingFrequencyCode()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency().getFrequency());
        Mockito.when((Object)awardAccountMock1.getChartOfAccountsCode()).thenReturn((Object)"BA");
        Mockito.when((Object)awardAccountMock1.getAccountNumber()).thenReturn((Object)"1020087");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks1 = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks1.add(awardAccountMock1);
        Mockito.when((Object)awardMock1.getActiveAwardAccounts()).thenReturn(awardAccountMocks1);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(awardMock1)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(awardMock1)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues1 = new HashMap<String, Object>();
        fieldValues1.put("invoiceGeneralDetail.proposalNumber", awardMock1.getProposalNumber());
        fieldValues1.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues1)).thenReturn(new ArrayList());
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(ContractsAndGrantsBillingAwardAccount.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        awards.add(awardMock);
        awards.add(awardMock1);
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertEquals((int)2, (int)validAwards.size());
    }

    private void prepareMocks(ContractsAndGrantsBillingAward award) {
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(award)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(award)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(award)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.hasIncomeAndReceivableObjectCodes(award)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", PENDING_DOCUMENT_STATUSES);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(new ArrayList());
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(ContractsAndGrantsBillingAwardAccount.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
    }

    private void expectError(String errorKey) {
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString(errorKey)).thenReturn((Object)"Error");
        Mockito.when((Object)this.cgInvoiceDocSvcMock.getBudgetAndActualsForAwardAccount((ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)KualiDecimal.ZERO);
    }

    private boolean errorLogContainsAward(Collection<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs, ContractsAndGrantsBillingAward award) {
        for (ContractsGrantsInvoiceDocumentErrorLog contractsGrantsInvoiceDocumentErrorLog : contractsGrantsInvoiceDocumentErrorLogs) {
            if (!contractsGrantsInvoiceDocumentErrorLog.getProposalNumber().equals(award.getProposalNumber())) continue;
            return true;
        }
        return false;
    }
}

