/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.batch.vo;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.NormalizedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for addressType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="addressType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerAddressName"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerLine1StreetAddress"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerLine2StreetAddress" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerCityName"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerStateCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerZipCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerCountryCode"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerAddressInternationalProvinceName"
 *         minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerInternationalMailCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerEmailAddress" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerAddressTypeCode"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerAddressEndDate" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "address", namespace = XmlConstants.CUSTOMER_NAMESPACE, propOrder = {"customerAddressName",
    "customerLine1StreetAddress", "customerLine2StreetAddress", "customerCityName", "customerStateCode",
    "customerZipCode", "customerCountryCode", "customerAddressInternationalProvinceName",
    "customerInternationalMailCode", "customerEmailAddress", "customerAddressTypeCode", "customerAddressEndDate"})
public class CustomerAddressVO {

    @XmlTransient
    private String customerNumber;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerAddressName;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerLine1StreetAddress;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerLine2StreetAddress;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerCityName;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerStateCode;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerZipCode;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerCountryCode;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerAddressInternationalProvinceName;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerInternationalMailCode;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerEmailAddress;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerAddressTypeCode;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerAddressEndDate;

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(final String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getCustomerAddressName() {
        return customerAddressName;
    }

    public void setCustomerAddressName(final String customerAddressName) {
        this.customerAddressName = customerAddressName;
    }

    public String getCustomerLine1StreetAddress() {
        return customerLine1StreetAddress;
    }

    public void setCustomerLine1StreetAddress(final String customerLine1StreetAddress) {
        this.customerLine1StreetAddress = customerLine1StreetAddress;
    }

    public String getCustomerLine2StreetAddress() {
        return customerLine2StreetAddress;
    }

    public void setCustomerLine2StreetAddress(final String customerLine2StreetAddress) {
        this.customerLine2StreetAddress = customerLine2StreetAddress;
    }

    public String getCustomerCityName() {
        return customerCityName;
    }

    public void setCustomerCityName(final String customerCityName) {
        this.customerCityName = customerCityName;
    }

    public String getCustomerStateCode() {
        return customerStateCode;
    }

    public void setCustomerStateCode(final String customerStateCode) {
        this.customerStateCode = customerStateCode;
    }

    public String getCustomerZipCode() {
        return customerZipCode;
    }

    public void setCustomerZipCode(final String customerZipCode) {
        this.customerZipCode = customerZipCode;
    }

    public String getCustomerCountryCode() {
        return customerCountryCode;
    }

    public void setCustomerCountryCode(final String customerCountryCode) {
        this.customerCountryCode = customerCountryCode;
    }

    public String getCustomerAddressInternationalProvinceName() {
        return customerAddressInternationalProvinceName;
    }

    public void setCustomerAddressInternationalProvinceName(final String customerAddressInternationalProvinceName) {
        this.customerAddressInternationalProvinceName = customerAddressInternationalProvinceName;
    }

    public String getCustomerInternationalMailCode() {
        return customerInternationalMailCode;
    }

    public void setCustomerInternationalMailCode(final String customerInternationalMailCode) {
        this.customerInternationalMailCode = customerInternationalMailCode;
    }

    public String getCustomerEmailAddress() {
        return customerEmailAddress;
    }

    public void setCustomerEmailAddress(final String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
    }

    public String getCustomerAddressTypeCode() {
        return customerAddressTypeCode;
    }

    public void setCustomerAddressTypeCode(final String customerAddressTypeCode) {
        this.customerAddressTypeCode = customerAddressTypeCode;
    }

    public String getCustomerAddressEndDate() {
        return customerAddressEndDate;
    }

    public void setCustomerAddressEndDate(final String customerAddressEndDate) {
        this.customerAddressEndDate = customerAddressEndDate;
    }

}
