/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.sql.Date;
import java.util.Objects;

/**
 * Base class so the Bill and InvoiceBill BOs don't have to duplicate code.
 */
public class BillBase extends PersistableBusinessObjectBase {

    protected Long billIdentifier;
    protected String billNumber;
    protected String billDescription;
    protected Date billDate;
    protected KualiDecimal estimatedAmount;

    public Date getBillDate() {
        return billDate;
    }

    public String getBillDescription() {
        return billDescription;
    }

    public Long getBillIdentifier() {
        return billIdentifier;
    }

    public String getBillNumber() {
        return billNumber;
    }

    public KualiDecimal getEstimatedAmount() {
        return estimatedAmount;
    }

    public void setBillDate(final Date billDate) {
        this.billDate = billDate;
    }

    public void setBillDescription(final String billDescription) {
        this.billDescription = billDescription;
    }

    public void setBillIdentifier(final Long billIdentifier) {
        this.billIdentifier = billIdentifier;
    }

    public void setBillNumber(final String billNumber) {
        this.billNumber = billNumber;
    }

    public void setEstimatedAmount(final KualiDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BillBase)) {
            return false;
        }
        final BillBase that = (BillBase) o;
        return Objects.equals(billIdentifier, that.billIdentifier) &&
                Objects.equals(billNumber, that.billNumber) &&
                Objects.equals(billDescription, that.billDescription) &&
                Objects.equals(billDate, that.billDate) &&
                Objects.equals(estimatedAmount, that.estimatedAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billIdentifier, billNumber, billDescription, billDate, estimatedAmount);
    }
}
