/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCodeCurrent;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.math.BigDecimal;

public class CustomerInvoiceItemCode extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String chartOfAccountsCode;
    private String organizationCode;
    private String invoiceItemCode;
    private String invoiceItemDescription;
    private String relatedStockNumber;
    private String defaultInvoiceChartOfAccountsCode;
    private String defaultInvoiceAccountNumber;
    private String defaultInvoiceSubAccountNumber;
    private String defaultInvoiceFinancialObjectCode;
    private String defaultInvoiceFinancialSubObjectCode;
    private String defaultInvoiceProjectCode;
    private String defaultInvoiceOrganizationReferenceIdentifier;
    private KualiDecimal itemDefaultPrice;
    private String defaultUnitOfMeasureCode;
    private BigDecimal itemDefaultQuantity;
    private boolean active;
    private boolean taxableIndicator;

    private Chart chartOfAccounts;
    private Organization organization;
    private Account defaultInvoiceAccount;
    private SubAccount defaultInvoiceSubAccount;
    private Chart defaultInvoiceChartOfAccounts;
    private ObjectCodeCurrent defaultInvoiceFinancialObject;
    private SubObjectCodeCurrent defaultInvoiceFinancialSubObject;
    private ProjectCode defaultInvoiceProject;
    private UnitOfMeasure unitOfMeasure;

    public CustomerInvoiceItemCode() {
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(final String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getInvoiceItemCode() {
        return invoiceItemCode;
    }

    public void setInvoiceItemCode(final String invoiceItemCode) {
        this.invoiceItemCode = invoiceItemCode;
    }

    public String getInvoiceItemDescription() {
        return invoiceItemDescription;
    }

    public void setInvoiceItemDescription(final String invoiceItemDescription) {
        this.invoiceItemDescription = invoiceItemDescription;
    }

    public String getRelatedStockNumber() {
        return relatedStockNumber;
    }

    public void setRelatedStockNumber(final String relatedStockNumber) {
        this.relatedStockNumber = relatedStockNumber;
    }

    public String getDefaultInvoiceChartOfAccountsCode() {
        return defaultInvoiceChartOfAccountsCode;
    }

    public void setDefaultInvoiceChartOfAccountsCode(final String defaultInvoiceChartOfAccountsCode) {
        this.defaultInvoiceChartOfAccountsCode = defaultInvoiceChartOfAccountsCode;
    }

    public String getDefaultInvoiceAccountNumber() {
        return defaultInvoiceAccountNumber;
    }

    public void setDefaultInvoiceAccountNumber(final String defaultInvoiceAccountNumber) {
        this.defaultInvoiceAccountNumber = defaultInvoiceAccountNumber;
    }

    public String getDefaultInvoiceSubAccountNumber() {
        return defaultInvoiceSubAccountNumber;
    }

    public void setDefaultInvoiceSubAccountNumber(final String defaultInvoiceSubAccountNumber) {
        this.defaultInvoiceSubAccountNumber = defaultInvoiceSubAccountNumber;
    }

    public String getDefaultInvoiceFinancialObjectCode() {
        return defaultInvoiceFinancialObjectCode;
    }

    public void setDefaultInvoiceFinancialObjectCode(final String defaultInvoiceFinancialObjectCode) {
        this.defaultInvoiceFinancialObjectCode = defaultInvoiceFinancialObjectCode;
    }

    public String getDefaultInvoiceFinancialSubObjectCode() {
        return defaultInvoiceFinancialSubObjectCode;
    }

    public void setDefaultInvoiceFinancialSubObjectCode(final String defaultInvoiceFinancialSubObjectCode) {
        this.defaultInvoiceFinancialSubObjectCode = defaultInvoiceFinancialSubObjectCode;
    }

    public String getDefaultInvoiceProjectCode() {
        return defaultInvoiceProjectCode;
    }

    public void setDefaultInvoiceProjectCode(final String defaultInvoiceProjectCode) {
        this.defaultInvoiceProjectCode = defaultInvoiceProjectCode;
    }

    public String getDefaultInvoiceOrganizationReferenceIdentifier() {
        return defaultInvoiceOrganizationReferenceIdentifier;
    }

    public void setDefaultInvoiceOrganizationReferenceIdentifier(final String defaultInvoiceOrganizationReferenceIdentifier) {
        this.defaultInvoiceOrganizationReferenceIdentifier = defaultInvoiceOrganizationReferenceIdentifier;
    }

    public KualiDecimal getItemDefaultPrice() {
        return itemDefaultPrice;
    }

    public void setItemDefaultPrice(final KualiDecimal itemDefaultPrice) {
        this.itemDefaultPrice = itemDefaultPrice;
    }

    public String getDefaultUnitOfMeasureCode() {
        return defaultUnitOfMeasureCode;
    }

    public void setDefaultUnitOfMeasureCode(final String defaultUnitOfMeasureCode) {
        this.defaultUnitOfMeasureCode = defaultUnitOfMeasureCode;
    }

    public BigDecimal getItemDefaultQuantity() {
        return itemDefaultQuantity;
    }

    public void setItemDefaultQuantity(final BigDecimal itemDefaultQuantity) {
        this.itemDefaultQuantity = itemDefaultQuantity;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

    public boolean isTaxableIndicator() {
        return taxableIndicator;
    }

    public void setTaxableIndicator(final boolean taxableIndicator) {
        this.taxableIndicator = taxableIndicator;
    }

    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    public UnitOfMeasure getUnitOfMeasure() {
        return unitOfMeasure;
    }

    public void setChartOfAccounts(final Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Organization getOrganization() {
        return organization;
    }

    public void setOrganization(final Organization organization) {
        this.organization = organization;
    }

    public Account getDefaultInvoiceAccount() {
        return defaultInvoiceAccount;
    }

    public void setDefaultInvoiceAccount(final Account defaultInvoiceAccount) {
        this.defaultInvoiceAccount = defaultInvoiceAccount;
    }

    public SubAccount getDefaultInvoiceSubAccount() {
        return defaultInvoiceSubAccount;
    }

    public void setDefaultInvoiceSubAccount(final SubAccount defaultInvoiceSubAccount) {
        this.defaultInvoiceSubAccount = defaultInvoiceSubAccount;
    }

    public Chart getDefaultInvoiceChartOfAccounts() {
        return defaultInvoiceChartOfAccounts;
    }

    public void setDefaultInvoiceChartOfAccounts(final Chart defaultInvoiceChartOfAccounts) {
        this.defaultInvoiceChartOfAccounts = defaultInvoiceChartOfAccounts;
    }

    public ObjectCodeCurrent getDefaultInvoiceFinancialObject() {
        return defaultInvoiceFinancialObject;
    }

    public void setDefaultInvoiceFinancialObject(final ObjectCodeCurrent defaultInvoiceFinancialObject) {
        this.defaultInvoiceFinancialObject = defaultInvoiceFinancialObject;
    }

    public SubObjectCodeCurrent getDefaultInvoiceFinancialSubObject() {
        return defaultInvoiceFinancialSubObject;
    }

    public void setDefaultInvoiceFinancialSubObject(final SubObjectCodeCurrent defaultInvoiceFinancialSubObject) {
        this.defaultInvoiceFinancialSubObject = defaultInvoiceFinancialSubObject;
    }

    public ProjectCode getDefaultInvoiceProject() {
        return defaultInvoiceProject;
    }

    public void setDefaultInvoiceProject(final ProjectCode defaultInvoiceProject) {
        this.defaultInvoiceProject = defaultInvoiceProject;
    }

}
