/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.ArPropertyConstants;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Business object for the Generate Dunning Letters Lookup Result.
 */
public class GenerateDunningLettersLookupResult extends TransientBusinessObjectBase {

    private String principalId;
    private String proposalNumber;
    private String accountNumber;
    private String agencyNumber;
    private String customerNumber;
    private String invoiceDocumentNumber;
    private String campaignID;
    private String agingBucket;
    private KualiDecimal awardTotal = KualiDecimal.ZERO;
    private Collection<ContractsGrantsInvoiceDocument> invoices;
    private ContractsAndGrantsAward award;
    private ContractsAndGrantsAgency agency;
    private Customer customer;
    private String chartOfAccountsCode;
    private String organizationCode;
    private String reportOption = ArConstants.ReportOptionFieldValues.PROCESSING_ORG;

    private Person collector;
    private final String userLookupRoleNamespaceCode = KFSConstants.OptionalModuleNamespaces.ACCOUNTS_RECEIVABLE;
    private final String userLookupRoleName = KFSConstants.SysKimApiConstants.ACCOUNTS_RECEIVABLE_COLLECTOR;

    private DunningCampaign dunningCampaign;

    public String getPrincipalId() {
        return principalId;
    }

    public void setPrincipalId(final String principalId) {
        this.principalId = principalId;
    }

    public Person getCollector() {
        return collector;
    }

    public void setCollector(final Person collector) {
        this.collector = collector;
    }

    public String getUserLookupRoleNamespaceCode() {
        return userLookupRoleNamespaceCode;
    }

    public String getUserLookupRoleName() {
        return userLookupRoleName;
    }

    public String getAgingBucket() {
        return agingBucket;
    }

    public void setAgingBucket(final String agingBucket) {
        this.agingBucket = agingBucket;
    }

    public String getCampaignID() {
        return campaignID;
    }

    public void setCampaignID(final String campaignID) {
        this.campaignID = campaignID;
    }

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public KualiDecimal getAwardTotal() {
        return awardTotal;
    }

    public void setAwardTotal(final KualiDecimal awardTotal) {
        this.awardTotal = awardTotal;
    }

    public Collection<ContractsGrantsInvoiceDocument> getInvoices() {
        return invoices;
    }

    public void setInvoices(final Collection<ContractsGrantsInvoiceDocument> invoices) {
        this.invoices = invoices;
    }

    public String getAgencyNumber() {
        return agencyNumber;
    }

    public void setAgencyNumber(final String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(final String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getInvoiceDocumentNumber() {
        return invoiceDocumentNumber;
    }

    public void setInvoiceDocumentNumber(final String invoiceDocumentNumber) {
        this.invoiceDocumentNumber = invoiceDocumentNumber;
    }

    public ContractsAndGrantsAward getAward() {
        return award;
    }

    public void setAward(final ContractsAndGrantsAward award) {
        this.award = award;
    }

    public ContractsAndGrantsAgency getAgency() {
        return agency;
    }

    public void setAgency(final ContractsAndGrantsAgency agency) {
        this.agency = agency;
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(final Customer customer) {
        this.customer = customer;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(final String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getReportOption() {
        return reportOption;
    }

    public void setReportOption(final String reportOption) {
        this.reportOption = reportOption;
    }

    public DunningCampaign getDunningCampaign() {
        return dunningCampaign;
    }

    public void setDunningCampaign(final DunningCampaign dunningCampaign) {
        this.dunningCampaign = dunningCampaign;
    }

    public List<String> getInvoiceAttributesForDisplay() {
        final List<String> invoiceAttributesForDisplay = new ArrayList<>();
        invoiceAttributesForDisplay.add(KFSPropertyConstants.DOCUMENT_NUMBER);
        invoiceAttributesForDisplay.add(KFSPropertyConstants.ACCOUNT_NUMBER);
        invoiceAttributesForDisplay.add(ArPropertyConstants.CustomerInvoiceDocumentFields.BILLING_DATE);
        invoiceAttributesForDisplay.add(ArPropertyConstants.CustomerInvoiceDocumentFields.AGE);
        invoiceAttributesForDisplay.add(ArPropertyConstants.DunningLetterDistributionFields.DUNNING_LETTER_TEMPLATE_SENT_DATE);
        invoiceAttributesForDisplay.add(ArPropertyConstants.CustomerInvoiceDocumentFields.SOURCE_TOTAL);
        invoiceAttributesForDisplay.add(ArPropertyConstants.CustomerInvoiceDocumentFields.OPEN_AMOUNT);
        return invoiceAttributesForDisplay;
    }

}
