/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.util.ArrayList;
import java.util.List;

public class NonInvoiced extends PersistableBusinessObjectBase {

    private String documentNumber;
    private Integer financialDocumentLineNumber;
    private Integer financialDocumentPostingYear;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String projectCode;
    private KualiDecimal financialDocumentLineAmount;
    private String financialDocumentOverrideCode;
    private KualiDecimal nonInvoicedDistributionAmount = KualiDecimal.ZERO;

    private AccountsReceivableDocumentHeader accountsReceivableDocumentHeader;
    private ObjectCode financialObject;
    private SubAccount subAccount;
    private Chart chartOfAccounts;
    private SubObjectCode financialSubObject;
    private Account account;
    private ProjectCode project;


    List<NonInvoicedDistribution> nonInvoicedDistributions;

    public NonInvoiced() {
        nonInvoicedDistributions = new ArrayList<>();
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getFinancialDocumentLineNumber() {
        return financialDocumentLineNumber;
    }

    public void setFinancialDocumentLineNumber(final Integer financialDocumentLineNumber) {
        this.financialDocumentLineNumber = financialDocumentLineNumber;
    }

    public Integer getFinancialDocumentPostingYear() {
        return financialDocumentPostingYear;
    }

    public void setFinancialDocumentPostingYear(final Integer financialDocumentPostingYear) {
        this.financialDocumentPostingYear = financialDocumentPostingYear;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;

        // if accounts can't cross charts, set chart code whenever account number is set
        final AccountService accountService = SpringContext.getBean(AccountService.class);
        if (!accountService.accountsCanCrossCharts()) {
            final Account account = accountService.getUniqueAccountForAccountNumber(accountNumber);
            if (ObjectUtils.isNotNull(account)) {
                setChartOfAccountsCode(account.getChartOfAccountsCode());
            }
        }
    }

    public String getSubAccountNumber() {
        return subAccountNumber;
    }

    public void setSubAccountNumber(final String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    public void setFinancialObjectCode(final String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(final String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(final String projectCode) {
        this.projectCode = projectCode;
    }

    public KualiDecimal getFinancialDocumentLineAmount() {
        return financialDocumentLineAmount;
    }

    public void setFinancialDocumentLineAmount(final KualiDecimal financialDocumentLineAmount) {
        this.financialDocumentLineAmount = financialDocumentLineAmount;
    }

    public String getFinancialDocumentOverrideCode() {
        return financialDocumentOverrideCode;
    }

    public void setFinancialDocumentOverrideCode(final String financialDocumentOverrideCode) {
        this.financialDocumentOverrideCode = financialDocumentOverrideCode;
    }

    public AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader() {
        return accountsReceivableDocumentHeader;
    }

    @Deprecated
    public void setAccountsReceivableDocumentHeader(final AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = accountsReceivableDocumentHeader;
    }

    public ObjectCode getFinancialObject() {
        return financialObject;
    }

    @Deprecated
    public void setFinancialObject(final ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public SubAccount getSubAccount() {
        return subAccount;
    }

    @Deprecated
    public void setSubAccount(final SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    @Deprecated
    public void setChartOfAccounts(final Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public SubObjectCode getFinancialSubObject() {
        return financialSubObject;
    }

    @Deprecated
    public void setFinancialSubObject(final SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    public Account getAccount() {
        return account;
    }

    @Deprecated
    public void setAccount(final Account account) {
        this.account = account;
    }

    public ProjectCode getProject() {
        return project;
    }

    @Deprecated
    public void setProject(final ProjectCode project) {
        this.project = project;
    }

    public List<NonInvoicedDistribution> getNonInvoicedDistributions() {
        return nonInvoicedDistributions;
    }

    public void setNonInvoicedDistributions(final List<NonInvoicedDistribution> nonInvoicedDistributions) {
        this.nonInvoicedDistributions = nonInvoicedDistributions;
    }

    public KualiDecimal getNonInvoicedDistributionAmount() {
        return nonInvoicedDistributionAmount;
    }

    public void setNonInvoicedDistributionAmount(final KualiDecimal nonInvoicedDistributionAmount) {
        this.nonInvoicedDistributionAmount = nonInvoicedDistributionAmount;
    }

}
