/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.context.SpringContext;

import java.util.HashMap;
import java.util.Map;

/**
 * Rules for the Milestone Schedule maintenance document.
 */
public final class MilestoneScheduleRuleUtil {
    private static BusinessObjectService businessObjectService;

    /**
     * Private Constructor since this is a util class that should never be instantiated.
     */
    private MilestoneScheduleRuleUtil() {
    }

    /**
     * Determines if a award/account has milestones defined
     *
     * @param milestoneSchedule to check for
     * @return true if the award/account has milestones defined
     */
    public static boolean checkIfMilestonesExists(final MilestoneSchedule milestoneSchedule) {
        if (ObjectUtils.isNull(milestoneSchedule)) {
            return false;
        }

        final Map<String, Object> primaryKeys = new HashMap<>();
        primaryKeys.put(KFSPropertyConstants.PROPOSAL_NUMBER, milestoneSchedule.getProposalNumber());
        primaryKeys.put(KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE, milestoneSchedule.getChartOfAccountsCode());
        primaryKeys.put(KFSPropertyConstants.ACCOUNT_NUMBER, milestoneSchedule.getAccountNumber());

        final MilestoneSchedule result = getBusinessObjectService().findByPrimaryKey(MilestoneSchedule.class, primaryKeys);

        return ObjectUtils.isNotNull(result) && !StringUtils.equals(milestoneSchedule.getObjectId(), result.getObjectId());
    }

    protected static BusinessObjectService getBusinessObjectService() {
        if (businessObjectService == null) {
            businessObjectService = SpringContext.getBean(BusinessObjectService.class);
        }
        return businessObjectService;
    }

    protected static void setBusinessObjectService(final BusinessObjectService businessObjectService) {
        MilestoneScheduleRuleUtil.businessObjectService = businessObjectService;
    }
}
