/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.report;

import org.kuali.kfs.module.ar.businessobject.CollectionActivityReport;

import java.util.Date;

/**
 * Data holder class for Collection Activity Report.
 */
public class CollectionActivityReportDetailDataHolder {

    private Date followupDate;
    private String activityType;
    private String activityComment;
    private String proposalNumber;
    private String agencyNumber;

    private String accountNumber;
    private String invoiceNumber;
    private Date activityDate;
    private String agencyName;
    private Date completedDate;
    private String userName;
    private String chartOfAccountsCode;

    public CollectionActivityReportDetailDataHolder() {
    }

    /**
     * Constructor to initialize other values from given object.
     *
     * @param cr CollectionActivityReport object from which values to be set in data holder object.
     */
    public CollectionActivityReportDetailDataHolder(final CollectionActivityReport cr) {
        accountNumber = cr.getAccountNumber();
        invoiceNumber = cr.getInvoiceNumber();
        activityDate = cr.getActivityDate();
        followupDate = cr.getFollowupDate();
        activityType = cr.getActivityType();
        activityComment = cr.getActivityComment();
        completedDate = cr.getCompletedDate();
        userName = cr.getUserName();
        chartOfAccountsCode = cr.getChartOfAccountsCode();
        agencyNumber = cr.getAgencyNumber();
        proposalNumber = cr.getProposalNumber();
    }

    public Date getFollowupDate() {
        return followupDate;
    }

    public void setFollowupDate(final Date followupDate) {
        this.followupDate = followupDate;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(final String activityType) {
        this.activityType = activityType;
    }

    public String getActivityComment() {
        return activityComment;
    }

    public void setActivityComment(final String activityComment) {
        this.activityComment = activityComment;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Date getActivityDate() {
        return activityDate;
    }

    public void setActivityDate(final Date activityDate) {
        this.activityDate = activityDate;
    }

    public Date getCompletedDate() {
        return completedDate;
    }

    public void setCompletedDate(final Date completedDate) {
        this.completedDate = completedDate;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(final String userName) {
        this.userName = userName;
    }

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getAgencyNumber() {
        return agencyNumber;
    }

    public void setAgencyNumber(final String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(final String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public void setAgencyName(final String agencyName) {
        this.agencyName = agencyName;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

}
