/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArPropertyConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Defines an entry in the Contracts & Grants Invoice Lookup Result.
 */
public class ContractsGrantsInvoiceLookupResult extends TransientBusinessObjectBase {

    private Long proposalNumber;
    private String agencyNumber;
    private String customerNumber;
    private String accountNumber;
    private boolean active;
    private String agencyReportingName;
    private String agencyFullName;
    private Date awardBeginningDate;
    private Date awardEndingDate;
    private String awardBillingFrequency;
    private KualiDecimal awardTotal = KualiDecimal.ZERO;
    private Collection<ContractsAndGrantsBillingAward> awards;
    private Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards;
    private ContractsAndGrantsBillingAgency agency;
    private BillingFrequency billingFrequency;
    private Customer customer;

    public Long getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(Long proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getAgencyNumber() {
        return agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public boolean getActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getAgencyReportingName() {
        return agencyReportingName;
    }

    public void setAgencyReportingName(String agencyReportingName) {
        this.agencyReportingName = agencyReportingName;
    }

    public String getAgencyFullName() {
        return agencyFullName;
    }

    public void setAgencyFullName(String agencyFullName) {
        this.agencyFullName = agencyFullName;
    }

    public Date getAwardBeginningDate() {
        return awardBeginningDate;
    }

    public void setAwardBeginningDate(Date awardBeginningDate) {
        this.awardBeginningDate = awardBeginningDate;
    }

    public Date getAwardEndingDate() {
        return awardEndingDate;
    }

    public void setAwardEndingDate(Date awardEndingDate) {
        this.awardEndingDate = awardEndingDate;
    }

    public String getAwardBillingFrequency() {
        return awardBillingFrequency;
    }

    public void setAwardBillingFrequency(String awardBillingFrequency) {
        this.awardBillingFrequency = awardBillingFrequency;
    }

    public KualiDecimal getAwardTotal() {
        return awardTotal;
    }

    public void setAwardTotal(KualiDecimal awardTotal) {
        this.awardTotal = awardTotal;
    }

    public Collection<ContractsAndGrantsBillingAward> getAwards() {
        return awards;
    }

    public void setAwards(Collection awards) {
        this.awards = awards;
    }

    public Collection<ContractsGrantsInvoiceLookupResultAward> getLookupResultAwards() {
        return lookupResultAwards;
    }

    public void setLookupResultAwards(
            Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards) {
        this.lookupResultAwards = lookupResultAwards;
    }

    public ContractsAndGrantsBillingAgency getAgency() {
        return agency;
    }

    public void setAgency(ContractsAndGrantsBillingAgency agency) {
        this.agency = agency;
    }

    public BillingFrequency getBillingFrequency() {
        if (billingFrequency == null || !StringUtils.equals(billingFrequency.getFrequency(),
                this.awardBillingFrequency)) {
            billingFrequency = SpringContext.getBean(BusinessObjectService.class)
                    .findBySinglePrimaryKey(BillingFrequency.class, this.awardBillingFrequency);
        }
        return billingFrequency;
    }

    public void setBillingFrequency(BillingFrequency billingFrequency) {
        this.billingFrequency = billingFrequency;
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public List<String> getAwardAttributesForDisplay() {
        List<String> awardAttributesForDisplay = new ArrayList<>();

        awardAttributesForDisplay.add(KFSPropertyConstants.PROPOSAL_NUMBER);
        awardAttributesForDisplay.add(KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE);
        awardAttributesForDisplay.add(KFSPropertyConstants.ACCOUNT_NUMBER);
        awardAttributesForDisplay.add(KFSPropertyConstants.AWARD_BEGINNING_DATE);
        awardAttributesForDisplay.add(KFSPropertyConstants.AWARD_ENDING_DATE);
        awardAttributesForDisplay.add(ArPropertyConstants.BILLING_FREQUENCY_CODE);
        awardAttributesForDisplay.add(ArPropertyConstants.INSTRUMENT_TYPE_DESCRIPTION);
        awardAttributesForDisplay.add(ArPropertyConstants.INVOICING_OPTION_DESCRIPTION);
        awardAttributesForDisplay.add(KFSPropertyConstants.AWARD_TOTAL_AMOUNT);

        return awardAttributesForDisplay;
    }

}
