/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import org.kuali.kfs.kim.api.KimConstants;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.admin.DefaultBoAdminService;

import java.util.HashMap;
import java.util.Map;

public class CustomerAdminService extends DefaultBoAdminService {

    @Override
    public boolean allowsCopy(BusinessObjectBase businessObject, Person person) {
        return false;
    }

    public boolean allowsReport(Person person) {
        Map<String, String> permissionDetails = new HashMap<>();
        permissionDetails.put(KimConstants.AttributeConstants.NAMESPACE_CODE, ArConstants.AR_NAMESPACE_CODE);
        permissionDetails.put(KimConstants.AttributeConstants.ACTION_CLASS,
                "org.kuali.kfs.module.ar.web.struts.CustomerOpenItemReportAction");

        return permissionService.isAuthorizedByTemplate(person.getPrincipalId(),
                KFSConstants.CoreModuleNamespaces.KFS, KimConstants.PermissionTemplateNames.USE_SCREEN, permissionDetails,
                new HashMap<>());
    }
}
