/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.HtmlData.AnchorHtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;

import java.util.HashMap;
import java.util.Map;

public abstract class AccountsReceivableLookupableHelperServiceImplBase extends KualiLookupableHelperServiceImpl {

    /**
     * Overridden to setup document number link for document number properties and add Rice Path prefix
     * to the URL where necessary (cases where the Lookupable is called from the KFS context instead of the Rice context).
     */
    @Override
    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        AnchorHtmlData inquiryHref = new AnchorHtmlData(KFSConstants.EMPTY_STRING, KFSConstants.EMPTY_STRING);

        if (KFSPropertyConstants.DOCUMENT_NUMBER.equals(propertyName)) {
            String baseUrl = configurationService.getPropertyValueAsString(KFSConstants.APPLICATION_URL_KEY) + "/"
                    + KFSConstants.DOC_HANDLER_ACTION;
            Map<String, String> parameters = new HashMap<>();
            parameters.put(KFSConstants.PARAMETER_DOC_ID, ObjectUtils.getPropertyValue(bo, propertyName).toString());
            parameters.put(KFSConstants.PARAMETER_COMMAND, KFSConstants.METHOD_DISPLAY_DOC_SEARCH_VIEW);

            inquiryHref.setHref(UrlFactory.parameterizeUrl(baseUrl, parameters));
        } else {
            inquiryHref = (AnchorHtmlData) super.getInquiryUrl(bo, propertyName);
        }

        return inquiryHref;
    }

}
